<?php

return [
    'title' => 'Nastavení',
    'general_setting' => 'Obecná nastavení',
    'menu' => 'Všechna nastavení',
    'email_setting_title' => 'Nastavení e-mailu',
    'email_setting_description' => 'Konfigurace nastavení e-mailu',
    'general' => [
        'theme' => 'Téma',
        'title' => 'Obecné informace',
        'description' => 'Zobrazení a aktualizace informací o webu',
        'rich_editor' => 'Rich Editor',
        'site_title' => 'Název webu',
        'admin_email' => 'E-mail správce',
        'seo_block' => 'Konfigurace SEO',
        'seo_title' => 'SEO titulek',
        'seo_description' => 'SEO popis',
        'webmaster_tools_block' => 'Nástroje pro webmastery Google',
        'placeholder' => [
            'site_title' => 'Název webu (maximálně 120 znaků)',
            'admin_email' => 'E-mail správce',
            'seo_title' => 'SEO titulek (maximálně 120 znaků)',
            'seo_description' => 'SEO popis (maximálně 120 znaků)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Odesílat hlášení o chybách e-mailem',
        'enable_send_error_reporting_via_email_helper' => 'Pokud je povoleno, budou podrobné zprávy o chybách odesílány na e-mailové adresy správce, když dojde k kritickým chybám na webu',
        'time_zone_helper' => 'Vyberte časové pásmo pro váš web. Toto bude použito pro všechna zobrazení data a času v celém systému',
        'time_zone' => 'Časové pásmo',
        'enable' => 'Povolit',
        'disable' => 'Zakázat',
        'disabled_helper' => 'Tuto e-mailovou šablonu nelze zakázat!',
        'enable_cache_site_map' => 'Povolit kešování mapy stránek',
        'cache_time_site_map' => 'Časový limit keše mapy stránek (v minutách)',
        'admin_logo' => 'Logo správce',
        'admin_favicon' => 'Favicon správce',
        'admin_title' => 'Titulek správce',
        'admin_title_placeholder' => 'Titulek zobrazený na kartě prohlížeče',
        'admin_appearance_title' => 'Vzhled správce',
        'admin_appearance_description' => 'Nastavení vzhledu správce, jako je editor, jazyk...',
        'seo_block_description' => 'Nastavení názvu webu, meta popisu webu, klíčových slov pro optimalizaci SEO',
        'webmaster_tools_description' => 'Google Search Console je bezplatný webový nástroj poskytovaný společností Google, který pomáhá vlastníkům webových stránek sledovat výkon jejich webu ve výsledcích vyhledávání Google.',
        'yes' => 'Ano',
        'no' => 'Ne',
        'show_on_front' => 'Vaše domovská stránka zobrazuje',
        'select' => '— Vybrat —',
        'show_site_name' => 'Zobrazit název webu za názvem stránky, oddělený pomlčkou "-"',
        'locale' => 'Jazyk webu',
        'locale_direction' => 'Směr jazyka webu',
        'minutes' => 'minut',
        'redirect_404_to_homepage' => 'Přesměrovat všechny požadavky Nenalezeno na domovskou stránku',
    ],
    'admin_appearance' => [
        'title' => 'Vzhled správce',
        'description' => 'Zobrazení a aktualizace loga, faviconu, rozložení...',
        'layout' => 'Rozložení',
        'horizontal' => 'Horizontální',
        'vertical' => 'Vertikální',
        'show_menu_item_icon' => 'Zobrazit ikony položek menu',
        'language' => 'Jazyk administračního panelu',
        'theme_mode' => 'Režim tématu',
        'dark' => 'Tmavý',
        'light' => 'Světlý',
        'container_width' => [
            'title' => 'Šířka kontejneru',
            'default' => 'Výchozí',
            'large' => 'Velká',
            'full' => 'Celá',
        ],
        'form' => [
            'admin_logo' => 'Logo správce',
            'admin_logo_max_height' => 'Výška loga (px)',
            'admin_logo_max_height_helper' => 'Nastavte výšku loga v pixelech. Výchozí hodnota je :default.',
            'admin_favicon' => 'Favicon správce',
            'admin_favicon_type' => 'Typ faviconu správce',
            'admin_title' => 'Titulek správce',
            'admin_title_placeholder' => 'Titulek zobrazený na kartě prohlížeče',
            'admin_login_screen_backgrounds' => 'Pozadí přihlašovací obrazovky (~1366 x 768)',
            'admin_locale' => 'Jazyk správce',
            'admin_locale_direction' => 'Směr jazyka správce',
            'rich_editor' => 'Rich Editor',
            'show_admin_bar' => 'Zobrazit panel správce pro přihlášené správce i na webu',
            'show_guidelines' => 'Zobrazit pokyny',
            'primary_font' => 'Hlavní písmo',
            'primary_color' => 'Primární barva',
            'secondary_color' => 'Sekundární barva',
            'heading_color' => 'Barva nadpisů',
            'text_color' => 'Barva textu',
            'link_color' => 'Barva odkazů',
            'link_hover_color' => 'Barva odkazu při najetí',
            'show_menu_item_icon' => 'Zobrazit ikony položek menu',
            'custom_css' => 'Vlastní CSS',
            'custom_js' => 'Vlastní JS',
            'custom_header_js' => 'JavaScript v hlavičce',
            'custom_header_js_placeholder' => 'JavaScript v hlavičce stránky, zabalte ho do &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'JavaScript v těle',
            'custom_body_js_placeholder' => 'JavaScript v těle stránky, zabalte ho do &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'JavaScript v patičce',
            'custom_footer_js_placeholder' => 'JavaScript v patičce stránky, zabalte ho do &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Datové tabulky',
        'description' => 'Nastavení pro datové tabulky',
        'form' => [
            'show_column_visibility' => 'Zobrazit viditelnost sloupců ve výchozím nastavení',
            'show_column_visibility_helper' => 'Povolit tlačítko přepínání viditelnosti sloupců v datových tabulkách, aby uživatelé mohli zobrazovat/skrývat sloupce',
            'show_export_button' => 'Zobrazit tlačítko exportu ve výchozím nastavení',
            'show_export_button_helper' => 'Zobrazit možnosti exportu (CSV, Excel, PDF) v datových tabulkách pro stahování dat',
            'pagination_type' => 'Typ stránkování',
            'pagination_type_helper' => 'Vyberte způsob zobrazení ovládacích prvků stránkování: Výchozí zobrazuje čísla stránek, Rozbalovací seznam zobrazuje kompaktní rozbalovací selektor',
            'default' => 'Výchozí',
            'dropdown' => 'Rozbalovací seznam',
            'enable_responsive' => 'Povolit responzivní tabulku',
            'enable_responsive_helper' => 'Automaticky přizpůsobit sloupce tabulky různým velikostem obrazovky pro lepší zážitek na mobilních zařízeních',
        ],
    ],
    'email' => [
        'subject' => 'Předmět',
        'content' => 'Obsah',
        'title' => 'Nastavení e-mailové šablony',
        'description' => 'E-mailová šablona používající HTML a systémové proměnné.',
        'reset_to_default' => 'Obnovit výchozí',
        'back' => 'Zpět na nastavení',
        'reset_success' => 'Úspěšně obnoveno na výchozí',
        'confirm_reset' => 'Potvrdit obnovení e-mailové šablony?',
        'confirm_message' => 'Opravdu chcete obnovit tuto e-mailovou šablonu na výchozí?',
        'continue' => 'Pokračovat',
        'sender_name' => 'Jméno odesílatele',
        'sender_name_placeholder' => 'Jméno',
        'sender_name_helper' => 'Jméno, které se zobrazí v poli Od e-mailů odeslaných systémem',
        'sender_email' => 'E-mail odesílatele',
        'sender_email_placeholder' => 'E-mailová adresa (např. :default)',
        'sender_email_helper' => 'E-mailová adresa, která bude použita jako odesílatel všech e-mailů odeslaných systémem',
        'mailer' => 'Mailer',
        'port' => 'Port',
        'port_placeholder' => 'Např.: 587',
        'port_helper' => 'Port používaný vaším poštovním serverem (běžné porty: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Např.: smtp.gmail.com',
        'host_helper' => 'Adresa SMTP hostu',
        'username' => 'Uživatelské jméno',
        'username_placeholder' => 'Uživatelské jméno pro přihlášení k poštovnímu serveru',
        'username_helper' => 'Uživatelské jméno pro přihlášení k poštovnímu serveru',
        'password' => 'Heslo',
        'password_placeholder' => 'Heslo pro přihlášení k poštovnímu serveru',
        'password_helper' => 'Heslo pro přihlášení k poštovnímu serveru',
        'encryption' => 'Šifrování',
        'encryption_placeholder' => 'Vyberte typ šifrování',
        'encryption_helper' => 'Vyberte metodu šifrování pro bezpečný přenos e-mailů',
        'encryption_none' => 'Žádné',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Tipy pro nastavení e-mailu',
        'setup_tip_gmail' => 'Pro Gmail: Použijte smtp.gmail.com jako host, port 587 s TLS nebo port 465 s SSL. Povolte "Přístup méně zabezpečených aplikací" nebo použijte heslo aplikace.',
        'setup_tip_port' => 'Běžné porty: 25 (nešifrovaný), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternativní).',
        'setup_tip_encryption' => 'Použijte TLS pro port 587 (doporučeno), SSL pro port 465 nebo Žádné pro port 25 (nedoporučeno pro produkci).',
        'setup_tip_test' => 'Vždy použijte tlačítko "Odeslat testovací e-mail" k ověření konfigurace před uložením.',
        'setup_tip_mailgun' => 'Pro lepší doručitelnost zvažte použití e-mailových služeb jako Mailgun, SendGrid nebo Amazon SES místo SMTP.',
        'queue_warning_title' => 'Vyžadována konfigurace fronty',
        'queue_warning_description' => 'Vaše fronta e-mailů je aktuálně nakonfigurována na použití ovladače ":default", ale váš worker fronty nemusí být spuštěn. To znamená, že e-maily nebudou odeslány, dokud nenastavíte worker fronty.',
        'queue_warning_action' => 'Pro okamžité odesílání e-mailů bez workera fronty nastavte QUEUE_CONNECTION=sync v souboru .env. Jinak se ujistěte, že váš worker fronty běží příkazem "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Další informace o frontách Laravel</a>.',
        'mail_gun_domain' => 'Doména',
        'mail_gun_domain_placeholder' => 'Např.: mg.vasedomena.cz',
        'mail_gun_domain_helper' => 'Název domény, kterou jste zaregistrovali u Mailgun',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => 'Např.: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Váš klíč Mailgun API',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Např.: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Endpoint Mailgun API (api.mailgun.net pro USA, api.eu.mailgun.net pro EU)',
        'log_channel' => 'Kanál logu',
        'log_channel_helper' => 'Vyberte kanál logování, který se má použít pro logy e-mailů',
        'sendmail_path' => 'Cesta k Sendmail',
        'local_domain' => 'Místní doména',
        'local_domain_placeholder' => 'Může být prázdné. Musí být nastaveno na vaši doménu při použití SMTP Relay. Např. vase-domena.cz',
        'local_domain_helper' => 'Doména, která bude použita k identifikaci serveru při komunikaci se vzdálenými SMTP servery',

        'ses_key' => 'Klíč',
        'ses_key_placeholder' => 'Např.: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Vaše ID přístupového klíče AWS',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => 'Např.: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Váš tajný přístupový klíč AWS',
        'ses_region' => 'Region',
        'ses_region_placeholder' => 'Např.: us-east-1',
        'ses_region_helper' => 'Region AWS, kde je nakonfigurována vaše služba SES',

        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Např.: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Váš token serveru Postmark',

        'resend_key' => 'Klíč API',
        'resend_key_placeholder' => 'Např.: re_123456789012345678901234567890',
        'resend_key_helper' => 'Váš klíč Resend API',

        'email_templates' => 'E-mailové šablony',
        'email_templates_description' => 'E-mailové šablony používající HTML a systémové proměnné.',
        'email_template_settings' => 'Nastavení e-mailových šablon',
        'email_template_settings_description' => 'Zobrazení a aktualizace nastavení e-mailových šablon',
        'email_rules' => 'Pravidla e-mailů',
        'email_rules_description' => 'Konfigurace pravidel e-mailů pro validaci',
        'base_template' => 'Základní šablona',
        'base_template_description' => 'Základní šablona pro všechny e-maily',
        'template_header' => 'Hlavička e-mailové šablony',
        'template_header_description' => 'Šablona hlavičky e-mailů',
        'template_footer' => 'Patička e-mailové šablony',
        'template_footer_description' => 'Šablona patičky e-mailů',
        'default' => 'Výchozí',
        'template_off_status_helper' => 'Tato e-mailová šablona je vypnuta.',
        'blacklist_email_domains' => 'Domény e-mailů na černé listině',
        'blacklist_email_domains_helper' => 'Zadejte seznam domén e-mailů, které budou na černé listině. Např. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'E-mailové adresy na černé listině',
        'blacklist_specified_emails_helper' => 'Zadejte seznam konkrétních e-mailových adres, které budou na černé listině. Např. mail@priklad.cz.',
        'exception_emails' => 'Výjimky e-mailů',
        'exception_emails_helper' => 'Tyto e-maily budou vyloučeny z validačních pravidel.',
        'email_rules_strict' => 'Přísná validace e-mailů',
        'email_rules_strict_helper' => 'Provádět validaci e-mailů podobnou RFC s přísnými pravidly.',
        'email_rules_dns' => 'Validace kontroly DNS',
        'email_rules_dns_helper' => 'Zkontrolovat, zda existují DNS záznamy indikující, že server přijímá e-maily.',
        'email_rules_spoof' => 'Detekce spoofingu',
        'email_rules_spoof_helper' => 'Detekovat potenciální pokusy o spoofing e-mailů.',
        'template_turn_off' => 'Kliknutím vypnete tuto e-mailovou šablonu',
        'template_turn_on' => 'Kliknutím zapnete tuto e-mailovou šablonu',
        'turn_on_success_message' => 'E-mailová šablona byla úspěšně zapnuta!',
        'turn_off_success_message' => 'E-mailová šablona byla úspěšně vypnuta!',
        'email_template_status' => 'Stav e-mailové šablony',
        'email_template_status_description' => 'Zapnout/vypnout e-mailovou šablonu',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Pokud není nastaveno, použije se logo správce z Správce -> Nastavení -> Vzhled správce -> Logo.',
        'email_template_copyright_text_helper_text' => 'Pokud není nastaveno, použije se copyright z možností tématu v Správce -> Vzhled -> Možnosti tématu -> Obecné -> Copyright.',
        'email_template_email_contact' => 'Kontaktní e-mailová adresa',
        'email_template_email_contact_helper_text' => 'Pokud není nastaveno, použije se e-mail odesílatele ze Správce -> Nastavení -> E-mail',
        'email_template_social_links' => 'Odkazy na sociální sítě',
        'email_template_copyright_text' => 'Copyright',
        'image_upload_supported' => 'Podporuje pouze formáty PNG, JPG, JPEG a GIF.',
        'email_template_custom_css' => 'Vlastní CSS pro e-mailovou šablonu',
        'social_links' => [
            'name' => 'Název',
            'icon' => 'Ikona',
            'icon_image' => 'Obrázek ikony (Podporuje pouze formáty PNG, JPG, JPEG a GIF.)',
            'url' => 'URL',
            'image' => 'Obrázek',
        ],
    ],
    'media' => [
        'title' => 'Média',
        'driver' => 'Ovladač',
        'description' => 'Nastavení médií',
        'local_disk' => 'Místní disk',
        'aws_access_key_id' => 'ID přístupového klíče AWS',
        'aws_secret_key' => 'Tajný klíč AWS',
        'aws_default_region' => 'Výchozí region AWS',
        'aws_bucket' => 'Bucket AWS',
        'aws_url' => 'URL AWS',
        'aws_endpoint' => 'Endpoint AWS (Volitelné)',
        'use_path_style_endpoint' => 'Použít endpoint ve stylu cesty',
        'r2_access_key_id' => 'ID přístupového klíče R2',
        'r2_secret_key' => 'Tajný klíč R2',
        'r2_bucket' => 'Bucket R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Endpoint R2',
        'do_spaces_access_key_id' => 'ID přístupového klíče DO Spaces',
        'do_spaces_secret_key' => 'Tajný klíč DO Spaces',
        'do_spaces_default_region' => 'Výchozí region DO Spaces',
        'do_spaces_bucket' => 'Bucket DO Spaces',
        'do_spaces_endpoint' => 'Endpoint DO Spaces',
        'do_spaces_cdn_enabled' => 'Je CDN DO Spaces povoleno?',
        'media_do_spaces_cdn_custom_domain' => 'Vlastní doména DO Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://vase-vlastni-domena.cz',
        'wasabi_access_key_id' => 'ID přístupového klíče Wasabi',
        'wasabi_secret_key' => 'Tajný klíč Wasabi',
        'wasabi_default_region' => 'Výchozí region Wasabi',
        'wasabi_bucket' => 'Bucket Wasabi',
        'wasabi_root' => 'Kořen Wasabi',
        'wasabi_root_helper' => 'Pro opětovné použití existujících obrázků jednoduše nastavte kořen Wasabi na "/", poté nahrajte všechny aktuální soubory z public/storage do kořenového adresáře Wasabi.',
        'backblaze_access_key_id' => 'ID přístupového klíče Backblaze',
        'backblaze_secret_key' => 'Tajný klíč Backblaze',
        'backblaze_bucket' => 'Bucket Backblaze',
        'backblaze_default_region' => 'Výchozí region Backblaze',
        'backblaze_url' => 'URL Backblaze',
        'backblaze_endpoint' => 'Endpoint Backblaze',
        'backblaze_cdn_enabled' => 'Je CDN Backblaze povoleno?',
        'media_backblaze_cdn_custom_domain' => 'Vlastní doména Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://vase-vlastni-domena.cz',
        'default_placeholder_image' => 'Výchozí zástupný obrázek',
        'enable_chunk' => 'Povolit nahrávání po částech',
        'chunk_size' => 'Velikost části (Byty)',
        'chunk_size_placeholder' => 'Výchozí: 1048576 ~ 1MB',
        'max_file_size' => 'Maximální velikost souboru při nahrávání po částech (MB)',
        'max_file_size_placeholder' => 'Výchozí: 1048576 ~ 1GB',
        'enable_watermark' => 'Povolit vodoznak',
        'watermark_source' => 'Obrázek vodoznaku',
        'watermark_source_helper' => 'Podporuje pouze formáty PNG, JPG a JPEG. Měli byste použít obrázek menší než 200x200px a velikost menší než 50KB.',
        'watermark_size' => 'Velikost vodoznaku (%)',
        'watermark_size_placeholder' => 'Výchozí: 10 (%)',
        'watermark_opacity' => 'Průhlednost vodoznaku (%)',
        'watermark_opacity_placeholder' => 'Výchozí: 70 (%)',
        'watermark_position' => 'Pozice vodoznaku',
        'watermark_position_x' => 'Pozice vodoznaku X',
        'watermark_position_y' => 'Pozice vodoznaku Y',
        'watermark_position_top_left' => 'Vlevo nahoře',
        'watermark_position_top_right' => 'Vpravo nahoře',
        'watermark_position_bottom_left' => 'Vlevo dole',
        'watermark_position_bottom_right' => 'Vpravo dole',
        'watermark_position_center' => 'Na střed',
        'turn_off_automatic_url_translation_into_latin' => 'Vypnout automatický překlad URL do latiny',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Název zóny (Název vaší úložné zóny)',
        'bunnycdn_key' => 'Heslo pro přístup FTP a API (Heslo pro přístup k API úložné zóny)',
        'bunnycdn_region' => 'Region (Region úložné zóny)',
        'optional' => 'Volitelné',
        'sizes' => 'Velikosti miniatur médií',
        'media_sizes_helper' => 'Nastavte šířku nebo výšku na 0, pokud chcete ořezat pouze podle šířky nebo výšky.',
        'width' => 'Šířka',
        'height' => 'Výška',
        'default_size_value' => 'Výchozí: :size',
        'all' => 'Vše',
        'all_helper_text' => 'Pokud zrušíte výběr všech složek, bude platit pro všechny složky.',
        'media_folders_can_add_watermark' => 'Přidat vodoznak pro obrázky ve složkách:',
        'max_upload_filesize' => 'Maximální velikost nahrávaného souboru (MB)',
        'max_upload_filesize_placeholder' => 'Výchozí: :size, musí být menší než :size.',
        'max_upload_filesize_helper' => 'Váš server umožňuje nahrávat soubory maximálně :size, můžete změnit tuto hodnotu a omezit velikost nahrávaných souborů.',
        'image_processing_library' => 'Knihovna pro zpracování obrázků',
        'use_original_name_for_file_path' => 'Použít původní název pro cestu souboru',
        'keep_original_file_size_and_quality' => 'Zachovat původní velikost a kvalitu souboru',
        'update_thumbnail_sizes_warning' => 'Po úpravě velikostí miniatur musíte kliknout na tlačítko ":button_text" pro jejich obnovení.',
        'thumbnail_crop_position' => 'Pozice ořezu miniatury',
        'thumbnail_crop_position_left' => 'Vlevo',
        'thumbnail_crop_position_center' => 'Na střed',
        'thumbnail_crop_position_right' => 'Vpravo',
        'thumbnail_crop_position_top' => 'Nahoře',
        'thumbnail_crop_position_bottom' => 'Dole',
        'thumbnail_crop_position_helper' => 'Toto nastavení se používá k oříznutí obrázku při generování miniatur. Bude oříznut z této pozice, dokud nebude obrázek vyplněn.',
        'user_can_only_view_own_media' => 'Uživatelé mohou zobrazit pouze svá vlastní média',
        'user_can_only_view_own_media_helper' => 'Pokud je povoleno, uživatelé mohou zobrazit pouze svá vlastní média, zatímco super správci mohou zobrazit všechna média.',
        'enable_thumbnail_sizes' => 'Povolit velikosti miniatur',
        'enable_thumbnail_sizes_helper' => 'Povolte tuto možnost pro generování miniatur obrázků. Pokud je zakázána, systém nebude generovat miniatury obrázků a vždy použije obrázek v plné velikosti.',
        'convert_image_to_webp' => 'Převést obrázky JPG, JPEG, PNG na WebP',
        'convert_image_to_webp_helper' => 'WebP je moderní formát obrázků, který poskytuje vynikající bezztrátovou a ztrátovou kompresi obrázků na webu. Je podporován v Chrome, Firefox, Edge a Opera. Obrázek bude převeden do formátu WebP při nahrávání. Platí pouze pro obrázky JPG, JPEG, PNG.',
        'reduce_large_image_size' => 'Zmenšit velikost velkých obrázků při nahrávání',
        'reduce_large_image_size_helper' => 'Pokud je povoleno, systém zmenší velikost velkých obrázků při nahrávání, platí pro obrázky JPG, JPEG, PNG, WebP. Maximální šířka a výška obrázku budou změněny na hodnoty, které nastavíte níže.',
        'image_max_width' => 'Maximální šířka obrázku (px)',
        'image_max_height' => 'Maximální výška obrázku (px)',
        'image_max_width_placeholder' => 'Nechte prázdné pro zachování původní šířky',
        'image_max_height_placeholder' => 'Nechte prázdné pro zachování původní výšky',
        'image_max_width_helper' => 'Nastavte maximální šířku obrázku v pixelech. Původní šířka bude zachována, pokud je toto pole prázdné.',
        'image_max_height_helper' => 'Nastavte maximální výšku obrázku v pixelech. Původní výška bude zachována, pokud je toto pole prázdné.',
        'customize_upload_path' => 'Přizpůsobit cestu pro nahrávání',
        'customize_upload_path_helper' => 'Přizpůsobte cestu pro nahrávání mediálních souborů. Ve výchozím nastavení systém nahraje soubory do složky ":path".',
        'upload_path' => 'Cesta pro nahrávání',
        'upload_path_placeholder' => 'Příklad: uploads',
        'upload_path_helper' => 'Tato složka bude vytvořena v /public. Výchozí složka je ":folder". Poté bude nahráno do "/public/:folder".',
        'upload_path_warning' => 'Systém nepřesune existující soubory do nové složky. Pokud chcete přesunout existující soubory do nové složky, musíte to udělat ručně.',
        'convert_file_name_to_uuid' => 'Převést název souboru na UUID',
        'convert_file_name_to_uuid_helper' => 'Pokud je povoleno, systém převede název souboru na UUID při nahrávání. Je to užitečné pro zabránění duplicitním názvům souborů a lepší zabezpečení.',
        's3_path' => 'Vlastní cesta S3 (Volitelné)',
        's3_path_placeholder' => 'Volitelná vlastní cesta v S3 bucketu (např. uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'Kód nákupu',
        'buyer' => 'Kupující',
    ],
    'field_type_not_exists' => 'Tento typ pole neexistuje',
    'save_settings' => 'Uložit nastavení',
    'template' => 'Šablona',
    'description' => 'Popis',
    'enable' => 'Povolit',
    'send' => 'Odeslat',
    'test_email_description' => 'Pro odeslání testovacího e-mailu se ujistěte, že jste aktualizovali konfiguraci pro odesílání e-mailů!',
    'test_email_input_placeholder' => 'Zadejte e-mailovou adresu, na kterou chcete odeslat testovací e-mail.',
    'test_email_modal_title' => 'Odeslat testovací e-mail',
    'test_send_mail' => 'Odeslat testovací e-mail',
    'test_email_send_success' => 'E-mail byl úspěšně odeslán!',
    'locale_direction_ltr' => 'Zleva doprava',
    'locale_direction_rtl' => 'Zprava doleva',
    'emails_warning' => 'Můžete přidat maximálně :count e-mailů',
    'email_add_more' => 'Přidat další',
    'generate' => 'Generovat',
    'generate_thumbnails' => 'Generovat miniatury',
    'generate_thumbnails_success' => 'Miniatury byly úspěšně vygenerovány. :count souborů bylo vygenerováno!',
    'generate_thumbnails_error' => 'Nepodařilo se regenerovat miniatury pro :count souborů!',
    'generate_thumbnails_description' => 'Opravdu chcete znovu vygenerovat miniatury pro všechny obrázky? To může chvíli trvat. Prosím, neopouštějte tuto stránku, dokud proces neskončí.',
    'enable_chunk_description' => 'Nahrávání po částech se používá pro nahrávání velkých souborů.',
    'watermark_description' => 'VAROVÁNÍ: Vodoznak je přidán pouze k nově nahraným obrázkům, nebude přidán k existujícím obrázkům. Zakázání vodoznaku neodstraní vodoznak z existujících obrázků.',
    'submit' => 'Odeslat',
    'back' => 'Zpět',
    'enter_sample_value' => 'Zadejte ukázkové hodnoty pro testování',
    'preview' => 'Náhled',
    'media_size_width' => 'Šířka velikosti :size musí být větší než 0',
    'media_size_height' => 'Výška velikosti :size musí být větší než 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob vám umožňuje automatizovat určité příkazy nebo skripty na vašem webu.',
        'is_not_ready' => 'Pro spuštění cronjobu postupujte podle níže uvedených pokynů.',
        'is_working' => 'Gratulujeme! Váš cronjob běží.',
        'is_not_working' => 'Váš cronjob neběží. Zkontrolujte prosím cronjob vašeho serveru.',
        'last_checked' => 'Naposledy zkontrolováno v :time.',
        'copy_button' => 'Kopírovat',
        'setup' => [
            'name' => 'Nastavení Cronjobu',
            'connect_to_server' => 'Připojte se k serveru přes SSH nebo jakoukoli preferovanou metodu.',
            'open_crontab' => 'Otevřete soubor crontab pomocí textového editoru (např. `crontab -e`).',
            'add_cronjob' => 'Přidejte výše uvedený příkaz do souboru crontab a uložte ho.',
            'done' => 'Cronjob nyní poběží každou minutu a provede zadaný příkaz.',
            'learn_more' => 'Více informací o cronjobu se můžete dozvědět v :documentation Laravel',
            'documentation' => 'dokumentaci',
            'copied' => 'Zkopírováno',
        ],
    ],
    'security' => [
        'title' => 'Nastavení zabezpečení',
        'description' => 'Zkontrolujte a nakonfigurujte nastavení zabezpečení pro váš web.',
        'menu_description' => 'Správa zabezpečení cookies a HTTP hlaviček',
        'status_secure' => 'Všechna nastavení zabezpečení jsou správně nakonfigurována!',
        'status_insecure' => 'Některá nastavení zabezpečení vyžadují pozornost!',
        'current_settings' => 'Aktuální nastavení zabezpečení',
        'status' => 'Stav',
        'setting' => 'Nastavení',
        'current_value' => 'Aktuální hodnota',
        'recommended_value' => 'Doporučeno',
        'session_http_only' => 'Příznak HttpOnly pro cookie',
        'session_http_only_description' => 'Zabraňuje JavaScriptu v přístupu k session cookies (chrání před XSS útoky)',
        'session_secure_cookie' => 'Příznak Secure pro cookie',
        'session_secure_cookie_description' => 'Zajišťuje, že cookies jsou odesílány pouze přes HTTPS připojení',
        'session_same_site' => 'Příznak SameSite pro cookie',
        'session_same_site_description' => 'Zabraňuje CSRF útokům omezením, kdy jsou cookies odesílány',
        'http_security_headers' => 'Bezpečnostní hlavičky HTTP',
        'http_security_headers_description' => 'Přidává bezpečnostní hlavičky pro ochranu před běžnými webovými zranitelnostmi',
        'https_warning' => 'Váš web nepoužívá HTTPS',
        'https_warning_description' => 'Některé funkce zabezpečení, jako jsou zabezpečené cookies, vyžadují HTTPS. Zvažte povolení SSL pro váš web.',
        'how_to_fix' => 'Jak opravit problémy se zabezpečením',
        'env_file_location' => 'Upravte soubor .env umístěný v:',
        'add_to_env' => 'Nastavení, která je třeba přidat',
        'required_settings' => 'Požadovaná nastavení zabezpečení',
        'for_https_sites' => 'Pouze pro weby HTTPS',
        'copy' => 'Kopírovat',
        'copy_settings' => 'Kopírovat všechna nastavení',
        'copied' => 'Zkopírováno!',
        'steps' => 'Kroky pro aplikaci nastavení',
        'step_1' => 'Otevřete soubor .env v textovém editoru',
        'step_2' => 'Přidejte nebo aktualizujte výše uvedená nastavení zabezpečení',
        'step_3' => 'Uložte soubor .env',
        'step_4' => 'Vymažte keš pomocí Administrační panel → Správa platformy → Správa keše',
        'security_headers_info' => 'Informace o bezpečnostních hlavičkách',
        'security_headers_list' => 'Pokud jsou povoleny, následující hlavičky jsou přidány ke všem odpovědím:',
        'header_nosniff' => 'Zabraňuje prohlížečům hádat typy obsahu',
        'header_frame' => 'Chrání před clickjacking útoky',
        'header_xss' => 'Povoluje ochranu prohlížeče před XSS',
        'header_referrer' => 'Řídí, kolik informací o refereru je odesláno',
        'learn_more' => 'Pro podrobnější informace viz :documentation',
        'documentation' => 'dokumentace zabezpečení',
    ],
    'cache' => [
        'title' => 'Keš',
        'description' => 'Konfigurace kešování pro optimalizovanou rychlost',
        'form' => [
            'cache_admin_menu' => 'Kešovat menu správce',
            'cache_admin_menu_helper' => 'Kešovat menu správce pro optimalizovanou rychlost. Tato možnost by měla být zakázána, pokud vyvíjíte nebo přizpůsobujete menu správce.',
            'enable_cache_site_map' => 'Kešovat mapu stránek',
            'enable_cache_site_map_helper' => 'Mapa stránek :url by měla být kešována kvůli velkému počtu stránek. Pokud máte malý počet stránek, můžete tuto možnost zakázat.',
            'cache_time_site_map' => 'Časový limit keše mapy stránek (v minutách)',
            'cache_front_menu' => 'Kešovat frontend menu',
            'cache_front_menu_helper' => 'Kešovat frontend menu pro optimalizovanou rychlost',
            'cache_user_avatar' => 'Kešovat avatary uživatelů',
            'cache_user_avatar_helper' => 'Pro uživatele bez avataru systém vygeneruje avatary z jejich uživatelských jmen. Avatary budou kešovány pro optimalizovanou rychlost a nebudou znovu generovány.',
            'shortcode_cache_enabled' => 'Kešovat zkrácené kódy (UI bloky)',
            'shortcode_cache_enabled_helper' => 'Povolit kešování zkrácených kódů pro zlepšení výkonu. Pokud je povoleno, zkrácené kódy budou kešovány pro zkrácení doby vykreslování.',
            'shortcode_cache_warning' => '<strong>⚠️ Důležité upozornění:</strong><br>• Zkrácené kódy obsahující formuláře (kontaktní formuláře, přihlášení k odběru newsletteru atd.) automaticky obejdou kešování pro zachování funkčnosti.<br>• Zkrácené kódy s dynamickým obsahem JavaScriptu by měly mít kešování zakázáno ručně.<br>• Pro zakázání kešování konkrétních zkrácených kódů přidejte <code>Enable caching: No</code> do konfigurace zkráceného kódu.<br>• Formuláře s CSRF tokeny, reCAPTCHA nebo jinými dynamickými prvky jsou automaticky detekovány a vyloučeny z kešování.',
            'shortcode_cache_ttl' => 'Doba trvání keše (sekundy)',
            'shortcode_cache_ttl_helper' => 'Doba, po kterou budou kešovány všechny zkrácené kódy. Výchozí je 1800 sekund (30 minut).',
            'widget_cache_enabled' => 'Kešovat widgety',
            'widget_cache_enabled_helper' => 'Povolit kešování widgetů pro zlepšení výkonu. Pokud je povoleno, widgety budou kešovány pro zkrácení doby vykreslování.',
            'widget_cache_warning' => '<strong>⚠️ Důležité upozornění:</strong><br>• Widgety obsahující formuláře (kontaktní formuláře, přihlášení k odběru newsletteru atd.) automaticky obejdou kešování pro zachování funkčnosti.<br>• Widgety s dynamickým obsahem JavaScriptu by měly mít kešování zakázáno ručně.<br>• Pro zakázání kešování konkrétních widgetů nastavte <code>Enable caching: No</code> v konfiguraci widgetu.<br>• Formuláře s CSRF tokeny, reCAPTCHA nebo jinými dynamickými prvky jsou automaticky detekovány a vyloučeny z kešování.',
            'widget_cache_ttl' => 'Doba trvání keše (sekundy)',
            'widget_cache_ttl_helper' => 'Doba, po kterou budou kešovány všechny widgety. Výchozí je 1800 sekund (30 minut).',
            'plugin_cache_enabled' => 'Kešovat nainstalované pluginy',
            'plugin_cache_enabled_helper' => 'Kešovat seznam nainstalovaných pluginů pro zlepšení výkonu. Pokud je povoleno, systém bude kešovat seznam pluginů po dobu 30 minut pro snížení skenování souborového systému.',
        ],
    ],
    'appearance' => [
        'title' => 'Vzhled',
    ],
    'panel' => [
        'common' => 'Běžné',
        'general' => 'Obecné',
        'general_description' => 'Zobrazení a aktualizace obecných nastavení a aktivace licence',
        'email' => 'E-mail',
        'email_description' => 'Zobrazení a aktualizace nastavení e-mailu a e-mailových šablon',
        'media' => 'Média',
        'media_description' => 'Zobrazení a aktualizace nastavení médií',
        'system' => 'Systém',
        'system_updater' => 'Aktualizátor systému',
        'system_updater_description' => 'Aktualizujte systém na nejnovější verzi',
        'others' => 'Ostatní',
    ],
    'saving' => 'Ukládání...',
    'generating_media_thumbnails' => 'Generování miniatur médií...',
    'test_email_template' => 'Testovat e-mailovou šablonu',
    'select_email_template' => 'Vybrat e-mailovou šablonu',
    'enums' => [
        'data_retention_period' => [
            '0' => 'Nikdy',
            '1' => '1 den',
            '3' => '3 dny',
            '7' => '1 týden',
            '30' => '1 měsíc',
            '90' => '3 měsíce',
            '180' => '6 měsíců',
            '365' => '1 rok',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute musí být platný region AWS (např. us-east-1, eu-west-1).',
    ],
];
