<?php

return [
    'title' => 'Settings',
    'general_setting' => 'réglages généraux',
    'menu' => 'Tous les paramètres',
    'email_setting_title' => 'Email settings',
    'email_setting_description' => 'Configurer les paramètres de messagerie',
    'general' => [
        'theme' => 'Thème',
        'rich_editor' => 'Éditeur riche',
        'seo_block' => 'Configuration du référencement',
        'seo_title' => 'Titre SEO',
        'seo_description' => 'Descriptif SEO',
        'webmaster_tools_block' => 'Outils Google pour les webmasters',
        'placeholder' => [
            'site_title' => 'Titre du site (maximum 120 caractères)',
            'admin_email' => 'E-mail de l\'administrateur',
            'seo_title' => 'Titre SEO (maximum 120 caractères)',
            'seo_description' => 'Description SEO (maximum 120 caractères)',
            'google_analytics' => 'Google Analytics',
        ],
        'time_zone' => 'Fuseau horaire',
        'enable_send_error_reporting_via_email_helper' => 'Lorsqu\'il est activé, des rapports d\'erreurs détaillés seront envoyés aux adresses e-mail de l\'administrateur lorsque des erreurs critiques se produisent sur le site',
        'time_zone_helper' => 'Sélectionnez le fuseau horaire de votre site Web. Cela sera utilisé pour tous les affichages de date et d\'heure dans tout le système',
        'enable_cache' => 'Activer le cache ?',
        'disabled_helper' => 'Impossible de désactiver ce modèle d\'e-mail !',
        'cache_time' => 'Temps de cache (minutes)',
        'enable_cache_site_map' => 'Activer le plan du site du cache ?',
        'cache_time_site_map' => 'Temps de cache Plan du site (minutes)',
        'seo_block_description' => 'Définition du titre du site, de la méta description du site, du mot-clé du site pour optimiser le référencement',
        'webmaster_tools_description' => 'Google Webmaster Tools (GWT) est un logiciel gratuit qui vous aide à gérer l\'aspect technique de votre site Web.',
        'select' => '- Sélectionner -',
        'locale_direction' => 'Direction linguistique du front-site',
        'minutes' => 'minutes',
        'redirect_404_to_homepage' => 'Rediriger toutes les requêtes introuvables vers la page d\'accueil ?',
    ],
    'admin_appearance' => [
        'title' => 'Apparition de l\'administrateur',
        'description' => 'Afficher et mettre à jour le logo, le favicon, la mise en page,...',
        'layout' => 'Mise en page',
        'horizontal' => 'Horizontal',
        'vertical' => 'Verticale',
        'show_menu_item_icon' => 'Afficher l\'icône de l\'élément de menu ?',
        'language' => 'Langue dans le panneau d\'administration',
        'theme_mode' => 'Mode thème',
        'dark' => 'Sombre',
        'light' => 'Lumière',
        'container_width' => [
            'title' => 'Largeur du conteneur',
            'default' => 'Défaut',
            'large' => 'Grand',
            'full' => 'Complet',
        ],
        'form' => [
            'admin_logo' => 'Logo d\'administrateur',
            'admin_favicon' => 'Icône de favori d\'administrateur',
            'admin_title' => 'Titre d\'administrateur',
            'admin_title_placeholder' => 'Titre affiché dans l\'onglet du navigateur',
            'admin_login_screen_backgrounds' => 'Arrière-plans de l\'écran de connexion (~ 1366 x 768)',
            'admin_locale' => 'Langue d\'administration',
            'admin_locale_direction' => 'Direction linguistique de l\'administrateur',
            'rich_editor' => 'Éditeur riche',
            'show_admin_bar' => 'Afficher la barre d\'administration (Lorsque l\'administrateur est connecté, afficher toujours la barre d\'administration sur le site Web) ?',
            'show_guidelines' => 'Afficher les lignes directrices ?',
            'primary_font' => 'Police principale',
            'primary_color' => 'Couleur primaire',
            'secondary_color' => 'Couleur secondaire',
            'heading_color' => 'Couleur du titre',
            'text_color' => 'Couleur du texte',
            'link_color' => 'Couleur du lien',
            'link_hover_color' => 'Couleur de survol du lien',
            'show_menu_item_icon' => 'Afficher l\'icône de l\'élément de menu ?',
            'custom_css' => 'CSS personnalisé',
            'custom_js' => 'JS personnalisé',
            'custom_header_js' => 'En-tête JS',
            'custom_header_js_placeholder' => 'JS dans l\'en-tête de la page, enveloppez-le dans <script></script>',
            'custom_body_js' => 'Corps JS',
            'custom_body_js_placeholder' => 'JS dans le corps de la page, enveloppez-le dans <script></script>',
            'custom_footer_js' => 'Pied de page JS',
            'custom_footer_js_placeholder' => 'JS en pied de page, enveloppez-le dans <script></script>',
        ],
    ],
    'datatable' => [
        'title' => 'Tableaux de données',
        'description' => 'Paramètres des tables de données',
        'form' => [
            'show_column_visibility' => 'Afficher la visibilité des colonnes par défaut ?',
            'show_export_button' => 'Afficher le bouton d\'exportation par défaut ?',
            'pagination_type' => 'Type de pagination',
            'default' => 'Défaut',
            'dropdown' => 'Dérouler',
        ],
    ],
    'email' => [
        'title' => 'Paramétrage du modèle d\'e-mail',
        'description' => 'Modèle d\'e-mail utilisant HTML et variables système.',
        'mailer' => 'Courrier',
        'port' => 'Port',
        'port_placeholder' => 'Exemple : 587',
        'host' => 'Hôte',
        'host_placeholder' => 'Ex : smtp.gmail.com',
        'encryption' => 'Chiffrement',
        'queue_warning_title' => 'Configuration de File d\'Attente Requise',
        'queue_warning_description' => 'Votre file d\'attente d\'e-mails est actuellement configurée pour utiliser le pilote ":default", mais votre worker de file d\'attente pourrait ne pas fonctionner. Cela signifie que les e-mails ne seront pas envoyés tant que vous n\'aurez pas configuré un worker de file d\'attente.',
        'queue_warning_action' => 'Pour envoyer des e-mails immédiatement sans worker de file d\'attente, définissez QUEUE_CONNECTION=sync dans votre fichier .env. Sinon, assurez-vous que votre worker de file d\'attente fonctionne avec "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">En savoir plus sur Laravel Queues</a>.',
        'mail_gun_domain' => 'Domaine',
        'mail_gun_domain_placeholder' => 'Domaine',
        'mail_gun_secret' => 'Secrète',
        'mail_gun_secret_placeholder' => 'Secrète',
        'mail_gun_endpoint' => 'Point de terminaison',
        'mail_gun_endpoint_placeholder' => 'Point de terminaison',
        'log_channel' => 'Canal de journal',
        'sendmail_path' => 'Chemin d\'envoi du courrier',
        'encryption_placeholder' => 'Cryptage : SSL ou TLS',
        'local_domain' => 'Domaine local',
        'local_domain_placeholder' => 'Il peut être vide. Doit être défini sur votre domaine lors de l\'utilisation du relais SMTP. Par exemple. votre-domaine.com',
        'ses_key' => 'Clé',
        'ses_key_placeholder' => 'Clé',
        'ses_secret' => 'Secrète',
        'ses_secret_placeholder' => 'Secrète',
        'ses_region' => 'Région',
        'ses_region_placeholder' => 'Région',
        'postmark_token' => 'Jeton',
        'postmark_token_placeholder' => 'Jeton',
        'email_templates' => 'Modèles d\'e-mails',
        'email_templates_description' => 'Modèles d\'e-mails utilisant HTML et variables système.',
        'email_template_settings' => 'Paramètres du modèle d\'e-mail',
        'email_template_settings_description' => 'Afficher et mettre à jour les paramètres de vos modèles d\'e-mail',
        'email_rules' => 'Règles de messagerie',
        'email_rules_description' => 'Configurer les règles de messagerie pour la validation',
        'base_template' => 'Modèle de base',
        'base_template_description' => 'Modèle de base pour tous les e-mails',
        'template_header' => 'En-tête du modèle d\'e-mail',
        'template_header_description' => 'Modèle d\'en-tête d\'e-mails',
        'template_footer' => 'Pied de page du modèle d\'e-mail',
        'template_footer_description' => 'Modèle de pied de page des e-mails',
        'default' => 'Défaut',
        'template_off_status_helper' => 'Ce modèle d\'e-mail est désactivé.',
        'blacklist_email_domains' => 'Domaines de messagerie sur liste noire',
        'blacklist_email_domains_helper' => 'Saisissez une liste de domaines de messagerie à mettre sur liste noire. Par exemple. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Adresses e-mail sur liste noire',
        'blacklist_specified_emails_helper' => 'Saisissez une liste d\'adresses e-mail spécifiques à mettre sur liste noire. Par exemple. mail@exemple.com.',
        'exception_emails' => 'E-mails d\'exception',
        'exception_emails_helper' => 'Ces emails seront exclus des règles de validation.',
        'email_rules_strict' => 'Validation stricte des e-mails',
        'email_rules_strict_helper' => 'Effectuez une validation des e-mails de type RFC avec des règles strictes.',
        'email_rules_dns' => 'Validation de la vérification DNS',
        'email_rules_dns_helper' => 'Vérifiez s\'il existe des enregistrements DNS indiquant que le serveur accepte les e-mails.',
        'email_rules_spoof' => 'Détection d\'usurpation d\'identité',
        'email_rules_spoof_helper' => 'Détectez les tentatives potentielles d’usurpation d’e-mails.',
        'template_turn_off' => 'Cliquez pour désactiver ce modèle d\'e-mail',
        'template_turn_on' => 'Cliquez pour activer ce modèle d\'e-mail',
        'turn_on_success_message' => 'Activez le modèle d\'e-mail avec succès !',
        'turn_off_success_message' => 'Désactivez le modèle d\'e-mail avec succès !',
        'email_template_status' => 'Statut du modèle d\'e-mail',
        'email_template_status_description' => 'Activer/désactiver le modèle d\'e-mail',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Si ce n\'est pas défini, il obtiendra le logo de l\'administrateur dans Admin -> Paramètres -> Apparence de l\'administrateur -> Logo.',
        'email_template_copyright_text_helper_text' => 'Si ce n\'est pas défini, il obtiendra les droits d\'auteur des options de thème dans Admin -> Apparence -> Options du thème -> Général -> Copyright.',
        'email_template_email_contact' => 'adresse e-mail de contact',
        'email_template_email_contact_helper_text' => 'Si ce n\'est pas défini, il recevra l\'e-mail de l\'expéditeur dans Admin -> Paramètres -> E-mail',
        'email_template_social_links' => 'Liens sociaux',
        'email_template_copyright_text' => 'droits d\'auteur',
        'image_upload_supported' => 'Prend en charge uniquement les formats PNG, JPG, JPEG et GIF.',
        'email_template_custom_css' => 'Modèle d\'e-mail CSS personnalisé',
        'social_links' => [
            'name' => 'Nom',
            'icon' => 'Icône',
            'icon_image' => 'Image d\'icône (prend en charge uniquement les formats PNG, JPG, JPEG et GIF.)',
            'url' => 'URL',
            'image' => 'Image',
        ],
    ],
    'media' => [
        'title' => 'Médias',
        'description' => 'Paramètres pour les médias',
        'aws_access_key_id' => 'ID de clé d\'accès AWS',
        'aws_secret_key' => 'Clé secrète AWS',
        'aws_default_region' => 'Région par défaut AWS',
        'aws_bucket' => 'Compartiment AWS',
        'aws_url' => 'URL AWS',
        'aws_endpoint' => 'Point de terminaison AWS (facultatif)',
        'use_path_style_endpoint' => 'Utiliser le point de terminaison du style de chemin ?',
        'r2_access_key_id' => 'ID de clé d\'accès R2',
        'r2_secret_key' => 'Clé secrète R2',
        'r2_bucket' => 'Godet R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Point de terminaison R2',
        'do_spaces_access_key_id' => 'ID de clé d\'accès aux espaces DO',
        'do_spaces_secret_key' => 'Clé secrète des espaces DO',
        'do_spaces_default_region' => 'Région par défaut des espaces DO',
        'do_spaces_bucket' => 'Seau d\'espaces DO',
        'do_spaces_endpoint' => 'Point de terminaison des espaces DO',
        'do_spaces_cdn_enabled' => 'Le CDN DO Spaces est-il activé ?',
        'media_do_spaces_cdn_custom_domain' => 'Faire un domaine personnalisé Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://votre-domaine-personnalisé.com',
        'wasabi_access_key_id' => 'Identifiant de la clé d\'accès Wasabi',
        'wasabi_secret_key' => 'Clé secrète Wasabi',
        'wasabi_default_region' => 'Région par défaut du wasabi',
        'wasabi_bucket' => 'Seau à Wasabi',
        'wasabi_root' => 'Racine de Wasabi',
        'wasabi_root_helper' => 'Pour réutiliser des images existantes, désignez simplement la racine Wasabi comme "/", puis téléchargez tous les fichiers actuels de public/storage vers votre répertoire racine Wasabi.',
        'default_placeholder_image' => 'Image de réserve par défaut',
        'chunk_size_placeholder' => 'Par défaut : 1048576 ~ 1 Mo',
        'max_file_size_placeholder' => 'Par défaut : 1048576 ~ 1 Go',
        'watermark_source' => 'Image en filigrane',
        'watermark_size' => 'Taille du filigrane (%)',
        'watermark_size_placeholder' => 'Par défaut : 10 (%)',
        'watermark_opacity' => 'Opacité du filigrane (%)',
        'watermark_opacity_placeholder' => 'Par défaut : 70 (%)',
        'watermark_position' => 'Position du filigrane',
        'watermark_position_x' => 'Position du filigrane X',
        'watermark_position_y' => 'Position du filigrane Y',
        'watermark_position_top_left' => 'En haut à gauche',
        'watermark_position_top_right' => 'En haut à droite',
        'watermark_position_bottom_left' => 'En bas à gauche',
        'watermark_position_bottom_right' => 'En bas à droite',
        'watermark_position_center' => 'Centre',
        'bunnycdn_hostname' => 'Nom d\'hôte',
        'bunnycdn_key' => 'Mot de passe d\'accès FTP et API (le mot de passe d\'accès à l\'API de la zone de stockage)',
        'sizes' => 'Tailles des miniatures multimédias',
        'default_size_value' => 'Default: :size',
        'all_helper_text' => 'Si vous décochez tous les dossiers, cela s\'appliquera à tous les dossiers.',
        'max_upload_filesize_placeholder' => 'Default: :size, must less than :size.',
        'image_processing_library' => 'Bibliothèque de traitement d\'images',
        'use_original_name_for_file_path' => 'Utiliser le nom d\'origine pour le chemin du fichier',
        'keep_original_file_size_and_quality' => 'Conserver la taille et la qualité du fichier d\'origine',
        'update_thumbnail_sizes_warning' => 'Après avoir ajusté la taille des vignettes, vous devez cliquer sur le bouton ":button_text" pour les actualiser.',
        'thumbnail_crop_position' => 'Position de recadrage des vignettes',
        'thumbnail_crop_position_left' => 'Gauche',
        'thumbnail_crop_position_center' => 'Centre',
        'thumbnail_crop_position_right' => 'Droite',
        'thumbnail_crop_position_top' => 'Haut',
        'thumbnail_crop_position_bottom' => 'Bas',
        'thumbnail_crop_position_helper' => 'Ce paramètre est utilisé pour recadrer l\'image lors de la génération de vignettes. Il sera recadré à partir de cette position jusqu\'à ce que l\'image soit remplie.',
        'user_can_only_view_own_media' => 'Les utilisateurs ne peuvent visualiser que leurs propres médias',
        'user_can_only_view_own_media_helper' => 'Lorsqu\'il est activé, les utilisateurs peuvent uniquement afficher leurs propres médias, tandis que les super administrateurs peuvent afficher tous les médias.',
    ],
    'license' => [
        'purchase_code' => 'Purchase code',
        'buyer' => 'Buyer',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Save settings',
    'template' => 'Modèle',
    'description' => 'Description',
    'enable' => 'Enable',
    'send' => 'Send',
    'test_email_description' => 'To send test email, please make sure you are updated configuration to send mail!',
    'test_email_input_placeholder' => 'Enter the email which you want to send test email.',
    'test_email_modal_title' => 'Send a test email',
    'test_send_mail' => 'Send test mail',
    'test_email_send_success' => 'Send email successfully!',
    'locale_direction_ltr' => 'Left to Right',
    'locale_direction_rtl' => 'Right to Left',
    'emails_warning' => 'You can add maximum :count emails',
    'email_add_more' => 'Add more',
    'generate' => 'Générer',
    'generate_thumbnails' => 'Générer des vignettes',
    'generate_thumbnails_success' => 'Generate thumbnails successfully. :count files are generated!',
    'generate_thumbnails_error' => 'We are unable to regenerate thumbnail for these files :count files!',
    'generate_thumbnails_description' => 'Are you sure you want to re-generate thumbnails for all images? It will take time so please DO NOT leave this page, wait until it is finished.',
    'enable_chunk_description' => 'Chunk size upload is used to upload large file size.',
    'watermark_description' => 'WARNING: Watermark is just added to new uploaded images, it won\'t be added to existing images. Disable watermark won\'t remove watermark from existing images.',
    'submit' => 'Soumettre',
    'back' => 'Dos',
    'enter_sample_value' => 'Entrez des exemples de valeurs pour les tests',
    'preview' => 'Aperçu',
    'media_size_width' => ':size size width must be greater than 0',
    'media_size_height' => ':size size height must be greater than 0',
    'cronjob' => [
        'name' => 'Tâche planifiée',
        'description' => 'Cronjob vous permet d\'automatiser certaines commandes ou scripts sur votre site.',
        'is_not_ready' => 'Pour exécuter la tâche cron, suivez les instructions ci-dessous.',
        'is_working' => 'Toutes nos félicitations! Votre tâche cron est en cours d\'exécution.',
        'is_not_working' => 'Votre tâche cron ne fonctionne pas. Veuillez vérifier la tâche cron de votre serveur.',
        'last_checked' => 'Last checked at :time.',
        'copy_button' => 'Copie',
        'setup' => [
            'name' => 'Configuration du travail Cron',
            'connect_to_server' => 'Connectez-vous à votre serveur via SSH ou toute autre méthode préférée.',
            'open_crontab' => 'Ouvrez le fichier crontab à l\'aide d\'un éditeur de texte (par exemple, `crontab -e`).',
            'add_cronjob' => 'Ajoutez la commande ci-dessus au fichier crontab et enregistrez-le.',
            'done' => 'Le cronjob s\'exécutera désormais toutes les minutes et exécutera la commande spécifiée.',
            'learn_more' => 'You can learn more about cronjob from the Laravel :documentation',
            'documentation' => 'Documentation',
            'copied' => 'Copié',
        ],
    ],
    'security' => [
        'title' => 'Paramètres de sécurité',
        'description' => 'Vérifier et configurer les paramètres de sécurité pour votre site web.',
        'menu_description' => 'Gérer la sécurité des cookies et les en-têtes HTTP',
        'status_secure' => 'Tous les paramètres de sécurité sont correctement configurés !',
        'status_insecure' => 'Certains paramètres de sécurité nécessitent votre attention !',
        'current_settings' => 'Paramètres de sécurité actuels',
        'status' => 'Statut',
        'setting' => 'Paramètre',
        'current_value' => 'Valeur actuelle',
        'recommended_value' => 'Recommandé',
        'session_http_only' => 'Indicateur HttpOnly Cookie',
        'session_http_only_description' => 'Empêche JavaScript d\'accéder aux cookies de session (protège contre les attaques XSS)',
        'session_secure_cookie' => 'Indicateur Secure Cookie',
        'session_secure_cookie_description' => 'S\'assure que les cookies ne sont envoyés que via des connexions HTTPS',
        'session_same_site' => 'Indicateur SameSite Cookie',
        'session_same_site_description' => 'Empêche les attaques CSRF en limitant l\'envoi des cookies',
        'http_security_headers' => 'En-têtes de sécurité HTTP',
        'http_security_headers_description' => 'Ajoute des en-têtes de sécurité pour protéger contre les vulnérabilités web courantes',
        'https_warning' => 'Votre site n\'utilise pas HTTPS',
        'https_warning_description' => 'Certaines fonctionnalités de sécurité comme les cookies sécurisés nécessitent HTTPS. Envisagez d\'activer SSL pour votre site web.',
        'how_to_fix' => 'Comment résoudre les problèmes de sécurité',
        'env_file_location' => 'Modifiez votre fichier .env situé à :',
        'add_to_env' => 'Paramètres à ajouter',
        'required_settings' => 'Paramètres de sécurité requis',
        'for_https_sites' => 'Pour les sites HTTPS uniquement',
        'copy' => 'Copier',
        'copy_settings' => 'Copier tous les paramètres',
        'copied' => 'Copié !',
        'steps' => 'Étapes pour appliquer les paramètres',
        'step_1' => 'Ouvrez votre fichier .env dans un éditeur de texte',
        'step_2' => 'Ajoutez ou mettez à jour les paramètres de sécurité affichés ci-dessus',
        'step_3' => 'Enregistrez le fichier .env',
        'step_4' => 'Videz le cache via Panneau d\'administration → Administration de la plateforme → Gestion du cache',
        'security_headers_info' => 'Informations sur les en-têtes de sécurité',
        'security_headers_list' => 'Lorsqu\'ils sont activés, les en-têtes suivants sont ajoutés à toutes les réponses :',
        'header_nosniff' => 'Empêche les navigateurs de deviner les types de contenu',
        'header_frame' => 'Protège contre les attaques de clickjacking',
        'header_xss' => 'Active la protection XSS du navigateur',
        'header_referrer' => 'Contrôle la quantité d\'informations de référence envoyées',
        'learn_more' => 'Pour des informations plus détaillées, consultez la :documentation',
        'documentation' => 'documentation de sécurité',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Cache de configuration pour le système pour optimiser la vitesse',
        'form' => [
            'enable_cache' => 'Activer le cache ?',
            'cache_time' => 'Temps de cache (minutes)',
            'disable_cache_in_the_admin_panel' => 'Désactiver le cache dans le panneau d\'administration ?',
            'cache_admin_menu' => 'Menu d\'administration du cache ?',
            'enable_cache_site_map' => 'Activer le plan du site du cache ?',
            'cache_time_site_map' => 'Temps de cache Plan du site (minutes)',
        ],
    ],
    'appearance' => [
        'title' => 'Apparence',
    ],
    'panel' => [
        'common' => 'Commun',
        'general' => 'Général',
        'general_description' => 'Afficher et mettre à jour vos paramètres généraux et activer la licence',
        'email' => 'E-mail',
        'email_description' => 'Afficher et mettre à jour vos paramètres de messagerie et vos modèles de courrier électronique',
        'media' => 'Médias',
        'media_description' => 'Afficher et mettre à jour vos paramètres multimédias',
        'system' => 'Système',
        'system_updater' => 'Programme de mise à jour du système',
        'system_updater_description' => 'Mettez à jour votre système avec la dernière version',
        'others' => 'Autres',
    ],
    'saving' => 'Saving...',
    'generating_media_thumbnails' => 'Génération de vignettes multimédias...',
    'test_email_template' => 'Tester le modèle d\'e-mail',
    'select_email_template' => 'Sélectionnez un modèle d\'e-mail',
];
