<?php

return [
    'title' => 'सेटिंग्स',
    'general_setting' => 'सामान्य सेटिंग्स',
    'menu' => 'सभी सेटिंग्स',
    'email_setting_title' => 'ईमेल सेटिंग्स',
    'email_setting_description' => 'ईमेल सेटिंग्स कॉन्फ़िगर करें',
    'general' => [
        'theme' => 'थीम',
        'title' => 'सामान्य जानकारी',
        'description' => 'साइट जानकारी देखें और अपडेट करें',
        'rich_editor' => 'रिच एडिटर',
        'site_title' => 'साइट शीर्षक',
        'admin_email' => 'एडमिन ईमेल',
        'seo_block' => 'SEO कॉन्फ़िगरेशन',
        'seo_title' => 'SEO शीर्षक',
        'seo_description' => 'SEO विवरण',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'साइट शीर्षक (अधिकतम 120 वर्ण)',
            'admin_email' => 'एडमिन ईमेल',
            'seo_title' => 'SEO शीर्षक (अधिकतम 120 वर्ण)',
            'seo_description' => 'SEO विवरण (अधिकतम 120 वर्ण)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'ईमेल के माध्यम से त्रुटि रिपोर्टिंग भेजें',
        'enable_send_error_reporting_via_email_helper' => 'सक्षम होने पर, जब साइट पर गंभीर त्रुटियां होती हैं तो विस्तृत त्रुटि रिपोर्ट व्यवस्थापक ईमेल पते पर भेजी जाएगी',
        'time_zone_helper' => 'अपनी वेबसाइट के लिए समय क्षेत्र चुनें। इसका उपयोग पूरे सिस्टम में सभी तारीख और समय प्रदर्शनों के लिए किया जाएगा',
        'time_zone' => 'समय क्षेत्र',
        'enable' => 'सक्षम करें',
        'disable' => 'अक्षम करें',
        'disabled_helper' => 'इस ईमेल टेम्पलेट को अक्षम नहीं किया जा सकता!',
        'enable_cache_site_map' => 'साइटमैप कैशिंग सक्षम करें',
        'cache_time_site_map' => 'साइटमैप कैश टाइमआउट (मिनटों में)',
        'admin_logo' => 'एडमिन लोगो',
        'admin_favicon' => 'एडमिन फ़ेविकॉन',
        'admin_title' => 'एडमिन शीर्षक',
        'admin_title_placeholder' => 'ब्राउज़र टैब में दिखाने के लिए शीर्षक',
        'admin_appearance_title' => 'एडमिन दिखावट',
        'admin_appearance_description' => 'एडमिन दिखावट सेटिंग जैसे एडिटर, भाषा...',
        'seo_block_description' => 'SEO को अनुकूलित करने के लिए साइट शीर्षक, साइट मेटा विवरण, साइट कीवर्ड सेट करें',
        'webmaster_tools_description' => 'Google Search Console एक निःशुल्क वेब टूल है जो Google द्वारा प्रदान किया जाता है जो वेबसाइट मालिकों को Google Search परिणामों में अपनी साइट के प्रदर्शन की निगरानी करने में मदद करता है।',
        'yes' => 'हां',
        'no' => 'नहीं',
        'show_on_front' => 'आपका होमपेज प्रदर्शित करता है',
        'select' => '— चुनें —',
        'show_site_name' => 'पेज शीर्षक के बाद साइट नाम दिखाएं, "-" से अलग',
        'locale' => 'साइट भाषा',
        'locale_direction' => 'फ्रंट साइट भाषा दिशा',
        'minutes' => 'मिनट',
        'redirect_404_to_homepage' => 'सभी Not Found अनुरोधों को होमपेज पर रीडायरेक्ट करें',
    ],
    'admin_appearance' => [
        'title' => 'एडमिन दिखावट',
        'description' => 'लोगो, फ़ेविकॉन, लेआउट देखें और अपडेट करें,...',
        'layout' => 'लेआउट',
        'horizontal' => 'क्षैतिज',
        'vertical' => 'लंबवत',
        'show_menu_item_icon' => 'मेनू आइटम आइकन दिखाएं',
        'language' => 'एडमिन पैनल भाषा',
        'theme_mode' => 'थीम मोड',
        'dark' => 'गहरा',
        'light' => 'हल्का',
        'container_width' => [
            'title' => 'कंटेनर चौड़ाई',
            'default' => 'डिफ़ॉल्ट',
            'large' => 'बड़ा',
            'full' => 'पूर्ण',
        ],
        'form' => [
            'admin_logo' => 'एडमिन लोगो',
            'admin_logo_max_height' => 'लोगो ऊंचाई (px)',
            'admin_logo_max_height_helper' => 'लोगो की ऊंचाई पिक्सेल में सेट करें। डिफ़ॉल्ट मान :default है।',
            'admin_favicon' => 'एडमिन फ़ेविकॉन',
            'admin_favicon_type' => 'एडमिन फ़ेविकॉन प्रकार',
            'admin_title' => 'एडमिन शीर्षक',
            'admin_title_placeholder' => 'ब्राउज़र टैब में दिखाने के लिए शीर्षक',
            'admin_login_screen_backgrounds' => 'लॉगिन स्क्रीन पृष्ठभूमि (~1366 x 768)',
            'admin_locale' => 'एडमिन भाषा',
            'admin_locale_direction' => 'एडमिन भाषा दिशा',
            'rich_editor' => 'रिच एडिटर',
            'show_admin_bar' => 'लॉग-इन एडमिन के लिए एडमिन बार दिखाएं, फ्रंट साइट में भी',
            'show_guidelines' => 'दिशानिर्देश दिखाएं',
            'primary_font' => 'प्राथमिक फ़ॉन्ट',
            'primary_color' => 'प्राथमिक रंग',
            'secondary_color' => 'द्वितीयक रंग',
            'heading_color' => 'शीर्षक रंग',
            'text_color' => 'टेक्स्ट रंग',
            'link_color' => 'लिंक रंग',
            'link_hover_color' => 'लिंक होवर रंग',
            'show_menu_item_icon' => 'मेनू आइटम आइकन दिखाएं',
            'custom_css' => 'कस्टम CSS',
            'custom_js' => 'कस्टम JS',
            'custom_header_js' => 'हेडर JS',
            'custom_header_js_placeholder' => 'पेज हेडर में JavaScript, इसे &#x3C;script&#x3E;&#x3C;/script&#x3E; के अंदर लपेटें',
            'custom_body_js' => 'बॉडी JS',
            'custom_body_js_placeholder' => 'पेज बॉडी में JavaScript, इसे &#x3C;script&#x3E;&#x3C;/script&#x3E; के अंदर लपेटें',
            'custom_footer_js' => 'फुटर JS',
            'custom_footer_js_placeholder' => 'पेज फुटर में JavaScript, इसे &#x3C;script&#x3E;&#x3C;/script&#x3E; के अंदर लपेटें',
        ],
    ],
    'datatable' => [
        'title' => 'डेटाटेबल',
        'description' => 'डेटाटेबल के लिए सेटिंग्स',
        'form' => [
            'show_column_visibility' => 'डिफ़ॉल्ट रूप से कॉलम दृश्यता दिखाएं',
            'show_column_visibility_helper' => 'उपयोगकर्ताओं को कॉलम दिखाने/छुपाने की अनुमति देने के लिए डेटा टेबल में कॉलम दृश्यता टॉगल बटन सक्षम करें',
            'show_export_button' => 'डिफ़ॉल्ट रूप से एक्सपोर्ट बटन दिखाएं',
            'show_export_button_helper' => 'टेबल डेटा डाउनलोड करने के लिए डेटा टेबल में एक्सपोर्ट विकल्प (CSV, Excel, PDF) प्रदर्शित करें',
            'pagination_type' => 'पेजिनेशन प्रकार',
            'pagination_type_helper' => 'चुनें कि पेजिनेशन नियंत्रण कैसे प्रदर्शित किए जाते हैं: डिफ़ॉल्ट पेज नंबर दिखाता है, ड्रॉपडाउन एक कॉम्पैक्ट ड्रॉपडाउन सिलेक्टर दिखाता है',
            'default' => 'डिफ़ॉल्ट',
            'dropdown' => 'ड्रॉपडाउन',
            'enable_responsive' => 'टेबल रिस्पॉन्सिव सक्षम करें',
            'enable_responsive_helper' => 'बेहतर मोबाइल अनुभव के लिए विभिन्न स्क्रीन आकारों में फिट होने के लिए टेबल कॉलम को स्वचालित रूप से समायोजित करें',
        ],
    ],
    'email' => [
        'subject' => 'विषय',
        'content' => 'सामग्री',
        'title' => 'ईमेल टेम्पलेट के लिए सेटिंग',
        'description' => 'HTML और सिस्टम वेरिएबल का उपयोग करके ईमेल टेम्पलेट।',
        'reset_to_default' => 'डिफ़ॉल्ट पर रीसेट करें',
        'back' => 'सेटिंग्स पर वापस जाएं',
        'reset_success' => 'सफलतापूर्वक डिफ़ॉल्ट पर रीसेट',
        'confirm_reset' => 'ईमेल टेम्पलेट रीसेट करने की पुष्टि करें?',
        'confirm_message' => 'क्या आप वाकई इस ईमेल टेम्पलेट को डिफ़ॉल्ट पर वापस रीसेट करना चाहते हैं?',
        'continue' => 'जारी रखें',
        'sender_name' => 'प्रेषक का नाम',
        'sender_name_placeholder' => 'नाम',
        'sender_name_helper' => 'वह नाम जो सिस्टम द्वारा भेजे गए ईमेल के From फ़ील्ड में दिखाई देगा',
        'sender_email' => 'प्रेषक ईमेल',
        'sender_email_placeholder' => 'ईमेल पता (उदाहरण: :default)',
        'sender_email_helper' => 'वह ईमेल पता जो सिस्टम द्वारा भेजे गए सभी ईमेल के लिए प्रेषक के रूप में उपयोग किया जाएगा',
        'mailer' => 'मेलर',
        'port' => 'पोर्ट',
        'port_placeholder' => 'उदाहरण: 587',
        'port_helper' => 'आपके मेल सर्वर द्वारा उपयोग किया जाने वाला पोर्ट (सामान्य पोर्ट: 25, 465, 587)',
        'host' => 'होस्ट',
        'host_placeholder' => 'उदाहरण: smtp.gmail.com',
        'host_helper' => 'SMTP होस्ट पता',
        'username' => 'उपयोगकर्ता नाम',
        'username_placeholder' => 'मेल सर्वर में लॉगिन करने के लिए उपयोगकर्ता नाम',
        'username_helper' => 'आपका मेल सर्वर लॉगिन उपयोगकर्ता नाम',
        'password' => 'पासवर्ड',
        'password_placeholder' => 'मेल सर्वर में लॉगिन करने के लिए पासवर्ड',
        'password_helper' => 'आपका मेल सर्वर लॉगिन पासवर्ड',
        'encryption' => 'एन्क्रिप्शन',
        'encryption_placeholder' => 'एन्क्रिप्शन प्रकार चुनें',
        'encryption_helper' => 'सुरक्षित ईमेल ट्रांसमिशन के लिए एन्क्रिप्शन विधि चुनें',
        'encryption_none' => 'कोई नहीं',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'ईमेल सेटअप टिप्स',
        'setup_tip_gmail' => 'Gmail के लिए: होस्ट के रूप में smtp.gmail.com का उपयोग करें, TLS के साथ पोर्ट 587 या SSL के साथ पोर्ट 465। "Less secure app access" सक्षम करें या App Password का उपयोग करें।',
        'setup_tip_port' => 'सामान्य पोर्ट: 25 (अनएन्क्रिप्टेड), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (वैकल्पिक)।',
        'setup_tip_encryption' => 'पोर्ट 587 (अनुशंसित) के लिए TLS, पोर्ट 465 के लिए SSL, या पोर्ट 25 के लिए None (प्रोडक्शन के लिए अनुशंसित नहीं) का उपयोग करें।',
        'setup_tip_test' => 'सहेजने से पहले अपने कॉन्फ़िगरेशन को सत्यापित करने के लिए हमेशा "Send Test Email" बटन का उपयोग करें।',
        'setup_tip_mailgun' => 'बेहतर डिलीवरेबिलिटी के लिए, SMTP के बजाय Mailgun, SendGrid, या Amazon SES जैसी ईमेल सेवाओं का उपयोग करने पर विचार करें।',
        'queue_warning_title' => 'कतार कॉन्फ़िगरेशन आवश्यक',
        'queue_warning_description' => 'आपकी ईमेल कतार वर्तमान में ":default" ड्राइवर का उपयोग करने के लिए कॉन्फ़िगर की गई है, लेकिन आपका कतार वर्कर नहीं चल रहा हो सकता है। इसका मतलब है कि ईमेल तब तक नहीं भेजे जाएंगे जब तक आप कतार वर्कर सेट नहीं करते।',
        'queue_warning_action' => 'कतार वर्कर के बिना तुरंत ईमेल भेजने के लिए, अपनी .env फ़ाइल में QUEUE_CONNECTION=sync सेट करें। अन्यथा, सुनिश्चित करें कि आपका कतार वर्कर "php artisan queue:work" के साथ चल रहा है। <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Laravel Queues के बारे में अधिक जानें</a>।',
        'mail_gun_domain' => 'डोमेन',
        'mail_gun_domain_placeholder' => 'उदाहरण: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'वह डोमेन नाम जो आपने Mailgun के साथ पंजीकृत किया है',
        'mail_gun_secret' => 'सीक्रेट',
        'mail_gun_secret_placeholder' => 'उदाहरण: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'आपकी Mailgun API कुंजी',
        'mail_gun_endpoint' => 'एंडपॉइंट',
        'mail_gun_endpoint_placeholder' => 'उदाहरण: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API एंडपॉइंट (US के लिए api.mailgun.net, EU के लिए api.eu.mailgun.net)',
        'log_channel' => 'लॉग चैनल',
        'log_channel_helper' => 'ईमेल लॉग के लिए किस लॉगिंग चैनल का उपयोग करना है, चुनें',
        'sendmail_path' => 'Sendmail पथ',
        'local_domain' => 'स्थानीय डोमेन',
        'local_domain_placeholder' => 'यह खाली हो सकता है। SMTP Relay का उपयोग करते समय अपने डोमेन पर सेट करने की आवश्यकता है। उदाहरण: your-domain.com',
        'local_domain_helper' => 'वह डोमेन जो रिमोट SMTP सर्वर के साथ संचार करते समय सर्वर की पहचान करने के लिए उपयोग किया जाएगा',

        'ses_key' => 'कुंजी',
        'ses_key_placeholder' => 'उदाहरण: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'आपकी AWS एक्सेस कुंजी ID',
        'ses_secret' => 'सीक्रेट',
        'ses_secret_placeholder' => 'उदाहरण: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'आपकी AWS सीक्रेट एक्सेस कुंजी',
        'ses_region' => 'क्षेत्र',
        'ses_region_placeholder' => 'उदाहरण: us-east-1',
        'ses_region_helper' => 'वह AWS क्षेत्र जहां आपकी SES सेवा कॉन्फ़िगर की गई है',

        'postmark_token' => 'टोकन',
        'postmark_token_placeholder' => 'उदाहरण: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'आपका Postmark सर्वर टोकन',

        'resend_key' => 'API कुंजी',
        'resend_key_placeholder' => 'उदाहरण: re_123456789012345678901234567890',
        'resend_key_helper' => 'आपकी Resend API कुंजी',

        'email_templates' => 'ईमेल टेम्पलेट',
        'email_templates_description' => 'HTML और सिस्टम वेरिएबल का उपयोग करके ईमेल टेम्पलेट।',
        'email_template_settings' => 'ईमेल टेम्पलेट सेटिंग्स',
        'email_template_settings_description' => 'अपनी ईमेल टेम्पलेट सेटिंग्स देखें और अपडेट करें',
        'email_rules' => 'ईमेल नियम',
        'email_rules_description' => 'सत्यापन के लिए ईमेल नियम कॉन्फ़िगर करें',
        'base_template' => 'बेस टेम्पलेट',
        'base_template_description' => 'सभी ईमेल के लिए बेस टेम्पलेट',
        'template_header' => 'ईमेल टेम्पलेट हेडर',
        'template_header_description' => 'ईमेल के हेडर के लिए टेम्पलेट',
        'template_footer' => 'ईमेल टेम्पलेट फुटर',
        'template_footer_description' => 'ईमेल के फुटर के लिए टेम्पलेट',
        'default' => 'डिफ़ॉल्ट',
        'template_off_status_helper' => 'यह ईमेल टेम्पलेट बंद है।',
        'blacklist_email_domains' => 'ब्लैकलिस्ट किए गए ईमेल डोमेन',
        'blacklist_email_domains_helper' => 'ब्लैकलिस्ट किए जाने वाले ईमेल डोमेन की सूची दर्ज करें। उदाहरण: gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'ब्लैकलिस्ट किए गए ईमेल पते',
        'blacklist_specified_emails_helper' => 'ब्लैकलिस्ट किए जाने वाले विशिष्ट ईमेल पतों की सूची दर्ज करें। उदाहरण: mail@example.com.',
        'exception_emails' => 'अपवाद ईमेल',
        'exception_emails_helper' => 'ये ईमेल सत्यापन नियमों से बाहर रखे जाएंगे।',
        'email_rules_strict' => 'सख्त ईमेल सत्यापन',
        'email_rules_strict_helper' => 'सख्त नियमों के साथ RFC-जैसा ईमेल सत्यापन करें।',
        'email_rules_dns' => 'DNS जांच सत्यापन',
        'email_rules_dns_helper' => 'जांचें कि क्या DNS रिकॉर्ड हैं जो संकेत देते हैं कि सर्वर ईमेल स्वीकार करता है।',
        'email_rules_spoof' => 'स्पूफिंग पहचान',
        'email_rules_spoof_helper' => 'संभावित ईमेल स्पूफिंग प्रयासों का पता लगाएं।',
        'template_turn_off' => 'इस ईमेल टेम्पलेट को बंद करने के लिए क्लिक करें',
        'template_turn_on' => 'इस ईमेल टेम्पलेट को चालू करने के लिए क्लिक करें',
        'turn_on_success_message' => 'ईमेल टेम्पलेट सफलतापूर्वक चालू!',
        'turn_off_success_message' => 'ईमेल टेम्पलेट सफलतापूर्वक बंद!',
        'email_template_status' => 'ईमेल टेम्पलेट स्थिति',
        'email_template_status_description' => 'ईमेल टेम्पलेट चालू/बंद करें',
        'email_template_logo' => 'लोगो',
        'email_template_logo_helper_text' => 'यदि सेट नहीं किया गया है, तो यह Admin -> Settings -> Admin Appearance -> Logo में एडमिन लोगो से प्राप्त होगा।',
        'email_template_copyright_text_helper_text' => 'यदि सेट नहीं किया गया है, तो यह Admin -> Appearance -> Theme Options -> General -> Copyright में थीम विकल्प कॉपीराइट से प्राप्त होगा।',
        'email_template_email_contact' => 'संपर्क ईमेल पता',
        'email_template_email_contact_helper_text' => 'यदि सेट नहीं किया गया है, तो यह Admin -> Settings -> Email में प्रेषक ईमेल से प्राप्त होगा',
        'email_template_social_links' => 'सोशल लिंक',
        'email_template_copyright_text' => 'कॉपीराइट',
        'image_upload_supported' => 'केवल PNG, JPG, JPEG, और GIF फॉर्मेट समर्थित हैं।',
        'email_template_custom_css' => 'ईमेल टेम्पलेट कस्टम CSS',
        'social_links' => [
            'name' => 'नाम',
            'icon' => 'आइकन',
            'icon_image' => 'आइकन छवि (केवल PNG, JPG, JPEG, और GIF फॉर्मेट समर्थित हैं।)',
            'url' => 'URL',
            'image' => 'छवि',
        ],
    ],
    'media' => [
        'title' => 'मीडिया',
        'driver' => 'ड्राइवर',
        'description' => 'मीडिया के लिए सेटिंग्स',
        'local_disk' => 'स्थानीय डिस्क',
        'aws_access_key_id' => 'AWS एक्सेस कुंजी ID',
        'aws_secret_key' => 'AWS सीक्रेट कुंजी',
        'aws_default_region' => 'AWS डिफ़ॉल्ट क्षेत्र',
        'aws_bucket' => 'AWS बकेट',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS एंडपॉइंट (वैकल्पिक)',
        'use_path_style_endpoint' => 'पथ शैली एंडपॉइंट का उपयोग करें',
        'r2_access_key_id' => 'R2 एक्सेस कुंजी ID',
        'r2_secret_key' => 'R2 सीक्रेट कुंजी',
        'r2_bucket' => 'R2 बकेट',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 एंडपॉइंट',
        'do_spaces_access_key_id' => 'DO Spaces एक्सेस कुंजी ID',
        'do_spaces_secret_key' => 'DO Spaces सीक्रेट कुंजी',
        'do_spaces_default_region' => 'DO Spaces डिफ़ॉल्ट क्षेत्र',
        'do_spaces_bucket' => 'DO Spaces बकेट',
        'do_spaces_endpoint' => 'DO Spaces एंडपॉइंट',
        'do_spaces_cdn_enabled' => 'क्या DO Spaces CDN सक्षम है?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN कस्टम डोमेन',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi एक्सेस कुंजी ID',
        'wasabi_secret_key' => 'Wasabi सीक्रेट कुंजी',
        'wasabi_default_region' => 'Wasabi डिफ़ॉल्ट क्षेत्र',
        'wasabi_bucket' => 'Wasabi बकेट',
        'wasabi_root' => 'Wasabi रूट',
        'wasabi_root_helper' => 'मौजूदा छवियों का पुन: उपयोग करने के लिए, बस Wasabi रूट को "/" के रूप में निर्दिष्ट करें, फिर सभी वर्तमान फ़ाइलों को public/storage से अपनी Wasabi रूट निर्देशिका में अपलोड करें।',
        'backblaze_access_key_id' => 'Backblaze एक्सेस कुंजी ID',
        'backblaze_secret_key' => 'Backblaze सीक्रेट कुंजी',
        'backblaze_bucket' => 'Backblaze बकेट',
        'backblaze_default_region' => 'Backblaze डिफ़ॉल्ट क्षेत्र',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze एंडपॉइंट',
        'backblaze_cdn_enabled' => 'क्या Backblaze CDN सक्षम है?',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN कस्टम डोमेन',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'डिफ़ॉल्ट प्लेसहोल्डर छवि',
        'enable_chunk' => 'चंक अपलोड सक्षम करें',
        'chunk_size' => 'चंक साइज़ (बाइट्स)',
        'chunk_size_placeholder' => 'डिफ़ॉल्ट: 1048576 ~ 1MB',
        'max_file_size' => 'चंक अधिकतम फ़ाइल साइज़ (MB)',
        'max_file_size_placeholder' => 'डिफ़ॉल्ट: 1048576 ~ 1GB',
        'enable_watermark' => 'वॉटरमार्क सक्षम करें',
        'watermark_source' => 'वॉटरमार्क छवि',
        'watermark_source_helper' => 'केवल PNG, JPG, और JPEG फॉर्मेट समर्थित हैं। आपको 200x200px से कम छवि और 50KB से छोटा साइज़ उपयोग करना चाहिए।',
        'watermark_size' => 'वॉटरमार्क का साइज़ (%)',
        'watermark_size_placeholder' => 'डिफ़ॉल्ट: 10 (%)',
        'watermark_opacity' => 'वॉटरमार्क अपारदर्शिता (%)',
        'watermark_opacity_placeholder' => 'डिफ़ॉल्ट: 70 (%)',
        'watermark_position' => 'वॉटरमार्क स्थिति',
        'watermark_position_x' => 'वॉटरमार्क स्थिति X',
        'watermark_position_y' => 'वॉटरमार्क स्थिति Y',
        'watermark_position_top_left' => 'ऊपर बाएं',
        'watermark_position_top_right' => 'ऊपर दाएं',
        'watermark_position_bottom_left' => 'नीचे बाएं',
        'watermark_position_bottom_right' => 'नीचे दाएं',
        'watermark_position_center' => 'केंद्र',
        'turn_off_automatic_url_translation_into_latin' => 'लैटिन में स्वचालित URL अनुवाद बंद करें',
        'bunnycdn_hostname' => 'होस्टनाम',
        'bunnycdn_zone' => 'जोन नाम (आपके स्टोरेज जोन का नाम)',
        'bunnycdn_key' => 'FTP & API एक्सेस पासवर्ड (स्टोरेज जोन API एक्सेस पासवर्ड)',
        'bunnycdn_region' => 'क्षेत्र (स्टोरेज जोन क्षेत्र)',
        'optional' => 'वैकल्पिक',
        'sizes' => 'मीडिया थंबनेल साइज़',
        'media_sizes_helper' => 'यदि आप केवल चौड़ाई या ऊंचाई के अनुसार क्रॉप करना चाहते हैं तो चौड़ाई या ऊंचाई को 0 पर सेट करें।',
        'width' => 'चौड़ाई',
        'height' => 'ऊंचाई',
        'default_size_value' => 'डिफ़ॉल्ट: :size',
        'all' => 'सभी',
        'all_helper_text' => 'यदि आप सभी फ़ोल्डरों को अनचेक करते हैं, तो यह सभी फ़ोल्डरों के लिए लागू होगा।',
        'media_folders_can_add_watermark' => 'फ़ोल्डरों में छवियों के लिए वॉटरमार्क जोड़ें:',
        'max_upload_filesize' => 'अधिकतम अपलोड फ़ाइलसाइज़ (MB)',
        'max_upload_filesize_placeholder' => 'डिफ़ॉल्ट: :size, :size से कम होना चाहिए।',
        'max_upload_filesize_helper' => 'आपका सर्वर अधिकतम :size फ़ाइलें अपलोड करने की अनुमति देता है, आप अपलोड फ़ाइलसाइज़ को सीमित करने के लिए इस मान को बदल सकते हैं।',
        'image_processing_library' => 'छवि प्रसंस्करण लाइब्रेरी',
        'use_original_name_for_file_path' => 'फ़ाइल पथ के लिए मूल नाम का उपयोग करें',
        'keep_original_file_size_and_quality' => 'मूल फ़ाइल साइज़ और गुणवत्ता रखें',
        'update_thumbnail_sizes_warning' => 'थंबनेल साइज़ समायोजित करने के बाद, आपको उन्हें रीफ्रेश करने के लिए ":button_text" बटन पर क्लिक करना होगा।',
        'thumbnail_crop_position' => 'थंबनेल क्रॉप स्थिति',
        'thumbnail_crop_position_left' => 'बाएं',
        'thumbnail_crop_position_center' => 'केंद्र',
        'thumbnail_crop_position_right' => 'दाएं',
        'thumbnail_crop_position_top' => 'ऊपर',
        'thumbnail_crop_position_bottom' => 'नीचे',
        'thumbnail_crop_position_helper' => 'यह सेटिंग थंबनेल उत्पन्न करते समय छवि को क्रॉप करने के लिए उपयोग की जाती है। छवि भरने तक इसे इस स्थिति से क्रॉप किया जाएगा।',
        'user_can_only_view_own_media' => 'उपयोगकर्ता केवल अपना मीडिया देख सकते हैं',
        'user_can_only_view_own_media_helper' => 'जब सक्षम हो, उपयोगकर्ता केवल अपना मीडिया देख सकते हैं, जबकि सुपर एडमिन सभी मीडिया देख सकते हैं।',
        'enable_thumbnail_sizes' => 'थंबनेल साइज़ सक्षम करें',
        'enable_thumbnail_sizes_helper' => 'छवियों के लिए थंबनेल उत्पन्न करने के लिए इस विकल्प को सक्षम करें। यदि यह अक्षम है, तो सिस्टम छवियों के लिए थंबनेल उत्पन्न नहीं करेगा और हमेशा पूर्ण साइज़ छवि का उपयोग करेगा।',
        'convert_image_to_webp' => 'JPG, JPEG, PNG छवि को WebP में कनवर्ट करें',
        'convert_image_to_webp_helper' => 'WebP एक आधुनिक छवि प्रारूप है जो वेब पर छवियों के लिए बेहतर लॉसलेस और लॉसी कम्प्रेशन प्रदान करता है। यह Chrome, Firefox, Edge, और Opera में समर्थित है। अपलोड करते समय छवि को WebP प्रारूप में कनवर्ट किया जाएगा। यह केवल JPG, JPEG, PNG छवियों के लिए लागू है।',
        'reduce_large_image_size' => 'अपलोड करते समय बड़ी छवि साइज़ कम करें',
        'reduce_large_image_size_helper' => 'जब सक्षम हो, सिस्टम अपलोड करते समय बड़ी छवियों का साइज़ कम कर देगा, JPG, JPEG, PNG, WebP छवि के लिए लागू। छवि की अधिकतम चौड़ाई और ऊंचाई को आपके द्वारा नीचे सेट किए गए मानों के अनुसार आकार दिया जाएगा।',
        'image_max_width' => 'छवि अधिकतम चौड़ाई (px)',
        'image_max_height' => 'छवि अधिकतम ऊंचाई (px)',
        'image_max_width_placeholder' => 'मूल चौड़ाई रखने के लिए खाली छोड़ें',
        'image_max_height_placeholder' => 'मूल ऊंचाई रखने के लिए खाली छोड़ें',
        'image_max_width_helper' => 'छवि की अधिकतम चौड़ाई पिक्सेल में सेट करें। यदि यह फ़ील्ड खाली है तो मूल चौड़ाई रखी जाएगी।',
        'image_max_height_helper' => 'छवि की अधिकतम ऊंचाई पिक्सेल में सेट करें। यदि यह फ़ील्ड खाली है तो मूल ऊंचाई रखी जाएगी।',
        'customize_upload_path' => 'अपलोड पथ अनुकूलित करें',
        'customize_upload_path_helper' => 'मीडिया फ़ाइलों के लिए अपलोड पथ अनुकूलित करें। डिफ़ॉल्ट रूप से, सिस्टम फ़ाइलों को ":path" फ़ोल्डर में अपलोड करेगा।',
        'upload_path' => 'अपलोड पथ',
        'upload_path_placeholder' => 'उदाहरण: uploads',
        'upload_path_helper' => 'वह फ़ोल्डर /public में बनाया जाएगा। डिफ़ॉल्ट फ़ोल्डर ":folder" है। फिर इसे "/public/:folder" में अपलोड किया जाएगा।',
        'upload_path_warning' => 'सिस्टम मौजूदा फ़ाइलों को नए फ़ोल्डर में नहीं ले जाएगा। यदि आप मौजूदा फ़ाइलों को नए फ़ोल्डर में ले जाना चाहते हैं, तो आपको इसे मैन्युअल रूप से करना होगा।',
        'convert_file_name_to_uuid' => 'फ़ाइल नाम को UUID में कनवर्ट करें',
        'convert_file_name_to_uuid_helper' => 'जब सक्षम हो, सिस्टम अपलोड करते समय फ़ाइल नाम को UUID में कनवर्ट कर देगा। यह डुप्लिकेट फ़ाइल नाम को रोकने और बेहतर सुरक्षा के लिए उपयोगी है।',
        's3_path' => 'कस्टम S3 पथ (वैकल्पिक)',
        's3_path_placeholder' => 'S3 बकेट में वैकल्पिक कस्टम पथ (उदाहरण: uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'खरीद कोड',
        'buyer' => 'खरीदार',
    ],
    'field_type_not_exists' => 'यह फ़ील्ड प्रकार मौजूद नहीं है',
    'save_settings' => 'सेटिंग्स सहेजें',
    'template' => 'टेम्पलेट',
    'description' => 'विवरण',
    'enable' => 'सक्षम करें',
    'send' => 'भेजें',
    'test_email_description' => 'टेस्ट ईमेल भेजने के लिए, सुनिश्चित करें कि आपने ईमेल भेजने के लिए कॉन्फ़िगरेशन अपडेट किया है!',
    'test_email_input_placeholder' => 'वह ईमेल पता दर्ज करें जिस पर आप टेस्ट ईमेल भेजना चाहते हैं।',
    'test_email_modal_title' => 'एक टेस्ट ईमेल भेजें',
    'test_send_mail' => 'टेस्ट ईमेल भेजें',
    'test_email_send_success' => 'ईमेल सफलतापूर्वक भेजा गया!',
    'locale_direction_ltr' => 'बाएं से दाएं',
    'locale_direction_rtl' => 'दाएं से बाएं',
    'emails_warning' => 'आप अधिकतम :count ईमेल जोड़ सकते हैं',
    'email_add_more' => 'और जोड़ें',
    'generate' => 'जनरेट करें',
    'generate_thumbnails' => 'थंबनेल जनरेट करें',
    'generate_thumbnails_success' => 'थंबनेल सफलतापूर्वक जनरेट किए गए। :count फ़ाइलें जनरेट की गई हैं!',
    'generate_thumbnails_error' => 'हम :count फ़ाइलों के लिए थंबनेल फिर से जनरेट करने में असमर्थ थे!',
    'generate_thumbnails_description' => 'क्या आप सभी छवियों के लिए थंबनेल फिर से जनरेट करना चाहते हैं? इसमें कुछ समय लग सकता है। कृपया प्रक्रिया पूर्ण होने तक इस पेज से दूर न जाएं।',
    'enable_chunk_description' => 'चंक साइज़ अपलोड का उपयोग बड़ी फ़ाइल साइज़ अपलोड करने के लिए किया जाता है।',
    'watermark_description' => 'चेतावनी: वॉटरमार्क केवल नई अपलोड की गई छवियों में जोड़ा जाता है, यह मौजूदा छवियों में नहीं जोड़ा जाएगा। वॉटरमार्क अक्षम करने से मौजूदा छवियों से वॉटरमार्क नहीं हटेगा।',
    'submit' => 'सबमिट करें',
    'back' => 'वापस',
    'enter_sample_value' => 'परीक्षण के लिए नमूना मान दर्ज करें',
    'preview' => 'पूर्वावलोकन',
    'media_size_width' => ':size साइज़ की चौड़ाई 0 से अधिक होनी चाहिए',
    'media_size_height' => ':size साइज़ की ऊंचाई 0 से अधिक होनी चाहिए',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob आपको अपनी साइट पर कुछ कमांड या स्क्रिप्ट को स्वचालित करने की अनुमति देता है।',
        'is_not_ready' => 'Cronjob चलाने के लिए, नीचे दिए गए निर्देशों का पालन करें।',
        'is_working' => 'बधाई हो! आपका cronjob चल रहा है।',
        'is_not_working' => 'आपका cronjob नहीं चल रहा है। कृपया अपने सर्वर के cronjob की जांच करें।',
        'last_checked' => 'अंतिम बार :time पर जांचा गया।',
        'copy_button' => 'कॉपी करें',
        'setup' => [
            'name' => 'Cronjob सेट करना',
            'connect_to_server' => 'SSH या किसी पसंदीदा विधि के माध्यम से अपने सर्वर से कनेक्ट करें।',
            'open_crontab' => 'टेक्स्ट एडिटर का उपयोग करके crontab फ़ाइल खोलें (उदाहरण: `crontab -e`)।',
            'add_cronjob' => 'ऊपर दिए गए कमांड को crontab फ़ाइल में जोड़ें और इसे सहेजें।',
            'done' => 'Cronjob अब हर मिनट चलेगा और निर्दिष्ट कमांड को निष्पादित करेगा।',
            'learn_more' => 'आप Laravel :documentation से cronjob के बारे में अधिक जान सकते हैं',
            'documentation' => 'दस्तावेज़ीकरण',
            'copied' => 'कॉपी किया गया',
        ],
    ],
    'security' => [
        'title' => 'सुरक्षा सेटिंग्स',
        'description' => 'अपनी वेबसाइट के लिए सुरक्षा सेटिंग्स की जांच करें और कॉन्फ़िगर करें।',
        'menu_description' => 'कुकी सुरक्षा और HTTP हेडर प्रबंधित करें',
        'status_secure' => 'सभी सुरक्षा सेटिंग्स ठीक से कॉन्फ़िगर हैं!',
        'status_insecure' => 'कुछ सुरक्षा सेटिंग्स पर ध्यान देने की आवश्यकता है!',
        'current_settings' => 'वर्तमान सुरक्षा सेटिंग्स',
        'status' => 'स्थिति',
        'setting' => 'सेटिंग',
        'current_value' => 'वर्तमान मान',
        'recommended_value' => 'अनुशंसित',
        'session_http_only' => 'HttpOnly कुकी ध्वज',
        'session_http_only_description' => 'JavaScript को सत्र कुकी तक पहुंचने से रोकता है (XSS हमलों से सुरक्षा)',
        'session_secure_cookie' => 'सुरक्षित कुकी ध्वज',
        'session_secure_cookie_description' => 'सुनिश्चित करता है कि कुकी केवल HTTPS कनेक्शन पर भेजी जाती हैं',
        'session_same_site' => 'SameSite कुकी ध्वज',
        'session_same_site_description' => 'कुकी कब भेजी जाती हैं, यह सीमित करके CSRF हमलों को रोकता है',
        'http_security_headers' => 'HTTP सुरक्षा हेडर',
        'http_security_headers_description' => 'सामान्य वेब कमजोरियों से बचाने के लिए सुरक्षा हेडर जोड़ता है',
        'https_warning' => 'आपकी साइट HTTPS का उपयोग नहीं कर रही है',
        'https_warning_description' => 'सुरक्षित कुकी जैसी कुछ सुरक्षा सुविधाओं के लिए HTTPS की आवश्यकता होती है। अपनी वेबसाइट के लिए SSL सक्षम करने पर विचार करें।',
        'how_to_fix' => 'सुरक्षा समस्याओं को कैसे ठीक करें',
        'env_file_location' => 'अपनी .env फ़ाइल यहां संपादित करें:',
        'add_to_env' => 'जोड़ने के लिए सेटिंग्स',
        'required_settings' => 'आवश्यक सुरक्षा सेटिंग्स',
        'for_https_sites' => 'केवल HTTPS साइटों के लिए',
        'copy' => 'कॉपी करें',
        'copy_settings' => 'सभी सेटिंग्स कॉपी करें',
        'copied' => 'कॉपी किया गया!',
        'steps' => 'सेटिंग्स लागू करने के चरण',
        'step_1' => 'अपनी .env फ़ाइल को टेक्स्ट एडिटर में खोलें',
        'step_2' => 'ऊपर दिखाई गई सुरक्षा सेटिंग्स जोड़ें या अपडेट करें',
        'step_3' => '.env फ़ाइल सहेजें',
        'step_4' => 'Admin Panel → Platform Administration → Cache Management का उपयोग करके कैश साफ़ करें',
        'security_headers_info' => 'सुरक्षा हेडर जानकारी',
        'security_headers_list' => 'जब सक्षम हो, तो सभी प्रतिक्रियाओं में निम्नलिखित हेडर जोड़े जाते हैं:',
        'header_nosniff' => 'ब्राउज़र को सामग्री प्रकारों का अनुमान लगाने से रोकता है',
        'header_frame' => 'क्लिकजैकिंग हमलों से सुरक्षा करता है',
        'header_xss' => 'ब्राउज़र XSS सुरक्षा सक्षम करता है',
        'header_referrer' => 'नियंत्रित करता है कि कितनी रेफ़रर जानकारी भेजी जाती है',
        'learn_more' => 'अधिक विस्तृत जानकारी के लिए, :documentation देखें',
        'documentation' => 'सुरक्षा दस्तावेज़ीकरण',
    ],
    'cache' => [
        'title' => 'कैश',
        'description' => 'अनुकूलित गति के लिए कैशिंग कॉन्फ़िगर करें',
        'form' => [
            'cache_admin_menu' => 'एडमिन मेनू कैश करें',
            'cache_admin_menu_helper' => 'अनुकूलित गति के लिए एडमिन मेनू को कैश करें। यदि आप एडमिन मेनू विकसित या अनुकूलित कर रहे हैं तो इस विकल्प को अक्षम किया जाना चाहिए।',
            'enable_cache_site_map' => 'साइटमैप कैश करें',
            'enable_cache_site_map_helper' => 'साइटमैप :url को बड़ी संख्या में पेजों के कारण कैश किया जाना चाहिए। यदि आपके पास कम संख्या में पेज हैं, तो आप इस विकल्प को अक्षम कर सकते हैं।',
            'cache_time_site_map' => 'साइटमैप कैश टाइमआउट (मिनटों में)',
            'cache_front_menu' => 'फ्रंट मेनू कैश करें',
            'cache_front_menu_helper' => 'अनुकूलित गति के लिए फ्रंट मेनू को कैश करें',
            'cache_user_avatar' => 'उपयोगकर्ता अवतार कैश करें',
            'cache_user_avatar_helper' => 'अवतार के बिना उपयोगकर्ताओं के लिए, सिस्टम उनके उपयोगकर्ता नामों से अवतार उत्पन्न करेगा। अवतार अनुकूलित गति के लिए कैश किए जाएंगे और पुन: उत्पन्न नहीं होंगे।',
            'shortcode_cache_enabled' => 'शॉर्टकोड कैश करें (UI ब्लॉक)',
            'shortcode_cache_enabled_helper' => 'प्रदर्शन में सुधार के लिए शॉर्टकोड के लिए कैशिंग सक्षम करें। जब सक्षम हो, तो रेंडरिंग समय कम करने के लिए शॉर्टकोड कैश किए जाएंगे।',
            'shortcode_cache_warning' => '<strong>⚠️ महत्वपूर्ण सूचना:</strong><br>• फॉर्म युक्त शॉर्टकोड (संपर्क फॉर्म, न्यूज़लेटर सदस्यता, आदि) स्वचालित रूप से कार्यक्षमता को संरक्षित करने के लिए कैशिंग को बायपास करेंगे।<br>• गतिशील JavaScript सामग्री वाले शॉर्टकोड को मैन्युअल रूप से कैशिंग अक्षम करना चाहिए।<br>• विशिष्ट शॉर्टकोड के लिए कैशिंग अक्षम करने के लिए, शॉर्टकोड कॉन्फ़िगरेशन में <code>Enable caching: No</code> जोड़ें।<br>• CSRF टोकन, reCAPTCHA, या अन्य गतिशील तत्वों वाले फॉर्म स्वचालित रूप से पहचाने जाते हैं और कैशिंग से बाहर रखे जाते हैं।',
            'shortcode_cache_ttl' => 'कैश अवधि (सेकंड)',
            'shortcode_cache_ttl_helper' => 'सभी शॉर्टकोड को कैश करने की अवधि। डिफ़ॉल्ट 1800 सेकंड (30 मिनट) है।',
            'widget_cache_enabled' => 'विजेट कैश करें',
            'widget_cache_enabled_helper' => 'प्रदर्शन में सुधार के लिए विजेट के लिए कैशिंग सक्षम करें। जब सक्षम हो, तो रेंडरिंग समय कम करने के लिए विजेट कैश किए जाएंगे।',
            'widget_cache_warning' => '<strong>⚠️ महत्वपूर्ण सूचना:</strong><br>• फॉर्म युक्त विजेट (संपर्क फॉर्म, न्यूज़लेटर सदस्यता, आदि) स्वचालित रूप से कार्यक्षमता को संरक्षित करने के लिए कैशिंग को बायपास करेंगे।<br>• गतिशील JavaScript सामग्री वाले विजेट को मैन्युअल रूप से कैशिंग अक्षम करना चाहिए।<br>• विशिष्ट विजेट के लिए कैशिंग अक्षम करने के लिए, विजेट कॉन्फ़िगरेशन में <code>Enable caching: No</code> सेट करें।<br>• CSRF टोकन, reCAPTCHA, या अन्य गतिशील तत्वों वाले फॉर्म स्वचालित रूप से पहचाने जाते हैं और कैशिंग से बाहर रखे जाते हैं।',
            'widget_cache_ttl' => 'कैश अवधि (सेकंड)',
            'widget_cache_ttl_helper' => 'सभी विजेट को कैश करने की अवधि। डिफ़ॉल्ट 1800 सेकंड (30 मिनट) है।',
            'plugin_cache_enabled' => 'इंस्टॉल किए गए प्लगइन कैश करें',
            'plugin_cache_enabled_helper' => 'बेहतर प्रदर्शन के लिए इंस्टॉल किए गए प्लगइन की सूची को कैश करें। जब सक्षम हो, तो फ़ाइल सिस्टम स्कैन को कम करने के लिए सिस्टम 30 मिनट के लिए प्लगइन सूची को कैश करेगा।',
        ],
    ],
    'appearance' => [
        'title' => 'दिखावट',
    ],
    'panel' => [
        'common' => 'सामान्य',
        'general' => 'सामान्य',
        'general_description' => 'अपनी सामान्य सेटिंग्स देखें और अपडेट करें और लाइसेंस सक्रिय करें',
        'email' => 'ईमेल',
        'email_description' => 'अपनी ईमेल सेटिंग्स और ईमेल टेम्पलेट देखें और अपडेट करें',
        'media' => 'मीडिया',
        'media_description' => 'अपनी मीडिया सेटिंग्स देखें और अपडेट करें',
        'system' => 'सिस्टम',
        'system_updater' => 'सिस्टम अपडेटर',
        'system_updater_description' => 'अपने सिस्टम को नवीनतम संस्करण में अपडेट करें',
        'others' => 'अन्य',
    ],
    'saving' => 'सहेज रहे हैं...',
    'generating_media_thumbnails' => 'मीडिया थंबनेल जनरेट कर रहे हैं...',
    'test_email_template' => 'टेस्ट ईमेल टेम्पलेट',
    'select_email_template' => 'ईमेल टेम्पलेट चुनें',
    'enums' => [
        'data_retention_period' => [
            '0' => 'कभी नहीं',
            '1' => '1 दिन',
            '3' => '3 दिन',
            '7' => '1 सप्ताह',
            '30' => '1 महीना',
            '90' => '3 महीने',
            '180' => '6 महीने',
            '365' => '1 साल',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute एक मान्य AWS क्षेत्र होना चाहिए (उदाहरण: us-east-1, eu-west-1)।',
    ],
];
