<?php

return [
    'title' => 'Beállítások',
    'general_setting' => 'Általános beállítások',
    'menu' => 'Összes beállítás',
    'email_setting_title' => 'E-mail beállítások',
    'email_setting_description' => 'E-mail beállítások konfigurálása',
    'general' => [
        'theme' => 'Téma',
        'title' => 'Általános információk',
        'description' => 'Oldal információk megtekintése és frissítése',
        'rich_editor' => 'Fejlett szerkesztő',
        'site_title' => 'Oldal címe',
        'admin_email' => 'Adminisztrátor e-mail',
        'seo_block' => 'SEO konfiguráció',
        'seo_title' => 'SEO cím',
        'seo_description' => 'SEO leírás',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Oldal címe (maximum 120 karakter)',
            'admin_email' => 'Adminisztrátor e-mail',
            'seo_title' => 'SEO cím (maximum 120 karakter)',
            'seo_description' => 'SEO leírás (maximum 120 karakter)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Hibajelentések küldése e-mailben',
        'enable_send_error_reporting_via_email_helper' => 'Ha engedélyezve van, részletes hibajelentések kerülnek elküldésre a rendszergazda e-mail címeire, amikor kritikus hibák történnek az oldalon',
        'time_zone_helper' => 'Válassza ki webhelye időzónáját. Ez lesz használva az összes dátum és idő megjelenítéshez az egész rendszerben',
        'time_zone' => 'Időzóna',
        'enable' => 'Engedélyezés',
        'disable' => 'Letiltás',
        'disabled_helper' => 'Nem lehet letiltani ezt az e-mail sablont!',
        'enable_cache_site_map' => 'Sitemap gyorsítótárazás engedélyezése',
        'cache_time_site_map' => 'Sitemap gyorsítótár időkorlátja (percben)',
        'admin_logo' => 'Adminisztrátori logó',
        'admin_favicon' => 'Adminisztrátori favicon',
        'admin_title' => 'Adminisztrátori cím',
        'admin_title_placeholder' => 'A böngésző fülön megjelenő cím',
        'admin_appearance_title' => 'Adminisztrátori megjelenés',
        'admin_appearance_description' => 'Adminisztrátori megjelenés beállítása, mint szerkesztő, nyelv...',
        'seo_block_description' => 'Oldal címének, meta leírásának, kulcsszavainak beállítása a SEO optimalizálásához',
        'webmaster_tools_description' => 'A Google Search Console egy ingyenes webes eszköz, amelyet a Google biztosít, és segít a weboldal tulajdonosoknak nyomon követni oldaluk teljesítményét a Google keresési találatokban.',
        'yes' => 'Igen',
        'no' => 'Nem',
        'show_on_front' => 'A kezdőlapon megjelenítés',
        'select' => '— Válasszon —',
        'show_site_name' => 'Oldal nevének megjelenítése az oldal címe után, elválasztva "-" jellel',
        'locale' => 'Oldal nyelve',
        'locale_direction' => 'Előtér-oldal nyelvi iránya',
        'minutes' => 'perc',
        'redirect_404_to_homepage' => 'Minden Nem található kérés átirányítása a kezdőlapra',
    ],
    'admin_appearance' => [
        'title' => 'Adminisztrátori megjelenés',
        'description' => 'Logó, favicon, elrendezés megtekintése és frissítése...',
        'layout' => 'Elrendezés',
        'horizontal' => 'Vízszintes',
        'vertical' => 'Függőleges',
        'show_menu_item_icon' => 'Menüelem ikon megjelenítése',
        'language' => 'Adminisztrátori panel nyelve',
        'theme_mode' => 'Téma mód',
        'dark' => 'Sötét',
        'light' => 'Világos',
        'container_width' => [
            'title' => 'Konténer szélessége',
            'default' => 'Alapértelmezett',
            'large' => 'Nagy',
            'full' => 'Teljes',
        ],
        'form' => [
            'admin_logo' => 'Adminisztrátori logó',
            'admin_logo_max_height' => 'Logó magassága (px)',
            'admin_logo_max_height_helper' => 'Állítsa be a logó magasságát pixelekben. Az alapértelmezett érték :default.',
            'admin_favicon' => 'Adminisztrátori favicon',
            'admin_favicon_type' => 'Adminisztrátori favicon típusa',
            'admin_title' => 'Adminisztrátori cím',
            'admin_title_placeholder' => 'A böngésző fülön megjelenő cím',
            'admin_login_screen_backgrounds' => 'Bejelentkezési képernyő háttérképek (~1366 x 768)',
            'admin_locale' => 'Adminisztrátori nyelv',
            'admin_locale_direction' => 'Adminisztrátori nyelv iránya',
            'rich_editor' => 'Fejlett szerkesztő',
            'show_admin_bar' => 'Adminisztrátori sáv megjelenítése bejelentkezett adminisztrátoroknak, még az előtér-oldalon is',
            'show_guidelines' => 'Útmutatók megjelenítése',
            'primary_font' => 'Elsődleges betűtípus',
            'primary_color' => 'Elsődleges szín',
            'secondary_color' => 'Másodlagos szín',
            'heading_color' => 'Címsor színe',
            'text_color' => 'Szöveg színe',
            'link_color' => 'Link színe',
            'link_hover_color' => 'Link színe lebegéskor',
            'show_menu_item_icon' => 'Menüelem ikon megjelenítése',
            'custom_css' => 'Egyéni CSS',
            'custom_js' => 'Egyéni JS',
            'custom_header_js' => 'Fejléc JS',
            'custom_header_js_placeholder' => 'JavaScript az oldal fejlécében, csomagolja &#x3C;script&#x3E;&#x3C;/script&#x3E; elembe',
            'custom_body_js' => 'Törzs JS',
            'custom_body_js_placeholder' => 'JavaScript az oldal törzsében, csomagolja &#x3C;script&#x3E;&#x3C;/script&#x3E; elembe',
            'custom_footer_js' => 'Lábléc JS',
            'custom_footer_js_placeholder' => 'JavaScript az oldal láblécében, csomagolja &#x3C;script&#x3E;&#x3C;/script&#x3E; elembe',
        ],
    ],
    'datatable' => [
        'title' => 'Adattáblázatok',
        'description' => 'Adattáblázatok beállításai',
        'form' => [
            'show_column_visibility' => 'Oszlop láthatóság megjelenítése alapértelmezetten',
            'show_column_visibility_helper' => 'Az oszlop láthatósági váltógomb engedélyezése az adattáblákban, hogy a felhasználók megjeleníthessék/elrejthessék az oszlopokat',
            'show_export_button' => 'Exportálás gomb megjelenítése alapértelmezetten',
            'show_export_button_helper' => 'Exportálási opciók megjelenítése (CSV, Excel, PDF) az adattáblákban a táblázat adatok letöltéséhez',
            'pagination_type' => 'Lapozás típusa',
            'pagination_type_helper' => 'Válassza ki, hogyan jelenjenek meg a lapozási vezérlők: Az alapértelmezett oldalszámokat mutat, a legördülő egy kompakt legördülő választót jelenít meg',
            'default' => 'Alapértelmezett',
            'dropdown' => 'Legördülő',
            'enable_responsive' => 'Táblázat reszponzivitás engedélyezése',
            'enable_responsive_helper' => 'Automatikusan igazítja a táblázat oszlopait a különböző képernyőméretekhez a jobb mobil élményért',
        ],
    ],
    'email' => [
        'subject' => 'Tárgy',
        'content' => 'Tartalom',
        'title' => 'E-mail sablon beállítások',
        'description' => 'E-mail sablon HTML és rendszerváltozók használatával.',
        'reset_to_default' => 'Visszaállítás alapértelmezettre',
        'back' => 'Vissza a beállításokhoz',
        'reset_success' => 'Sikeresen visszaállítva az alapértelmezett értékekre',
        'confirm_reset' => 'Megerősíti az e-mail sablon visszaállítását?',
        'confirm_message' => 'Valóban vissza akarja állítani ezt az e-mail sablont az alapértelmezett értékekre?',
        'continue' => 'Folytatás',
        'sender_name' => 'Küldő neve',
        'sender_name_placeholder' => 'Név',
        'sender_name_helper' => 'A rendszer által küldött e-mailekben a Feladó mezőben megjelenő név',
        'sender_email' => 'Küldő e-mail címe',
        'sender_email_placeholder' => 'E-mail cím (pl. :default)',
        'sender_email_helper' => 'A rendszer által küldött összes e-mailhez feladóként használt e-mail cím',
        'mailer' => 'Levelező',
        'port' => 'Port',
        'port_placeholder' => 'Pl.: 587',
        'port_helper' => 'A levelezőszerver által használt port (gyakori portok: 25, 465, 587)',
        'host' => 'Kiszolgáló',
        'host_placeholder' => 'Pl.: smtp.gmail.com',
        'host_helper' => 'SMTP kiszolgáló címe',
        'username' => 'Felhasználónév',
        'username_placeholder' => 'Felhasználónév a levelezőszerverre való bejelentkezéshez',
        'username_helper' => 'A levelezőszerver bejelentkezési felhasználóneve',
        'password' => 'Jelszó',
        'password_placeholder' => 'Jelszó a levelezőszerverre való bejelentkezéshez',
        'password_helper' => 'A levelezőszerver bejelentkezési jelszava',
        'encryption' => 'Titkosítás',
        'encryption_placeholder' => 'Válassza ki a titkosítás típusát',
        'encryption_helper' => 'Válassza ki a titkosítási módszert a biztonságos e-mail átvitelhez',
        'encryption_none' => 'Nincs',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'E-mail beállítási tippek',
        'setup_tip_gmail' => 'Gmail esetén: Használja az smtp.gmail.com-ot kiszolgálóként, 587-es portot TLS-sel vagy 465-ös portot SSL-lel. Engedélyezze a "Kevésbé biztonságos alkalmazások elérését" vagy használjon alkalmazásjelszót.',
        'setup_tip_port' => 'Gyakori portok: 25 (titkosítatlan), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternatív).',
        'setup_tip_encryption' => 'Használjon TLS-t a 587-es porthoz (ajánlott), SSL-t a 465-ös porthoz, vagy Nincs-t a 25-ös porthoz (nem ajánlott éles környezetben).',
        'setup_tip_test' => 'Mindig használja a "Teszt e-mail küldése" gombot a konfiguráció ellenőrzéséhez mentés előtt.',
        'setup_tip_mailgun' => 'A jobb kézbesíthetőség érdekében fontolja meg az e-mail szolgáltatások, mint a Mailgun, SendGrid vagy Amazon SES használatát SMTP helyett.',
        'queue_warning_title' => 'Várakozási sor konfigurálása szükséges',
        'queue_warning_description' => 'Az e-mail várakozási sor jelenleg ":default" illesztőprogramot használ, de lehet, hogy a várakozási sor feldolgozója nem fut. Ez azt jelenti, hogy az e-mailek nem kerülnek elküldésre, amíg nem állít be egy várakozási sor feldolgozót.',
        'queue_warning_action' => 'Az e-mailek azonnali küldéséhez várakozási sor feldolgozó nélkül állítsa be a QUEUE_CONNECTION=sync értéket a .env fájlban. Egyéb esetben győződjön meg arról, hogy a várakozási sor feldolgozója fut a "php artisan queue:work" paranccsal. <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">További információ a Laravel várakozási sorokról</a>.',
        'mail_gun_domain' => 'Tartomány',
        'mail_gun_domain_placeholder' => 'Pl.: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'A Mailgun-nál regisztrált tartománynév',
        'mail_gun_secret' => 'Titok',
        'mail_gun_secret_placeholder' => 'Pl.: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Az Ön Mailgun API kulcsa',
        'mail_gun_endpoint' => 'Végpont',
        'mail_gun_endpoint_placeholder' => 'Pl.: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API végpont (api.mailgun.net az USA-ban, api.eu.mailgun.net az EU-ban)',
        'log_channel' => 'Napló csatorna',
        'log_channel_helper' => 'Válassza ki, melyik naplózási csatornát használja az e-mail naplókhoz',
        'sendmail_path' => 'Sendmail útvonal',
        'local_domain' => 'Helyi tartomány',
        'local_domain_placeholder' => 'Üresen hagyható. Be kell állítani a tartományára SMTP Relay használatakor. Pl.: az-on-tartomanya.com',
        'local_domain_helper' => 'A távoli SMTP szerverekkel való kommunikáció során a szerver azonosítására használt tartomány',

        'ses_key' => 'Kulcs',
        'ses_key_placeholder' => 'Pl.: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Az Ön AWS hozzáférési kulcs azonosítója',
        'ses_secret' => 'Titok',
        'ses_secret_placeholder' => 'Pl.: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Az Ön AWS titkos hozzáférési kulcsa',
        'ses_region' => 'Régió',
        'ses_region_placeholder' => 'Pl.: us-east-1',
        'ses_region_helper' => 'Az AWS régió, ahol az SES szolgáltatása konfigurálva van',

        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Pl.: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Az Ön Postmark szerver tokenje',

        'resend_key' => 'API kulcs',
        'resend_key_placeholder' => 'Pl.: re_123456789012345678901234567890',
        'resend_key_helper' => 'Az Ön Resend API kulcsa',

        'email_templates' => 'E-mail sablonok',
        'email_templates_description' => 'E-mail sablonok HTML és rendszerváltozók használatával.',
        'email_template_settings' => 'E-mail sablon beállítások',
        'email_template_settings_description' => 'E-mail sablon beállítások megtekintése és frissítése',
        'email_rules' => 'E-mail szabályok',
        'email_rules_description' => 'E-mail szabályok konfigurálása az ellenőrzéshez',
        'base_template' => 'Alap sablon',
        'base_template_description' => 'Alap sablon az összes e-mailhez',
        'template_header' => 'E-mail sablon fejléc',
        'template_header_description' => 'Az e-mailek fejlécének sablonja',
        'template_footer' => 'E-mail sablon lábléc',
        'template_footer_description' => 'Az e-mailek láblécének sablonja',
        'default' => 'Alapértelmezett',
        'template_off_status_helper' => 'Ez az e-mail sablon ki van kapcsolva.',
        'blacklist_email_domains' => 'Feketelistás e-mail tartományok',
        'blacklist_email_domains_helper' => 'Adja meg a feketelistára kerülő e-mail tartományok listáját. Pl.: gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Feketelistás e-mail címek',
        'blacklist_specified_emails_helper' => 'Adja meg a feketelistára kerülő specifikus e-mail címek listáját. Pl.: mail@example.com.',
        'exception_emails' => 'Kivétel e-mailek',
        'exception_emails_helper' => 'Ezek az e-mailek ki lesznek zárva az ellenőrzési szabályokból.',
        'email_rules_strict' => 'Szigorú e-mail ellenőrzés',
        'email_rules_strict_helper' => 'RFC-szerű e-mail ellenőrzés végrehajtása szigorú szabályokkal.',
        'email_rules_dns' => 'DNS ellenőrzés érvényesítése',
        'email_rules_dns_helper' => 'Ellenőrizze, hogy vannak-e DNS rekordok jelezve, hogy a szerver elfogad e-maileket.',
        'email_rules_spoof' => 'Hamisítás észlelése',
        'email_rules_spoof_helper' => 'Potenciális e-mail hamisítási kísérletek észlelése.',
        'template_turn_off' => 'Kattintson az e-mail sablon kikapcsolásához',
        'template_turn_on' => 'Kattintson az e-mail sablon bekapcsolásához',
        'turn_on_success_message' => 'E-mail sablon sikeresen bekapcsolva!',
        'turn_off_success_message' => 'E-mail sablon sikeresen kikapcsolva!',
        'email_template_status' => 'E-mail sablon állapota',
        'email_template_status_description' => 'E-mail sablon be/kikapcsolása',
        'email_template_logo' => 'Logó',
        'email_template_logo_helper_text' => 'Ha nincs beállítva, a rendszer az adminisztrátori logót fogja használni az Adminisztrátor -> Beállítások -> Adminisztrátori megjelenés -> Logó menüpontból.',
        'email_template_copyright_text_helper_text' => 'Ha nincs beállítva, a rendszer a téma opciók szerzői jogait fogja használni az Adminisztrátor -> Megjelenés -> Téma opciók -> Általános -> Szerzői jog menüpontból.',
        'email_template_email_contact' => 'Kapcsolat e-mail cím',
        'email_template_email_contact_helper_text' => 'Ha nincs beállítva, a rendszer a küldő e-mail címét fogja használni az Adminisztrátor -> Beállítások -> E-mail menüpontból',
        'email_template_social_links' => 'Közösségi hivatkozások',
        'email_template_copyright_text' => 'Szerzői jog',
        'image_upload_supported' => 'Csak PNG, JPG, JPEG és GIF formátumokat támogat.',
        'email_template_custom_css' => 'E-mail sablon egyéni CSS',
        'social_links' => [
            'name' => 'Név',
            'icon' => 'Ikon',
            'icon_image' => 'Ikon kép (Csak PNG, JPG, JPEG és GIF formátumokat támogat.)',
            'url' => 'URL',
            'image' => 'Kép',
        ],
    ],
    'media' => [
        'title' => 'Média',
        'driver' => 'Illesztőprogram',
        'description' => 'Média beállítások',
        'local_disk' => 'Helyi lemez',
        'aws_access_key_id' => 'AWS hozzáférési kulcs azonosító',
        'aws_secret_key' => 'AWS titkos kulcs',
        'aws_default_region' => 'AWS alapértelmezett régió',
        'aws_bucket' => 'AWS tároló',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS végpont (opcionális)',
        'use_path_style_endpoint' => 'Útvonalstílusú végpont használata',
        'r2_access_key_id' => 'R2 hozzáférési kulcs azonosító',
        'r2_secret_key' => 'R2 titkos kulcs',
        'r2_bucket' => 'R2 tároló',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 végpont',
        'do_spaces_access_key_id' => 'DO Spaces hozzáférési kulcs azonosító',
        'do_spaces_secret_key' => 'DO Spaces titkos kulcs',
        'do_spaces_default_region' => 'DO Spaces alapértelmezett régió',
        'do_spaces_bucket' => 'DO Spaces tároló',
        'do_spaces_endpoint' => 'DO Spaces végpont',
        'do_spaces_cdn_enabled' => 'Engedélyezve van a DO Spaces CDN?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN egyéni tartomány',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://az-on-egyeni-tartomanya.com',
        'wasabi_access_key_id' => 'Wasabi hozzáférési kulcs azonosító',
        'wasabi_secret_key' => 'Wasabi titkos kulcs',
        'wasabi_default_region' => 'Wasabi alapértelmezett régió',
        'wasabi_bucket' => 'Wasabi tároló',
        'wasabi_root' => 'Wasabi gyökér',
        'wasabi_root_helper' => 'A meglévő képek újrafelhasználásához egyszerűen jelölje ki a Wasabi gyökeret "/"-ként, majd töltse fel az összes jelenlegi fájlt a public/storage könyvtárból a Wasabi gyökérkönyvtárába.',
        'backblaze_access_key_id' => 'Backblaze hozzáférési kulcs azonosító',
        'backblaze_secret_key' => 'Backblaze titkos kulcs',
        'backblaze_bucket' => 'Backblaze tároló',
        'backblaze_default_region' => 'Backblaze alapértelmezett régió',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze végpont',
        'backblaze_cdn_enabled' => 'Engedélyezve van a Backblaze CDN?',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN egyéni tartomány',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://az-on-egyeni-tartomanya.com',
        'default_placeholder_image' => 'Alapértelmezett helyőrző kép',
        'enable_chunk' => 'Darabolt feltöltés engedélyezése',
        'chunk_size' => 'Darab mérete (bájtban)',
        'chunk_size_placeholder' => 'Alapértelmezett: 1048576 ~ 1MB',
        'max_file_size' => 'Darabolt maximális fájlméret (MB)',
        'max_file_size_placeholder' => 'Alapértelmezett: 1048576 ~ 1GB',
        'enable_watermark' => 'Vízjel engedélyezése',
        'watermark_source' => 'Vízjel kép',
        'watermark_source_helper' => 'Csak PNG, JPG és JPEG formátumokat támogat. 200x200px-nél kisebb és 50KB-nál kisebb méretű képet használjon.',
        'watermark_size' => 'Vízjel mérete (%)',
        'watermark_size_placeholder' => 'Alapértelmezett: 10 (%)',
        'watermark_opacity' => 'Vízjel átlátszósága (%)',
        'watermark_opacity_placeholder' => 'Alapértelmezett: 70 (%)',
        'watermark_position' => 'Vízjel pozíciója',
        'watermark_position_x' => 'Vízjel X pozíciója',
        'watermark_position_y' => 'Vízjel Y pozíciója',
        'watermark_position_top_left' => 'Bal felső',
        'watermark_position_top_right' => 'Jobb felső',
        'watermark_position_bottom_left' => 'Bal alsó',
        'watermark_position_bottom_right' => 'Jobb alsó',
        'watermark_position_center' => 'Közép',
        'turn_off_automatic_url_translation_into_latin' => 'Automatikus URL fordítás latin betűkre kikapcsolása',
        'bunnycdn_hostname' => 'Gazdanév',
        'bunnycdn_zone' => 'Zóna neve (A tárolási zóna neve)',
        'bunnycdn_key' => 'FTP és API hozzáférési jelszó (A tárolási zóna API hozzáférési jelszava)',
        'bunnycdn_region' => 'Régió (A tárolási zóna régiója)',
        'optional' => 'Opcionális',
        'sizes' => 'Média bélyegkép méretek',
        'media_sizes_helper' => 'Állítsa a szélességet vagy magasságot 0-ra, ha csak szélesség vagy magasság szerint szeretne vágni.',
        'width' => 'Szélesség',
        'height' => 'Magasság',
        'default_size_value' => 'Alapértelmezett: :size',
        'all' => 'Összes',
        'all_helper_text' => 'Ha minden mappát kijelöl, akkor az összes mappára vonatkozik.',
        'media_folders_can_add_watermark' => 'Vízjel hozzáadása a mappákban lévő képekhez:',
        'max_upload_filesize' => 'Maximális feltöltési fájlméret (MB)',
        'max_upload_filesize_placeholder' => 'Alapértelmezett: :size, kevesebb kell legyen mint :size.',
        'max_upload_filesize_helper' => 'A szerver maximum :size méretű fájlokat engedélyez feltölteni, ezt az értéket módosíthatja a feltöltési fájlméret korlátozásához.',
        'image_processing_library' => 'Képfeldolgozó könyvtár',
        'use_original_name_for_file_path' => 'Eredeti név használata a fájl elérési útjához',
        'keep_original_file_size_and_quality' => 'Eredeti fájlméret és minőség megtartása',
        'update_thumbnail_sizes_warning' => 'A bélyegkép méretek módosítása után kattintson a ":button_text" gombra a frissítéshez.',
        'thumbnail_crop_position' => 'Bélyegkép vágási pozíció',
        'thumbnail_crop_position_left' => 'Bal',
        'thumbnail_crop_position_center' => 'Közép',
        'thumbnail_crop_position_right' => 'Jobb',
        'thumbnail_crop_position_top' => 'Felső',
        'thumbnail_crop_position_bottom' => 'Alsó',
        'thumbnail_crop_position_helper' => 'Ez a beállítás a kép vágására szolgál bélyegképek generálásakor. A kép erről a pozícióról lesz vágva, amíg a kép meg nem telik.',
        'user_can_only_view_own_media' => 'A felhasználók csak a saját médiájukat láthatják',
        'user_can_only_view_own_media_helper' => 'Ha engedélyezve van, a felhasználók csak a saját médiájukat láthatják, míg a fő adminisztrátorok az összes médiát láthatják.',
        'enable_thumbnail_sizes' => 'Bélyegkép méretek engedélyezése',
        'enable_thumbnail_sizes_helper' => 'Engedélyezze ezt az opciót a bélyegképek generálásához. Ha le van tiltva, a rendszer nem generál bélyegképeket a képekhez, és mindig a teljes méretű képet használja.',
        'convert_image_to_webp' => 'JPG, JPEG, PNG képek konvertálása WebP formátumba',
        'convert_image_to_webp_helper' => 'A WebP egy modern képformátum, amely kiváló veszteségmentes és veszteséges tömörítést biztosít a webes képekhez. Chrome, Firefox, Edge és Opera böngészőkben támogatott. A kép WebP formátumba lesz konvertálva feltöltéskor. Csak JPG, JPEG, PNG képekre vonatkozik.',
        'reduce_large_image_size' => 'Nagy képek méretének csökkentése feltöltéskor',
        'reduce_large_image_size_helper' => 'Ha engedélyezve van, a rendszer csökkenti a nagy képek méretét feltöltéskor, JPG, JPEG, PNG, WebP képekre alkalmazva. A kép maximális szélessége és magassága az alább beállított értékekre lesz átméretezve.',
        'image_max_width' => 'Kép maximális szélessége (px)',
        'image_max_height' => 'Kép maximális magassága (px)',
        'image_max_width_placeholder' => 'Hagyja üresen az eredeti szélesség megtartásához',
        'image_max_height_placeholder' => 'Hagyja üresen az eredeti magasság megtartásához',
        'image_max_width_helper' => 'Állítsa be a kép maximális szélességét pixelekben. Az eredeti szélesség megmarad, ha ez a mező üres.',
        'image_max_height_helper' => 'Állítsa be a kép maximális magasságát pixelekben. Az eredeti magasság megmarad, ha ez a mező üres.',
        'customize_upload_path' => 'Feltöltési útvonal testreszabása',
        'customize_upload_path_helper' => 'Testreszabhatja a médiafájlok feltöltési útvonalát. Alapértelmezés szerint a rendszer a ":path" mappába tölti fel a fájlokat.',
        'upload_path' => 'Feltöltési útvonal',
        'upload_path_placeholder' => 'Példa: uploads',
        'upload_path_helper' => 'Ez a mappa lesz létrehozva a /public mappában. Az alapértelmezett mappa a ":folder". Ezután a "/public/:folder" mappába lesz feltöltve.',
        'upload_path_warning' => 'A rendszer nem mozgatja át a meglévő fájlokat az új mappába. Ha a meglévő fájlokat az új mappába szeretné mozgatni, akkor manuálisan kell megtennie.',
        'convert_file_name_to_uuid' => 'Fájlnév konvertálása UUID-re',
        'convert_file_name_to_uuid_helper' => 'Ha engedélyezve van, a rendszer UUID-re konvertálja a fájlnevet feltöltéskor. Hasznos a duplikált fájlnevek elkerüléséhez és a jobb biztonsághoz.',
        's3_path' => 'Egyéni S3 útvonal (opcionális)',
        's3_path_placeholder' => 'Opcionális egyéni útvonal az S3 tárolóban (pl.: uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'Vásárlási kód',
        'buyer' => 'Vásárló',
    ],
    'field_type_not_exists' => 'Ez a mezőtípus nem létezik',
    'save_settings' => 'Beállítások mentése',
    'template' => 'Sablon',
    'description' => 'Leírás',
    'enable' => 'Engedélyezés',
    'send' => 'Küldés',
    'test_email_description' => 'Teszt e-mail küldéséhez győződjön meg arról, hogy frissítette az e-mail küldési beállításokat!',
    'test_email_input_placeholder' => 'Adja meg azt az e-mail címet, amelyre a teszt e-mailt szeretné küldeni.',
    'test_email_modal_title' => 'Teszt e-mail küldése',
    'test_send_mail' => 'Teszt e-mail küldése',
    'test_email_send_success' => 'E-mail sikeresen elküldve!',
    'locale_direction_ltr' => 'Balról jobbra',
    'locale_direction_rtl' => 'Jobbról balra',
    'emails_warning' => 'Maximum :count e-mail címet adhat hozzá',
    'email_add_more' => 'További hozzáadása',
    'generate' => 'Generálás',
    'generate_thumbnails' => 'Bélyegképek generálása',
    'generate_thumbnails_success' => 'Bélyegképek sikeresen generálva. :count fájl lett generálva!',
    'generate_thumbnails_error' => 'Nem sikerült újragenerálni a bélyegképeket :count fájlhoz!',
    'generate_thumbnails_description' => 'Biztosan újra szeretné generálni a bélyegképeket az összes képhez? Ez eltarthat egy ideig. Kérjük, ne navigáljon el erről az oldalról, amíg a folyamat be nem fejeződik.',
    'enable_chunk_description' => 'A darabolt feltöltés nagy fájlméretek feltöltésére szolgál.',
    'watermark_description' => 'FIGYELEM: A vízjel csak az újonnan feltöltött képekhez kerül hozzáadásra, a meglévő képekhez nem. A vízjel letiltása nem távolítja el a vízjelet a meglévő képekről.',
    'submit' => 'Beküldés',
    'back' => 'Vissza',
    'enter_sample_value' => 'Adja meg a minta értékeket teszteléshez',
    'preview' => 'Előnézet',
    'media_size_width' => ':size méret szélességének nagyobbnak kell lennie 0-nál',
    'media_size_height' => ':size méret magasságának nagyobbnak kell lennie 0-nál',
    'cronjob' => [
        'name' => 'Ütemezett feladat',
        'description' => 'Az ütemezett feladat lehetővé teszi bizonyos parancsok vagy szkriptek automatizálását az oldalon.',
        'is_not_ready' => 'Az ütemezett feladat futtatásához kövesse az alábbi utasításokat.',
        'is_working' => 'Gratulálunk! Az ütemezett feladata fut.',
        'is_not_working' => 'Az ütemezett feladata nem fut. Kérjük, ellenőrizze a szerver ütemezett feladatát.',
        'last_checked' => 'Utoljára ellenőrizve: :time.',
        'copy_button' => 'Másolás',
        'setup' => [
            'name' => 'Ütemezett feladat beállítása',
            'connect_to_server' => 'Csatlakozzon a szerverhez SSH-n vagy bármely előnyben részesített módszerrel.',
            'open_crontab' => 'Nyissa meg a crontab fájlt egy szövegszerkesztővel (pl.: `crontab -e`).',
            'add_cronjob' => 'Adja hozzá a fenti parancsot a crontab fájlhoz és mentse el.',
            'done' => 'Az ütemezett feladat most minden percben futni fog és végrehajtja a megadott parancsot.',
            'learn_more' => 'Többet megtudhat az ütemezett feladatokról a Laravel :documentation oldalon',
            'documentation' => 'dokumentációból',
            'copied' => 'Másolva',
        ],
    ],
    'security' => [
        'title' => 'Biztonsági beállítások',
        'description' => 'Ellenőrizze és konfigurálja a weboldal biztonsági beállításait.',
        'menu_description' => 'Cookie biztonság és HTTP fejlécek kezelése',
        'status_secure' => 'Minden biztonsági beállítás megfelelően konfigurálva van!',
        'status_insecure' => 'Néhány biztonsági beállítás figyelmet igényel!',
        'current_settings' => 'Jelenlegi biztonsági beállítások',
        'status' => 'Állapot',
        'setting' => 'Beállítás',
        'current_value' => 'Jelenlegi érték',
        'recommended_value' => 'Ajánlott',
        'session_http_only' => 'HttpOnly Cookie jelző',
        'session_http_only_description' => 'Megakadályozza, hogy a JavaScript hozzáférjen a munkamenet cookie-khoz (véd az XSS támadások ellen)',
        'session_secure_cookie' => 'Secure Cookie jelző',
        'session_secure_cookie_description' => 'Biztosítja, hogy a cookie-k csak HTTPS kapcsolatokon keresztül legyenek elküldve',
        'session_same_site' => 'SameSite Cookie jelző',
        'session_same_site_description' => 'Megakadályozza a CSRF támadásokat azáltal, hogy korlátozza, mikor kerülnek elküldésre a cookie-k',
        'http_security_headers' => 'HTTP biztonsági fejlécek',
        'http_security_headers_description' => 'Biztonsági fejléceket ad hozzá a gyakori webes sebezhetőségek elleni védelemhez',
        'https_warning' => 'Az oldala nem használ HTTPS-t',
        'https_warning_description' => 'Néhány biztonsági funkció, mint a biztonságos cookie-k, HTTPS-t igényel. Fontolja meg az SSL engedélyezését a weboldalához.',
        'how_to_fix' => 'Hogyan javítsuk a biztonsági problémákat',
        'env_file_location' => 'Szerkessze a .env fájlt a következő helyen:',
        'add_to_env' => 'Hozzáadandó beállítások',
        'required_settings' => 'Szükséges biztonsági beállítások',
        'for_https_sites' => 'Csak HTTPS oldalakhoz',
        'copy' => 'Másolás',
        'copy_settings' => 'Összes beállítás másolása',
        'copied' => 'Másolva!',
        'steps' => 'Beállítások alkalmazásának lépései',
        'step_1' => 'Nyissa meg a .env fájlt egy szövegszerkesztővel',
        'step_2' => 'Adja hozzá vagy frissítse a fent látható biztonsági beállításokat',
        'step_3' => 'Mentse el a .env fájlt',
        'step_4' => 'Törölje a gyorsítótárat az Adminisztrátor panel → Platform adminisztráció → Gyorsítótár kezelés menüpontban',
        'security_headers_info' => 'Biztonsági fejlécek információi',
        'security_headers_list' => 'Ha engedélyezve van, a következő fejlécek kerülnek hozzáadásra minden válaszhoz:',
        'header_nosniff' => 'Megakadályozza, hogy a böngészők kitalálják a tartalomtípusokat',
        'header_frame' => 'Véd a clickjacking támadások ellen',
        'header_xss' => 'Engedélyezi a böngésző XSS védelmét',
        'header_referrer' => 'Szabályozza, hogy mennyi referrer információ kerül elküldésre',
        'learn_more' => 'Részletesebb információkért lásd a :documentation',
        'documentation' => 'biztonsági dokumentációt',
    ],
    'cache' => [
        'title' => 'Gyorsítótár',
        'description' => 'Gyorsítótárazás konfigurálása az optimalizált sebességhez',
        'form' => [
            'cache_admin_menu' => 'Adminisztrátori menü gyorsítótárazása',
            'cache_admin_menu_helper' => 'Adminisztrátori menü gyorsítótárazása az optimalizált sebességért. Ezt az opciót le kell tiltani, ha fejleszt vagy testreszab az adminisztrátori menün.',
            'enable_cache_site_map' => 'Sitemap gyorsítótárazása',
            'enable_cache_site_map_helper' => 'A sitemap :url gyorsítótárazandó a nagy számú oldal miatt. Ha kevés oldala van, letilthatja ezt az opciót.',
            'cache_time_site_map' => 'Sitemap gyorsítótár időkorlátja (percben)',
            'cache_front_menu' => 'Előtér-menü gyorsítótárazása',
            'cache_front_menu_helper' => 'Előtér-menü gyorsítótárazása az optimalizált sebességért',
            'cache_user_avatar' => 'Felhasználói avatar gyorsítótárazása',
            'cache_user_avatar_helper' => 'Az avatar nélküli felhasználók esetében a rendszer generálja az avatarokat a felhasználónevükből. Az avatarok gyorsítótárazva lesznek az optimalizált sebességért és nem lesznek újragenerálva.',
            'shortcode_cache_enabled' => 'Rövid kódok gyorsítótárazása (UI blokkok)',
            'shortcode_cache_enabled_helper' => 'Gyorsítótárazás engedélyezése a rövid kódokhoz a teljesítmény javításához. Ha engedélyezve van, a rövid kódok gyorsítótárazva lesznek a renderelési idő csökkentéséhez.',
            'shortcode_cache_warning' => '<strong>⚠️ Fontos megjegyzés:</strong><br>• Az űrlapokat tartalmazó rövid kódok (kapcsolati űrlapok, hírlevél feliratkozások stb.) automatikusan megkerülik a gyorsítótárazást a funkcionalitás megőrzése érdekében.<br>• A dinamikus JavaScript tartalmat tartalmazó rövid kódoknál a gyorsítótárazást manuálisan kell letiltani.<br>• Adott rövid kódok gyorsítótárazásának letiltásához adja hozzá a <code>Gyorsítótárazás engedélyezése: Nem</code> értéket a rövid kód konfigurációjához.<br>• A CSRF tokeneket, reCAPTCHA-t vagy más dinamikus elemeket tartalmazó űrlapok automatikusan észlelve vannak és ki vannak zárva a gyorsítótárazásból.',
            'shortcode_cache_ttl' => 'Gyorsítótár időtartama (másodperc)',
            'shortcode_cache_ttl_helper' => 'Az összes rövid kód gyorsítótárazásának időtartama. Alapértelmezett 1800 másodperc (30 perc).',
            'widget_cache_enabled' => 'Widgetek gyorsítótárazása',
            'widget_cache_enabled_helper' => 'Gyorsítótárazás engedélyezése a widgetekhez a teljesítmény javításához. Ha engedélyezve van, a widgetek gyorsítótárazva lesznek a renderelési idő csökkentéséhez.',
            'widget_cache_warning' => '<strong>⚠️ Fontos megjegyzés:</strong><br>• Az űrlapokat tartalmazó widgetek (kapcsolati űrlapok, hírlevél feliratkozások stb.) automatikusan megkerülik a gyorsítótárazást a funkcionalitás megőrzése érdekében.<br>• A dinamikus JavaScript tartalmat tartalmazó widgeteknél a gyorsítótárazást manuálisan kell letiltani.<br>• Adott widgetek gyorsítótárazásának letiltásához állítsa be a <code>Gyorsítótárazás engedélyezése: Nem</code> értéket a widget konfigurációjában.<br>• A CSRF tokeneket, reCAPTCHA-t vagy más dinamikus elemeket tartalmazó űrlapok automatikusan észlelve vannak és ki vannak zárva a gyorsítótárazásból.',
            'widget_cache_ttl' => 'Gyorsítótár időtartama (másodperc)',
            'widget_cache_ttl_helper' => 'Az összes widget gyorsítótárazásának időtartama. Alapértelmezett 1800 másodperc (30 perc).',
            'plugin_cache_enabled' => 'Telepített beépülők gyorsítótárazása',
            'plugin_cache_enabled_helper' => 'A telepített beépülők listájának gyorsítótárazása a jobb teljesítmény érdekében. Ha engedélyezve van, a rendszer 30 percre gyorsítótárazza a beépülők listáját, hogy csökkentse a fájlrendszer vizsgálatokat.',
        ],
    ],
    'appearance' => [
        'title' => 'Megjelenés',
    ],
    'panel' => [
        'common' => 'Közös',
        'general' => 'Általános',
        'general_description' => 'Általános beállítások megtekintése és frissítése, valamint licenc aktiválása',
        'email' => 'E-mail',
        'email_description' => 'E-mail beállítások és e-mail sablonok megtekintése és frissítése',
        'media' => 'Média',
        'media_description' => 'Média beállítások megtekintése és frissítése',
        'system' => 'Rendszer',
        'system_updater' => 'Rendszerfrissítő',
        'system_updater_description' => 'Rendszer frissítése a legújabb verzióra',
        'others' => 'Egyebek',
    ],
    'saving' => 'Mentés...',
    'generating_media_thumbnails' => 'Média bélyegképek generálása...',
    'test_email_template' => 'E-mail sablon tesztelése',
    'select_email_template' => 'E-mail sablon kiválasztása',
    'enums' => [
        'data_retention_period' => [
            '0' => 'Soha',
            '1' => '1 nap',
            '3' => '3 nap',
            '7' => '1 hét',
            '30' => '1 hónap',
            '90' => '3 hónap',
            '180' => '6 hónap',
            '365' => '1 év',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'A :attribute mezőnek érvényes AWS régiónak kell lennie (pl.: us-east-1, eu-west-1).',
    ],
];
