<?php

return [
    'title' => 'Ustawienia',
    'general_setting' => 'Ustawienia ogólne',
    'menu' => 'Wszystkie ustawienia',
    'email_setting_title' => 'Ustawienia e-mail',
    'email_setting_description' => 'Skonfiguruj ustawienia e-mail',
    'general' => [
        'theme' => 'Motyw',
        'title' => 'Informacje ogólne',
        'description' => 'Wyświetl i zaktualizuj informacje o witrynie',
        'rich_editor' => 'Edytor zaawansowany',
        'site_title' => 'Tytuł witryny',
        'admin_email' => 'E-mail administratora',
        'seo_block' => 'Konfiguracja SEO',
        'seo_title' => 'Tytuł SEO',
        'seo_description' => 'Opis SEO',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Tytuł witryny (maksymalnie 120 znaków)',
            'admin_email' => 'E-mail administratora',
            'seo_title' => 'Tytuł SEO (maksymalnie 120 znaków)',
            'seo_description' => 'Opis SEO (maksymalnie 120 znaków)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Wysyłaj raporty o błędach przez e-mail',
        'enable_send_error_reporting_via_email_helper' => 'Po włączeniu szczegółowe raporty o błędach będą wysyłane na adresy e-mail administratora, gdy wystąpią krytyczne błędy na stronie',
        'time_zone_helper' => 'Wybierz strefę czasową dla swojej witryny. Będzie to używane dla wszystkich wyświetleń daty i czasu w całym systemie',
        'time_zone' => 'Strefa czasowa',
        'enable' => 'Włącz',
        'disable' => 'Wyłącz',
        'disabled_helper' => 'Nie można wyłączyć tego szablonu e-mail!',
        'enable_cache_site_map' => 'Włącz buforowanie mapy witryny',
        'cache_time_site_map' => 'Limit czasu bufora mapy witryny (w minutach)',
        'admin_logo' => 'Logo administratora',
        'admin_favicon' => 'Favicon administratora',
        'admin_title' => 'Tytuł administratora',
        'admin_title_placeholder' => 'Tytuł wyświetlany w zakładce przeglądarki',
        'admin_appearance_title' => 'Wygląd panelu administratora',
        'admin_appearance_description' => 'Ustawienia wyglądu panelu administratora, takie jak edytor, język...',
        'seo_block_description' => 'Ustawienia tytułu witryny, opisu meta witryny, słów kluczowych witryny w celu optymalizacji SEO',
        'webmaster_tools_description' => 'Google Search Console to bezpłatne narzędzie internetowe udostępniane przez Google, które pomaga właścicielom witryn monitorować wydajność ich witryny w wynikach wyszukiwania Google.',
        'yes' => 'Tak',
        'no' => 'Nie',
        'show_on_front' => 'Twoja strona główna wyświetla',
        'select' => '— Wybierz —',
        'show_site_name' => 'Pokaż nazwę witryny po tytule strony, oddzieloną "-"',
        'locale' => 'Język witryny',
        'locale_direction' => 'Kierunek tekstu witryny frontowej',
        'minutes' => 'minuty',
        'redirect_404_to_homepage' => 'Przekieruj wszystkie żądania Nie znaleziono na stronę główną',
    ],
    'admin_appearance' => [
        'title' => 'Wygląd panelu administratora',
        'description' => 'Wyświetl i zaktualizuj logo, favicon, układ,...',
        'layout' => 'Układ',
        'horizontal' => 'Poziomy',
        'vertical' => 'Pionowy',
        'show_menu_item_icon' => 'Pokaż ikonę elementu menu',
        'language' => 'Język panelu administratora',
        'theme_mode' => 'Tryb motywu',
        'dark' => 'Ciemny',
        'light' => 'Jasny',
        'container_width' => [
            'title' => 'Szerokość kontenera',
            'default' => 'Domyślna',
            'large' => 'Duża',
            'full' => 'Pełna',
        ],
        'form' => [
            'admin_logo' => 'Logo administratora',
            'admin_logo_max_height' => 'Wysokość logo (px)',
            'admin_logo_max_height_helper' => 'Ustaw wysokość logo w pikselach. Wartość domyślna to :default.',
            'admin_favicon' => 'Favicon administratora',
            'admin_favicon_type' => 'Typ favicon administratora',
            'admin_title' => 'Tytuł administratora',
            'admin_title_placeholder' => 'Tytuł wyświetlany w zakładce przeglądarki',
            'admin_login_screen_backgrounds' => 'Tła ekranu logowania (~1366 x 768)',
            'admin_locale' => 'Język administratora',
            'admin_locale_direction' => 'Kierunek języka administratora',
            'rich_editor' => 'Edytor zaawansowany',
            'show_admin_bar' => 'Pokaż pasek administratora dla zalogowanych administratorów, nawet w witrynie frontowej',
            'show_guidelines' => 'Pokaż wytyczne',
            'primary_font' => 'Czcionka główna',
            'primary_color' => 'Kolor główny',
            'secondary_color' => 'Kolor drugorzędny',
            'heading_color' => 'Kolor nagłówka',
            'text_color' => 'Kolor tekstu',
            'link_color' => 'Kolor linku',
            'link_hover_color' => 'Kolor linku po najechaniu',
            'show_menu_item_icon' => 'Pokaż ikonę elementu menu',
            'custom_css' => 'Niestandardowy CSS',
            'custom_js' => 'Niestandardowy JS',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript w nagłówku strony, opakuj wewnątrz &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript w treści strony, opakuj wewnątrz &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript w stopce strony, opakuj wewnątrz &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Tabele danych',
        'description' => 'Ustawienia tabel danych',
        'form' => [
            'show_column_visibility' => 'Pokaż widoczność kolumn domyślnie',
            'show_column_visibility_helper' => 'Włącz przycisk przełączania widoczności kolumn w tabelach danych, aby umożliwić użytkownikom pokazywanie/ukrywanie kolumn',
            'show_export_button' => 'Pokaż przycisk eksportu domyślnie',
            'show_export_button_helper' => 'Wyświetl opcje eksportu (CSV, Excel, PDF) w tabelach danych do pobierania danych z tabeli',
            'pagination_type' => 'Typ paginacji',
            'pagination_type_helper' => 'Wybierz sposób wyświetlania elementów sterujących paginacją: Domyślny wyświetla numery stron, Rozwijana wyświetla kompaktowy selektor rozwijany',
            'default' => 'Domyślna',
            'dropdown' => 'Rozwijana',
            'enable_responsive' => 'Włącz responsywność tabeli',
            'enable_responsive_helper' => 'Automatycznie dostosuj kolumny tabeli do różnych rozmiarów ekranów dla lepszego doświadczenia mobilnego',
        ],
    ],
    'email' => [
        'subject' => 'Temat',
        'content' => 'Treść',
        'title' => 'Ustawienia szablonu e-mail',
        'description' => 'Szablon e-mail używający HTML i zmiennych systemowych.',
        'reset_to_default' => 'Przywróć domyślne',
        'back' => 'Powrót do ustawień',
        'reset_success' => 'Pomyślnie przywrócono domyślne ustawienia',
        'confirm_reset' => 'Potwierdzić zresetowanie szablonu e-mail?',
        'confirm_message' => 'Czy naprawdę chcesz przywrócić ten szablon e-mail do ustawień domyślnych?',
        'continue' => 'Kontynuuj',
        'sender_name' => 'Nazwa nadawcy',
        'sender_name_placeholder' => 'Nazwa',
        'sender_name_helper' => 'Nazwa, która pojawi się w polu Od w e-mailach wysyłanych przez system',
        'sender_email' => 'E-mail nadawcy',
        'sender_email_placeholder' => 'Adres e-mail (np. :default)',
        'sender_email_helper' => 'Adres e-mail, który będzie używany jako nadawca dla wszystkich e-maili wysyłanych przez system',
        'mailer' => 'Mailer',
        'port' => 'Port',
        'port_placeholder' => 'Np.: 587',
        'port_helper' => 'Port używany przez serwer pocztowy (typowe porty: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Np.: smtp.gmail.com',
        'host_helper' => 'Adres hosta SMTP',
        'username' => 'Nazwa użytkownika',
        'username_placeholder' => 'Nazwa użytkownika do logowania na serwer pocztowy',
        'username_helper' => 'Twoja nazwa użytkownika do logowania na serwer pocztowy',
        'password' => 'Hasło',
        'password_placeholder' => 'Hasło do logowania na serwer pocztowy',
        'password_helper' => 'Twoje hasło do logowania na serwer pocztowy',
        'encryption' => 'Szyfrowanie',
        'encryption_placeholder' => 'Wybierz typ szyfrowania',
        'encryption_helper' => 'Wybierz metodę szyfrowania dla bezpiecznej transmisji e-mail',
        'encryption_none' => 'Brak',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Wskazówki dotyczące konfiguracji e-mail',
        'setup_tip_gmail' => 'Dla Gmail: Użyj smtp.gmail.com jako hosta, port 587 z TLS lub port 465 z SSL. Włącz "Dostęp dla mniej bezpiecznych aplikacji" lub użyj Hasła aplikacji.',
        'setup_tip_port' => 'Typowe porty: 25 (nieszyfrowany), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternatywny).',
        'setup_tip_encryption' => 'Użyj TLS dla portu 587 (zalecane), SSL dla portu 465 lub Brak dla portu 25 (niezalecane dla produkcji).',
        'setup_tip_test' => 'Zawsze używaj przycisku "Wyślij testowy e-mail" aby zweryfikować konfigurację przed zapisaniem.',
        'setup_tip_mailgun' => 'Dla lepszej dostarczalności rozważ użycie usług e-mail takich jak Mailgun, SendGrid lub Amazon SES zamiast SMTP.',
        'queue_warning_title' => 'Wymagana konfiguracja kolejki',
        'queue_warning_description' => 'Twoja kolejka e-mail jest obecnie skonfigurowana do używania sterownika ":default", ale twój proces kolejki może nie być uruchomiony. Oznacza to, że e-maile nie będą wysyłane, dopóki nie skonfigurujesz procesu kolejki.',
        'queue_warning_action' => 'Aby wysyłać e-maile natychmiast bez procesu kolejki, ustaw QUEUE_CONNECTION=sync w pliku .env. W przeciwnym razie upewnij się, że proces kolejki działa za pomocą "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Dowiedz się więcej o kolejkach Laravel</a>.',
        'mail_gun_domain' => 'Domena',
        'mail_gun_domain_placeholder' => 'Np.: mg.twojadomena.com',
        'mail_gun_domain_helper' => 'Nazwa domeny zarejestrowanej w Mailgun',
        'mail_gun_secret' => 'Klucz tajny',
        'mail_gun_secret_placeholder' => 'Np.: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Twój klucz API Mailgun',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Np.: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Endpoint API Mailgun (api.mailgun.net dla USA, api.eu.mailgun.net dla UE)',
        'log_channel' => 'Kanał logów',
        'log_channel_helper' => 'Wybierz kanał logowania do użycia dla logów e-mail',
        'sendmail_path' => 'Ścieżka Sendmail',
        'local_domain' => 'Domena lokalna',
        'local_domain_placeholder' => 'Może być puste. Należy ustawić na twoją domenę podczas używania SMTP Relay. Np. twoja-domena.com',
        'local_domain_helper' => 'Domena, która będzie używana do identyfikacji serwera podczas komunikacji ze zdalnymi serwerami SMTP',

        'ses_key' => 'Klucz',
        'ses_key_placeholder' => 'Np.: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Twój identyfikator klucza dostępu AWS',
        'ses_secret' => 'Klucz tajny',
        'ses_secret_placeholder' => 'Np.: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Twój tajny klucz dostępu AWS',
        'ses_region' => 'Region',
        'ses_region_placeholder' => 'Np.: us-east-1',
        'ses_region_helper' => 'Region AWS, w którym skonfigurowano usługę SES',

        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Np.: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Twój token serwera Postmark',

        'resend_key' => 'Klucz API',
        'resend_key_placeholder' => 'Np.: re_123456789012345678901234567890',
        'resend_key_helper' => 'Twój klucz API Resend',

        'email_templates' => 'Szablony e-mail',
        'email_templates_description' => 'Szablony e-mail używające HTML i zmiennych systemowych.',
        'email_template_settings' => 'Ustawienia szablonów e-mail',
        'email_template_settings_description' => 'Wyświetl i zaktualizuj ustawienia szablonów e-mail',
        'email_rules' => 'Zasady e-mail',
        'email_rules_description' => 'Skonfiguruj zasady e-mail dla walidacji',
        'base_template' => 'Szablon bazowy',
        'base_template_description' => 'Szablon bazowy dla wszystkich e-maili',
        'template_header' => 'Nagłówek szablonu e-mail',
        'template_header_description' => 'Szablon nagłówka e-maili',
        'template_footer' => 'Stopka szablonu e-mail',
        'template_footer_description' => 'Szablon stopki e-maili',
        'default' => 'Domyślny',
        'template_off_status_helper' => 'Ten szablon e-mail jest wyłączony.',
        'blacklist_email_domains' => 'Zablokowane domeny e-mail',
        'blacklist_email_domains_helper' => 'Wprowadź listę domen e-mail do zablokowania. Np. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Zablokowane adresy e-mail',
        'blacklist_specified_emails_helper' => 'Wprowadź listę konkretnych adresów e-mail do zablokowania. Np. mail@example.com.',
        'exception_emails' => 'Wyjątki e-mail',
        'exception_emails_helper' => 'Te e-maile będą wyłączone z reguł walidacji.',
        'email_rules_strict' => 'Ścisła walidacja e-mail',
        'email_rules_strict_helper' => 'Wykonaj walidację e-mail zgodną z RFC ze ścisłymi regułami.',
        'email_rules_dns' => 'Walidacja sprawdzania DNS',
        'email_rules_dns_helper' => 'Sprawdź, czy istnieją rekordy DNS wskazujące, że serwer akceptuje e-maile.',
        'email_rules_spoof' => 'Wykrywanie podszycia',
        'email_rules_spoof_helper' => 'Wykrywaj potencjalne próby podszycia się pod e-mail.',
        'template_turn_off' => 'Kliknij, aby wyłączyć ten szablon e-mail',
        'template_turn_on' => 'Kliknij, aby włączyć ten szablon e-mail',
        'turn_on_success_message' => 'Pomyślnie włączono szablon e-mail!',
        'turn_off_success_message' => 'Pomyślnie wyłączono szablon e-mail!',
        'email_template_status' => 'Status szablonu e-mail',
        'email_template_status_description' => 'Włącz/wyłącz szablon e-mail',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Jeśli nie zostanie ustawione, zostanie pobrane z logo administratora w Admin -> Ustawienia -> Wygląd administratora -> Logo.',
        'email_template_copyright_text_helper_text' => 'Jeśli nie zostanie ustawione, zostanie pobrane z praw autorskich opcji motywu w Admin -> Wygląd -> Opcje motywu -> Ogólne -> Prawa autorskie.',
        'email_template_email_contact' => 'Kontaktowy adres e-mail',
        'email_template_email_contact_helper_text' => 'Jeśli nie zostanie ustawione, zostanie pobrane z e-mail nadawcy w Admin -> Ustawienia -> E-mail',
        'email_template_social_links' => 'Linki społecznościowe',
        'email_template_copyright_text' => 'Prawa autorskie',
        'image_upload_supported' => 'Obsługuje tylko formaty PNG, JPG, JPEG i GIF.',
        'email_template_custom_css' => 'Niestandardowy CSS szablonu e-mail',
        'social_links' => [
            'name' => 'Nazwa',
            'icon' => 'Ikona',
            'icon_image' => 'Obraz ikony (Obsługuje tylko formaty PNG, JPG, JPEG i GIF.)',
            'url' => 'URL',
            'image' => 'Obraz',
        ],
    ],
    'media' => [
        'title' => 'Media',
        'driver' => 'Sterownik',
        'description' => 'Ustawienia mediów',
        'local_disk' => 'Dysk lokalny',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS Default Region',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (Opcjonalnie)',
        'use_path_style_endpoint' => 'Użyj endpoint w stylu ścieżki',
        'r2_access_key_id' => 'R2 Access Key ID',
        'r2_secret_key' => 'R2 Secret Key',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces Default Region',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'Czy DO Spaces CDN jest włączone?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN domena niestandardowa',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://twoja-domena-niestandardowa.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi Default Region',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'Aby ponownie użyć istniejących obrazów, po prostu wyznacz katalog główny Wasabi jako "/", a następnie prześlij wszystkie bieżące pliki z public/storage do katalogu głównego Wasabi.',
        'backblaze_access_key_id' => 'Backblaze Access Key ID',
        'backblaze_secret_key' => 'Backblaze Secret Key',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze Default Region',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Czy Backblaze CDN jest włączone?',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN domena niestandardowa',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://twoja-domena-niestandardowa.com',
        'default_placeholder_image' => 'Domyślny obraz zastępczy',
        'enable_chunk' => 'Włącz przesyłanie fragmentami',
        'chunk_size' => 'Rozmiar fragmentu (bajty)',
        'chunk_size_placeholder' => 'Domyślnie: 1048576 ~ 1MB',
        'max_file_size' => 'Maksymalny rozmiar pliku fragmentu (MB)',
        'max_file_size_placeholder' => 'Domyślnie: 1048576 ~ 1GB',
        'enable_watermark' => 'Włącz znak wodny',
        'watermark_source' => 'Obraz znaku wodnego',
        'watermark_source_helper' => 'Obsługuje tylko formaty PNG, JPG i JPEG. Powinieneś użyć obrazu mniejszego niż 200x200px i rozmiaru mniejszego niż 50KB.',
        'watermark_size' => 'Rozmiar znaku wodnego (%)',
        'watermark_size_placeholder' => 'Domyślnie: 10 (%)',
        'watermark_opacity' => 'Przezroczystość znaku wodnego (%)',
        'watermark_opacity_placeholder' => 'Domyślnie: 70 (%)',
        'watermark_position' => 'Pozycja znaku wodnego',
        'watermark_position_x' => 'Pozycja X znaku wodnego',
        'watermark_position_y' => 'Pozycja Y znaku wodnego',
        'watermark_position_top_left' => 'Góra lewo',
        'watermark_position_top_right' => 'Góra prawo',
        'watermark_position_bottom_left' => 'Dół lewo',
        'watermark_position_bottom_right' => 'Dół prawo',
        'watermark_position_center' => 'Środek',
        'turn_off_automatic_url_translation_into_latin' => 'Wyłącz automatyczne tłumaczenie URL na łacinę',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Nazwa strefy (nazwa strefy przechowywania)',
        'bunnycdn_key' => 'Hasło dostępu FTP i API (hasło dostępu API strefy przechowywania)',
        'bunnycdn_region' => 'Region (region strefy przechowywania)',
        'optional' => 'Opcjonalnie',
        'sizes' => 'Rozmiary miniatur mediów',
        'media_sizes_helper' => 'Ustaw szerokość lub wysokość na 0, jeśli chcesz przyciąć tylko według szerokości lub wysokości.',
        'width' => 'Szerokość',
        'height' => 'Wysokość',
        'default_size_value' => 'Domyślnie: :size',
        'all' => 'Wszystkie',
        'all_helper_text' => 'Jeśli odznaczysz wszystkie foldery, będzie to stosowane do wszystkich folderów.',
        'media_folders_can_add_watermark' => 'Dodaj znak wodny do obrazów w folderach:',
        'max_upload_filesize' => 'Maksymalny rozmiar przesyłanego pliku (MB)',
        'max_upload_filesize_placeholder' => 'Domyślnie: :size, musi być mniejsze niż :size.',
        'max_upload_filesize_helper' => 'Twój serwer pozwala na przesyłanie plików maksymalnie :size, możesz zmienić tę wartość, aby ograniczyć rozmiar przesyłanego pliku.',
        'image_processing_library' => 'Biblioteka przetwarzania obrazów',
        'use_original_name_for_file_path' => 'Użyj oryginalnej nazwy dla ścieżki pliku',
        'keep_original_file_size_and_quality' => 'Zachowaj oryginalny rozmiar i jakość pliku',
        'update_thumbnail_sizes_warning' => 'Po dostosowaniu rozmiarów miniatur musisz kliknąć przycisk ":button_text", aby je odświeżyć.',
        'thumbnail_crop_position' => 'Pozycja przycinania miniatury',
        'thumbnail_crop_position_left' => 'Lewo',
        'thumbnail_crop_position_center' => 'Środek',
        'thumbnail_crop_position_right' => 'Prawo',
        'thumbnail_crop_position_top' => 'Góra',
        'thumbnail_crop_position_bottom' => 'Dół',
        'thumbnail_crop_position_helper' => 'To ustawienie służy do przycinania obrazu podczas generowania miniatur. Zostanie przycięty z tej pozycji aż do wypełnienia obrazu.',
        'user_can_only_view_own_media' => 'Użytkownicy mogą przeglądać tylko swoje media',
        'user_can_only_view_own_media_helper' => 'Po włączeniu użytkownicy mogą przeglądać tylko swoje media, podczas gdy super administratorzy mogą przeglądać wszystkie media.',
        'enable_thumbnail_sizes' => 'Włącz rozmiary miniatur',
        'enable_thumbnail_sizes_helper' => 'Włącz tę opcję, aby generować miniatury dla obrazów. Jeśli jest wyłączona, system nie będzie generował miniatur dla obrazów i zawsze będzie używał obrazu w pełnym rozmiarze.',
        'convert_image_to_webp' => 'Konwertuj obraz JPG, JPEG, PNG na WebP',
        'convert_image_to_webp_helper' => 'WebP to nowoczesny format obrazu, który zapewnia doskonałą kompresję bezstratną i stratną dla obrazów w Internecie. Jest obsługiwany w Chrome, Firefox, Edge i Opera. Obraz zostanie przekonwertowany na format WebP podczas przesyłania. Jest stosowany tylko dla obrazów JPG, JPEG, PNG.',
        'reduce_large_image_size' => 'Zmniejsz rozmiar dużych obrazów podczas przesyłania',
        'reduce_large_image_size_helper' => 'Po włączeniu system zmniejszy rozmiar dużych obrazów podczas przesyłania, stosowany dla obrazów JPG, JPEG, PNG, WebP. Maksymalna szerokość i wysokość obrazu zostaną zmienione do wartości ustawionych poniżej.',
        'image_max_width' => 'Maksymalna szerokość obrazu (px)',
        'image_max_height' => 'Maksymalna wysokość obrazu (px)',
        'image_max_width_placeholder' => 'Zostaw puste, aby zachować oryginalną szerokość',
        'image_max_height_placeholder' => 'Zostaw puste, aby zachować oryginalną wysokość',
        'image_max_width_helper' => 'Ustaw maksymalną szerokość obrazu w pikselach. Oryginalna szerokość zostanie zachowana, jeśli to pole jest puste.',
        'image_max_height_helper' => 'Ustaw maksymalną wysokość obrazu w pikselach. Oryginalna wysokość zostanie zachowana, jeśli to pole jest puste.',
        'customize_upload_path' => 'Dostosuj ścieżkę przesyłania',
        'customize_upload_path_helper' => 'Dostosuj ścieżkę przesyłania plików multimedialnych. Domyślnie system będzie przesyłał pliki do folderu ":path".',
        'upload_path' => 'Ścieżka przesyłania',
        'upload_path_placeholder' => 'Przykład: uploads',
        'upload_path_helper' => 'Ten folder zostanie utworzony w /public. Domyślny folder to ":folder". Następnie zostanie przesłany do "/public/:folder".',
        'upload_path_warning' => 'System nie przeniesie istniejących plików do nowego folderu. Jeśli chcesz przenieść istniejące pliki do nowego folderu, musisz to zrobić ręcznie.',
        'convert_file_name_to_uuid' => 'Konwertuj nazwę pliku na UUID',
        'convert_file_name_to_uuid_helper' => 'Po włączeniu system przekonwertuje nazwę pliku na UUID podczas przesyłania. Jest to przydatne do zapobiegania duplikatom nazw plików i lepszego bezpieczeństwa.',
        's3_path' => 'Niestandardowa ścieżka S3 (Opcjonalnie)',
        's3_path_placeholder' => 'Opcjonalna niestandardowa ścieżka w zasobniku S3 (np. uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'Kod zakupu',
        'buyer' => 'Kupujący',
    ],
    'field_type_not_exists' => 'Ten typ pola nie istnieje',
    'save_settings' => 'Zapisz ustawienia',
    'template' => 'Szablon',
    'description' => 'Opis',
    'enable' => 'Włącz',
    'send' => 'Wyślij',
    'test_email_description' => 'Aby wysłać testowy e-mail, upewnij się, że zaktualizowałeś konfigurację wysyłania e-maili!',
    'test_email_input_placeholder' => 'Wprowadź adres e-mail, na który chcesz wysłać testowy e-mail.',
    'test_email_modal_title' => 'Wyślij testowy e-mail',
    'test_send_mail' => 'Wyślij testowy e-mail',
    'test_email_send_success' => 'E-mail wysłany pomyślnie!',
    'locale_direction_ltr' => 'Od lewej do prawej',
    'locale_direction_rtl' => 'Od prawej do lewej',
    'emails_warning' => 'Możesz dodać maksymalnie :count e-maili',
    'email_add_more' => 'Dodaj więcej',
    'generate' => 'Generuj',
    'generate_thumbnails' => 'Generuj miniatury',
    'generate_thumbnails_success' => 'Miniatury wygenerowane pomyślnie. Wygenerowano :count plików!',
    'generate_thumbnails_error' => 'Nie udało się ponownie wygenerować miniatur dla :count plików!',
    'generate_thumbnails_description' => 'Czy na pewno chcesz ponownie wygenerować miniatury dla wszystkich obrazów? Może to zająć trochę czasu. Nie opuszczaj tej strony, dopóki proces się nie zakończy.',
    'enable_chunk_description' => 'Przesyłanie fragmentami służy do przesyłania dużych plików.',
    'watermark_description' => 'UWAGA: Znak wodny jest dodawany tylko do nowo przesłanych obrazów, nie zostanie dodany do istniejących obrazów. Wyłączenie znaku wodnego nie usunie znaku wodnego z istniejących obrazów.',
    'submit' => 'Prześlij',
    'back' => 'Wstecz',
    'enter_sample_value' => 'Wprowadź przykładowe wartości do testowania',
    'preview' => 'Podgląd',
    'media_size_width' => 'Szerokość rozmiaru :size musi być większa niż 0',
    'media_size_height' => 'Wysokość rozmiaru :size musi być większa niż 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob pozwala zautomatyzować niektóre polecenia lub skrypty na Twojej stronie.',
        'is_not_ready' => 'Aby uruchomić cronjob, postępuj zgodnie z poniższymi instrukcjami.',
        'is_working' => 'Gratulacje! Twój cronjob działa.',
        'is_not_working' => 'Twój cronjob nie działa. Sprawdź cronjob serwera.',
        'last_checked' => 'Ostatnio sprawdzono o :time.',
        'copy_button' => 'Kopiuj',
        'setup' => [
            'name' => 'Konfigurowanie Cronjob',
            'connect_to_server' => 'Połącz się z serwerem za pomocą SSH lub innej preferowanej metody.',
            'open_crontab' => 'Otwórz plik crontab za pomocą edytora tekstu (np. `crontab -e`).',
            'add_cronjob' => 'Dodaj powyższe polecenie do pliku crontab i zapisz go.',
            'done' => 'Cronjob będzie teraz uruchamiany co minutę i wykonywać określone polecenie.',
            'learn_more' => 'Możesz dowiedzieć się więcej o cronjob z :documentation Laravel',
            'documentation' => 'dokumentacji',
            'copied' => 'Skopiowano',
        ],
    ],
    'security' => [
        'title' => 'Ustawienia bezpieczeństwa',
        'description' => 'Sprawdź i skonfiguruj ustawienia bezpieczeństwa swojej witryny.',
        'menu_description' => 'Zarządzaj bezpieczeństwem plików cookie i nagłówkami HTTP',
        'status_secure' => 'Wszystkie ustawienia bezpieczeństwa są poprawnie skonfigurowane!',
        'status_insecure' => 'Niektóre ustawienia bezpieczeństwa wymagają uwagi!',
        'current_settings' => 'Bieżące ustawienia bezpieczeństwa',
        'status' => 'Status',
        'setting' => 'Ustawienie',
        'current_value' => 'Bieżąca wartość',
        'recommended_value' => 'Zalecana',
        'session_http_only' => 'Flaga pliku cookie HttpOnly',
        'session_http_only_description' => 'Zapobiega dostępowi JavaScript do plików cookie sesji (chroni przed atakami XSS)',
        'session_secure_cookie' => 'Flaga bezpiecznego pliku cookie',
        'session_secure_cookie_description' => 'Zapewnia, że pliki cookie są wysyłane tylko przez połączenia HTTPS',
        'session_same_site' => 'Flaga pliku cookie SameSite',
        'session_same_site_description' => 'Zapobiega atakom CSRF, ograniczając kiedy pliki cookie są wysyłane',
        'http_security_headers' => 'Nagłówki bezpieczeństwa HTTP',
        'http_security_headers_description' => 'Dodaje nagłówki bezpieczeństwa, aby chronić przed typowymi lukami w zabezpieczeniach stron internetowych',
        'https_warning' => 'Twoja witryna nie używa HTTPS',
        'https_warning_description' => 'Niektóre funkcje bezpieczeństwa, takie jak bezpieczne pliki cookie, wymagają HTTPS. Rozważ włączenie SSL dla swojej witryny.',
        'how_to_fix' => 'Jak naprawić problemy z bezpieczeństwem',
        'env_file_location' => 'Edytuj swój plik .env znajdujący się w:',
        'add_to_env' => 'Ustawienia do dodania',
        'required_settings' => 'Wymagane ustawienia bezpieczeństwa',
        'for_https_sites' => 'Tylko dla witryn HTTPS',
        'copy' => 'Kopiuj',
        'copy_settings' => 'Kopiuj wszystkie ustawienia',
        'copied' => 'Skopiowano!',
        'steps' => 'Kroki do zastosowania ustawień',
        'step_1' => 'Otwórz plik .env w edytorze tekstu',
        'step_2' => 'Dodaj lub zaktualizuj ustawienia bezpieczeństwa pokazane powyżej',
        'step_3' => 'Zapisz plik .env',
        'step_4' => 'Wyczyść pamięć podręczną za pomocą Panel administratora → Administracja platformy → Zarządzanie pamięcią podręczną',
        'security_headers_info' => 'Informacje o nagłówkach bezpieczeństwa',
        'security_headers_list' => 'Po włączeniu następujące nagłówki są dodawane do wszystkich odpowiedzi:',
        'header_nosniff' => 'Zapobiega odgadywaniu typów treści przez przeglądarki',
        'header_frame' => 'Chroni przed atakami clickjacking',
        'header_xss' => 'Włącza ochronę XSS przeglądarki',
        'header_referrer' => 'Kontroluje, ile informacji o referrerze jest wysyłanych',
        'learn_more' => 'Aby uzyskać więcej szczegółowych informacji, zobacz :documentation',
        'documentation' => 'dokumentację bezpieczeństwa',
    ],
    'cache' => [
        'title' => 'Pamięć podręczna',
        'description' => 'Konfiguruj buforowanie dla zoptymalizowanej prędkości',
        'form' => [
            'cache_admin_menu' => 'Buforuj menu administratora',
            'cache_admin_menu_helper' => 'Buforuj menu administratora dla zoptymalizowanej prędkości. Ta opcja powinna być wyłączona, jeśli rozwijasz lub dostosowujesz menu administratora.',
            'enable_cache_site_map' => 'Buforuj mapę witryny',
            'enable_cache_site_map_helper' => 'Mapa witryny :url powinna być buforowana ze względu na dużą liczbę stron. Jeśli masz małą liczbę stron, możesz wyłączyć tę opcję.',
            'cache_time_site_map' => 'Limit czasu bufora mapy witryny (w minutach)',
            'cache_front_menu' => 'Buforuj menu frontowe',
            'cache_front_menu_helper' => 'Buforuj menu frontowe dla zoptymalizowanej prędkości',
            'cache_user_avatar' => 'Buforuj awatar użytkownika',
            'cache_user_avatar_helper' => 'Dla użytkowników bez awatara system wygeneruje awatary z ich nazw użytkowników. Awatary będą buforowane dla zoptymalizowanej prędkości i nie będą ponownie generowane.',
            'shortcode_cache_enabled' => 'Buforuj shortcody (bloki UI)',
            'shortcode_cache_enabled_helper' => 'Włącz buforowanie shortcodów, aby poprawić wydajność. Po włączeniu shortcody będą buforowane, aby skrócić czas renderowania.',
            'shortcode_cache_warning' => '<strong>⚠️ Ważna informacja:</strong><br>• Shortcody zawierające formularze (formularze kontaktowe, subskrypcje newslettera itp.) automatycznie ominą buforowanie, aby zachować funkcjonalność.<br>• Shortcody z dynamiczną zawartością JavaScript powinny mieć buforowanie wyłączone ręcznie.<br>• Aby wyłączyć buforowanie dla konkretnych shortcodów, dodaj <code>Enable caching: No</code> do konfiguracji shortcodu.<br>• Formularze z tokenami CSRF, reCAPTCHA lub innymi dynamicznymi elementami są automatycznie wykrywane i wyłączone z buforowania.',
            'shortcode_cache_ttl' => 'Czas trwania bufora (sekundy)',
            'shortcode_cache_ttl_helper' => 'Czas trwania bufora dla wszystkich shortcodów. Domyślnie 1800 sekund (30 minut).',
            'widget_cache_enabled' => 'Buforuj widgety',
            'widget_cache_enabled_helper' => 'Włącz buforowanie widgetów, aby poprawić wydajność. Po włączeniu widgety będą buforowane, aby skrócić czas renderowania.',
            'widget_cache_warning' => '<strong>⚠️ Ważna informacja:</strong><br>• Widgety zawierające formularze (formularze kontaktowe, subskrypcje newslettera itp.) automatycznie ominą buforowanie, aby zachować funkcjonalność.<br>• Widgety z dynamiczną zawartością JavaScript powinny mieć buforowanie wyłączone ręcznie.<br>• Aby wyłączyć buforowanie dla konkretnych widgetów, ustaw <code>Enable caching: No</code> w konfiguracji widgetu.<br>• Formularze z tokenami CSRF, reCAPTCHA lub innymi dynamicznymi elementami są automatycznie wykrywane i wyłączone z buforowania.',
            'widget_cache_ttl' => 'Czas trwania bufora (sekundy)',
            'widget_cache_ttl_helper' => 'Czas trwania bufora dla wszystkich widgetów. Domyślnie 1800 sekund (30 minut).',
            'plugin_cache_enabled' => 'Buforuj zainstalowane wtyczki',
            'plugin_cache_enabled_helper' => 'Buforuj listę zainstalowanych wtyczek dla poprawy wydajności. Po włączeniu system będzie buforował listę wtyczek przez 30 minut, aby zmniejszyć skanowanie systemu plików.',
        ],
    ],
    'appearance' => [
        'title' => 'Wygląd',
    ],
    'panel' => [
        'common' => 'Wspólne',
        'general' => 'Ogólne',
        'general_description' => 'Wyświetl i zaktualizuj swoje ogólne ustawienia i aktywuj licencję',
        'email' => 'E-mail',
        'email_description' => 'Wyświetl i zaktualizuj swoje ustawienia e-mail i szablony e-mail',
        'media' => 'Media',
        'media_description' => 'Wyświetl i zaktualizuj swoje ustawienia mediów',
        'system' => 'System',
        'system_updater' => 'Aktualizator systemu',
        'system_updater_description' => 'Zaktualizuj swój system do najnowszej wersji',
        'others' => 'Inne',
    ],
    'saving' => 'Zapisywanie...',
    'generating_media_thumbnails' => 'Generowanie miniatur mediów...',
    'test_email_template' => 'Testuj szablon e-mail',
    'select_email_template' => 'Wybierz szablon e-mail',
    'enums' => [
        'data_retention_period' => [
            '0' => 'Nigdy',
            '1' => '1 dzień',
            '3' => '3 dni',
            '7' => '1 tydzień',
            '30' => '1 miesiąc',
            '90' => '3 miesiące',
            '180' => '6 miesięcy',
            '365' => '1 rok',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute musi być prawidłowym regionem AWS (np. us-east-1, eu-west-1).',
    ],
];
