<?php

return [
    'title' => 'Настройки',
    'general_setting' => 'General Settings',
    'menu' => 'All Settings',
    'email_setting_title' => 'Настройки электронной почты',
    'email_setting_description' => 'Configure email settings',
    'general' => [
        'theme' => 'Тема',
        'description' => 'Настройка информации о сайте',
        'title' => 'Общие',
        'general_block' => 'Основная информация',
        'rich_editor' => 'Rich Editor',
        'site_title' => 'Название сайта',
        'admin_email' => 'Электронная почта администратора',
        'seo_block' => 'SEO Конфигурация',
        'seo_title' => 'SEO Заголовок',
        'seo_description' => 'SEO Описание',
        'webmaster_tools_block' => 'Инструменты Google для веб-мастеров',
        'google_site_verification' => 'Проверка сайта Google',
        'placeholder' => [
            'site_title' => 'Название сайта (максимум 120 символов)',
            'admin_email' => 'Электронная почта администратора',
            'seo_title' => 'SEO Название (максимум 120 символов)',
            'seo_description' => 'SEO Описание (максимум 120 символов)',
            'google_analytics' => 'Google Analytics',
            'google_site_verification' => 'Google Site Verification',
        ],
        'cache_admin_menu' => 'Кэшировать меню администратора?',
        'enable_send_error_reporting_via_email' => 'Включить отправку отчетов об ошибках по электронной почте?',
        'enable_send_error_reporting_via_email_helper' => 'При включении подробные отчеты об ошибках будут отправляться на адреса электронной почты администратора при возникновении критических ошибок на сайте',
        'time_zone_helper' => 'Выберите часовой пояс для вашего веб-сайта. Это будет использоваться для всех отображений даты и времени во всей системе',
        'time_zone' => 'Часовой пояс',
        'default_admin_theme' => 'Тема администратора по умолчанию',
        'enable_change_admin_theme' => 'Включить смену темы администратора?',
        'enable' => 'Включить',
        'disable' => 'Выключить',
        'enable_cache' => 'Включить кэш?',
        'cache_time' => 'Время кэширования (минуты)',
        'enable_cache_site_map' => 'Включить кеширование карты сайта?',
        'cache_time_site_map' => 'Время кэширования карты сайта (минуты)',
        'admin_logo' => 'Admin logo',
        'admin_favicon' => 'Admin favicon',
        'admin_title' => 'Admin заголовок',
        'admin_title_placeholder' => 'Заголовок отображается на вкладке браузера',
        'cache_block' => 'Кэш',
        'admin_appearance_title' => 'Внешний вид администратора',
        'admin_appearance_description' => 'Настройка внешнего вида администратора, такого как редактор, язык...',
        'seo_block_description' => 'Настройка заголовка сайта, мета-описания сайта, ключевого слова сайта для оптимизации SEO',
        'webmaster_tools_description' => 'Google Webmaster Tools (GWT) это бесплатное программное обеспечение, которое помогает вам управлять технической стороной вашего веб-сайта',
        'cache_description' => 'Конфигурационный кэш для системы для оптимизации скорости',
        'yes' => 'Да',
        'no' => 'Нет',
        'show_on_front' => 'Ваша домашняя страница отображается',
        'select' => '— Выбрать —',
        'show_site_name' => 'Показывать название сайта после заголовка страницы, разделяя "-"?',
        'locale' => 'Язык сайта',
        'locale_direction' => 'Языковое направление передней части сайта',
        'admin_locale_direction' => 'Языковое направление администратора',
        'admin_login_screen_backgrounds' => 'Фон экрана входа в систему (~1366x768)',
        'minutes' => 'минуты',
    ],
    'admin_appearance' => [
        'title' => 'Admin appearance',
        'description' => 'View and update logo, favicon, layout,...',
        'layout' => 'Layout',
        'horizontal' => 'Horizontal',
        'vertical' => 'Vertical',
        'show_menu_item_icon' => 'Show menu item icon',
        'language' => 'Admin panel language',
        'theme_mode' => 'Theme mode',
        'dark' => 'Dark',
        'light' => 'Light',
        'container_width' => [
            'title' => 'Container width',
            'default' => 'Default',
            'large' => 'Large',
            'full' => 'Full',
        ],
        'form' => [
            'admin_logo' => 'Admin logo',
            'admin_logo_max_height' => 'Logo height (px)',
            'admin_logo_max_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
            'admin_favicon' => 'Admin favicon',
            'admin_title' => 'Admin title',
            'admin_title_placeholder' => 'Title to show in browser tab',
            'admin_login_screen_backgrounds' => 'Login screen backgrounds (~1366 x 768)',
            'admin_locale' => 'Admin language',
            'admin_locale_direction' => 'Admin language direction',
            'rich_editor' => 'Rich Editor',
            'show_admin_bar' => 'Show admin bar for logged-in admins, even in the front site',
            'show_guidelines' => 'Show guidelines',
            'primary_font' => 'Primary font',
            'primary_color' => 'Primary color',
            'secondary_color' => 'Secondary color',
            'heading_color' => 'Heading color',
            'text_color' => 'Text color',
            'link_color' => 'Link color',
            'link_hover_color' => 'Link hover color',
            'show_menu_item_icon' => 'Show menu item icon',
            'custom_css' => 'Custom CSS',
            'custom_js' => 'Custom JS',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript in the page header, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript in the page body, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript in the page footer, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Datatables',
        'description' => 'Settings for datatables',
        'form' => [
            'show_column_visibility' => 'Show column visibility by default',
            'show_export_button' => 'Show export button by default',
            'pagination_type' => 'Pagination type',
            'default' => 'Default',
            'dropdown' => 'Dropdown',
        ],
    ],
    'email' => [
        'subject' => 'Тема',
        'content' => 'Содержание',
        'title' => 'Настройка шаблона электронной почты',
        'description' => 'Шаблон электронной почты с использованием HTML и системных переменных.',
        'reset_to_default' => 'Восстановление значений по умолчанию',
        'back' => 'Назад к настройкам',
        'reset_success' => 'Сбросить настройки по умолчанию успешно',
        'confirm_reset' => 'Подтвердить сброс шаблона электронной почты?',
        'confirm_message' => 'Вы действительно хотите сбросить этот шаблон электронной почты по умолчанию?',
        'continue' => 'Продолжить',
        'sender_name' => 'Имя отправителя',
        'sender_name_placeholder' => 'Имя',
        'sender_email' => 'Email отправителя',
        'mailer' => 'Почтовая программа',
        'port' => 'Port',
        'port_placeholder' => 'Ex: 587',
        'host' => 'Host',
        'host_placeholder' => 'Ex: smtp.gmail.com',
        'username' => 'Имя пользователя',
        'username_placeholder' => 'Имя пользователя для входа на почтовый сервер',
        'password' => 'Пароль',
        'password_placeholder' => 'Пароль для входа на почтовый сервер',
        'encryption' => 'Шифрование',
        'queue_warning_title' => 'Требуется Конфигурация Очереди',
        'queue_warning_description' => 'Ваша очередь электронной почты в настоящее время настроена на использование драйвера ":default", но ваш воркер очереди может не работать. Это означает, что электронные письма не будут отправляться, пока вы не настроите воркер очереди.',
        'queue_warning_action' => 'Чтобы отправлять электронные письма немедленно без воркера очереди, установите QUEUE_CONNECTION=sync в вашем .env файле. В противном случае убедитесь, что ваш воркер очереди работает с помощью "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Узнайте больше о Laravel Queues</a>.',
        'mail_gun_domain' => 'Домен',
        'mail_gun_domain_placeholder' => 'Домен',
        'mail_gun_secret' => 'Секрет',
        'mail_gun_secret_placeholder' => 'Секрет',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Endpoint',
        'log_channel' => 'Канал регистрации',
        'sendmail_path' => 'Путь отправки почты',
        'encryption_placeholder' => 'Шифрование: ssl or tls',
        'ses_key' => 'Key',
        'ses_key_placeholder' => 'Key',
        'ses_secret' => 'Секрет',
        'ses_secret_placeholder' => 'Секрет',
        'ses_region' => 'Регион',
        'ses_region_placeholder' => 'Регион',
        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Token',
        'template_title' => 'Шаблоны электронной почты',
        'template_description' => 'Базовые шаблоны для всех электронных писем',
        'template_header' => 'Заголовок шаблона электронной почты',
        'template_header_description' => 'Шаблон для заголовка электронных писем',
        'template_footer' => 'Нижний колонтитул шаблона электронной почты',
        'template_footer_description' => 'Шаблон для нижнего колонтитула электронных писем',
        'default' => 'По умолчанию',
        'using_queue_to_send_mail' => 'Использование задания очереди для отправки электронных писем (сначала необходимо настроить очередь https://laravel.com/docs/queues#supervisor-configuration)',
        'social_links' => [
            'name' => 'Имя',
        ],
    ],
    'media' => [
        'title' => 'Media',
        'driver' => 'Driver',
        'description' => 'Settings for media',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS Default Region',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (Optional)',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces Default Region',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'Is DO Spaces CDN enabled?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN custom domain',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi Default Region',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'default_placeholder_image' => 'Изображение-заполнитель по умолчанию',
        'enable_chunk' => 'Включить загрузку размера блока?',
        'chunk_size' => 'Размер блока (Bytes)',
        'chunk_size_placeholder' => 'Default: 1048576 ~ 1MB',
        'max_file_size' => 'Максимальный размер блока файла (MB)',
        'max_file_size_placeholder' => 'Default: 1048576 ~ 1GB',
        'enable_watermark' => 'Включить водяной знак?',
        'watermark_source' => 'Изображение водяного знака',
        'watermark_size' => 'Размер водяного знака (%)',
        'watermark_size_placeholder' => 'Default: 10 (%)',
        'watermark_opacity' => 'Непрозрачность водяного знака (%)',
        'watermark_opacity_placeholder' => 'Default: 70 (%)',
        'watermark_position' => 'Позиция водяного знака',
        'watermark_position_x' => 'Позиция водяного знака X',
        'watermark_position_y' => 'Позиция водяного знака Y',
        'watermark_position_top_left' => 'С лева вверху',
        'watermark_position_top_right' => 'С права вверху',
        'watermark_position_bottom_left' => 'Нижняя левый',
        'watermark_position_bottom_right' => 'Нижний правый',
        'watermark_position_center' => 'Центр',
        'turn_off_automatic_url_translation_into_latin' => 'Отключить автоматический перевод URL на латиницу?',
        'bunnycdn_hostname' => 'Имя хоста',
        'bunnycdn_zone' => 'Имя зоны (имя вашей области хранения)',
        'bunnycdn_key' => 'Пароль доступа к FTP и API (Пароль доступа к API области хранения)',
        'bunnycdn_region' => 'Регион (регион зоны хранения)',
        'optional' => 'Необязательный',
        'sizes' => 'Размеры миниатюр',
        'media_sizes_helper' => 'Установите ширину или высоту равными 0, если вы просто хотите обрезать по ширине или высоте. Нужно нажать на кнопку "Создать миниатюры", чтобы применить изменения.',
        'width' => 'Ширина',
        'height' => 'Высота',
        'default_size_value' => 'По умолчанию: :size',
        'all' => 'Все',
        'media_folders_can_add_watermark' => 'Добавление водяных знаков для изображений в папках:',
        'max_upload_filesize' => 'Максимальный размер загружаемого файла (МБ)',
        'max_upload_filesize_helper' => 'Ваш сервер позволяет загружать файлы максимального размера :size вы можете изменить это значение, чтобы ограничить размер загружаемого файла.',
        'max_upload_filesize_placeholder' => 'По умолчанию: :size, должен быть меньше :size.',
    ],
    'license' => [
        'purchase_code' => 'Код покупки',
        'buyer' => 'Покупатель',
    ],
    'field_type_not_exists' => 'Этот тип поля не существует',
    'save_settings' => 'Сохранение настроек',
    'template' => 'Template',
    'description' => 'Описание',
    'enable' => 'Включить',
    'send' => 'Отправить',
    'test_email_description' => 'Чтобы отправить тестовое электронное письмо, пожалуйста, убедитесь, что у вас обновлена конфигурация для отправки почты!',
    'test_email_input_placeholder' => 'Введите адрес электронной почты, который вы хотите отправить тестовым письмом.',
    'test_email_modal_title' => 'Отправьте тестовое электронное письмо',
    'test_send_mail' => 'Отправить тестовое письмо',
    'test_email_send_success' => 'Электронное письмо отправлено!',
    'locale_direction_ltr' => 'Слева направо',
    'locale_direction_rtl' => 'Справа налево',
    'emails_warning' => 'Вы можете добавить до :count emails',
    'email_add_more' => 'Добавить больше',
    'generate' => 'Создать',
    'generate_thumbnails' => 'Создание эскизов',
    'generate_thumbnails_success' => 'Создание эскизов успешно. :count файлов генерируются!',
    'generate_thumbnails_error' => 'Мы не можем восстановить миниатюру для этих :count файлов!',
    'generate_thumbnails_description' => 'Вы уверены, что хотите повторно создать миниатюры для всех изображений? Это займет время, поэтому, пожалуйста, НЕ покидайте эту страницу, подождите, пока она не будет завершена.',
    'enable_chunk_description' => 'Загрузка размера фрагмента используется для загрузки файла большого размера..',
    'watermark_description' => 'ПРЕДУПРЕЖДЕНИЕ:Водяной знак просто добавляется к новым загруженным изображениям, он не будет добавлен к существующим изображениям. Отключение водяного знака не удалит водяной знак с существующих изображений.',
    'submit' => 'Submit',
    'back' => 'Back',
    'enter_sample_value' => 'Enter sample values for testing',
    'preview' => 'Preview',
    'media_size_width' => ':size size width must be greater than 0',
    'media_size_height' => ':size size height must be greater than 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob allow you to automate certain commands or scripts on your site.',
        'is_not_ready' => 'To run the cronjob, follow the instructions below.',
        'is_working' => 'Congratulations! Your cronjob is running.',
        'is_not_working' => 'Your cronjob is not running. Please check your server\'s cronjob.',
        'last_checked' => 'Last checked at :time.',
        'copy_button' => 'Copy',
        'setup' => [
            'name' => 'Setting up the Cronjob',
            'connect_to_server' => 'Connect to your server via SSH or any preferred method.',
            'open_crontab' => 'Open the crontab file using a text editor (e.g., `crontab -e`).',
            'add_cronjob' => 'Add the above command to the crontab file and save it.',
            'done' => 'The cronjob will now run at every minute and execute the specified command.',
            'learn_more' => 'You can learn more about cronjob from the Laravel :documentation',
            'documentation' => 'documentation',
            'copied' => 'Copied',
        ],
    ],

    'security' => [
        'title' => 'Настройки безопасности',
        'description' => 'Проверьте и настройте параметры безопасности для вашего сайта.',
        'menu_description' => 'Управление безопасностью cookie и HTTP-заголовками',
        'status_secure' => 'Все настройки безопасности настроены правильно!',
        'status_insecure' => 'Некоторые настройки безопасности требуют внимания!',
        'current_settings' => 'Текущие настройки безопасности',
        'status' => 'Статус',
        'setting' => 'Настройка',
        'current_value' => 'Текущее значение',
        'recommended_value' => 'Рекомендуется',
        'session_http_only' => 'Флаг HttpOnly Cookie',
        'session_http_only_description' => 'Предотвращает доступ JavaScript к сеансовым cookie (защита от XSS-атак)',
        'session_secure_cookie' => 'Флаг Secure Cookie',
        'session_secure_cookie_description' => 'Гарантирует отправку cookie только через HTTPS-соединения',
        'session_same_site' => 'Флаг SameSite Cookie',
        'session_same_site_description' => 'Предотвращает CSRF-атаки, ограничивая отправку cookie',
        'http_security_headers' => 'Заголовки безопасности HTTP',
        'http_security_headers_description' => 'Добавляет заголовки безопасности для защиты от распространенных веб-уязвимостей',
        'https_warning' => 'Ваш сайт не использует HTTPS',
        'https_warning_description' => 'Некоторые функции безопасности, такие как защищенные cookie, требуют HTTPS. Рассмотрите возможность включения SSL для вашего сайта.',
        'how_to_fix' => 'Как исправить проблемы безопасности',
        'env_file_location' => 'Отредактируйте файл .env, расположенный по адресу:',
        'add_to_env' => 'Настройки для добавления',
        'required_settings' => 'Обязательные настройки безопасности',
        'for_https_sites' => 'Только для сайтов HTTPS',
        'copy' => 'Копировать',
        'copy_settings' => 'Копировать все настройки',
        'copied' => 'Скопировано!',
        'steps' => 'Шаги для применения настроек',
        'step_1' => 'Откройте файл .env в текстовом редакторе',
        'step_2' => 'Добавьте или обновите настройки безопасности, показанные выше',
        'step_3' => 'Сохраните файл .env',
        'step_4' => 'Очистите кэш через Панель администратора → Управление платформой → Управление кэшем',
        'security_headers_info' => 'Информация о заголовках безопасности',
        'security_headers_list' => 'При включении к всем ответам добавляются следующие заголовки:',
        'header_nosniff' => 'Предотвращает угадывание типов контента браузерами',
        'header_frame' => 'Защищает от clickjacking-атак',
        'header_xss' => 'Включает защиту XSS браузера',
        'header_referrer' => 'Контролирует объем отправляемой реферальной информации',
        'learn_more' => 'Для получения более подробной информации см. :documentation',
        'documentation' => 'документацию по безопасности',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Configure caching for optimized speed',
        'form' => [
            'cache_admin_menu' => 'Cache admin menu',
            'cache_admin_menu_helper' => 'Cache admin menu for optimized speed. This option should be disabled if you are developing or customizing the admin menu.',
            'enable_cache_site_map' => 'Cache sitemap',
            'enable_cache_site_map_helper' => 'Sitemap :url should be cached due to the large number of pages. If you have a small number of pages, you can disable this option.',
            'cache_time_site_map' => 'Sitemap cache timeout (in minutes)',
            'cache_front_menu' => 'Cache front menu',
            'cache_front_menu_helper' => 'Cache front menu for optimized speed',
            'cache_user_avatar' => 'Cache user avatar',
            'cache_user_avatar_helper' => 'For users without avatar, the system will generate avatars from their usernames. The avatars will be cached for optimized speed and will not be regenerated.',
        ],
    ],
    'appearance' => [
        'title' => 'Appearance',
    ],
    'panel' => [
        'common' => 'Common',
        'general' => 'General',
        'general_description' => 'View and update your general settings and activate license',
        'email' => 'Email',
        'email_description' => 'View and update your email settings and email templates',
        'media' => 'Media',
        'media_description' => 'View and update your media settings',
        'system' => 'System',
        'system_updater' => 'System Updater',
        'system_updater_description' => 'Update your system to the latest version',
        'others' => 'Others',
    ],
    'saving' => 'Сохранение...',
    'generating_media_thumbnails' => 'Generating media thumbnails...',
    'test_email_template' => 'Test email template',
    'select_email_template' => 'Select email template',
    'enums' => [
        'data_retention_period' => [
            'Never',
            '1 Day',
            3 => '3 Days',
            7 => '1 Week',
            30 => '1 Month',
            90 => '3 Months',
            180 => '6 Months',
            365 => '1 Year',
        ],
    ],
];
