<?php

return [
    'title' => 'Nastavenia',
    'general_setting' => 'Všeobecné nastavenia',
    'menu' => 'Všetky nastavenia',
    'email_setting_title' => 'Nastavenia e-mailu',
    'email_setting_description' => 'Konfigurácia nastavení e-mailu',
    'general' => [
        'theme' => 'Téma',
        'title' => 'Všeobecné informácie',
        'description' => 'Zobraziť a aktualizovať informácie o stránke',
        'rich_editor' => 'Rich Editor',
        'site_title' => 'Názov stránky',
        'admin_email' => 'Admin e-mail',
        'seo_block' => 'SEO konfigurácia',
        'seo_title' => 'SEO titulok',
        'seo_description' => 'SEO popis',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Názov stránky (maximum 120 znakov)',
            'admin_email' => 'Admin e-mail',
            'seo_title' => 'SEO titulok (maximum 120 znakov)',
            'seo_description' => 'SEO popis (maximum 120 znakov)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Odosielať hlásenia o chybách e-mailom',
        'enable_send_error_reporting_via_email_helper' => 'Ak je povolené, budú sa podrobné správy o chybách posielať na e-mailové adresy správcu, keď dôjde ku kritickým chybám na stránke',
        'time_zone_helper' => 'Vyberte časové pásmo pre vašu webovú stránku. Toto sa použije pre všetky zobrazenia dátumu a času v celom systéme',
        'time_zone' => 'Časové pásmo',
        'enable' => 'Povoliť',
        'disable' => 'Zakázať',
        'disabled_helper' => 'Túto šablónu e-mailu nie je možné zakázať!',
        'enable_cache_site_map' => 'Povoliť cachovanie sitemapy',
        'cache_time_site_map' => 'Časový limit cache sitemapy (v minútach)',
        'admin_logo' => 'Admin logo',
        'admin_favicon' => 'Admin favicon',
        'admin_title' => 'Admin titulok',
        'admin_title_placeholder' => 'Titulok na zobrazenie v záložke prehliadača',
        'admin_appearance_title' => 'Vzhľad administrácie',
        'admin_appearance_description' => 'Nastavenie vzhľadu administrácie ako je editor, jazyk...',
        'seo_block_description' => 'Nastavenie titulku stránky, meta popisu, kľúčových slov pre optimalizáciu SEO',
        'webmaster_tools_description' => 'Google Search Console je bezplatný webový nástroj poskytovaný spoločnosťou Google, ktorý pomáha vlastníkom webových stránok monitorovať výkon ich stránky vo výsledkoch vyhľadávania Google.',
        'yes' => 'Áno',
        'no' => 'Nie',
        'show_on_front' => 'Vaša domovská stránka zobrazuje',
        'select' => '— Vybrať —',
        'show_site_name' => 'Zobraziť názov stránky za titulkom stránky, oddelený "-"',
        'locale' => 'Jazyk stránky',
        'locale_direction' => 'Smer jazyka stránky',
        'minutes' => 'minúty',
        'redirect_404_to_homepage' => 'Presmerovať všetky požiadavky Not Found na domovskú stránku',
    ],
    'admin_appearance' => [
        'title' => 'Vzhľad administrácie',
        'description' => 'Zobraziť a aktualizovať logo, favicon, rozloženie,...',
        'layout' => 'Rozloženie',
        'horizontal' => 'Horizontálne',
        'vertical' => 'Vertikálne',
        'show_menu_item_icon' => 'Zobraziť ikonu položky menu',
        'language' => 'Jazyk administračného panela',
        'theme_mode' => 'Režim témy',
        'dark' => 'Tmavý',
        'light' => 'Svetlý',
        'container_width' => [
            'title' => 'Šírka kontajnera',
            'default' => 'Predvolený',
            'large' => 'Veľký',
            'full' => 'Plný',
        ],
        'form' => [
            'admin_logo' => 'Admin logo',
            'admin_logo_max_height' => 'Výška loga (px)',
            'admin_logo_max_height_helper' => 'Nastaviť výšku loga v pixeloch. Predvolená hodnota je :default.',
            'admin_favicon' => 'Admin favicon',
            'admin_favicon_type' => 'Typ admin favicon',
            'admin_title' => 'Admin titulok',
            'admin_title_placeholder' => 'Titulok na zobrazenie v záložke prehliadača',
            'admin_login_screen_backgrounds' => 'Pozadia prihlasovacej obrazovky (~1366 x 768)',
            'admin_locale' => 'Jazyk administrácie',
            'admin_locale_direction' => 'Smer jazyka administrácie',
            'rich_editor' => 'Rich Editor',
            'show_admin_bar' => 'Zobraziť admin panel pre prihlásených administrátorov aj na stránke',
            'show_guidelines' => 'Zobraziť pokyny',
            'primary_font' => 'Primárne písmo',
            'primary_color' => 'Primárna farba',
            'secondary_color' => 'Sekundárna farba',
            'heading_color' => 'Farba nadpisov',
            'text_color' => 'Farba textu',
            'link_color' => 'Farba odkazov',
            'link_hover_color' => 'Farba odkazu pri nabehnutí myšou',
            'show_menu_item_icon' => 'Zobraziť ikonu položky menu',
            'custom_css' => 'Vlastné CSS',
            'custom_js' => 'Vlastné JS',
            'custom_header_js' => 'Hlavičkové JS',
            'custom_header_js_placeholder' => 'JavaScript v hlavičke stránky, obaľte ho do &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript v tele stránky, obaľte ho do &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Pätkové JS',
            'custom_footer_js_placeholder' => 'JavaScript v pätke stránky, obaľte ho do &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Dátové tabuľky',
        'description' => 'Nastavenia pre dátové tabuľky',
        'form' => [
            'show_column_visibility' => 'Zobraziť viditeľnosť stĺpcov predvolene',
            'show_column_visibility_helper' => 'Povoliť tlačidlo prepínača viditeľnosti stĺpcov v dátových tabuľkách, aby používatelia mohli zobrazovať/skrývať stĺpce',
            'show_export_button' => 'Zobraziť tlačidlo exportu predvolene',
            'show_export_button_helper' => 'Zobraziť možnosti exportu (CSV, Excel, PDF) v dátových tabuľkách na stiahnutie údajov z tabuľky',
            'pagination_type' => 'Typ stránkovania',
            'pagination_type_helper' => 'Vyberte, ako sa zobrazujú ovládacie prvky stránkovania: Predvolené zobrazuje čísla strán, Rozbaľovacia ponuka zobrazuje kompaktný výber rozbaľovacej ponuky',
            'default' => 'Predvolený',
            'dropdown' => 'Rozbaľovacia ponuka',
            'enable_responsive' => 'Povoliť responzívnu tabuľku',
            'enable_responsive_helper' => 'Automaticky prispôsobiť stĺpce tabuľky rôznym veľkostiam obrazoviek pre lepší mobilný zážitok',
        ],
    ],
    'email' => [
        'subject' => 'Predmet',
        'content' => 'Obsah',
        'title' => 'Nastavenie pre šablónu e-mailu',
        'description' => 'Šablóna e-mailu používajúca HTML a systémové premenné.',
        'reset_to_default' => 'Obnoviť na predvolené',
        'back' => 'Späť do nastavení',
        'reset_success' => 'Úspešne obnovené na predvolené',
        'confirm_reset' => 'Potvrdiť obnovenie šablóny e-mailu?',
        'confirm_message' => 'Naozaj chcete obnoviť túto šablónu e-mailu na predvolené?',
        'continue' => 'Pokračovať',
        'sender_name' => 'Meno odosielateľa',
        'sender_name_placeholder' => 'Meno',
        'sender_name_helper' => 'Meno, ktoré sa zobrazí v poli Od e-mailov odoslaných systémom',
        'sender_email' => 'E-mail odosielateľa',
        'sender_email_placeholder' => 'E-mailová adresa (napr. :default)',
        'sender_email_helper' => 'E-mailová adresa, ktorá bude použitá ako odosielateľ pre všetky e-maily odoslané systémom',
        'mailer' => 'Mailer',
        'port' => 'Port',
        'port_placeholder' => 'Napr.: 587',
        'port_helper' => 'Port používaný vaším poštovým serverom (bežné porty: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Napr.: smtp.gmail.com',
        'host_helper' => 'SMTP adresa hosta',
        'username' => 'Používateľské meno',
        'username_placeholder' => 'Používateľské meno na prihlásenie na poštový server',
        'username_helper' => 'Vaše prihlasovacie meno poštového servera',
        'password' => 'Heslo',
        'password_placeholder' => 'Heslo na prihlásenie na poštový server',
        'password_helper' => 'Vaše prihlasovacie heslo poštového servera',
        'encryption' => 'Šifrovanie',
        'encryption_placeholder' => 'Vyberte typ šifrovania',
        'encryption_helper' => 'Vyberte metódu šifrovania pre bezpečný prenos e-mailov',
        'encryption_none' => 'Žiadne',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Tipy na nastavenie e-mailu',
        'setup_tip_gmail' => 'Pre Gmail: Použite smtp.gmail.com ako host, port 587 s TLS alebo port 465 s SSL. Povoľte "Prístup menej bezpečných aplikácií" alebo použite heslo aplikácie.',
        'setup_tip_port' => 'Bežné porty: 25 (nešifrované), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternatívny).',
        'setup_tip_encryption' => 'Použite TLS pre port 587 (odporúčané), SSL pre port 465 alebo Žiadne pre port 25 (neodporúča sa pre produkciu).',
        'setup_tip_test' => 'Vždy použite tlačidlo "Odoslať testovací e-mail" na overenie vašej konfigurácie pred uložením.',
        'setup_tip_mailgun' => 'Pre lepšie doručovanie zvážte použitie e-mailových služieb ako Mailgun, SendGrid alebo Amazon SES namiesto SMTP.',
        'queue_warning_title' => 'Vyžaduje sa konfigurácia fronty',
        'queue_warning_description' => 'Vaša e-mailová fronta je momentálne nakonfigurovaná na použitie ovládača ":default", ale váš pracovník fronty nemusí bežať. To znamená, že e-maily nebudú odoslané, kým nenastavíte pracovníka fronty.',
        'queue_warning_action' => 'Na okamžité odosielanie e-mailov bez pracovníka fronty nastavte QUEUE_CONNECTION=sync v súbore .env. V opačnom prípade sa uistite, že váš pracovník fronty beží pomocou "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Zistite viac o Laravel Queues</a>.',
        'mail_gun_domain' => 'Doména',
        'mail_gun_domain_placeholder' => 'Napr.: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Názov domény, ktorú ste zaregistrovali v Mailgun',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => 'Napr.: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Váš API klúč Mailgun',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Napr.: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API endpoint (api.mailgun.net pre USA, api.eu.mailgun.net pre EÚ)',
        'log_channel' => 'Log kanál',
        'log_channel_helper' => 'Vyberte, ktorý kanál logovania použiť pre e-mailové logy',
        'sendmail_path' => 'Cesta k Sendmail',
        'local_domain' => 'Lokálna doména',
        'local_domain_placeholder' => 'Môže byť prázdne. Je potrebné nastaviť na vašu doménu pri použití SMTP Relay. Napr. vasa-domena.com',
        'local_domain_helper' => 'Doména, ktorá bude použitá na identifikáciu servera pri komunikácii so vzdialenými SMTP servermi',

        'ses_key' => 'Klúč',
        'ses_key_placeholder' => 'Napr.: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Váš AWS prístupový kľúč ID',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => 'Napr.: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Váš AWS tajný prístupový klúč',
        'ses_region' => 'Región',
        'ses_region_placeholder' => 'Napr.: us-east-1',
        'ses_region_helper' => 'AWS región, kde je nakonfigurovaná vaša služba SES',

        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Napr.: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Váš Postmark server token',

        'resend_key' => 'API klúč',
        'resend_key_placeholder' => 'Napr.: re_123456789012345678901234567890',
        'resend_key_helper' => 'Váš Resend API klúč',

        'email_templates' => 'Šablóny e-mailov',
        'email_templates_description' => 'Šablóny e-mailov používajúce HTML a systémové premenné.',
        'email_template_settings' => 'Nastavenia šablón e-mailov',
        'email_template_settings_description' => 'Zobraziť a aktualizovať nastavenia šablón e-mailov',
        'email_rules' => 'Pravidlá e-mailov',
        'email_rules_description' => 'Konfigurácia pravidiel e-mailov pre validáciu',
        'base_template' => 'Základná šablóna',
        'base_template_description' => 'Základná šablóna pre všetky e-maily',
        'template_header' => 'Hlavička šablóny e-mailu',
        'template_header_description' => 'Šablóna pre hlavičku e-mailov',
        'template_footer' => 'Pätka šablóny e-mailu',
        'template_footer_description' => 'Šablóna pre pätku e-mailov',
        'default' => 'Predvolené',
        'template_off_status_helper' => 'Táto šablóna e-mailu je vypnutá.',
        'blacklist_email_domains' => 'Zakázané e-mailové domény',
        'blacklist_email_domains_helper' => 'Zadajte zoznam e-mailových domén, ktoré majú byť na čiernej listine. Napr. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Zakázané e-mailové adresy',
        'blacklist_specified_emails_helper' => 'Zadajte zoznam konkrétnych e-mailových adries, ktoré majú byť na čiernej listine. Napr. mail@example.com.',
        'exception_emails' => 'E-maily výnimiek',
        'exception_emails_helper' => 'Tieto e-maily budú vylúčené z validačných pravidiel.',
        'email_rules_strict' => 'Prísna validácia e-mailov',
        'email_rules_strict_helper' => 'Vykonávať validáciu e-mailov podobnú RFC s prísnymi pravidlami.',
        'email_rules_dns' => 'Validácia DNS kontroly',
        'email_rules_dns_helper' => 'Skontrolovať, či existujú DNS záznamy naznačujúce, že server prijíma e-maily.',
        'email_rules_spoof' => 'Detekcia podvrhnutia',
        'email_rules_spoof_helper' => 'Zistiť potenciálne pokusy o podvrhnutie e-mailu.',
        'template_turn_off' => 'Kliknite pre vypnutie tejto šablóny e-mailu',
        'template_turn_on' => 'Kliknite pre zapnutie tejto šablóny e-mailu',
        'turn_on_success_message' => 'Šablóna e-mailu bola úspešne zapnutá!',
        'turn_off_success_message' => 'Šablóna e-mailu bola úspešne vypnutá!',
        'email_template_status' => 'Stav šablóny e-mailu',
        'email_template_status_description' => 'Zapnúť/vypnúť šablónu e-mailu',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Ak nie je nastavené, použije sa z admin loga v Admin -> Nastavenia -> Vzhľad administrácie -> Logo.',
        'email_template_copyright_text_helper_text' => 'Ak nie je nastavené, použije sa z možností témy autorské práva v Admin -> Vzhľad -> Možnosti témy -> Všeobecné -> Autorské práva.',
        'email_template_email_contact' => 'Kontaktná e-mailová adresa',
        'email_template_email_contact_helper_text' => 'Ak nie je nastavená, použije sa z e-mailu odosielateľa v Admin -> Nastavenia -> E-mail',
        'email_template_social_links' => 'Sociálne odkazy',
        'email_template_copyright_text' => 'Autorské práva',
        'image_upload_supported' => 'Podporuje iba formáty PNG, JPG, JPEG a GIF.',
        'email_template_custom_css' => 'Vlastné CSS šablóny e-mailu',
        'social_links' => [
            'name' => 'Názov',
            'icon' => 'Ikona',
            'icon_image' => 'Obrázok ikony (Podporuje iba formáty PNG, JPG, JPEG a GIF.)',
            'url' => 'URL',
            'image' => 'Obrázok',
        ],
    ],
    'media' => [
        'title' => 'Médiá',
        'driver' => 'Ovládač',
        'description' => 'Nastavenia pre médiá',
        'local_disk' => 'Lokálny disk',
        'aws_access_key_id' => 'AWS prístupový kľúč ID',
        'aws_secret_key' => 'AWS tajný klúč',
        'aws_default_region' => 'AWS predvolený región',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (Voliteľné)',
        'use_path_style_endpoint' => 'Použiť endpoint v štýle cesty',
        'r2_access_key_id' => 'R2 prístupový kľúč ID',
        'r2_secret_key' => 'R2 tajný klúč',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces prístupový kľúč ID',
        'do_spaces_secret_key' => 'DO Spaces tajný klúč',
        'do_spaces_default_region' => 'DO Spaces predvolený región',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'Je DO Spaces CDN povolené?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN vlastná doména',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://vasa-vlastna-domena.com',
        'wasabi_access_key_id' => 'Wasabi prístupový kľúč ID',
        'wasabi_secret_key' => 'Wasabi tajný klúč',
        'wasabi_default_region' => 'Wasabi predvolený región',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'Na opätovné použitie existujúcich obrázkov jednoducho určte koreň Wasabi ako "/", potom nahrajte všetky aktuálne súbory z public/storage do vášho koreňového adresára Wasabi.',
        'backblaze_access_key_id' => 'Backblaze prístupový kľúč ID',
        'backblaze_secret_key' => 'Backblaze tajný klúč',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze predvolený región',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Je Backblaze CDN povolené?',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN vlastná doména',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://vasa-vlastna-domena.com',
        'default_placeholder_image' => 'Predvolený zástupný obrázok',
        'enable_chunk' => 'Povoliť nahrávanie po častiach',
        'chunk_size' => 'Veľkosť časti (Bytes)',
        'chunk_size_placeholder' => 'Predvolené: 1048576 ~ 1MB',
        'max_file_size' => 'Maximálna veľkosť súboru časti (MB)',
        'max_file_size_placeholder' => 'Predvolené: 1048576 ~ 1GB',
        'enable_watermark' => 'Povoliť vodoznak',
        'watermark_source' => 'Obrázok vodoznaku',
        'watermark_source_helper' => 'Podporuje iba formáty PNG, JPG a JPEG. Mali by ste použiť obrázok menší ako 200x200px a veľkosť menšiu ako 50KB.',
        'watermark_size' => 'Veľkosť vodoznaku (%)',
        'watermark_size_placeholder' => 'Predvolené: 10 (%)',
        'watermark_opacity' => 'Priehľadnosť vodoznaku (%)',
        'watermark_opacity_placeholder' => 'Predvolené: 70 (%)',
        'watermark_position' => 'Pozícia vodoznaku',
        'watermark_position_x' => 'Pozícia vodoznaku X',
        'watermark_position_y' => 'Pozícia vodoznaku Y',
        'watermark_position_top_left' => 'Vľavo hore',
        'watermark_position_top_right' => 'Vpravo hore',
        'watermark_position_bottom_left' => 'Vľavo dole',
        'watermark_position_bottom_right' => 'Vpravo dole',
        'watermark_position_center' => 'Stred',
        'turn_off_automatic_url_translation_into_latin' => 'Vypnúť automatický preklad URL do latinky',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Názov zóny (Názov vašej úložnej zóny)',
        'bunnycdn_key' => 'FTP & API prístupové heslo (Heslo API prístupu úložnej zóny)',
        'bunnycdn_region' => 'Región (Región úložnej zóny)',
        'optional' => 'Voliteľné',
        'sizes' => 'Veľkosti miniatúr médií',
        'media_sizes_helper' => 'Nastavte šírku alebo výšku na 0, ak chcete orezať len podľa šírky alebo výšky.',
        'width' => 'Šírka',
        'height' => 'Výška',
        'default_size_value' => 'Predvolené: :size',
        'all' => 'Všetko',
        'all_helper_text' => 'Ak zrušíte začiarknutie všetkých priečinkov, bude to platiť pre všetky priečinky.',
        'media_folders_can_add_watermark' => 'Pridať vodoznak pre obrázky v priečinkoch:',
        'max_upload_filesize' => 'Maximálna veľkosť nahraného súboru (MB)',
        'max_upload_filesize_placeholder' => 'Predvolené: :size, musí byť menej ako :size.',
        'max_upload_filesize_helper' => 'Váš server umožňuje nahrávať súbory maximálne :size, môžete zmeniť túto hodnotu na obmedzenie veľkosti nahraných súborov.',
        'image_processing_library' => 'Knižnica na spracovanie obrázkov',
        'use_original_name_for_file_path' => 'Použiť pôvodný názov pre cestu k súboru',
        'keep_original_file_size_and_quality' => 'Zachovať pôvodnú veľkosť a kvalitu súboru',
        'update_thumbnail_sizes_warning' => 'Po úprave veľkostí miniatúr musíte kliknúť na tlačidlo ":button_text" pre ich obnovenie.',
        'thumbnail_crop_position' => 'Pozícia orezania miniatúry',
        'thumbnail_crop_position_left' => 'Vľavo',
        'thumbnail_crop_position_center' => 'Stred',
        'thumbnail_crop_position_right' => 'Vpravo',
        'thumbnail_crop_position_top' => 'Hore',
        'thumbnail_crop_position_bottom' => 'Dole',
        'thumbnail_crop_position_helper' => 'Toto nastavenie sa používa na orezanie obrázka pri generovaní miniatúr. Bude orezaný z tejto pozície, kým sa obrázok nevyplní.',
        'user_can_only_view_own_media' => 'Používatelia môžu vidieť len svoje vlastné médiá',
        'user_can_only_view_own_media_helper' => 'Keď je povolené, používatelia môžu vidieť len svoje vlastné médiá, zatiaľ čo super administrátori môžu vidieť všetky médiá.',
        'enable_thumbnail_sizes' => 'Povoliť veľkosti miniatúr',
        'enable_thumbnail_sizes_helper' => 'Povoliť túto možnosť na generovanie miniatúr pre obrázky. Ak je zakázaná, systém negeneruje miniatúry pre obrázky a vždy používa obrázok v plnej veľkosti.',
        'convert_image_to_webp' => 'Konvertovať JPG, JPEG, PNG obrázok na WebP',
        'convert_image_to_webp_helper' => 'WebP je moderný formát obrázka, ktorý poskytuje vynikajúcu bezstratovú a stratovú kompresiu pre obrázky na webe. Je podporovaný v Chrome, Firefox, Edge a Opera. Obrázok bude konvertovaný do formátu WebP pri nahrávaní. Platí len pre obrázky JPG, JPEG, PNG.',
        'reduce_large_image_size' => 'Zmenšiť veľkosť veľkých obrázkov pri nahrávaní',
        'reduce_large_image_size_helper' => 'Keď je povolené, systém zmenší veľkosť veľkých obrázkov pri nahrávaní, platí pre obrázky JPG, JPEG, PNG, WebP. Maximálna šírka a výška obrázka sa zmení na hodnoty, ktoré nastavíte nižšie.',
        'image_max_width' => 'Maximálna šírka obrázka (px)',
        'image_max_height' => 'Maximálna výška obrázka (px)',
        'image_max_width_placeholder' => 'Nechajte prázdne pre zachovanie pôvodnej šírky',
        'image_max_height_placeholder' => 'Nechajte prázdne pre zachovanie pôvodnej výšky',
        'image_max_width_helper' => 'Nastavte maximálnu šírku obrázka v pixeloch. Pôvodná šírka bude zachovaná, ak je toto pole prázdne.',
        'image_max_height_helper' => 'Nastavte maximálnu výšku obrázka v pixeloch. Pôvodná výška bude zachovaná, ak je toto pole prázdne.',
        'customize_upload_path' => 'Prispôsobiť cestu nahrávania',
        'customize_upload_path_helper' => 'Prispôsobiť cestu nahrávania pre mediálne súbory. Predvolene systém nahrá súbory do priečinka ":path".',
        'upload_path' => 'Cesta nahrávania',
        'upload_path_placeholder' => 'Príklad: uploads',
        'upload_path_helper' => 'Tento priečinok bude vytvorený v /public. Predvolený priečinok je ":folder". Potom sa nahrá do "/public/:folder".',
        'upload_path_warning' => 'Systém nepresunie existujúce súbory do nového priečinka. Ak chcete presunúť existujúce súbory do nového priečinka, musíte to urobiť manuálne.',
        'convert_file_name_to_uuid' => 'Konvertovať názov súboru na UUID',
        'convert_file_name_to_uuid_helper' => 'Keď je povolené, systém skonvertuje názov súboru na UUID pri nahrávaní. Je to užitočné na zabránenie duplicitných názvov súborov a lepšiu bezpečnosť.',
        's3_path' => 'Vlastná S3 cesta (Voliteľné)',
        's3_path_placeholder' => 'Voliteľná vlastná cesta v S3 buckete (napr. uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'Kód nákupu',
        'buyer' => 'Kupujúci',
    ],
    'field_type_not_exists' => 'Tento typ poľa neexistuje',
    'save_settings' => 'Uložiť nastavenia',
    'template' => 'Šablóna',
    'description' => 'Popis',
    'enable' => 'Povoliť',
    'send' => 'Odoslať',
    'test_email_description' => 'Na odoslanie testovacieho e-mailu sa uistite, že ste aktualizovali konfigurácie pre odosielanie e-mailov!',
    'test_email_input_placeholder' => 'Zadajte e-mailovú adresu, na ktorú chcete odoslať testovací e-mail.',
    'test_email_modal_title' => 'Odoslať testovací e-mail',
    'test_send_mail' => 'Odoslať testovací e-mail',
    'test_email_send_success' => 'E-mail bol úspešne odoslaný!',
    'locale_direction_ltr' => 'Zľava doprava',
    'locale_direction_rtl' => 'Sprava doľava',
    'emails_warning' => 'Môžete pridať maximálne :count e-mailov',
    'email_add_more' => 'Pridať ďalší',
    'generate' => 'Generovať',
    'generate_thumbnails' => 'Generovať miniatúry',
    'generate_thumbnails_success' => 'Miniatúry boli úspešne vygenerované. :count súborov bolo vygenerovaných!',
    'generate_thumbnails_error' => 'Nepodarilo sa nám regenerovať miniatúry pre :count súborov!',
    'generate_thumbnails_description' => 'Ste si istí, že chcete regenerovať miniatúry pre všetky obrázky? Môže to nejaký čas trvať. Neodchádzajte z tejto stránky, kým sa proces nedokončí.',
    'enable_chunk_description' => 'Nahrávanie po častiach sa používa na nahrávanie veľkých súborov.',
    'watermark_description' => 'UPOZORNENIE: Vodoznak je pridaný len k novo nahratým obrázkom, nebude pridaný k existujúcim obrázkom. Zakázanie vodoznaku neodstráni vodoznak z existujúcich obrázkov.',
    'submit' => 'Odoslať',
    'back' => 'Späť',
    'enter_sample_value' => 'Zadajte vzorové hodnoty na testovanie',
    'preview' => 'Náhľad',
    'media_size_width' => ':size veľkosť šírky musí byť väčšia ako 0',
    'media_size_height' => ':size veľkosť výšky musí byť väčšia ako 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob vám umožňuje automatizovať určité príkazy alebo skripty na vašej stránke.',
        'is_not_ready' => 'Ak chcete spustiť cronjob, postupujte podľa nasledujúcich pokynov.',
        'is_working' => 'Gratulujeme! Váš cronjob beží.',
        'is_not_working' => 'Váš cronjob nebeží. Skontrolujte prosím cronjob vášho servera.',
        'last_checked' => 'Naposledy skontrolované o :time.',
        'copy_button' => 'Kopírovať',
        'setup' => [
            'name' => 'Nastavenie Cronjob',
            'connect_to_server' => 'Pripojte sa k svojmu serveru cez SSH alebo akoukoľvek uprednostňovanou metódou.',
            'open_crontab' => 'Otvorte súbor crontab pomocou textového editora (napr. `crontab -e`).',
            'add_cronjob' => 'Pridajte vyššie uvedený príkaz do súboru crontab a uložte ho.',
            'done' => 'Cronjob sa teraz spustí každú minútu a vykoná zadaný príkaz.',
            'learn_more' => 'Môžete sa dozvedieť viac o cronjob z Laravel :documentation',
            'documentation' => 'dokumentácie',
            'copied' => 'Skopírované',
        ],
    ],
    'security' => [
        'title' => 'Nastavenia zabezpečenia',
        'description' => 'Skontrolovať a nakonfigurovať nastavenia zabezpečenia pre vašu webovú stránku.',
        'menu_description' => 'Spravovať zabezpečenie cookies a HTTP hlavičky',
        'status_secure' => 'Všetky nastavenia zabezpečenia sú správne nakonfigurované!',
        'status_insecure' => 'Niektoré nastavenia zabezpečenia potrebujú pozornosť!',
        'current_settings' => 'Aktuálne nastavenia zabezpečenia',
        'status' => 'Stav',
        'setting' => 'Nastavenie',
        'current_value' => 'Aktuálna hodnota',
        'recommended_value' => 'Odporúčané',
        'session_http_only' => 'HttpOnly Cookie príznak',
        'session_http_only_description' => 'Zabraňuje JavaScriptu prístup k session cookies (chráni proti XSS útokom)',
        'session_secure_cookie' => 'Secure Cookie príznak',
        'session_secure_cookie_description' => 'Zabezpečuje, že cookies sú odosielané len cez HTTPS pripojenie',
        'session_same_site' => 'SameSite Cookie príznak',
        'session_same_site_description' => 'Zabraňuje CSRF útokom obmedzením, kedy sa cookies odosielajú',
        'http_security_headers' => 'HTTP bezpečnostné hlavičky',
        'http_security_headers_description' => 'Pridáva bezpečnostné hlavičky na ochranu proti bežným webovým zraniteľnostiam',
        'https_warning' => 'Vaša stránka nepoužíva HTTPS',
        'https_warning_description' => 'Niektoré bezpečnostné funkcie ako bezpečné cookies vyžadujú HTTPS. Zvážte povolenie SSL pre vašu webovú stránku.',
        'how_to_fix' => 'Ako opraviť bezpečnostné problémy',
        'env_file_location' => 'Upravte váš .env súbor umiestnený na:',
        'add_to_env' => 'Nastavenia na pridanie',
        'required_settings' => 'Požadované nastavenia zabezpečenia',
        'for_https_sites' => 'Len pre HTTPS stránky',
        'copy' => 'Kopírovať',
        'copy_settings' => 'Kopírovať všetky nastavenia',
        'copied' => 'Skopírované!',
        'steps' => 'Kroky na použitie nastavení',
        'step_1' => 'Otvorte váš .env súbor v textovom editore',
        'step_2' => 'Pridajte alebo aktualizujte bezpečnostné nastavenia zobrazené vyššie',
        'step_3' => 'Uložte .env súbor',
        'step_4' => 'Vyčistite cache pomocou Admin Panel → Správa platformy → Správa cache',
        'security_headers_info' => 'Informácie o bezpečnostných hlavičkách',
        'security_headers_list' => 'Keď je povolené, nasledujúce hlavičky sú pridané ku všetkým odpovediam:',
        'header_nosniff' => 'Zabraňuje prehliadačom hádať typy obsahu',
        'header_frame' => 'Chráni proti clickjacking útokom',
        'header_xss' => 'Povoľuje XSS ochranu prehliadača',
        'header_referrer' => 'Kontroluje, koľko informácií o odkazovači sa odosiela',
        'learn_more' => 'Pre podrobnejšie informácie pozrite :documentation',
        'documentation' => 'dokumentáciu zabezpečenia',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Konfigurácia cachovania pre optimalizovanú rýchlosť',
        'form' => [
            'cache_admin_menu' => 'Cachovať admin menu',
            'cache_admin_menu_helper' => 'Cachovať admin menu pre optimalizovanú rýchlosť. Táto možnosť by mala byť zakázaná, ak vyvíjate alebo prispôsobujete admin menu.',
            'enable_cache_site_map' => 'Cachovať sitemapu',
            'enable_cache_site_map_helper' => 'Sitemapa :url by mala byť cachovaná kvôli veľkému počtu stránok. Ak máte malý počet stránok, môžete túto možnosť zakázať.',
            'cache_time_site_map' => 'Časový limit cache sitemapy (v minútach)',
            'cache_front_menu' => 'Cachovať frontové menu',
            'cache_front_menu_helper' => 'Cachovať frontové menu pre optimalizovanú rýchlosť',
            'cache_user_avatar' => 'Cachovať avatary používateľov',
            'cache_user_avatar_helper' => 'Pre používateľov bez avatara systém generuje avatary z ich používateľských mien. Avatary budú cachované pre optimalizovanú rýchlosť a nebudú regenerované.',
            'shortcode_cache_enabled' => 'Cachovať shortcodes (UI bloky)',
            'shortcode_cache_enabled_helper' => 'Povoliť cachovanie pre shortcodes na zlepšenie výkonu. Keď je povolené, shortcodes budú cachované, aby sa znížil čas vykresľovania.',
            'shortcode_cache_warning' => '<strong>⚠️ Dôležité upozornenie:</strong><br>• Shortcodes obsahujúce formuláre (kontaktné formuláre, prihlásenie k odberu noviniek atď.) automaticky obídu cachovanie, aby sa zachovala funkčnosť.<br>• Shortcodes s dynamickým JavaScript obsahom by mali mať cachovanie zakázané manuálne.<br>• Na zakázanie cachovania pre konkrétne shortcodes pridajte <code>Enable caching: No</code> do konfigurácie shortcode.<br>• Formuláre s CSRF tokenmi, reCAPTCHA alebo inými dynamickými prvkami sú automaticky detekované a vylúčené z cachovania.',
            'shortcode_cache_ttl' => 'Trvanie cache (sekundy)',
            'shortcode_cache_ttl_helper' => 'Trvanie cachovania všetkých shortcodes. Predvolená hodnota je 1800 sekúnd (30 minút).',
            'widget_cache_enabled' => 'Cachovať widgety',
            'widget_cache_enabled_helper' => 'Povoliť cachovanie pre widgety na zlepšenie výkonu. Keď je povolené, widgety budú cachované, aby sa znížil čas vykresľovania.',
            'widget_cache_warning' => '<strong>⚠️ Dôležité upozornenie:</strong><br>• Widgety obsahujúce formuláre (kontaktné formuláre, prihlásenie k odberu noviniek atď.) automaticky obídu cachovanie, aby sa zachovala funkčnosť.<br>• Widgety s dynamickým JavaScript obsahom by mali mať cachovanie zakázané manuálne.<br>• Na zakázanie cachovania pre konkrétne widgety nastavte <code>Enable caching: No</code> v konfigurácii widgetu.<br>• Formuláre s CSRF tokenmi, reCAPTCHA alebo inými dynamickými prvkami sú automaticky detekované a vylúčené z cachovania.',
            'widget_cache_ttl' => 'Trvanie cache (sekundy)',
            'widget_cache_ttl_helper' => 'Trvanie cachovania všetkých widgetov. Predvolená hodnota je 1800 sekúnd (30 minút).',
            'plugin_cache_enabled' => 'Cachovať nainštalované pluginy',
            'plugin_cache_enabled_helper' => 'Cachovať zoznam nainštalovaných pluginov pre zlepšený výkon. Keď je povolené, systém bude cachovať zoznam pluginov na 30 minút, aby sa znížili skenovania súborového systému.',
        ],
    ],
    'appearance' => [
        'title' => 'Vzhľad',
    ],
    'panel' => [
        'common' => 'Bežné',
        'general' => 'Všeobecné',
        'general_description' => 'Zobraziť a aktualizovať vaše všeobecné nastavenia a aktivovať licenciu',
        'email' => 'E-mail',
        'email_description' => 'Zobraziť a aktualizovať vaše nastavenia e-mailu a šablóny e-mailov',
        'media' => 'Médiá',
        'media_description' => 'Zobraziť a aktualizovať vaše nastavenia médií',
        'system' => 'Systém',
        'system_updater' => 'Aktualizátor systému',
        'system_updater_description' => 'Aktualizovať váš systém na najnovšiu verziu',
        'others' => 'Ostatné',
    ],
    'saving' => 'Ukladá sa...',
    'generating_media_thumbnails' => 'Generovanie miniatúr médií...',
    'test_email_template' => 'Testovacia šablóna e-mailu',
    'select_email_template' => 'Vybrať šablónu e-mailu',
    'enums' => [
        'data_retention_period' => [
            '0' => 'Nikdy',
            '1' => '1 deň',
            '3' => '3 dni',
            '7' => '1 týždeň',
            '30' => '1 mesiac',
            '90' => '3 mesiace',
            '180' => '6 mesiacov',
            '365' => '1 rok',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute musí byť platný AWS región (napr. us-east-1, eu-west-1).',
    ],
];
