<?php

return [
    'title' => 'Подешавања',
    'general_setting' => 'Општа подешавања',
    'menu' => 'Сва подешавања',
    'email_setting_title' => 'Подешавања е-поште',
    'email_setting_description' => 'Конфигуришите подешавања е-поште',
    'general' => [
        'theme' => 'Тема',
        'title' => 'Опште информације',
        'description' => 'Прегледајте и ажурирајте информације о сајту',
        'rich_editor' => 'Напредни уређивач',
        'site_title' => 'Наслов сајта',
        'admin_email' => 'Администраторска е-пошта',
        'seo_block' => 'SEO конфигурација',
        'seo_title' => 'SEO наслов',
        'seo_description' => 'SEO опис',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Наслов сајта (максимум 120 карактера)',
            'admin_email' => 'Администраторска е-пошта',
            'seo_title' => 'SEO наслов (максимум 120 карактера)',
            'seo_description' => 'SEO опис (максимум 120 карактера)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Шаљите извештаје о грешкама путем е-поште',
        'enable_send_error_reporting_via_email_helper' => 'Kada je omogućeno, detaljni izveštaji o greškama će biti poslati na imejl adrese administratora kada se dogode kritične greške na sajtu',
        'time_zone_helper' => 'Izaberite vremensku zonu za vašu veb lokaciju. Ovo će se koristiti za sva prikazivanja datuma i vremena u celom sistemu',
        'time_zone' => 'Временска зона',
        'enable' => 'Омогући',
        'disable' => 'Онемогући',
        'disabled_helper' => 'Није могуће онемогућити овај шаблон е-поште!',
        'enable_cache_site_map' => 'Омогући кеширање мапе сајта',
        'cache_time_site_map' => 'Време кеширања мапе сајта (у минутима)',
        'admin_logo' => 'Логотип администрације',
        'admin_favicon' => 'Favicon администрације',
        'admin_title' => 'Наслов администрације',
        'admin_title_placeholder' => 'Наслов за приказ у таб прегледача',
        'admin_appearance_title' => 'Изглед администрације',
        'admin_appearance_description' => 'Подешавање изгледа администрације као што су уређивач, језик...',
        'seo_block_description' => 'Подешавање наслова сајта, мета описа сајта, кључних речи сајта за оптимизацију SEO',
        'webmaster_tools_description' => 'Google Search Console је бесплатан веб алат који пружа Google, који помаже власницима веб сајтова да прате перформансе свог сајта у Google резултатима претраге.',
        'yes' => 'Да',
        'no' => 'Не',
        'show_on_front' => 'Ваша почетна страница приказује',
        'select' => '— Изаберите —',
        'show_site_name' => 'Прикажи назив сајта после наслова странице, раздвојено са "-"',
        'locale' => 'Језик сајта',
        'locale_direction' => 'Правац језика предњег сајта',
        'minutes' => 'минута',
        'redirect_404_to_homepage' => 'Преусмери све захтеве за страницама које нису пронађене на почетну страницу',
    ],
    'admin_appearance' => [
        'title' => 'Изглед администрације',
        'description' => 'Прегледајте и ажурирајте логотип, favicon, распоред,...',
        'layout' => 'Распоред',
        'horizontal' => 'Хоризонтални',
        'vertical' => 'Вертикални',
        'show_menu_item_icon' => 'Прикажи иконе ставки менија',
        'language' => 'Језик административног панела',
        'theme_mode' => 'Режим теме',
        'dark' => 'Тамни',
        'light' => 'Светли',
        'container_width' => [
            'title' => 'Ширина контејнера',
            'default' => 'Подразумевано',
            'large' => 'Велики',
            'full' => 'Пуни',
        ],
        'form' => [
            'admin_logo' => 'Логотип администрације',
            'admin_logo_max_height' => 'Висина логотипа (px)',
            'admin_logo_max_height_helper' => 'Поставите висину логотипа у пикселима. Подразумевана вредност је :default.',
            'admin_favicon' => 'Favicon администрације',
            'admin_favicon_type' => 'Тип favicon-а администрације',
            'admin_title' => 'Наслов администрације',
            'admin_title_placeholder' => 'Наслов за приказ у таб прегледача',
            'admin_login_screen_backgrounds' => 'Позадине екрана за пријаву (~1366 x 768)',
            'admin_locale' => 'Језик администрације',
            'admin_locale_direction' => 'Правац језика администрације',
            'rich_editor' => 'Напредни уређивач',
            'show_admin_bar' => 'Прикажи административну траку за пријављене администраторе, чак и на предњем сајту',
            'show_guidelines' => 'Прикажи смернице',
            'primary_font' => 'Примарни фонт',
            'primary_color' => 'Примарна боја',
            'secondary_color' => 'Секундарна боја',
            'heading_color' => 'Боја наслова',
            'text_color' => 'Боја текста',
            'link_color' => 'Боја везе',
            'link_hover_color' => 'Боја везе при преласку',
            'show_menu_item_icon' => 'Прикажи иконе ставки менија',
            'custom_css' => 'Прилагођени CSS',
            'custom_js' => 'Прилагођени JS',
            'custom_header_js' => 'Заглавље JS',
            'custom_header_js_placeholder' => 'JavaScript у заглављу странице, умотајте га унутар &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Тело JS',
            'custom_body_js_placeholder' => 'JavaScript у телу странице, умотајте га унутар &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Подножје JS',
            'custom_footer_js_placeholder' => 'JavaScript у подножју странице, умотајте га унутар &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Табеле података',
        'description' => 'Подешавања за табеле података',
        'form' => [
            'show_column_visibility' => 'Прикажи видљивост колона подразумевано',
            'show_column_visibility_helper' => 'Омогућите дугме за пребацивање видљивости колона у табелама података да бисте омогућили корисницима да прикажу/сакрију колоне',
            'show_export_button' => 'Прикажи дугме за извоз подразумевано',
            'show_export_button_helper' => 'Прикажи опције извоза (CSV, Excel, PDF) у табелама података за преузимање података табеле',
            'pagination_type' => 'Тип пагинације',
            'pagination_type_helper' => 'Изаберите како се приказују контроле пагинације: Подразумевано приказује бројеве страница, Падајући мени приказује компактан селектор падајућег менија',
            'default' => 'Подразумевано',
            'dropdown' => 'Падајући мени',
            'enable_responsive' => 'Омогући респонзивност табеле',
            'enable_responsive_helper' => 'Аутоматски прилагодите колоне табеле различитим величинама екрана за боље искуство на мобилним уређајима',
        ],
    ],
    'email' => [
        'subject' => 'Тема',
        'content' => 'Садржај',
        'title' => 'Подешавање за шаблон е-поште',
        'description' => 'Шаблон е-поште користећи HTML и системске променљиве.',
        'reset_to_default' => 'Ресетуј на подразумевано',
        'back' => 'Назад на подешавања',
        'reset_success' => 'Успешно ресетовано на подразумевано',
        'confirm_reset' => 'Потврдите ресетовање шаблона е-поште?',
        'confirm_message' => 'Да ли заиста желите да ресетујете овај шаблон е-поште на подразумевано?',
        'continue' => 'Настави',
        'sender_name' => 'Име пошиљаоца',
        'sender_name_placeholder' => 'Име',
        'sender_name_helper' => 'Име које ће се појавити у пољу Од е-порука које шаље систем',
        'sender_email' => 'Е-пошта пошиљаоца',
        'sender_email_placeholder' => 'Адреса е-поште (нпр. :default)',
        'sender_email_helper' => 'Адреса е-поште која ће се користити као пошиљалац за све е-поруке које шаље систем',
        'mailer' => 'Пошиљалац',
        'port' => 'Порт',
        'port_placeholder' => 'Нпр: 587',
        'port_helper' => 'Порт који користи ваш мејл сервер (уобичајени портови: 25, 465, 587)',
        'host' => 'Хост',
        'host_placeholder' => 'Нпр: smtp.gmail.com',
        'host_helper' => 'SMTP адреса хоста',
        'username' => 'Корисничко име',
        'username_placeholder' => 'Корисничко име за пријаву на мејл сервер',
        'username_helper' => 'Ваше корисничко име за пријаву на мејл сервер',
        'password' => 'Лозинка',
        'password_placeholder' => 'Лозинка за пријаву на мејл сервер',
        'password_helper' => 'Ваша лозинка за пријаву на мејл сервер',
        'encryption' => 'Енкрипција',
        'encryption_placeholder' => 'Изаберите тип енкрипције',
        'encryption_helper' => 'Изаберите метод енкрипције за безбедан пренос е-поште',
        'encryption_none' => 'Ниједна',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Савети за подешавање е-поште',
        'setup_tip_gmail' => 'За Gmail: Користите smtp.gmail.com као хост, порт 587 са TLS или порт 465 са SSL. Омогућите "Приступ мање безбедних апликација" или користите лозинку апликације.',
        'setup_tip_port' => 'Уобичајени портови: 25 (неенкриптовано), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (алтернативно).',
        'setup_tip_encryption' => 'Користите TLS за порт 587 (препоручено), SSL за порт 465, или Ниједна за порт 25 (није препоручено за продукцију).',
        'setup_tip_test' => 'Увек користите дугме "Пошаљи тест е-пошту" да верификујете вашу конфигурацију пре чувања.',
        'setup_tip_mailgun' => 'За бољу испоруку, размислите о коришћењу услуга е-поште као што су Mailgun, SendGrid или Amazon SES уместо SMTP.',
        'queue_warning_title' => 'Потребна је конфигурација реда',
        'queue_warning_description' => 'Ваш ред е-поште је тренутно конфигурисан да користи ":default" драјвер, али ваш радник реда можда не ради. То значи да е-поруке неће бити послате док не подесите радника реда.',
        'queue_warning_action' => 'Да бисте послали е-поруке одмах без радника реда, поставите QUEUE_CONNECTION=sync у вашем .env фајлу. У супротном, уверите се да ваш радник реда ради са "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Сазнајте више о Laravel редовима</a>.',
        'mail_gun_domain' => 'Домен',
        'mail_gun_domain_placeholder' => 'Нпр: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Име домена које сте регистровали са Mailgun',
        'mail_gun_secret' => 'Тајна',
        'mail_gun_secret_placeholder' => 'Нпр: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Ваш Mailgun API кључ',
        'mail_gun_endpoint' => 'Крајња тачка',
        'mail_gun_endpoint_placeholder' => 'Нпр: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API крајња тачка (api.mailgun.net за US, api.eu.mailgun.net за EU)',
        'log_channel' => 'Канал дневника',
        'log_channel_helper' => 'Изаберите који канал логовања да користите за дневнике е-поште',
        'sendmail_path' => 'Sendmail путања',
        'local_domain' => 'Локални домен',
        'local_domain_placeholder' => 'Може бити празно. Треба да поставите на ваш домен када користите SMTP Relay. Нпр. your-domain.com',
        'local_domain_helper' => 'Домен који ће се користити за идентификацију сервера приликом комуникације са удаљеним SMTP серверима',

        'ses_key' => 'Кључ',
        'ses_key_placeholder' => 'Нпр: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Ваш AWS ID кључа за приступ',
        'ses_secret' => 'Тајна',
        'ses_secret_placeholder' => 'Нпр: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Ваш AWS тајни кључ за приступ',
        'ses_region' => 'Регион',
        'ses_region_placeholder' => 'Нпр: us-east-1',
        'ses_region_helper' => 'AWS регион где је конфигурисана ваша SES услуга',

        'postmark_token' => 'Токен',
        'postmark_token_placeholder' => 'Нпр: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Ваш Postmark серверски токен',

        'resend_key' => 'API кључ',
        'resend_key_placeholder' => 'Нпр: re_123456789012345678901234567890',
        'resend_key_helper' => 'Ваш Resend API кључ',

        'email_templates' => 'Шаблони е-поште',
        'email_templates_description' => 'Шаблони е-поште користећи HTML и системске променљиве.',
        'email_template_settings' => 'Подешавања шаблона е-поште',
        'email_template_settings_description' => 'Прегледајте и ажурирајте подешавања шаблона е-поште',
        'email_rules' => 'Правила е-поште',
        'email_rules_description' => 'Конфигуришите правила е-поште за валидацију',
        'base_template' => 'Основни шаблон',
        'base_template_description' => 'Основни шаблон за све е-поруке',
        'template_header' => 'Заглавље шаблона е-поште',
        'template_header_description' => 'Шаблон за заглавље е-порука',
        'template_footer' => 'Подножје шаблона е-поште',
        'template_footer_description' => 'Шаблон за подножје е-порука',
        'default' => 'Подразумевано',
        'template_off_status_helper' => 'Овај шаблон е-поште је искључен.',
        'blacklist_email_domains' => 'Домени е-поште на црној листи',
        'blacklist_email_domains_helper' => 'Унесите листу домена е-поште који ће бити на црној листи. Нпр. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Адресе е-поште на црној листи',
        'blacklist_specified_emails_helper' => 'Унесите листу одређених адреса е-поште које ће бити на црној листи. Нпр. mail@example.com.',
        'exception_emails' => 'Изузете е-поруке',
        'exception_emails_helper' => 'Ове е-поруке ће бити искључене из правила валидације.',
        'email_rules_strict' => 'Строга валидација е-поште',
        'email_rules_strict_helper' => 'Извршите RFC-сличну валидацију е-поште са строгим правилима.',
        'email_rules_dns' => 'DNS провера валидације',
        'email_rules_dns_helper' => 'Проверите да ли постоје DNS записи који показују да сервер прихвата е-поруке.',
        'email_rules_spoof' => 'Детекција лажирања',
        'email_rules_spoof_helper' => 'Откријте потенцијалне покушаје лажирања е-поште.',
        'template_turn_off' => 'Кликните да искључите овај шаблон е-поште',
        'template_turn_on' => 'Кликните да укључите овај шаблон е-поште',
        'turn_on_success_message' => 'Шаблон е-поште успешно укључен!',
        'turn_off_success_message' => 'Шаблон е-поште успешно искључен!',
        'email_template_status' => 'Статус шаблона е-поште',
        'email_template_status_description' => 'Укључи/искључи шаблон е-поште',
        'email_template_logo' => 'Логотип',
        'email_template_logo_helper_text' => 'Ако није постављено, узеће се из логотипа администрације у Администрација -> Подешавања -> Изглед администрације -> Логотип.',
        'email_template_copyright_text_helper_text' => 'Ако није постављено, узеће се из опција теме за ауторска права у Администрација -> Изглед -> Опције теме -> Опште -> Ауторска права.',
        'email_template_email_contact' => 'Контакт адреса е-поште',
        'email_template_email_contact_helper_text' => 'Ако није постављено, узеће се из е-поште пошиљаоца у Администрација -> Подешавања -> Е-пошта',
        'email_template_social_links' => 'Везе друштвених мрежа',
        'email_template_copyright_text' => 'Ауторска права',
        'image_upload_supported' => 'Подржава само PNG, JPG, JPEG и GIF формате.',
        'email_template_custom_css' => 'Прилагођени CSS шаблона е-поште',
        'social_links' => [
            'name' => 'Име',
            'icon' => 'Икона',
            'icon_image' => 'Слика иконе (Подржава само PNG, JPG, JPEG и GIF формате.)',
            'url' => 'URL',
            'image' => 'Слика',
        ],
    ],
    'media' => [
        'title' => 'Медији',
        'driver' => 'Драјвер',
        'description' => 'Подешавања за медије',
        'local_disk' => 'Локални диск',
        'aws_access_key_id' => 'AWS ID кључа за приступ',
        'aws_secret_key' => 'AWS тајни кључ',
        'aws_default_region' => 'AWS подразумевани регион',
        'aws_bucket' => 'AWS корпа',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS крајња тачка (опционо)',
        'use_path_style_endpoint' => 'Користите крајњу тачку стила путање',
        'r2_access_key_id' => 'R2 ID кључа за приступ',
        'r2_secret_key' => 'R2 тајни кључ',
        'r2_bucket' => 'R2 корпа',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 крајња тачка',
        'do_spaces_access_key_id' => 'DO Spaces ID кључа за приступ',
        'do_spaces_secret_key' => 'DO Spaces тајни кључ',
        'do_spaces_default_region' => 'DO Spaces подразумевани регион',
        'do_spaces_bucket' => 'DO Spaces корпа',
        'do_spaces_endpoint' => 'DO Spaces крајња тачка',
        'do_spaces_cdn_enabled' => 'Да ли је DO Spaces CDN омогућен?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN прилагођени домен',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi ID кључа за приступ',
        'wasabi_secret_key' => 'Wasabi тајни кључ',
        'wasabi_default_region' => 'Wasabi подразумевани регион',
        'wasabi_bucket' => 'Wasabi корпа',
        'wasabi_root' => 'Wasabi корен',
        'wasabi_root_helper' => 'Да бисте поново користили постојеће слике, једноставно одредите Wasabi корен као "/", затим отпремите све тренутне датотеке из public/storage у ваш Wasabi коренски директоријум.',
        'backblaze_access_key_id' => 'Backblaze ID кључа за приступ',
        'backblaze_secret_key' => 'Backblaze тајни кључ',
        'backblaze_bucket' => 'Backblaze корпа',
        'backblaze_default_region' => 'Backblaze подразумевани регион',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze крајња тачка',
        'backblaze_cdn_enabled' => 'Да ли је Backblaze CDN омогућен?',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN прилагођени домен',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'Подразумевана слика заменика',
        'enable_chunk' => 'Омогући отпремање делова',
        'chunk_size' => 'Величина дела (Bytes)',
        'chunk_size_placeholder' => 'Подразумевано: 1048576 ~ 1MB',
        'max_file_size' => 'Максимална величина датотеке дела (MB)',
        'max_file_size_placeholder' => 'Подразумевано: 1048576 ~ 1GB',
        'enable_watermark' => 'Омогући водени жиг',
        'watermark_source' => 'Слика воденог жига',
        'watermark_source_helper' => 'Подржава само PNG, JPG и JPEG формате. Требало би да користите слику мању од 200x200px и величину мању од 50KB.',
        'watermark_size' => 'Величина воденог жига (%)',
        'watermark_size_placeholder' => 'Подразумевано: 10 (%)',
        'watermark_opacity' => 'Непрозирност воденог жига (%)',
        'watermark_opacity_placeholder' => 'Подразумевано: 70 (%)',
        'watermark_position' => 'Позиција воденог жига',
        'watermark_position_x' => 'Позиција воденог жига X',
        'watermark_position_y' => 'Позиција воденог жига Y',
        'watermark_position_top_left' => 'Горе лево',
        'watermark_position_top_right' => 'Горе десно',
        'watermark_position_bottom_left' => 'Доле лево',
        'watermark_position_bottom_right' => 'Доле десно',
        'watermark_position_center' => 'Центар',
        'turn_off_automatic_url_translation_into_latin' => 'Искључи аутоматски превод URL-а на латиницу',
        'bunnycdn_hostname' => 'Име хоста',
        'bunnycdn_zone' => 'Име зоне (Име ваше зоне за складиштење)',
        'bunnycdn_key' => 'FTP & API лозинка за приступ (Лозинка за API приступ зони складиштења)',
        'bunnycdn_region' => 'Регион (Регион зоне складиштења)',
        'optional' => 'Опционо',
        'sizes' => 'Величине сличица медија',
        'media_sizes_helper' => 'Поставите ширину или висину на 0 ако желите да исечете само по ширини или висини.',
        'width' => 'Ширина',
        'height' => 'Висина',
        'default_size_value' => 'Подразумевано: :size',
        'all' => 'Све',
        'all_helper_text' => 'Ако поништите означавање свих фолдера, примењиваће се на све фолдере.',
        'media_folders_can_add_watermark' => 'Додајте водени жиг за слике у фолдерима:',
        'max_upload_filesize' => 'Максимална величина датотеке за отпремање (MB)',
        'max_upload_filesize_placeholder' => 'Подразумевано: :size, мора бити мање од :size.',
        'max_upload_filesize_helper' => 'Ваш сервер дозвољава отпремање датотека максимално :size, можете променити ову вредност да ограничите величину датотеке за отпремање.',
        'image_processing_library' => 'Библиотека за обраду слика',
        'use_original_name_for_file_path' => 'Користите оригинално име за путању датотеке',
        'keep_original_file_size_and_quality' => 'Задржите оригиналну величину и квалитет датотеке',
        'update_thumbnail_sizes_warning' => 'Након подешавања величина сличица, морате кликнути на дугме ":button_text" да бисте их освежили.',
        'thumbnail_crop_position' => 'Позиција исецања сличице',
        'thumbnail_crop_position_left' => 'Лево',
        'thumbnail_crop_position_center' => 'Центар',
        'thumbnail_crop_position_right' => 'Десно',
        'thumbnail_crop_position_top' => 'Горе',
        'thumbnail_crop_position_bottom' => 'Доле',
        'thumbnail_crop_position_helper' => 'Ово подешавање се користи за исецање слике приликом генерисања сличица. Биће исечена са ове позиције док слика не буде попуњена.',
        'user_can_only_view_own_media' => 'Корисници могу видети само своје медије',
        'user_can_only_view_own_media_helper' => 'Када је омогућено, корисници могу видети само своје медије, док супер администратори могу видети све медије.',
        'enable_thumbnail_sizes' => 'Омогући величине сличица',
        'enable_thumbnail_sizes_helper' => 'Омогућите ову опцију да генеришете сличице за слике. Ако је онемогућено, систем неће генерисати сличице за слике и увек ће користити слику пуне величине.',
        'convert_image_to_webp' => 'Конвертуј JPG, JPEG, PNG слику у WebP',
        'convert_image_to_webp_helper' => 'WebP је модеран формат слике који пружа супериорну компресију без губитака и са губицима за слике на вебу. Подржан је у Chrome, Firefox, Edge и Opera. Слика ће бити конвертована у WebP формат приликом отпремања. Примењује се само на JPG, JPEG, PNG слике.',
        'reduce_large_image_size' => 'Смањи величину велике слике приликом отпремања',
        'reduce_large_image_size_helper' => 'Када је омогућено, систем ће смањити величину великих слика приликом отпремања, примењује се на JPG, JPEG, PNG, WebP слике. Максимална ширина и висина слике ће бити промењене на вредности које поставите испод.',
        'image_max_width' => 'Максимална ширина слике (px)',
        'image_max_height' => 'Максимална висина слике (px)',
        'image_max_width_placeholder' => 'Оставите празно да задржите оригиналну ширину',
        'image_max_height_placeholder' => 'Оставите празно да задржите оригиналну висину',
        'image_max_width_helper' => 'Поставите максималну ширину слике у пикселима. Оригинална ширина ће бити задржана ако је ово поље празно.',
        'image_max_height_helper' => 'Поставите максималну висину слике у пикселима. Оригинална висина ће бити задржана ако је ово поље празно.',
        'customize_upload_path' => 'Прилагоди путању отпремања',
        'customize_upload_path_helper' => 'Прилагодите путању отпремања за медијске датотеке. Подразумевано, систем ће отпремити датотеке у фолдер ":path".',
        'upload_path' => 'Путања отпремања',
        'upload_path_placeholder' => 'Пример: uploads',
        'upload_path_helper' => 'Тај фолдер ће бити креиран у /public. Подразумевани фолдер је ":folder". Затим ће бити отпремљен у "/public/:folder".',
        'upload_path_warning' => 'Систем неће преместити постојеће датотеке у нови фолдер. Ако желите да преместите постојеће датотеке у нови фолдер, морате то урадити ручно.',
        'convert_file_name_to_uuid' => 'Конвертуј име датотеке у UUID',
        'convert_file_name_to_uuid_helper' => 'Када је омогућено, систем ће конвертовати име датотеке у UUID приликом отпремања. Корисно је за спречавање дупликата имена датотека и бољу безбедност.',
        's3_path' => 'Прилагођена S3 путања (опционо)',
        's3_path_placeholder' => 'Опциона прилагођена путања у S3 корпи (нпр., uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'Код куповине',
        'buyer' => 'Купац',
    ],
    'field_type_not_exists' => 'Овај тип поља не постоји',
    'save_settings' => 'Сачувај подешавања',
    'template' => 'Шаблон',
    'description' => 'Опис',
    'enable' => 'Омогући',
    'send' => 'Пошаљи',
    'test_email_description' => 'Да бисте послали тест е-пошту, уверите се да сте ажурирали конфигурације за слање е-поште!',
    'test_email_input_placeholder' => 'Унесите адресу е-поште на коју желите да пошаљете тест е-пошту.',
    'test_email_modal_title' => 'Пошаљите тест е-пошту',
    'test_send_mail' => 'Пошаљи тест е-пошту',
    'test_email_send_success' => 'Е-пошта успешно послата!',
    'locale_direction_ltr' => 'Слева надесно',
    'locale_direction_rtl' => 'Здесна налево',
    'emails_warning' => 'Можете додати максимум :count е-порука',
    'email_add_more' => 'Додај још',
    'generate' => 'Генериши',
    'generate_thumbnails' => 'Генериши сличице',
    'generate_thumbnails_success' => 'Сличице успешно генерисане. :count датотека је генерисано!',
    'generate_thumbnails_error' => 'Нисмо могли да регенеришемо сличице за :count датотека!',
    'generate_thumbnails_description' => 'Да ли сте сигурни да желите да поново генеришете сличице за све слике? Ово може потрајати. Молимо вас да не напуштате ову страницу док се процес не заврши.',
    'enable_chunk_description' => 'Отпремање величине дела се користи за отпремање велике величине датотеке.',
    'watermark_description' => 'УПОЗОРЕЊЕ: Водени жиг се додаје само на ново отпремљене слике, неће бити додат на постојеће слике. Онемогућавање воденог жига неће уклонити водени жиг са постојећих слика.',
    'submit' => 'Поднеси',
    'back' => 'Назад',
    'enter_sample_value' => 'Унесите примерне вредности за тестирање',
    'preview' => 'Преглед',
    'media_size_width' => ':size величина ширине мора бити већа од 0',
    'media_size_height' => ':size величина висине мора бити већа од 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob вам омогућава да аутоматизујете одређене команде или скрипте на вашем сајту.',
        'is_not_ready' => 'Да бисте покренули cronjob, пратите упутства испод.',
        'is_working' => 'Честитамо! Ваш cronjob ради.',
        'is_not_working' => 'Ваш cronjob не ради. Молимо вас да проверите cronjob вашег сервера.',
        'last_checked' => 'Последња провера у :time.',
        'copy_button' => 'Копирај',
        'setup' => [
            'name' => 'Подешавање Cronjob-а',
            'connect_to_server' => 'Повежите се на ваш сервер преко SSH или било које префериране методе.',
            'open_crontab' => 'Отворите crontab датотеку користећи текстуални уређивач (нпр., `crontab -e`).',
            'add_cronjob' => 'Додајте горњу команду у crontab датотеку и сачувајте је.',
            'done' => 'Cronjob ће сада радити сваког минута и извршавати наведену команду.',
            'learn_more' => 'Можете сазнати више о cronjob-у из Laravel :documentation',
            'documentation' => 'документације',
            'copied' => 'Копирано',
        ],
    ],
    'security' => [
        'title' => 'Безбедносна подешавања',
        'description' => 'Проверите и конфигуришите безбедносна подешавања за ваш веб сајт.',
        'menu_description' => 'Управљајте безбедношћу колачића и HTTP заглављима',
        'status_secure' => 'Сва безбедносна подешавања су правилно конфигурисана!',
        'status_insecure' => 'Нека безбедносна подешавања захтевају пажњу!',
        'current_settings' => 'Тренутна безбедносна подешавања',
        'status' => 'Статус',
        'setting' => 'Подешавање',
        'current_value' => 'Тренутна вредност',
        'recommended_value' => 'Препоручено',
        'session_http_only' => 'HttpOnly заставица колачића',
        'session_http_only_description' => 'Спречава JavaScript да приступи колачићима сесије (штити од XSS напада)',
        'session_secure_cookie' => 'Безбедна заставица колачића',
        'session_secure_cookie_description' => 'Осигурава да се колачићи шаљу само преко HTTPS веза',
        'session_same_site' => 'SameSite заставица колачића',
        'session_same_site_description' => 'Спречава CSRF нападе ограничавањем када се колачићи шаљу',
        'http_security_headers' => 'HTTP безбедносна заглавља',
        'http_security_headers_description' => 'Додаје безбедносна заглавља за заштиту од уобичајених веб рањивости',
        'https_warning' => 'Ваш сајт не користи HTTPS',
        'https_warning_description' => 'Неке безбедносне функције као што су безбедни колачићи захтевају HTTPS. Размислите о омогућавању SSL за ваш веб сајт.',
        'how_to_fix' => 'Како поправити безбедносне проблеме',
        'env_file_location' => 'Уредите ваш .env фајл који се налази на:',
        'add_to_env' => 'Подешавања за додавање',
        'required_settings' => 'Потребна безбедносна подешавања',
        'for_https_sites' => 'Само за HTTPS сајтове',
        'copy' => 'Копирај',
        'copy_settings' => 'Копирај сва подешавања',
        'copied' => 'Копирано!',
        'steps' => 'Кораци за примену подешавања',
        'step_1' => 'Отворите ваш .env фајл у текстуалном уређивачу',
        'step_2' => 'Додајте или ажурирајте безбедносна подешавања приказана горе',
        'step_3' => 'Сачувајте .env фајл',
        'step_4' => 'Обришите кеш користећи Администраторски панел → Администрација платформе → Управљање кешом',
        'security_headers_info' => 'Информације о безбедносним заглављима',
        'security_headers_list' => 'Када је омогућено, следећа заглавља се додају свим одговорима:',
        'header_nosniff' => 'Спречава прегледаче да погађају типове садржаја',
        'header_frame' => 'Штити од clickjacking напада',
        'header_xss' => 'Омогућава заштиту прегледача од XSS',
        'header_referrer' => 'Контролише колико референтних информација се шаље',
        'learn_more' => 'За детаљније информације, погледајте :documentation',
        'documentation' => 'безбедносну документацију',
    ],
    'cache' => [
        'title' => 'Кеш',
        'description' => 'Конфигуришите кеширање за оптимизовану брзину',
        'form' => [
            'cache_admin_menu' => 'Кеширај административни мени',
            'cache_admin_menu_helper' => 'Кеширај административни мени за оптимизовану брзину. Ова опција треба бити онемогућена ако развијате или прилагођавате административни мени.',
            'enable_cache_site_map' => 'Кеширај мапу сајта',
            'enable_cache_site_map_helper' => 'Мапа сајта :url треба да буде кеширана због великог броја страница. Ако имате мали број страница, можете онемогућити ову опцију.',
            'cache_time_site_map' => 'Време кеширања мапе сајта (у минутима)',
            'cache_front_menu' => 'Кеширај предњи мени',
            'cache_front_menu_helper' => 'Кеширај предњи мени за оптимизовану брзину',
            'cache_user_avatar' => 'Кеширај аватар корисника',
            'cache_user_avatar_helper' => 'За кориснике без аватара, систем ће генерисати аватаре из њихових корисничких имена. Аватари ће бити кеширани за оптимизовану брзину и неће бити поново генерисани.',
            'shortcode_cache_enabled' => 'Кеширај шорткодове (UI блокове)',
            'shortcode_cache_enabled_helper' => 'Омогућите кеширање за шорткодове да побољшате перформансе. Када је омогућено, шорткодови ће бити кеширани да смање време рендеровања.',
            'shortcode_cache_warning' => '<strong>⚠️ Важно обавештење:</strong><br>• Шорткодови који садрже форме (контакт форме, пријаве на билтен, итд.) ће аутоматски заобићи кеширање да би се очувала функционалност.<br>• Шорткодови са динамичким JavaScript садржајем треба да имају онемогућено кеширање ручно.<br>• Да бисте онемогућили кеширање за одређене шорткодове, додајте <code>Омогући кеширање: Не</code> у конфигурацију шорткода.<br>• Форме са CSRF токенима, reCAPTCHA или другим динамичким елементима се аутоматски откривају и искључују из кеширања.',
            'shortcode_cache_ttl' => 'Трајање кеша (секунди)',
            'shortcode_cache_ttl_helper' => 'Трајање кеширања свих шорткодова. Подразумевано је 1800 секунди (30 минута).',
            'widget_cache_enabled' => 'Кеширај виџете',
            'widget_cache_enabled_helper' => 'Омогућите кеширање за виџете да побољшате перформансе. Када је омогућено, виџети ће бити кеширани да смање време рендеровања.',
            'widget_cache_warning' => '<strong>⚠️ Важно обавештење:</strong><br>• Виџети који садрже форме (контакт форме, пријаве на билтен, итд.) ће аутоматски заобићи кеширање да би се очувала функционалност.<br>• Виџети са динамичким JavaScript садржајем треба да имају онемогућено кеширање ручно.<br>• Да бисте онемогућили кеширање за одређене виџете, поставите <code>Омогући кеширање: Не</code> у конфигурацији виџета.<br>• Форме са CSRF токенима, reCAPTCHA или другим динамичким елементима се аутоматски откривају и искључују из кеширања.',
            'widget_cache_ttl' => 'Трајање кеша (секунди)',
            'widget_cache_ttl_helper' => 'Трајање кеширања свих виџета. Подразумевано је 1800 секунди (30 минута).',
            'plugin_cache_enabled' => 'Кеширај инсталиране додатке',
            'plugin_cache_enabled_helper' => 'Кеширајте листу инсталираних додатака за побољшане перформансе. Када је омогућено, систем ће кеширати листу додатака 30 минута да смањи скенирање система датотека.',
        ],
    ],
    'appearance' => [
        'title' => 'Изглед',
    ],
    'panel' => [
        'common' => 'Уобичајено',
        'general' => 'Опште',
        'general_description' => 'Прегледајте и ажурирајте општа подешавања и активирајте лиценцу',
        'email' => 'Е-пошта',
        'email_description' => 'Прегледајте и ажурирајте подешавања е-поште и шаблоне е-поште',
        'media' => 'Медији',
        'media_description' => 'Прегледајте и ажурирајте подешавања медија',
        'system' => 'Систем',
        'system_updater' => 'Ажурирање система',
        'system_updater_description' => 'Ажурирајте ваш систем на најновију верзију',
        'others' => 'Остало',
    ],
    'saving' => 'Чување...',
    'generating_media_thumbnails' => 'Генерисање сличица медија...',
    'test_email_template' => 'Тестирај шаблон е-поште',
    'select_email_template' => 'Изаберите шаблон е-поште',
    'enums' => [
        'data_retention_period' => [
            '0' => 'Никада',
            '1' => '1 дан',
            '3' => '3 дана',
            '7' => '1 недеља',
            '30' => '1 месец',
            '90' => '3 месеца',
            '180' => '6 месеци',
            '365' => '1 година',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute мора бити важећи AWS регион (нпр., us-east-1, eu-west-1).',
    ],
];
