<?php

return [
    'title' => 'Inställningar',
    'general_setting' => 'Allmänna inställningar',
    'menu' => 'Alla inställningar',
    'email_setting_title' => 'E-postinställningar',
    'email_setting_description' => 'Konfigurera e-postinställningar',
    'general' => [
        'theme' => 'Tema',
        'title' => 'Allmän information',
        'description' => 'Visa och uppdatera webbplatsinformation',
        'rich_editor' => 'Rich Editor',
        'site_title' => 'Webbplatstitel',
        'admin_email' => 'Admin-e-post',
        'seo_block' => 'SEO-konfiguration',
        'seo_title' => 'SEO-titel',
        'seo_description' => 'SEO-beskrivning',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Webbplatstitel (max 120 tecken)',
            'admin_email' => 'Admin-e-post',
            'seo_title' => 'SEO-titel (max 120 tecken)',
            'seo_description' => 'SEO-beskrivning (max 120 tecken)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Skicka felrapportering via e-post',
        'enable_send_error_reporting_via_email_helper' => 'När det är aktiverat skickas detaljerade felrapporter till administratörens e-postadresser när kritiska fel inträffar på webbplatsen',
        'time_zone_helper' => 'Välj tidszon för din webbplats. Detta kommer att användas för alla datum- och tidsvisningar i hela systemet',
        'time_zone' => 'Tidszon',
        'enable' => 'Aktivera',
        'disable' => 'Inaktivera',
        'disabled_helper' => 'Kan inte inaktivera denna e-postmall!',
        'enable_cache_site_map' => 'Aktivera sitemap-cachning',
        'cache_time_site_map' => 'Timeout för sitemap-cache (i minuter)',
        'admin_logo' => 'Admin-logotyp',
        'admin_favicon' => 'Admin-favicon',
        'admin_title' => 'Admin-titel',
        'admin_title_placeholder' => 'Titel att visa i webbläsarfliken',
        'admin_appearance_title' => 'Admin-utseende',
        'admin_appearance_description' => 'Inställning av admin-utseende som editor, språk...',
        'seo_block_description' => 'Ställa in webbplatstitel, webbplatsmetabeskrivning, webbplatsnyckelord för att optimera SEO',
        'webmaster_tools_description' => 'Google Search Console är ett gratis webbverktyg från Google som hjälper webbplatsägare att övervaka sin webbplats prestanda i Googles sökresultat.',
        'yes' => 'Ja',
        'no' => 'Nej',
        'show_on_front' => 'Din hemsida visar',
        'select' => '— Välj —',
        'show_site_name' => 'Visa webbplatsnamn efter sidtitel, separerat med "-"',
        'locale' => 'Webbplatsspråk',
        'locale_direction' => 'Språkriktning för framsidan',
        'minutes' => 'minuter',
        'redirect_404_to_homepage' => 'Omdirigera alla förfrågningar som inte hittades till hemsidan',
    ],
    'admin_appearance' => [
        'title' => 'Admin-utseende',
        'description' => 'Visa och uppdatera logotyp, favicon, layout,...',
        'layout' => 'Layout',
        'horizontal' => 'Horisontell',
        'vertical' => 'Vertikal',
        'show_menu_item_icon' => 'Visa menyobjektikon',
        'language' => 'Admin-panelens språk',
        'theme_mode' => 'Temaläge',
        'dark' => 'Mörk',
        'light' => 'Ljus',
        'container_width' => [
            'title' => 'Containerbredd',
            'default' => 'Standard',
            'large' => 'Stor',
            'full' => 'Full',
        ],
        'form' => [
            'admin_logo' => 'Admin-logotyp',
            'admin_logo_max_height' => 'Logotyphöjd (px)',
            'admin_logo_max_height_helper' => 'Ställ in höjden på logotypen i pixlar. Standardvärdet är :default.',
            'admin_favicon' => 'Admin-favicon',
            'admin_favicon_type' => 'Admin-favicon-typ',
            'admin_title' => 'Admin-titel',
            'admin_title_placeholder' => 'Titel att visa i webbläsarfliken',
            'admin_login_screen_backgrounds' => 'Bakgrunder för inloggningsskärmen (~1366 x 768)',
            'admin_locale' => 'Admin-språk',
            'admin_locale_direction' => 'Admin-språkriktning',
            'rich_editor' => 'Rich Editor',
            'show_admin_bar' => 'Visa adminverktygsfältet för inloggade administratörer, även på framsidan',
            'show_guidelines' => 'Visa riktlinjer',
            'primary_font' => 'Primärt typsnitt',
            'primary_color' => 'Primärfärg',
            'secondary_color' => 'Sekundärfärg',
            'heading_color' => 'Rubrikfärg',
            'text_color' => 'Textfärg',
            'link_color' => 'Länkfärg',
            'link_hover_color' => 'Länk hover-färg',
            'show_menu_item_icon' => 'Visa menyobjektikon',
            'custom_css' => 'Anpassad CSS',
            'custom_js' => 'Anpassad JS',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript i sidhuvudet, linda in det i &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript i sidkroppen, linda in det i &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript i sidfoten, linda in det i &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Datatabeller',
        'description' => 'Inställningar för datatabeller',
        'form' => [
            'show_column_visibility' => 'Visa kolumnsynlighet som standard',
            'show_column_visibility_helper' => 'Aktivera växlingsknappen för kolumnsynlighet i datatabeller för att låta användare visa/dölja kolumner',
            'show_export_button' => 'Visa exportknapp som standard',
            'show_export_button_helper' => 'Visa exportalternativ (CSV, Excel, PDF) i datatabeller för att ladda ner tabelldata',
            'pagination_type' => 'Pagineringstyp',
            'pagination_type_helper' => 'Välj hur pagineringskontroller visas: Standard visar sidnummer, Dropdown visar en kompakt dropdown-väljare',
            'default' => 'Standard',
            'dropdown' => 'Dropdown',
            'enable_responsive' => 'Aktivera tabellresponsivitet',
            'enable_responsive_helper' => 'Justera automatiskt tabellkolumner för att passa olika skärmstorlekar för bättre mobilupplevelse',
        ],
    ],
    'email' => [
        'subject' => 'Ämne',
        'content' => 'Innehåll',
        'title' => 'Inställning för e-postmall',
        'description' => 'E-postmall med HTML & systemvariabler.',
        'reset_to_default' => 'Återställ till standard',
        'back' => 'Tillbaka till inställningar',
        'reset_success' => 'Återställd till standard framgångsrikt',
        'confirm_reset' => 'Bekräfta återställning av e-postmall?',
        'confirm_message' => 'Vill du verkligen återställa denna e-postmall till standard?',
        'continue' => 'Fortsätt',
        'sender_name' => 'Avsändarnamn',
        'sender_name_placeholder' => 'Namn',
        'sender_name_helper' => 'Namnet som visas i Från-fältet i e-postmeddelanden som skickas av systemet',
        'sender_email' => 'Avsändar-e-post',
        'sender_email_placeholder' => 'E-postadress (t.ex. :default)',
        'sender_email_helper' => 'E-postadressen som kommer att användas som avsändare för alla e-postmeddelanden som skickas av systemet',
        'mailer' => 'Mailer',
        'port' => 'Port',
        'port_placeholder' => 'Ex: 587',
        'port_helper' => 'Porten som används av din e-postserver (vanliga portar: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Ex: smtp.gmail.com',
        'host_helper' => 'SMTP värdadress',
        'username' => 'Användarnamn',
        'username_placeholder' => 'Användarnamn för att logga in på e-postservern',
        'username_helper' => 'Ditt användarnamn för e-postservern',
        'password' => 'Lösenord',
        'password_placeholder' => 'Lösenord för att logga in på e-postservern',
        'password_helper' => 'Ditt lösenord för e-postservern',
        'encryption' => 'Kryptering',
        'encryption_placeholder' => 'Välj krypteringstyp',
        'encryption_helper' => 'Välj krypteringsmetod för säker e-postöverföring',
        'encryption_none' => 'Ingen',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Tips för e-postinställning',
        'setup_tip_gmail' => 'För Gmail: Använd smtp.gmail.com som värd, port 587 med TLS eller port 465 med SSL. Aktivera "Mindre säker appåtkomst" eller använd ett applösenord.',
        'setup_tip_port' => 'Vanliga portar: 25 (okrypterad), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternativ).',
        'setup_tip_encryption' => 'Använd TLS för port 587 (rekommenderat), SSL för port 465, eller Ingen för port 25 (rekommenderas inte för produktion).',
        'setup_tip_test' => 'Använd alltid knappen "Skicka test-e-post" för att verifiera din konfiguration innan du sparar.',
        'setup_tip_mailgun' => 'För bättre leveransförmåga, överväg att använda e-posttjänster som Mailgun, SendGrid eller Amazon SES istället för SMTP.',
        'queue_warning_title' => 'Kökonfiguration krävs',
        'queue_warning_description' => 'Din e-postkö är för närvarande konfigurerad att använda ":default"-drivrutin, men din köarbetare kanske inte körs. Detta innebär att e-postmeddelanden inte skickas förrän du ställer in en köarbetare.',
        'queue_warning_action' => 'För att skicka e-postmeddelanden omedelbart utan en köarbetare, ställ in QUEUE_CONNECTION=sync i din .env-fil. Annars, se till att din köarbetare körs med "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Läs mer om Laravel-köer</a>.',
        'mail_gun_domain' => 'Domän',
        'mail_gun_domain_placeholder' => 'Ex: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Domännamnet du registrerade med Mailgun',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => 'Ex: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Din Mailgun API-nyckel',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Ex: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API endpoint (api.mailgun.net för USA, api.eu.mailgun.net för EU)',
        'log_channel' => 'Loggkanal',
        'log_channel_helper' => 'Välj vilken loggkanal som ska användas för e-postloggar',
        'sendmail_path' => 'Sendmail-sökväg',
        'local_domain' => 'Lokal domän',
        'local_domain_placeholder' => 'Den kan vara tom. Måste ställas in på din domän när du använder SMTP Relay. T.ex. your-domain.com',
        'local_domain_helper' => 'Domänen som kommer att användas för att identifiera servern vid kommunikation med fjärr-SMTP-servrar',

        'ses_key' => 'Nyckel',
        'ses_key_placeholder' => 'Ex: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Ditt AWS-åtkomstnyckel-ID',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => 'Ex: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Din hemliga AWS-åtkomstnyckel',
        'ses_region' => 'Region',
        'ses_region_placeholder' => 'Ex: us-east-1',
        'ses_region_helper' => 'AWS-regionen där din SES-tjänst är konfigurerad',

        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Ex: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Din Postmark-servertoken',

        'resend_key' => 'API-nyckel',
        'resend_key_placeholder' => 'Ex: re_123456789012345678901234567890',
        'resend_key_helper' => 'Din Resend API-nyckel',

        'email_templates' => 'E-postmallar',
        'email_templates_description' => 'E-postmallar med HTML & systemvariabler.',
        'email_template_settings' => 'Inställningar för e-postmall',
        'email_template_settings_description' => 'Visa och uppdatera dina inställningar för e-postmallar',
        'email_rules' => 'E-postregler',
        'email_rules_description' => 'Konfigurera e-postregler för validering',
        'base_template' => 'Basmall',
        'base_template_description' => 'Basmall för alla e-postmeddelanden',
        'template_header' => 'E-postmallshuvud',
        'template_header_description' => 'Mall för e-postmeddelandens huvud',
        'template_footer' => 'E-postmallsfot',
        'template_footer_description' => 'Mall för e-postmeddelandens fot',
        'default' => 'Standard',
        'template_off_status_helper' => 'Denna e-postmall är avstängd.',
        'blacklist_email_domains' => 'Svartlistade e-postdomäner',
        'blacklist_email_domains_helper' => 'Ange en lista med e-postdomäner som ska svartlistas. T.ex. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Svartlistade e-postadresser',
        'blacklist_specified_emails_helper' => 'Ange en lista med specifika e-postadresser som ska svartlistas. T.ex. mail@example.com.',
        'exception_emails' => 'Undantags-e-postadresser',
        'exception_emails_helper' => 'Dessa e-postadresser kommer att uteslutas från valideringsreglerna.',
        'email_rules_strict' => 'Strikt e-postvalidering',
        'email_rules_strict_helper' => 'Utför RFC-liknande e-postvalidering med strikta regler.',
        'email_rules_dns' => 'DNS-kontrollvalidering',
        'email_rules_dns_helper' => 'Kontrollera om det finns DNS-poster som indikerar att servern accepterar e-postmeddelanden.',
        'email_rules_spoof' => 'Spoofing-detektion',
        'email_rules_spoof_helper' => 'Upptäck potentiella e-postspoofing-försök.',
        'template_turn_off' => 'Klicka för att stänga av denna e-postmall',
        'template_turn_on' => 'Klicka för att slå på denna e-postmall',
        'turn_on_success_message' => 'E-postmall aktiverad framgångsrikt!',
        'turn_off_success_message' => 'E-postmall inaktiverad framgångsrikt!',
        'email_template_status' => 'Status för e-postmall',
        'email_template_status_description' => 'Aktivera/inaktivera e-postmall',
        'email_template_logo' => 'Logotyp',
        'email_template_logo_helper_text' => 'Om den inte ställs in, kommer den att hämtas från admin-logotypen i Admin -> Inställningar -> Admin-utseende -> Logotyp.',
        'email_template_copyright_text_helper_text' => 'Om den inte ställs in, kommer den att hämtas från temaalternativ upphovsrätt i Admin -> Utseende -> Temaalternativ -> Allmänt -> Upphovsrätt.',
        'email_template_email_contact' => 'Kontakt-e-postadress',
        'email_template_email_contact_helper_text' => 'Om den inte ställs in, kommer den att hämtas från avsändar-e-post i Admin -> Inställningar -> E-post',
        'email_template_social_links' => 'Sociala länkar',
        'email_template_copyright_text' => 'Upphovsrätt',
        'image_upload_supported' => 'Stöder endast PNG, JPG, JPEG och GIF-format.',
        'email_template_custom_css' => 'Anpassad CSS för e-postmall',
        'social_links' => [
            'name' => 'Namn',
            'icon' => 'Ikon',
            'icon_image' => 'Ikonbild (Stöder endast PNG, JPG, JPEG och GIF-format.)',
            'url' => 'URL',
            'image' => 'Bild',
        ],
    ],
    'media' => [
        'title' => 'Media',
        'driver' => 'Drivrutin',
        'description' => 'Inställningar för media',
        'local_disk' => 'Lokal disk',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS standardregion',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (Valfritt)',
        'use_path_style_endpoint' => 'Använd path style endpoint',
        'r2_access_key_id' => 'R2 Access Key ID',
        'r2_secret_key' => 'R2 Secret Key',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces standardregion',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'Är DO Spaces CDN aktiverad?',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN anpassad domän',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi standardregion',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'För att återanvända befintliga bilder, ange helt enkelt Wasabi root som "/", ladda sedan upp alla aktuella filer från public/storage till din Wasabi root-katalog.',
        'backblaze_access_key_id' => 'Backblaze Access Key ID',
        'backblaze_secret_key' => 'Backblaze Secret Key',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze standardregion',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Är Backblaze CDN aktiverad?',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN anpassad domän',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'Standard platshållarbild',
        'enable_chunk' => 'Aktivera chunk-uppladdning',
        'chunk_size' => 'Chunk-storlek (Bytes)',
        'chunk_size_placeholder' => 'Standard: 1048576 ~ 1MB',
        'max_file_size' => 'Chunk max filstorlek (MB)',
        'max_file_size_placeholder' => 'Standard: 1048576 ~ 1GB',
        'enable_watermark' => 'Aktivera vattenstämpel',
        'watermark_source' => 'Vattenstämpelbild',
        'watermark_source_helper' => 'Stöder endast PNG, JPG och JPEG-format. Du bör använda bild mindre än 200x200px och storlek mindre än 50KB.',
        'watermark_size' => 'Storlek på vattenstämpel (%)',
        'watermark_size_placeholder' => 'Standard: 10 (%)',
        'watermark_opacity' => 'Vattenstämpelens opacitet (%)',
        'watermark_opacity_placeholder' => 'Standard: 70 (%)',
        'watermark_position' => 'Vattenstämpelposition',
        'watermark_position_x' => 'Vattenstämpelposition X',
        'watermark_position_y' => 'Vattenstämpelposition Y',
        'watermark_position_top_left' => 'Överst till vänster',
        'watermark_position_top_right' => 'Överst till höger',
        'watermark_position_bottom_left' => 'Nederst till vänster',
        'watermark_position_bottom_right' => 'Nederst till höger',
        'watermark_position_center' => 'Centrum',
        'turn_off_automatic_url_translation_into_latin' => 'Stäng av automatisk URL-översättning till latin',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Zonnamn (Namnet på din lagringszon)',
        'bunnycdn_key' => 'FTP & API-åtkomstlösenord (Lagringszonens API-åtkomstlösenord)',
        'bunnycdn_region' => 'Region (Lagringszonens region)',
        'optional' => 'Valfritt',
        'sizes' => 'Storlekar för mediaminiatyrer',
        'media_sizes_helper' => 'Ställ in bredd eller höjd till 0 om du bara vill beskära efter bredd eller höjd.',
        'width' => 'Bredd',
        'height' => 'Höjd',
        'default_size_value' => 'Standard: :size',
        'all' => 'Alla',
        'all_helper_text' => 'Om du avmarkerar alla mappar kommer det att gälla för alla mappar.',
        'media_folders_can_add_watermark' => 'Lägg till vattenstämpel för bilder i mappar:',
        'max_upload_filesize' => 'Max uppladdningsfilstorlek (MB)',
        'max_upload_filesize_placeholder' => 'Standard: :size, måste vara mindre än :size.',
        'max_upload_filesize_helper' => 'Din server tillåter att ladda upp filer maximalt :size, du kan ändra detta värde för att begränsa uppladdningsfilstorlek.',
        'image_processing_library' => 'Bildbehandlingsbibliotek',
        'use_original_name_for_file_path' => 'Använd originalnamn för filsökväg',
        'keep_original_file_size_and_quality' => 'Behåll original filstorlek och kvalitet',
        'update_thumbnail_sizes_warning' => 'Efter justering av miniatyrstorlekarna måste du klicka på knappen ":button_text" för att uppdatera dem.',
        'thumbnail_crop_position' => 'Beskärningsposition för miniatyr',
        'thumbnail_crop_position_left' => 'Vänster',
        'thumbnail_crop_position_center' => 'Centrum',
        'thumbnail_crop_position_right' => 'Höger',
        'thumbnail_crop_position_top' => 'Topp',
        'thumbnail_crop_position_bottom' => 'Botten',
        'thumbnail_crop_position_helper' => 'Denna inställning används för att beskära bilden vid generering av miniatyrer. Den kommer att beskäras från denna position tills bilden är fylld.',
        'user_can_only_view_own_media' => 'Användare kan endast se sin egna media',
        'user_can_only_view_own_media_helper' => 'När detta är aktiverat kan användare endast se sin egna media, medan superadministratörer kan se all media.',
        'enable_thumbnail_sizes' => 'Aktivera miniatyrstorlekar',
        'enable_thumbnail_sizes_helper' => 'Aktivera detta alternativ för att generera miniatyrer för bilder. Om det är inaktiverat kommer systemet inte att generera miniatyrer för bilder och alltid använda bilder i full storlek.',
        'convert_image_to_webp' => 'Konvertera JPG, JPEG, PNG-bild till WebP',
        'convert_image_to_webp_helper' => 'WebP är ett modernt bildformat som ger överlägsen förlustfri och förlustbehäftad komprimering för bilder på webben. Det stöds i Chrome, Firefox, Edge och Opera. Bilden kommer att konverteras till WebP-format vid uppladdning. Det gäller endast för JPG, JPEG, PNG-bilder.',
        'reduce_large_image_size' => 'Minska stor bildstorlek vid uppladdning',
        'reduce_large_image_size_helper' => 'När detta är aktiverat kommer systemet att minska storleken på stora bilder vid uppladdning, gäller för JPG, JPEG, PNG, WebP-bild. Den maximala bredden och höjden på bilden kommer att ändras till de värden du anger nedan.',
        'image_max_width' => 'Bild max bredd (px)',
        'image_max_height' => 'Bild max höjd (px)',
        'image_max_width_placeholder' => 'Lämna tomt för att behålla original bredd',
        'image_max_height_placeholder' => 'Lämna tomt för att behålla original höjd',
        'image_max_width_helper' => 'Ställ in den maximala bredden på bilden i pixlar. Originalbredden kommer att behållas om detta fält är tomt.',
        'image_max_height_helper' => 'Ställ in den maximala höjden på bilden i pixlar. Originalhöjden kommer att behållas om detta fält är tomt.',
        'customize_upload_path' => 'Anpassa uppladdningssökväg',
        'customize_upload_path_helper' => 'Anpassa uppladdningssökvägen för mediafiler. Som standard kommer systemet att ladda upp filer till ":path"-mappen.',
        'upload_path' => 'Uppladdningssökväg',
        'upload_path_placeholder' => 'Exempel: uploads',
        'upload_path_helper' => 'Den mappen kommer att skapas i /public. Standardmappen är ":folder". Sedan kommer den att laddas upp till "/public/:folder".',
        'upload_path_warning' => 'Systemet kommer inte att flytta befintliga filer till den nya mappen. Om du vill flytta befintliga filer till den nya mappen måste du göra det manuellt.',
        'convert_file_name_to_uuid' => 'Konvertera filnamn till UUID',
        'convert_file_name_to_uuid_helper' => 'När detta är aktiverat kommer systemet att konvertera filnamnet till UUID vid uppladdning. Det är användbart för att förhindra dubbletter av filnamn och bättre säkerhet.',
        's3_path' => 'Anpassad S3-sökväg (Valfritt)',
        's3_path_placeholder' => 'Valfri anpassad sökväg i S3-bucket (t.ex. uploads/media)',
    ],
    'license' => [
        'purchase_code' => 'Köpkod',
        'buyer' => 'Köpare',
    ],
    'field_type_not_exists' => 'Denna fälttyp finns inte',
    'save_settings' => 'Spara inställningar',
    'template' => 'Mall',
    'description' => 'Beskrivning',
    'enable' => 'Aktivera',
    'send' => 'Skicka',
    'test_email_description' => 'För att skicka test-e-post, se till att du har uppdaterat konfigurationerna för att skicka e-post!',
    'test_email_input_placeholder' => 'Ange den e-postadress till vilken du vill skicka test-e-post.',
    'test_email_modal_title' => 'Skicka ett test-e-post',
    'test_send_mail' => 'Skicka test-e-post',
    'test_email_send_success' => 'E-post skickat framgångsrikt!',
    'locale_direction_ltr' => 'Vänster till höger',
    'locale_direction_rtl' => 'Höger till vänster',
    'emails_warning' => 'Du kan lägga till maximalt :count e-postadresser',
    'email_add_more' => 'Lägg till fler',
    'generate' => 'Generera',
    'generate_thumbnails' => 'Generera miniatyrer',
    'generate_thumbnails_success' => 'Miniatyrer genererade framgångsrikt. :count filer har genererats!',
    'generate_thumbnails_error' => 'Vi kunde inte regenerera miniatyrer för :count filer!',
    'generate_thumbnails_description' => 'Är du säker på att du vill regenerera miniatyrer för alla bilder? Detta kan ta lite tid. Vänligen navigera inte bort från denna sida förrän processen är klar.',
    'enable_chunk_description' => 'Chunk-storlek uppladdning används för att ladda upp stora filstorlekar.',
    'watermark_description' => 'VARNING: Vattenstämpel läggs bara till nya uppladdade bilder, den kommer inte att läggas till befintliga bilder. Att inaktivera vattenstämpel kommer inte att ta bort vattenstämpel från befintliga bilder.',
    'submit' => 'Skicka',
    'back' => 'Tillbaka',
    'enter_sample_value' => 'Ange exempelvärden för testning',
    'preview' => 'Förhandsgranska',
    'media_size_width' => ':size storlek bredd måste vara större än 0',
    'media_size_height' => ':size storlek höjd måste vara större än 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob låter dig automatisera vissa kommandon eller skript på din webbplats.',
        'is_not_ready' => 'För att köra cronjob, följ instruktionerna nedan.',
        'is_working' => 'Grattis! Din cronjob körs.',
        'is_not_working' => 'Din cronjob körs inte. Vänligen kontrollera din servers cronjob.',
        'last_checked' => 'Senast kontrollerad kl :time.',
        'copy_button' => 'Kopiera',
        'setup' => [
            'name' => 'Konfigurera Cronjob',
            'connect_to_server' => 'Anslut till din server via SSH eller någon föredragen metod.',
            'open_crontab' => 'Öppna crontab-filen med en textredigerare (t.ex. `crontab -e`).',
            'add_cronjob' => 'Lägg till ovanstående kommando i crontab-filen och spara den.',
            'done' => 'Cronjob kommer nu att köras varje minut och köra det angivna kommandot.',
            'learn_more' => 'Du kan lära dig mer om cronjob från Laravels :documentation',
            'documentation' => 'dokumentation',
            'copied' => 'Kopierad',
        ],
    ],
    'security' => [
        'title' => 'Säkerhetsinställningar',
        'description' => 'Kontrollera och konfigurera säkerhetsinställningar för din webbplats.',
        'menu_description' => 'Hantera cookie-säkerhet och HTTP-headers',
        'status_secure' => 'Alla säkerhetsinställningar är korrekt konfigurerade!',
        'status_insecure' => 'Vissa säkerhetsinställningar behöver uppmärksamhet!',
        'current_settings' => 'Aktuella säkerhetsinställningar',
        'status' => 'Status',
        'setting' => 'Inställning',
        'current_value' => 'Aktuellt värde',
        'recommended_value' => 'Rekommenderat',
        'session_http_only' => 'HttpOnly Cookie-flagga',
        'session_http_only_description' => 'Förhindrar JavaScript från att få åtkomst till sessionscookies (skyddar mot XSS-attacker)',
        'session_secure_cookie' => 'Secure Cookie-flagga',
        'session_secure_cookie_description' => 'Säkerställer att cookies endast skickas över HTTPS-anslutningar',
        'session_same_site' => 'SameSite Cookie-flagga',
        'session_same_site_description' => 'Förhindrar CSRF-attacker genom att begränsa när cookies skickas',
        'http_security_headers' => 'HTTP-säkerhetsheaders',
        'http_security_headers_description' => 'Lägger till säkerhetsheaders för att skydda mot vanliga webbsårbarheter',
        'https_warning' => 'Din webbplats använder inte HTTPS',
        'https_warning_description' => 'Vissa säkerhetsfunktioner som säkra cookies kräver HTTPS. Överväg att aktivera SSL för din webbplats.',
        'how_to_fix' => 'Hur man åtgärdar säkerhetsproblem',
        'env_file_location' => 'Redigera din .env-fil som finns på:',
        'add_to_env' => 'Inställningar att lägga till',
        'required_settings' => 'Nödvändiga säkerhetsinställningar',
        'for_https_sites' => 'Endast för HTTPS-webbplatser',
        'copy' => 'Kopiera',
        'copy_settings' => 'Kopiera alla inställningar',
        'copied' => 'Kopierad!',
        'steps' => 'Steg för att tillämpa inställningar',
        'step_1' => 'Öppna din .env-fil i en textredigerare',
        'step_2' => 'Lägg till eller uppdatera säkerhetsinställningarna som visas ovan',
        'step_3' => 'Spara .env-filen',
        'step_4' => 'Rensa cache med Admin-panelen → Plattformsadministration → Cachehantering',
        'security_headers_info' => 'Information om säkerhetsheaders',
        'security_headers_list' => 'När detta är aktiverat läggs följande headers till i alla svar:',
        'header_nosniff' => 'Förhindrar webbläsare från att gissa innehållstyper',
        'header_frame' => 'Skyddar mot clickjacking-attacker',
        'header_xss' => 'Aktiverar webbläsarens XSS-skydd',
        'header_referrer' => 'Kontrollerar hur mycket referrer-information som skickas',
        'learn_more' => 'För mer detaljerad information, se :documentation',
        'documentation' => 'säkerhetsdokumentation',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Konfigurera cachning för optimerad hastighet',
        'form' => [
            'cache_admin_menu' => 'Cacha adminmeny',
            'cache_admin_menu_helper' => 'Cacha adminmeny för optimerad hastighet. Detta alternativ bör inaktiveras om du utvecklar eller anpassar adminmenyn.',
            'enable_cache_site_map' => 'Cacha sitemap',
            'enable_cache_site_map_helper' => 'Sitemap :url bör cachas på grund av det stora antalet sidor. Om du har ett litet antal sidor kan du inaktivera detta alternativ.',
            'cache_time_site_map' => 'Timeout för sitemap-cache (i minuter)',
            'cache_front_menu' => 'Cacha frontmeny',
            'cache_front_menu_helper' => 'Cacha frontmeny för optimerad hastighet',
            'cache_user_avatar' => 'Cacha användaravatar',
            'cache_user_avatar_helper' => 'För användare utan avatar kommer systemet att generera avatarer från deras användarnamn. Avatarerna kommer att cachas för optimerad hastighet och kommer inte att regenereras.',
            'shortcode_cache_enabled' => 'Cacha shortcodes (UI-block)',
            'shortcode_cache_enabled_helper' => 'Aktivera cachning för shortcodes för att förbättra prestanda. När det är aktiverat kommer shortcodes att cachas för att minska renderingstiden.',
            'shortcode_cache_warning' => '<strong>⚠️ Viktig information:</strong><br>• Shortcodes som innehåller formulär (kontaktformulär, nyhetsbrevsprenumerationer, etc.) kommer automatiskt att kringgå cachning för att bevara funktionalitet.<br>• Shortcodes med dynamiskt JavaScript-innehåll bör ha cachning inaktiverad manuellt.<br>• För att inaktivera cachning för specifika shortcodes, lägg till <code>Enable caching: No</code> till shortcode-konfigurationen.<br>• Formulär med CSRF-tokens, reCAPTCHA eller andra dynamiska element upptäcks automatiskt och utesluts från cachning.',
            'shortcode_cache_ttl' => 'Cache-varaktighet (sekunder)',
            'shortcode_cache_ttl_helper' => 'Varaktigheten för att cacha alla shortcodes. Standard är 1800 sekunder (30 minuter).',
            'widget_cache_enabled' => 'Cacha widgets',
            'widget_cache_enabled_helper' => 'Aktivera cachning för widgets för att förbättra prestanda. När det är aktiverat kommer widgets att cachas för att minska renderingstiden.',
            'widget_cache_warning' => '<strong>⚠️ Viktig information:</strong><br>• Widgets som innehåller formulär (kontaktformulär, nyhetsbrevsprenumerationer, etc.) kommer automatiskt att kringgå cachning för att bevara funktionalitet.<br>• Widgets med dynamiskt JavaScript-innehåll bör ha cachning inaktiverad manuellt.<br>• För att inaktivera cachning för specifika widgets, ställ in <code>Enable caching: No</code> i widgetkonfigurationen.<br>• Formulär med CSRF-tokens, reCAPTCHA eller andra dynamiska element upptäcks automatiskt och utesluts från cachning.',
            'widget_cache_ttl' => 'Cache-varaktighet (sekunder)',
            'widget_cache_ttl_helper' => 'Varaktigheten för att cacha alla widgets. Standard är 1800 sekunder (30 minuter).',
            'plugin_cache_enabled' => 'Cacha installerade plugins',
            'plugin_cache_enabled_helper' => 'Cacha listan över installerade plugins för förbättrad prestanda. När det är aktiverat kommer systemet att cacha plugin-listan i 30 minuter för att minska filsystemsökningar.',
        ],
    ],
    'appearance' => [
        'title' => 'Utseende',
    ],
    'panel' => [
        'common' => 'Gemensamt',
        'general' => 'Allmänt',
        'general_description' => 'Visa och uppdatera dina allmänna inställningar och aktivera licens',
        'email' => 'E-post',
        'email_description' => 'Visa och uppdatera dina e-postinställningar och e-postmallar',
        'media' => 'Media',
        'media_description' => 'Visa och uppdatera dina mediainställningar',
        'system' => 'System',
        'system_updater' => 'Systemuppdaterare',
        'system_updater_description' => 'Uppdatera ditt system till den senaste versionen',
        'others' => 'Övrigt',
    ],
    'saving' => 'Sparar...',
    'generating_media_thumbnails' => 'Genererar mediaminiatyrer...',
    'test_email_template' => 'Testa e-postmall',
    'select_email_template' => 'Välj e-postmall',
    'enums' => [
        'data_retention_period' => [
            '0' => 'Aldrig',
            '1' => '1 dag',
            '3' => '3 dagar',
            '7' => '1 vecka',
            '30' => '1 månad',
            '90' => '3 månader',
            '180' => '6 månader',
            '365' => '1 år',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute måste vara en giltig AWS-region (t.ex. us-east-1, eu-west-1).',
    ],
];
