<?php

return [
    'name' => 'Produkte',
    'description' => 'Ihre Produkteinstellungen anzeigen und aktualisieren',
    'create' => 'Neues Produkt',
    'create_product_type' => [
        'physical' => 'Neues physisches Produkt',
        'digital' => 'Neues digitales Produkt',
    ],
    'edit' => 'Produkt bearbeiten - :name',
    'form' => [
        'name' => 'Name',
        'name_placeholder' => 'Produktname (Maximal 120 Zeichen)',
        'description' => 'Beschreibung',
        'description_placeholder' => 'Kurzbeschreibung für Produkt (Maximal 400 Zeichen)',
        'categories' => 'Kategorien',
        'content' => 'Inhalt',
        'price' => 'Preis',
        'quantity' => 'Menge',
        'brand' => 'Marke',
        'width' => 'Breite',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'date' => [
            'start' => 'Von Datum',
            'end' => 'Bis Datum',
        ],
        'image' => 'Bilder',
        'collections' => 'Produktsammlungen',
        'labels' => 'Labels',
        'price_sale' => 'Verkaufspreis',
        'product_type' => [
            'title' => 'Produkttyp',
        ],
        'product' => 'Produkt',
        'total' => 'Gesamt',
        'sub_total' => 'Zwischensumme',
        'shipping_fee' => 'Versandkosten',
        'discount' => 'Rabatt',
        'options' => 'Optionen',
        'shipping' => [
            'height' => 'Höhe',
            'length' => 'Länge',
            'title' => 'Versand',
            'weight' => 'Gewicht',
            'wide' => 'Breite',
        ],
        'barcode' => 'Barcode (ISBN, UPC, GTIN, etc.)',
        'barcode_placeholder' => 'Barcode eingeben',
        'cost_per_item' => 'Kosten pro Artikel',
        'cost_per_item_placeholder' => 'Kosten pro Artikel eingeben',
        'cost_per_item_helper' => 'Kunden sehen diesen Preis nicht.',
        'price_includes_tax' => 'Preis inkl. Steuern',
        'price_includes_tax_helper' => 'Aktivieren Sie dies, wenn der eingegebene Preis bereits Steuern enthält. Das System berechnet den Grundpreis, indem der Steuerbetrag abgezogen wird.',
        'stock' => [
            'allow_order_when_out' => 'Kunde erlauben auszuchecken, wenn dieses Produkt nicht vorrätig ist',
            'in_stock' => 'Vorrätig',
            'out_stock' => 'Nicht vorrätig',
            'title' => 'Lagerstatus',
        ],
        'storehouse' => [
            'no_storehouse' => 'Keine Lagerverwaltung',
            'storehouse' => 'Mit Lagerverwaltung',
            'title' => 'Lager',
            'quantity' => 'Menge',
        ],
        'tax' => 'Steuer',
        'taxes' => 'Steuern',
        'taxes_helper' => 'Der Standard-Steuersatz ist in <a href=":url">Einstellungen -> Steuer</a> konfiguriert. Wenn keine spezifische Steuer für dieses Produkt ausgewählt ist, wird der Standardsatz angewendet. Um die Steuer für dieses Produkt zu deaktivieren, entfernen Sie den Standard-Steuersatz aus den Steuereinstellungen.',
        'is_default' => 'Ist Standard',
        'action' => 'Aktion',
        'restock_quantity' => 'Nachbestandsmenge',
        'remain' => 'Verbleibend',
        'choose_discount_period' => 'Rabattzeitraum wählen',
        'cancel' => 'Abbrechen',
        'no_results' => 'Keine Ergebnisse!',
        'value' => 'Wert',
        'attribute_name' => 'Attributname',
        'add_more_attribute' => 'Mehr Attribut hinzufügen',
        'continue' => 'Fortfahren',
        'add_new_attributes' => 'Neue Attribute hinzufügen',
        'add_new_attributes_description' => 'Das Hinzufügen neuer Attribute hilft dem Produkt, viele Optionen zu haben, wie Größe oder Farbe.',
        'create_product_variations' => ':link um Produktvariationen zu erstellen!',
        'tags' => 'Tags',
        'write_some_tags' => 'Einige Tags schreiben',
        'variation_existed' => 'Diese Variation existiert bereits.',
        'no_attributes_selected' => 'Keine Attribute ausgewählt!',
        'added_variation_success' => 'Variation erfolgreich hinzugefügt!',
        'updated_variation_success' => 'Variation erfolgreich aktualisiert!',
        'created_all_variation_success' => 'Alle Variationen erfolgreich erstellt!',
        'updated_product_attributes_success' => 'Produktattribute erfolgreich aktualisiert!',
        'stock_status' => 'Lagerstatus',
        'auto_generate_sku' => 'SKU automatisch generieren?',
        'featured_image' => 'Hauptbild (optional)',
        'product_id' => 'Produkt-ID',
        'price_sale_percent_helper' => 'Rabatt :percent vom ursprünglichen Preis.',
        'minimum_order_quantity' => 'Mindestbestellmenge',
        'minimum_order_quantity_helper' => 'Mindestmenge für eine Bestellung, wenn der Wert 0 ist, gibt es keine Begrenzung.',
        'maximum_order_quantity' => 'Maximale Bestellmenge',
        'maximum_order_quantity_helper' => 'Maximale Menge für eine Bestellung, wenn der Wert 0 ist, gibt es keine Begrenzung.',
        'video' => 'Video',
        'video_file' => 'Datei',
        'video_url' => 'Oder externe Video-URL',
        'video_url_help' => 'YouTube- oder Vimeo-Video-URL eingeben',
        'enter_video_url' => 'Video-URL eingeben',
        'video_thumbnail' => 'Video-Thumbnail',
        'video_thumbnail_help' => 'Wählen Sie ein Thumbnail für das Video. Wenn nicht ausgewählt, wird es automatisch von der Video-URL abgerufen, falls verfügbar.',
        'barcode_existed' => 'Dieser Barcode wird von einem anderen Produkt verwendet. Bitte geben Sie einen anderen Barcode ein.',
        'barcode_helper' => 'Muss für jedes Produkt eindeutig sein.',
    ],
    'price' => 'Preis',
    'quantity' => 'Menge',
    'type' => 'Typ',
    'image' => 'Thumbnail',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Variations-SKU',
    'brand' => 'Marke',
    'cannot_delete' => 'Produkt konnte nicht gelöscht werden',
    'product_deleted' => 'Produkt gelöscht',
    'product_collections' => 'Produktsammlungen',
    'products' => 'Produkte',
    'menu' => 'Produkte',
    'control' => [
        'button_add_image' => 'Bild hinzufügen',
    ],
    'price_sale' => 'Verkaufspreis',
    'price_group_title' => 'Produktpreis verwalten',
    'store_house_group_title' => 'Lager verwalten',
    'shipping_group_title' => 'Versand verwalten',
    'overview' => 'Übersicht',
    'attributes' => 'Attribute',
    'product_has_variations' => 'Produkt hat Variationen',
    'manage_products' => 'Produkte verwalten',
    'add_new_product' => 'Neues Produkt hinzufügen',
    'start_by_adding_new_product' => 'Beginnen Sie mit dem Hinzufügen neuer Produkte.',
    'edit_this_product' => 'Dieses Produkt bearbeiten',
    'delete' => 'Löschen',
    'related_products' => 'Verwandte Produkte',
    'cross_selling_products' => 'Cross-Selling-Produkte',
    'up_selling_products' => 'Up-Selling-Produkte',
    'grouped_products' => 'Gruppierte Produkte',
    'search_products' => 'Produkte suchen',
    'selected_products' => 'Ausgewählte Produkte',
    'edit_variation_item' => 'Bearbeiten',
    'variations_box_description' => 'Klicken Sie auf "Attribut bearbeiten", um Attribute der Variation hinzuzufügen/zu entfernen oder klicken Sie auf "Neue Variation hinzufügen", um eine Variation hinzuzufügen.',
    'save_changes' => 'Änderungen speichern',
    'continue' => 'Fortfahren',
    'edit_attribute' => 'Attribut bearbeiten',
    'select_attribute' => 'Attribut auswählen',
    'add_new_variation' => 'Neue Variation hinzufügen',
    'edit_variation' => 'Variation bearbeiten',
    'generate_variations' => 'Variationen generieren',
    'generate_variations_confirmation' => 'Sind Sie sicher, dass Sie Variationen für dieses Produkt generieren möchten?',
    'delete_variation' => 'Variation löschen?',
    'delete_variation_confirmation' => 'Sind Sie sicher, dass Sie diese Variation löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
    'delete_variations_confirmation' => 'Sind Sie sicher, dass Sie diese Variationen löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
    'product_create_validate_name_required' => 'Bitte geben Sie den Produktnamen ein',
    'product_create_validate_sale_price_max' => 'Der Rabatt muss geringer sein als der ursprüngliche Preis',
    'product_create_validate_cost_per_item_max' => 'Die Kosten pro Artikel müssen geringer sein als der ursprüngliche Preis',
    'product_create_validate_sale_price_required_if' => 'Muss einen Rabatt eingeben, wenn Sie eine Aktion planen möchten',
    'product_create_validate_end_date_after' => 'Enddatum muss nach dem Startdatum liegen',
    'product_create_validate_start_date_required_if' => 'Rabatt-Startdatum kann nicht leer bleiben, wenn Zeitplanung ausgewählt ist',
    'product_create_validate_sale_price' => 'Rabatte können nicht leer bleiben, wenn Zeitplanung ausgewählt ist',
    'stock_statuses' => [
        'in_stock' => 'Vorrätig',
        'out_of_stock' => 'Nicht vorrätig',
        'on_backorder' => 'Nachbestellung',
    ],
    'stock_status' => 'Lagerstatus',
    'processing' => 'Bearbeitung...',
    'delete_selected_variations' => 'Ausgewählte Variationen löschen',
    'delete_variations' => 'Variationen löschen',
    'category' => 'Kategorie',
    'product_price_flash_sale_warning' => 'Dieses Produkt ist im Flash Sale <strong>:name</strong>, daher ist sein Preis <strong>:price</strong>.',
    'product_price_discount_warning' => 'Dieses Produkt ist im Rabatt <strong>:name</strong>, daher ist sein Preis <strong>:price</strong>.',
    'product_image' => 'Produktbild',
    'product_name' => 'Produktname',
    'product_link' => 'Produktlink',
    'types' => [
        'physical' => 'Physisch',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Digitale Anhänge',
        'add' => 'Anhang hinzufügen',
        'file_name' => 'Dateiname',
        'file_size' => 'Dateigröße',
        'unsaved' => 'Nicht gespeichert',
        'add_external_link' => 'Externen Link hinzufügen',
        'enter_file_name' => 'Dateiname eingeben',
        'enter_external_link_download' => 'Externen Download-Link eingeben',
        'enter_file_size' => 'Dateigröße eingeben',
        'external_link_download' => 'Externer Download-Link',
        'generate_license_code_after_purchasing_product' => 'Lizenzcode-Zuweisung für dieses Produkt aktivieren',
        'notify_attachment_updated' => 'E-Mail an Kunden senden, wenn Anhang aktualisiert wird',
    ],
    'license_codes' => [
        'title' => 'Lizenzcodes',
        'add' => 'Lizenzcode hinzufügen',
        'back' => 'Zurück zum Produkt',
        'edit' => 'Lizenzcode bearbeiten',
        'generate' => 'Codes generieren',
        'manage_codes' => 'Lizenzcodes verwalten',
        'management' => 'Lizenzcode-Verwaltung',
        'variation_breadcrumb' => 'Variation: :name',
        'variation_label' => 'Produktvariation',
        'variation_specific_note' => 'Diese Lizenzcodes sind spezifisch für diese Produktvariation. Kunden, die diese Variation kaufen, erhalten Codes aus diesem Pool.',
        'main_product_note' => 'Dieses Produkt hat Variationen. Jede Variation kann ihre eigenen Lizenzcodes haben, oder Kunden können Codes aus diesem Hauptprodukt-Pool erhalten, wenn die Variation keine Codes hat.',
        'code' => 'Lizenzcode',
        'codes' => 'Lizenzcodes',
        'status' => 'Status',
        'assigned_at' => 'Zugewiesen am',
        'status_available' => 'Verfügbar',
        'status_used' => 'Verwendet',
        'statuses' => [
            'available' => 'Verfügbar',
            'used' => 'Verwendet',
        ],
        'no_codes' => 'Keine Lizenzcodes gefunden. Fügen Sie einige Codes hinzu oder generieren Sie sie automatisch.',
        'no_codes_warning_title' => 'Keine Lizenzcodes verfügbar!',
        'no_codes_warning_message' => 'Dieses Produkt ist auf "Aus Liste auswählen" eingestellt, hat aber keine verfügbaren Lizenzcodes. Kunden, die dieses Produkt kaufen, erhalten stattdessen automatisch generierte Codes. Bitte fügen Sie Lizenzcodes hinzu, um die ordnungsgemäße Funktionalität sicherzustellen.',
        'no_codes_auto_generate' => 'Dieses Produkt ist so eingestellt, dass es automatisch Lizenzcodes generiert. Keine manuellen Codes erforderlich.',
        'used_code_no_actions' => 'Verwendeter Code - keine Aktionen verfügbar',
        'created_successfully' => 'Lizenzcode erfolgreich erstellt!',
        'updated_successfully' => 'Lizenzcode erfolgreich aktualisiert!',
        'deleted_successfully' => 'Lizenzcode erfolgreich gelöscht!',
        'generated_successfully' => ':count Lizenzcodes erfolgreich generiert!',
        'duplicates_skipped' => ':count doppelte Codes wurden übersprungen.',
        'generation_incomplete' => 'Warnung: Konnte nur :generated von :requested angeforderten Codes aufgrund von Duplikatskonflikten generieren.',
        'cannot_edit_used_code' => 'Kann einen verwendeten Lizenzcode nicht bearbeiten.',
        'cannot_delete_used_code' => 'Kann einen verwendeten Lizenzcode nicht löschen.',
        'show_all' => 'Alle anzeigen',
        'show_less' => 'Weniger anzeigen',
        'more' => 'mehr',
        'used_codes_hidden' => ':count verwendete Lizenzcode(s) sind ausgeblendet. Sie können alle Codes auf der Lizenzcode-Verwaltungsseite anzeigen.',
        'low_stock_title' => 'Niedriger Lizenzcode-Bestand',
        'low_stock_message' => 'Nur noch :count Lizenzcodes übrig. Erwägen Sie, weitere Codes hinzuzufügen, um nicht auszugehen.',
        'out_of_stock_title' => 'Keine Lizenzcodes mehr!',
        'out_of_stock_message' => 'Keine Lizenzcodes verfügbar. Kunden erhalten automatisch generierte Codes, bis Sie weitere hinzufügen.',
        'type' => [
            'title' => 'Lizenzcode-Zuweisungsmethode',
            'auto_generate' => 'Automatisch generieren (System generiert Codes automatisch)',
            'pick_from_list' => 'Aus Liste auswählen (Vorab eingegebene Codes verwenden)',
            'description' => 'Wählen Sie, wie Lizenzcodes Kunden zugewiesen werden sollen, wenn sie dieses Produkt kaufen.',
        ],
        'generate_modal' => [
            'title' => 'Lizenzcodes generieren',
            'quantity' => 'Menge',
            'format' => 'Format',
            'custom_pattern' => 'Benutzerdefiniertes Muster',
            'pattern_help' => 'Verwenden Sie # für Zahlen, A für Großbuchstaben, a für Kleinbuchstaben',
            'generate' => 'Generieren',
        ],
        'errors' => [
            'feature_not_enabled' => 'Lizenzcode-Funktion ist nicht aktiviert. Bitte aktivieren Sie sie in E-Commerce-Einstellungen > Digitale Produkte.',
            'digital_products_not_enabled' => 'Digitale Produkte sind nicht aktiviert. Bitte aktivieren Sie zuerst die Unterstützung für digitale Produkte.',
            'product_not_found' => 'Produkt nicht gefunden.',
            'not_digital_product' => 'Lizenzcodes sind nur für digitale Produkte verfügbar. Dieses Produkt ist als physisches Produkt eingestellt.',
            'license_codes_not_enabled_for_product' => 'Lizenzcode-Verwaltung ist für dieses Produkt nicht aktiviert. Bitte aktivieren Sie "Lizenzcode nach Produktkauf generieren" in den Produkteinstellungen.',
            'cannot_add_codes_auto_generate' => 'Kann keine Lizenzcodes manuell zu Produkten hinzufügen, die auf automatische Generierung eingestellt sind. Ändern Sie zuerst den Lizenzcode-Typ auf "Aus Liste auswählen".',
            'cannot_generate_codes_auto_generate' => 'Kann keine Lizenzcodes manuell für Produkte generieren, die auf automatische Generierung eingestellt sind. Ändern Sie zuerst den Lizenzcode-Typ auf "Aus Liste auswählen".',
        ],
        'copied' => 'Lizenzcode in Zwischenablage kopiert!',
    ],
    'this_action_will_reload_page' => 'Diese Aktion wird die Seite neu laden, um die Daten zu aktualisieren!',
    'select' => 'Auswählen',
    'set_this_variant_as_default' => 'Diese Variante als Standard setzen',
    'download' => 'Herunterladen',
    'cross_sell_price_type' => [
        'title' => 'Preistyp',
        'fixed' => 'Fest',
        'percent' => 'Prozent',
    ],
    'cross_sell_help' => [
        'price' => '* Preisfeld',
        'price_description' => 'Geben Sie den Betrag ein, den Sie vom ursprünglichen Preis abziehen möchten. Beispiel: Wenn der ursprüngliche Preis 100€ ist, geben Sie 20 ein, um den Preis auf 80€ zu reduzieren.',
        'type' => '* Typfeld',
        'type_description' => 'Wählen Sie den Rabatttyp: Fest (einen bestimmten Betrag reduzieren) oder Prozent (um einen Prozentsatz reduzieren).',
    ],
    'apply_for_all_variations' => 'Für alle Variationen anwenden',
    'export' => [
        'description' => 'Exportieren Sie Ihre Produktdaten in CSV- oder Excel-Dateien.',
        'total_items' => 'Gesamtartikel',
        'total_products' => 'Gesamtprodukte',
        'total_variations' => 'Gesamtvariationen',
        'advanced_options' => 'Erweiterte Optionen',
        'use_chunked_export' => 'Chunked Export verwenden',
        'use_chunked_export_helper' => 'Daten in Chunks verarbeiten, um große Datensätze effizient zu handhaben',
        'include_variations' => 'Produktvariationen einschließen',
        'include_variations_helper' => 'Produktvariationen zusammen mit Hauptprodukten exportieren',
        'optimize_memory' => 'Speichernutzung optimieren',
        'optimize_memory_helper' => 'Speicheroptimierung für sehr große Exporte aktivieren',
        'chunk_size' => 'Chunk-Größe',
        'chunk_size_helper' => 'Anzahl der gleichzeitig zu verarbeitenden Produkte (50-5000)',
        'use_streaming' => 'Streaming-Export verwenden',
        'use_streaming_helper' => 'Streaming für sehr große Datensätze aktivieren (automatisch aktiviert für >10.000 Artikel)',
        'large_dataset_warning_title' => 'Großer Produktkatalog erkannt',
        'large_dataset_warning_message' => 'Ihr Katalog enthält :count Artikel. Aufgrund der großen Größe wurden einige Exportoptionen für beste Leistung optimiert.',
        'large_dataset_specific_message' => 'Für Ihre :count Produkte verwenden Sie das CSV-Format mit aktiviertem Streaming. Das System kann nun Ihren großen Produktkatalog effizient ohne Timeouts oder Speicherprobleme handhaben.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Erforderlich)',
        'chunk_label' => 'Verarbeitung',
        'chunk_recommended' => '300 Produkte/Batch',
        'time_label' => 'Geschätzte Zeit',
        'time_estimate' => '1-3 Minuten',
        'pro_tip' => 'Profi-Tipp:',
        'pro_tip_message' => 'Der Export läuft weiter, auch wenn Ihr Browser einen Ladeindikator anzeigt. Nach dem Start beginnt der Download automatisch.',
        'large_dataset_tip_1' => 'Excel-Format wurde deaktiviert - verwenden Sie CSV-Format für schnellere und zuverlässigere Exporte',
        'large_dataset_tip_2' => 'Streaming-Modus wurde automatisch aktiviert, um Timeouts zu verhindern',
        'large_dataset_tip_3' => 'Der Exportvorgang kann je nach Server 1-3 Minuten dauern',
        'large_dataset_recommendation' => 'Empfohlen: Verwenden Sie CSV-Format mit 200-500 Chunk-Größe für optimale Leistung.',
        'excel_disabled_for_large_export' => 'Excel-Format nicht verfügbar für Kataloge über 10.000 Artikel',
        'streaming_auto_enabled' => 'Streaming-Modus wurde automatisch für optimale Leistung mit großen Datensätzen aktiviert.',
        'streaming_enabled_title' => 'Für großen Export optimiert',
        'streaming_enabled_message' => 'Streaming-Modus ist aktiv, um reibungslosen Export ohne Speicherprobleme zu gewährleisten.',
        'use_multi_file' => 'Mehrdatei-Export verwenden',
        'use_multi_file_helper' => 'Teilt den Export in mehrere Dateien auf, die in einer ZIP-Datei verpackt werden, für sehr große Datensätze',
        'multi_file_enabled_title' => 'Mehrdatei-Export aktiviert',
        'multi_file_enabled_message' => 'Ihr Export wird in :count Dateien aufgeteilt, die in einer ZIP-Datei verpackt werden, für optimale Leistung.',
        'records_per_file' => 'Datensätze pro Datei',
        'records_per_file_helper' => 'Anzahl der Datensätze in jeder Datei bei Verwendung des Mehrdatei-Exports',
        'estimated_files' => 'Geschätzte Dateien',
        'recommended_range' => 'Empfohlener Bereich',
        'range_large_export' => '200-500 Artikel',
        'range_medium_export' => '300-800 Artikel',
        'range_small_export' => '500-1000 Artikel',
        'export_progress' => 'Export-Fortschritt',
        'preparing_export' => 'Export wird vorbereitet...',
        'items_processed' => ':count Artikel verarbeitet',
        'estimated_time_calculating' => 'Geschätzte Zeit: wird berechnet...',
        'medium_dataset_detected' => 'Mittlerer Datensatz erkannt',
        'medium_dataset_message' => 'Sie exportieren :count Produkte. Erwägen Sie die Verwendung von Chunked Export für bessere Leistung.',
        'optimal_range' => 'Optimaler Bereich',
        'too_small_slow' => 'Zu klein - kann langsam sein',
        'too_large_timeouts' => 'Zu groß - kann Timeouts verursachen',
        'excel_disabled_warning' => 'Excel-Format für große Exporte deaktiviert (:count Artikel)',
        'starting_export' => 'Export wird gestartet...',
        'processing_data' => 'Daten werden verarbeitet...',
        'finalizing_export' => 'Export wird abgeschlossen...',
        'items_processed_suffix' => 'Artikel verarbeitet',
        'estimated_time_prefix' => 'Geschätzte Zeit:',
        'seconds_remaining' => 's verbleibend',
        'export_completed' => 'Export abgeschlossen!',
        'download_starting' => 'Download wird gestartet...',
    ],
    'import' => [
        'description' => 'Importieren Sie Ihre Produktdaten aus CSV- oder Excel-Dateien.',
        'rules' => [
            'in' => ':attribute muss einer der definierten Werte sein: :values.',
            'required_string_max' => ':attribute ist erforderlich und muss ein String mit einer maximalen Länge von :max Zeichen sein.',
            'nullable_string' => ':attribute kann leer gelassen werden oder muss ein String sein, falls angegeben.',
            'nullable_string_max' => ':attribute kann leer gelassen werden oder muss ein String mit einer maximalen Länge von :max Zeichen sein, falls angegeben',
            'nullable_bool' => 'Ob :attribute leer gelassen werden kann oder ein boolescher Wert sein muss, falls angegeben.',
            'nullable_numeric_min' => ':attribute kann leer gelassen werden oder muss eine nicht-negative Zahl sein, falls angegeben.',
            'nullable_numeric_min_max' => ':attribute kann leer gelassen werden oder muss eine Zahl zwischen :min und :max sein, falls angegeben.',
            'nullable_array' => ':attribute kann leer gelassen werden oder muss als Array bereitgestellt werden, falls angegeben.',
            'nullable_date_required_if' => ':attribute kann leer gelassen werden oder muss ein gültiges Datum sein, falls angegeben, erforderlich wenn :required angegeben ist.',
            'nullable_date_after' => ':attribute kann leer gelassen werden oder muss ein gültiges Datum nach dem :after sein, falls angegeben.',
        ],
        'updated_message' => ':count Produkte erfolgreich aktualisiert!',
    ],
    'import_products_intro' => 'Oder Produkte aus CSV/Excel importieren',
    'select_attributes' => 'Attribute auswählen, um Variationen zu erstellen:',
    'all' => 'Alle',
    'copy' => 'Kopieren',
    'product_translations' => 'Produktübersetzungen',
];
