<?php

return [
    'save_settings' => 'Enregistrer les paramètres',
    'ecommerce' => 'E-commerce',
    'general' => [
        'name' => 'Général',
        'description' => 'Afficher et mettre à jour vos paramètres généraux',
    ],
    'currency' => [
        'name' => 'Devises',
        'description' => 'Afficher et mettre à jour les paramètres de devise',
        'currency_setting_description' => 'Afficher et mettre à jour les devises utilisées sur le site web',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Activer la détection automatique de la devise du visiteur',
            'enable_auto_detect_visitor_currency_helper' => 'Détecter automatiquement et afficher les prix dans la devise locale du visiteur en fonction de sa localisation. Cela offre une expérience d\'achat plus personnalisée.',
            'add_space_between_price_and_currency' => 'Ajouter un espace entre le prix et la devise',
            'add_space_between_price_and_currency_helper' => 'Lorsque activé, ajoute un espace entre la valeur du prix et le symbole de devise (ex. \"100 USD\" au lieu de \"100USD\").',
            'thousands_separator' => 'Séparateur de milliers',
            'thousands_separator_helper' => 'Choisissez le caractère pour séparer les milliers dans l\'affichage du prix (ex. 1 000 ou 1.000 ou 1,000).',
            'decimal_separator' => 'Séparateur décimal',
            'decimal_separator_helper' => 'Choisissez le caractère pour séparer les valeurs décimales dans les prix (ex. 10,99 ou 10.99).',
            'separator_period' => 'Point (.)',
            'separator_comma' => 'Virgule (,)',
            'separator_space' => 'Espace ( )',
            'api_key' => 'Clé API des taux de change',
            'api_key_helper' => 'Obtenez la clé API des taux de change sur :link',
            'update_currency_rates' => 'Mettre à jour les taux de change',
            'use_exchange_rate_from_api' => 'Utiliser le taux de change depuis l\'API',
            'clear_cache_rates' => 'Effacer le cache des taux',
            'auto_detect_visitor_currency_description' => 'Il détecte la devise du visiteur basée sur la langue du navigateur. Cela remplacera la sélection de devise par défaut.',
            'exchange_rate' => [
                'api_provider' => 'Fournisseur d\'API',
                'select' => '-- Sélectionner --',
                'none' => 'Aucun',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'ID d\'application Open Exchange Rates',
            ],
            'default_currency_warning' => 'Pour la devise par défaut, le taux de change doit être 1.',
        ],
    ],
    'product' => [
        'name' => 'Produits',
        'description' => 'Afficher et mettre à jour vos paramètres de produits',
        'product_settings' => 'Paramètres des produits',
        'product_settings_description' => 'Configurer les règles pour les produits',
        'form' => [
            'show_number_of_products' => 'Afficher le nombre de produits dans la page produit unique',
            'show_number_of_products_helper' => 'Afficher le nombre total de produits sur la page de détail du produit.',
            'show_out_of_stock_products' => 'Afficher les produits en rupture de stock',
            'show_out_of_stock_products_helper' => 'Si activé, les produits en rupture de stock seront affichés sur la page de liste des produits.',
            'how_to_display_product_variation_images' => 'Comment afficher les images de variation de produit',
            'how_to_display_product_variation_images_helper' => 'Choisir d\'afficher uniquement les images spécifiques à la variation ou d\'inclure les images de variation et du produit principal.',
            'only_variation_images' => 'Images de variation uniquement',
            'variation_images_and_main_product_images' => 'Images de variation et images du produit principal',
            'enable_product_options' => 'Activer les options de produit',
            'enable_product_options_helper' => 'Permettre aux produits d\'avoir des options personnalisables comme la taille, la couleur, etc.',
            'is_enabled_cross_sale_products' => 'Activer les produits de vente croisée',
            'is_enabled_cross_sale_products_helper' => 'Afficher les suggestions de produits de vente croisée pour encourager les achats supplémentaires.',
            'is_enabled_related_products' => 'Activer les produits connexes',
            'is_enabled_related_products_helper' => 'Afficher les produits connexes basés sur la catégorie, ou sélectionnés par l\'administrateur dans le formulaire produit.',
            'related_products_source' => 'Source des produits connexes',
            'related_products_source_helper' => 'Quand l\'administrateur ne sélectionne pas de produits connexes dans le formulaire produit, afficher les produits connexes basés sur cette source.',
            'related_products_source_category' => 'Même catégorie',
            'related_products_source_brand' => 'Même marque',
            'trending_products_period' => 'Période des produits tendance',
            'trending_products_period_helper' => 'Sélectionner la période à considérer pour calculer les produits tendance basés sur le nombre de vues.',
            'trending_products_period_1_day' => 'Dernières 24 heures',
            'trending_products_period_3_days' => '3 derniers jours',
            'trending_products_period_7_days' => '7 derniers jours (1 semaine)',
            'trending_products_period_14_days' => '14 derniers jours (2 semaines)',
            'trending_products_period_30_days' => '30 derniers jours (1 mois)',
            'trending_products_period_60_days' => '60 derniers jours (2 mois)',
            'trending_products_period_90_days' => '90 derniers jours (3 mois)',
            'auto_generate_product_sku' => 'Générer automatiquement le SKU lors de la création du produit',
            'auto_generate_product_sku_helper' => 'Générer automatiquement des SKU uniques pour les nouveaux produits basés sur le format ci-dessous.',
            'product_sku_format' => 'Format SKU',
            'product_sku_format_helper' => 'Vous pouvez utiliser %s (1 caractère de chaîne) ou %d (1 chiffre) dans le format pour générer une chaîne aléatoire. Ex: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Activer les spécifications de produit',
            'enable_product_specification_help' => 'Si activé, le tableau des spécifications de produit sera affiché sur la page de détail du produit.',
            'make_product_barcode_required' => 'Rendre le code-barres du produit obligatoire',
            'make_product_barcode_required_helper' => 'Si activé, le code-barres du produit sera obligatoire lors de la création d\'un produit.',
        ],
    ],
    'product_search' => [
        'name' => 'Recherche de Produits',
        'description' => 'Afficher et mettre à jour les paramètres de recherche de produits',
        'product_search_settings' => 'Recherche de produits',
        'product_search_settings_description' => 'Configurer les règles pour la recherche de produits',
        'form' => [
            'search_for_an_exact_phrase' => 'Rechercher une phrase exacte',
            'search_products_by' => 'Rechercher les produits par :',
            'enable_filter_products_by_categories' => 'Activer le filtrage des produits par catégories',
            'enable_filter_products_by_brands' => 'Activer le filtrage des produits par marques',
            'enable_filter_products_by_tags' => 'Activer le filtrage des produits par étiquettes',
            'number_of_popular_tags_for_filter' => 'Nombre d\'étiquettes populaires pour le filtre',
            'number_of_popular_tags_for_filter_placeholder' => 'Entrez le nombre d\'étiquettes populaires à afficher',
            'number_of_popular_tags_for_filter_helper' => 'Définir le nombre maximum d\'étiquettes populaires à afficher dans le filtre. Par défaut, c\'est 10.',
            'enable_filter_products_by_attributes' => 'Activer le filtrage des produits par attributs',
            'enable_filter_products_by_price' => 'Activer le filtrage des produits par prix',
            'max_product_price_for_filter' => 'Prix maximum du produit pour le filtre',
            'max_product_price_for_filter_placeholder' => 'Si c\'est vide ou zéro, il obtiendra le prix maximum du produit de vos produits existants.',
            'max_product_price_for_filter_helper' => 'Vous pouvez définir un prix fixe pour cela ou il obtiendra dynamiquement le prix maximum du produit de vos produits existants. Actuellement, c\'est :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Produits Numériques',
        'description' => 'Afficher et mettre à jour les paramètres des produits numériques',
        'digital_products_settings' => 'Produits numériques',
        'digital_products_settings_description' => 'Configurer les règles pour les produits numériques',
        'form' => [
            'enable_support_digital_product' => 'Est-il activé pour prendre en charge les produits numériques',
            'enable_support_digital_product_helper' => 'Lorsqu\'activé, le système prendra en charge la vente de produits numériques tels que des logiciels, des livres électroniques, de la musique et d\'autre contenu téléchargeable.',
            'allow_guest_checkout_for_digital_products' => 'Permettre la commande invité pour les produits numériques',
            'allow_guest_checkout_for_digital_products_helper' => 'Lorsqu\'activé, les clients peuvent acheter des produits numériques sans créer de compte. Ils recevront des liens de téléchargement par e-mail.',
            'disable_physical_product' => 'Désactiver les produits physiques',
            'disable_physical_product_helper' => 'Lorsqu\'activé, la boutique ne vendra que des produits numériques. Les options de produits physiques seront masquées des formulaires de produits et de la commande.',
            'enable_license_codes_for_digital_products' => 'Activer les codes de licence pour les produits numériques',
            'auto_complete_digital_orders_after_payment' => 'Compléter automatiquement les commandes numériques après paiement',
            'auto_complete_digital_orders_after_payment_helper' => 'Lorsqu\'activé, les commandes contenant uniquement des produits numériques seront automatiquement marquées comme terminées une fois le paiement reçu.',
            'enable_license_codes_for_digital_products_helper' => 'Lorsqu\'activé, vous pouvez ajouter des codes de licence aux produits numériques. Lorsque désactivé, la fonctionnalité de code de licence sera masquée des formulaires de produits.',
            'hide_used_license_codes_in_product_form' => 'Masquer les codes de licence utilisés dans le formulaire produit',
            'hide_used_license_codes_in_product_form_helper' => 'Lorsqu\'activé, les codes de licence utilisés seront masqués du tableau des codes de licence dans le formulaire d\'édition du produit. Cela aide à garder l\'interface propre lorsque vous avez beaucoup de codes utilisés.',
        ],
    ],
    'product_review' => [
        'name' => 'Avis sur les Produits',
        'description' => 'Afficher et mettre à jour vos paramètres d\'avis sur les produits',
        'form' => [
            'enable_review' => 'Activer les avis sur les produits',
            'enable_review_help' => 'Permettre aux clients de laisser des avis et des notes sur les produits. Lorsque désactivé, toutes les fonctionnalités d\'avis seront masquées de la boutique.',
            'allow_customer_upload_image_in_review' => 'Permettre aux clients de télécharger des images dans les avis',
            'allow_customer_upload_image_in_review_help' => 'Lorsque désactivé, les clients ne peuvent pas télécharger d\'images lors de la soumission d\'avis',
            'review' => [
                'max_file_size' => 'Taille maximale du fichier d\'avis (MB)',
                'max_file_number' => 'Nombre maximum de fichiers d\'avis',
            ],
            'only_allow_customers_purchased_to_review' => 'Seuls les clients qui ont acheté le produit peuvent donner un avis sur le produit',
            'review_need_to_be_approved' => 'L\'avis doit être approuvé avant d\'être affiché sur la page du produit',
            'show_customer_full_name' => 'Afficher le nom complet du client',
            'show_customer_full_name_help' => 'S\'il n\'est pas coché, le nom du client qui donne l\'avis sera masqué et remplacé par des astérisques (***)',
            'hide_rating_when_no_reviews' => 'Masquer la note quand il n\'y a pas d\'avis',
            'hide_rating_when_no_reviews_help' => 'Lorsqu\'activé, les notes des produits seront masquées dans les listes de produits et les pages de détail des produits lorsque le produit n\'a pas d\'avis',
            'display_uploaded_customer_review_images_list' => 'Afficher la section "Images des clients"',
            'display_uploaded_customer_review_images_list_help' => 'Lorsqu\'activé, affiche une galerie de toutes les images téléchargées par les clients en haut de la section des avis',
        ],
    ],
    'shopping' => [
        'name' => 'Shopping',
        'description' => 'Afficher et mettre à jour vos paramètres de shopping',
        'general_setting' => 'Paramètres généraux',
        'return_settings' => 'Paramètres de retour',
        'return_settings_description' => 'Configurer les règles pour les paramètres de retour',
        'form' => [
            'enable_cart' => 'Activer le panier d\'achat',
            'enable_cart_helper' => 'Si désactivé, le bouton panier sera supprimé, transformant votre site en affichage de catalogue uniquement.',
            'enable_wishlist' => 'Activer la liste de souhaits',
            'enable_wishlist_helper' => 'Si désactivé, le bouton liste de souhaits sera supprimé du site.',
            'enable_wishlist_sharing' => 'Activer le partage de liste de souhaits',
            'shared_wishlist_lifetime' => 'Durée de vie de la liste de souhaits partagée (jours)',
            'shared_wishlist_lifetime_helper' => 'La durée de vie de la liste de souhaits partagée en jours. Après ce temps, la liste de souhaits partagée sera supprimée.',
            'enable_compare' => 'Activer la comparaison',
            'enable_compare_helper' => 'Si désactivé, le bouton de comparaison sera supprimé du site.',
            'enable_order_tracking' => 'Activer le suivi des commandes',
            'enable_order_tracking_helper' => 'Les clients peuvent suivre leurs commandes en entrant le code de commande et l\'e-mail/téléphone sur :url',
            'order_tracking_method' => 'Méthode de suivi des commandes',
            'order_tracking_method_helper' => 'Choisir comment les clients suivront leurs commandes : en utilisant ID de commande + E-mail ou ID de commande + Numéro de téléphone.',
            'order_tracking_method_email' => 'ID de commande + E-mail',
            'order_tracking_method_phone' => 'ID de commande + Numéro de téléphone',
            'enable_quick_buy_button' => 'Activer le bouton d\'achat rapide',
            'enable_quick_buy_button_helper' => 'Il affichera un bouton Acheter Maintenant sur la liste des produits et la page de détail. Lorsque les clients cliquent sur ce bouton, le produit sera ajouté au panier et redirigé vers la page panier/commande.',
            'enable_order_auto_confirmed' => 'Confirmation automatique de commande',
            'enable_order_auto_confirmed_helper' => 'Si activé, la commande sera automatiquement confirmée après que le client passe une commande.',
            'quick_buy_target' => 'Page cible d\'achat rapide',
            'checkout_page' => 'Page de commande',
            'cart_page' => 'Page panier',
            'cart_destroy_on_logout' => 'Détruire le panier à la déconnexion',
            'cart_destroy_on_logout_helper' => 'Le panier sera détruit lorsque le client se déconnecte.',
            'hide_product_price' => 'Masquer le prix du produit',
            'hide_product_price_helper' => 'Cette option ne fonctionne que si vous désactivez le panier d\'achat, transformant votre site en affichage de catalogue uniquement. Si activé, le prix du produit sera masqué. C\'est utile lorsque vous voulez masquer le prix et exiger que les clients vous contactent pour le prix.',
            'enable_payment_proof' => 'Activer le téléchargement de preuve de paiement',
            'enable_payment_proof_helper' => 'Permettre aux clients de télécharger une preuve de paiement pour leurs commandes. C\'est utile pour les méthodes de paiement manuelles.',
            'enable_guest_payment_proof' => 'Permettre aux clients invités de télécharger une preuve de paiement',
            'enable_guest_payment_proof_helper' => 'Lorsqu\'activé, les clients invités peuvent télécharger une preuve de paiement en utilisant leur jeton de commande sans se connecter. Ils recevront le lien de téléchargement dans leur e-mail de confirmation de commande.',
        ],
    ],
    'checkout' => [
        'name' => 'Commande',
        'panel_description' => 'Afficher et mettre à jour les paramètres de commande',
        'description' => 'Configurer les règles pour les paramètres de commande',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Afficher les informations bancaires sur la page de succès de commande',
            'mandatory_form_fields_at_checkout' => 'Champs obligatoires à la page de commande :',
            'mandatory_form_fields_at_checkout_helper' => 'Sélectionner quels champs sont requis pendant la commande. Les clients doivent remplir ces champs pour terminer leur commande.',
            'hide_form_fields_at_checkout' => 'Masquer les champs client à la page de commande :',
            'hide_form_fields_at_checkout_helper' => 'Sélectionner quels champs doivent être masqués sur la page de commande. Ces champs ne seront pas visibles pour les clients.',
            'load_countries_states_cities_from_location_plugin' => 'Charger les pays, états, villes depuis le plugin de localisation',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Après avoir changé cette option, vous devez mettre à jour toutes les adresses à nouveau. Vous devriez le définir une fois.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Ensuite, vous devez aller dans Outils -> Importer/Exporter des Données pour importer les données de localisation.',
            'minimum_order_amount' => 'Montant minimum de commande pour passer une commande (:currency).',
            'minimum_order_amount_helper' => 'Définir le montant total minimum requis pour qu\'une commande soit traitée. Les commandes en dessous de ce montant ne seront pas acceptées.',
            'zip_code_enabled' => 'Activer le code postal',
            'zip_code_enabled_helper' => 'Activer ou désactiver le champ code postal dans le formulaire d\'adresse de livraison.',
            'billing_address_enabled' => 'Activer l\'adresse de facturation',
            'billing_address_enabled_helper' => 'Permettre aux clients d\'entrer une adresse de facturation séparée qui diffère de leur adresse de livraison.',
            'display_tax_fields_at_checkout_page' => 'Afficher les champs d\'informations fiscales à la page de commande',
            'display_tax_fields_at_checkout_page_helper' => 'Si activé, les champs d\'informations fiscales seront affichés pour entrer les détails fiscaux de l\'entreprise pour recevoir une facture.',
            'use_city_field_as_field_text' => 'Utiliser le champ ville comme champ de texte libre',
            'available_countries' => 'Pays disponibles',
            'all' => 'Tous',
            'all_helper_text' => 'Si vous décochez tous les pays, cela s\'appliquera à tous les pays.',
            'enable_guest_checkout' => 'Activer la commande invité',
            'enable_guest_checkout_helper' => 'Si activé, les clients peuvent passer une commande sans créer de compte.',
            'recently_viewed' => [
                'enable' => 'Activer les produits récemment vus par le client',
                'enable_helper' => 'Suivre et afficher les produits que les clients ont récemment vus. Cela aide les clients à trouver facilement les produits qui les intéressaient.',
                'max' => 'Nombre maximum de produits récemment vus par le client',
                'max_helper_text' => 'Si défini à 0, il n\'y aura pas de limite.',
            ],
            'minimum_order_quantity' => 'Quantité minimum de commande',
            'minimum_order_quantity_helper' => 'Quantité minimum pour passer une commande. Laissez à 0 si vous ne voulez pas le définir.',
            'maximum_order_quantity' => 'Quantité maximum de commande',
            'maximum_order_quantity_helper' => 'Quantité maximum pour passer une commande. Laissez à 0 si vous ne voulez pas le définir.',
            'default_country_at_checkout_page' => 'Pays par défaut à la page de commande',
            'default_country_at_checkout_page_placeholder' => 'Sélectionner un pays',
            'default_country_at_checkout_page_help' => 'Si vous sélectionnez un pays, le pays sera sélectionné par défaut à la page de commande.',
            'checkout_product_quantity_editable' => 'Permettre aux clients de modifier la quantité de produit à la page de commande',
            'checkout_product_quantity_editable_helper' => 'Lorsqu\'activé, les clients peuvent modifier la quantité de produits directement sur la page de commande sans retourner au panier.',
            'show_terms_and_policy_checkbox' => 'Afficher la case à cocher des conditions et politique',
            'show_terms_and_policy_checkbox_helper' => 'Si activé, les clients doivent accepter les conditions et la politique avant de passer une commande. Veuillez configurer d\'abord l\'URL des Conditions et de la Politique de Confidentialité dans Apparence -> Options du thème.',
            'terms_and_policy_checkbox_checked_by_default' => 'Case à cocher des conditions et politique cochée par défaut',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Si activé, la case à cocher des conditions et politique sera pré-cochée lorsque le formulaire de commande se charge.',
            'checkout_acceptance_message_enabled' => 'Afficher le message d\'acceptation de commande',
            'checkout_acceptance_message_enabled_helper' => 'Afficher un message informatif qui informe les clients des conditions qu\'ils acceptent en passant une commande.',
            'hide_customer_info_at_checkout' => 'Masquer les informations client à la commande',
            'hide_customer_info_at_checkout_helper' => 'Masquer les informations de compte client et le bouton de déconnexion de la page de commande. Lorsqu\'activé, les clients connectés ne verront pas leurs détails de compte affichés.',
        ],
    ],
    'return' => [
        'name' => 'Retour',
        'description' => 'Configurer les règles pour les paramètres de retour',
        'panel_description' => 'Afficher et mettre à jour les paramètres de retour',
        'form' => [
            'is_enabled_order_return' => 'Est activé le retour de commande',
            'allow_partial_return' => 'Permettre le retour partiel',
            'allow_partial_return_description' => 'Le client peut retourner quelques produits, pas besoin de retourner tous les produits d\'une commande.',
            'returnable_days' => 'Jours de retour',
            'return_settings_helper' => 'Nombre de jours qu\'un client peut demander un retour après que la commande soit terminée.',
        ],
    ],
    'invoice' => [
        'name' => 'Factures',
        'description' => 'Afficher et mettre à jour vos paramètres de factures',
        'company_settings' => 'Paramètres d\'entreprise',
        'company_settings_description' => 'Paramètres des informations d\'entreprise pour la facturation',
        'form' => [
            'company_name' => 'Nom de l\'entreprise',
            'company_name_placeholder' => 'Acme Société',
            'company_name_helper' => 'Le nom de votre entreprise ou société qui apparaîtra sur toutes les factures envoyées aux clients.',
            'company_address' => 'Adresse de l\'entreprise',
            'company_address_placeholder' => '123 Rue de la Paix, Bureau 100, 75001 Paris, France',
            'company_address_helper' => 'L\'adresse complète de votre entreprise incluant rue, ville, région et pays. Cela apparaîtra sur les factures.',
            'company_zipcode' => 'Code postal de l\'entreprise',
            'company_zipcode_placeholder' => '75001',
            'company_zipcode_helper' => 'Code postal de l\'adresse de votre entreprise.',
            'company_email' => 'E-mail de l\'entreprise',
            'company_email_placeholder' => 'facturation@societe.fr',
            'company_email_helper' => 'Adresse e-mail pour les demandes commerciales. Les clients peuvent l\'utiliser pour les questions liées aux factures.',
            'company_phone' => 'Téléphone de l\'entreprise',
            'company_phone_placeholder' => '+33 1 23 45 67 89',
            'company_phone_helper' => 'Numéro de téléphone de contact qui sera affiché sur les factures pour le support client.',
            'company_logo' => 'Logo de l\'entreprise',
            'company_logo_helper' => 'Le logo de votre entreprise qui sera affiché en haut des factures. Taille recommandée : 200x60 pixels.',
            'company_tax_id' => 'ID fiscal de l\'entreprise',
            'company_tax_id_placeholder' => 'TVA: FR12345678901',
            'company_tax_id_helper' => 'Votre numéro d\'identification fiscale d\'entreprise (TVA, SIRET, etc.) pour la conformité fiscale.',
            'invoice_code_prefix' => 'Préfixe du code de facture',
            'invoice_code_prefix_placeholder' => 'FACT-',
            'invoice_code_prefix_helper' => 'Préfixe ajouté avant les numéros de facture (ex: "FACT-" créera des codes de facture comme FACT-001, FACT-002).',
            'using_custom_font_for_invoice' => 'Utiliser une police personnalisée pour la facture',
            'using_custom_font_for_invoice_helper' => 'Activer pour utiliser une police Google personnalisée pour les PDF de factures au lieu de la police par défaut.',
            'invoice_font_family' => 'Famille de police de facture (Fonctionne uniquement pour les langues latines)',
            'invoice_font_family_helper' => 'Sélectionnez une police Google à utiliser dans les PDF de factures. Fonctionne uniquement avec les jeux de caractères latins.',
            'enable_invoice_stamp' => 'Activer le tampon de facture',
            'enable_invoice_stamp_helper' => 'Ajouter un tampon "PAYÉ" aux factures lorsque le paiement de la commande est terminé.',
            'add_language_support' => 'Ajouter le support de langue',
            'add_language_support_helper' => 'Choisir le support de jeu de caractères supplémentaire pour les langues non latines dans les PDF de factures.',
            'invoice_processing_library' => 'Bibliothèque de traitement de facture',
            'invoice_processing_library_helper' => 'Choisissez la bibliothèque de génération PDF. DomPDF est plus rapide mais a des fonctionnalités limitées. mPDF prend en charge plus de langues et de fonctionnalités mais peut être plus lent.',
            'only_latin_languages' => 'Langues latines uniquement',
            'disable_order_invoice_until_order_confirmed' => 'Désactiver la facture de commande jusqu\'à confirmation de commande',
            'disable_order_invoice_until_order_confirmed_helper' => 'Lorsqu\'activé, les factures ne seront disponibles qu\'après confirmation des commandes, pas immédiatement après la passation.',
            'date_format' => 'Format de date',
            'date_format_helper' => 'Choisissez comment les dates seront affichées sur les factures (ex: "F d, Y" affiche "Janvier 01, 2024").',
            'languages' => [
                'arabic' => 'Arabe',
                'bangladesh' => 'Bengali',
                'chinese' => 'Chinois',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Taxe',
        'description' => 'Paramètres de taxe',
        'enable' => 'Activer la taxe ?',
        'display_product_price_including_taxes' => 'Afficher le prix du produit incluant les taxes ?',
        'display_tax_description' => 'Afficher les informations fiscales sur le prix du produit ?',
        'display_tax_description_help' => 'Afficher du texte comme "(Y compris X% TVA)" ou "(Hors X% TVA)" à côté des prix des produits sur la page de détail du produit.',
        'tax_included_in_products_price' => 'Taxe incluse dans le prix des produits',
        'tax_included_in_products_price_description' => 'La taxe sera incluse dans le prix des produits',
        'tax_setting' => 'Paramètres de taxe',
        'tax_setting_description' => 'Configurer les paramètres de taxe',
        'tax_management' => 'Gestion des taxes',
        'tax_management_description' => 'Afficher et gérer vos taxes',
        'form' => [
            'enable_tax' => 'Activer la taxe',
            'display_company_invoice_information_fields_at_checkout_page' => 'Afficher les champs d\'informations de facture d\'entreprise à la page de commande',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Si activé, les champs d\'informations de facture d\'entreprise seront affichés à la page de commande. Il est obligatoire de remplir les champs d\'informations de facture d\'entreprise.',
            'default_tax_rate' => 'Taux de taxe par défaut',
            'default_tax_rate_description' => 'Important : il sera appliqué si aucune taxe n\'est sélectionnée dans le produit.',
            'select_tax' => '-- Sélectionner --',
            'display_product_price_including_taxes' => 'Afficher le prix du produit incluant les taxes',
        ],
    ],
    'customer' => [
        'name' => 'Clients',
        'description' => 'Afficher et mettre à jour vos paramètres de clients',
        'customer_setting' => 'Paramètres client',
        'customer_setting_description' => 'Configurer les paramètres client',
        'form' => [
            'enable_customer_registration' => 'Activer l\'inscription client',
            'enable_customer_registration_helper' => 'Si désactivé, les clients ne pourront pas enregistrer de nouveaux comptes. Les clients existants peuvent toujours se connecter.',
            'verify_customer_email' => 'Vérifier l\'e-mail du client',
            'verify_customer_email_helper' => 'Lorsqu\'activé, un lien de vérification sera envoyé à l\'e-mail du client, les clients doivent cliquer sur ce lien pour vérifier leur e-mail avant de pouvoir se connecter. Besoin de configurer l\'e-mail dans Admin -> Paramètres -> E-mail pour envoyer la vérification d\'e-mail.',
            'verification_expire_minutes' => 'Temps d\'expiration du lien de vérification',
            'verification_expire_minutes_helper' => 'Le temps en minutes pendant lequel le lien de vérification d\'e-mail sera valide. Par défaut, c\'est 60 minutes (1 heure). Maximum 10080 minutes (7 jours).',
            'login_using_phone' => 'Se connecter avec le numéro de téléphone au lieu de l\'e-mail',
            'login_option' => 'Option de connexion',
            'login_with_email' => 'Connexion avec e-mail',
            'login_with_phone' => 'Connexion avec téléphone',
            'login_with_email_or_phone' => 'Connexion avec e-mail ou téléphone',
            'enabled_customer_account_deletion' => 'Activer la suppression de compte client',
            'enabled_customer_account_deletion_helper' => 'Lorsqu\'activé, les clients peuvent supprimer leur compte dans tableau de bord client → Paramètres de compte.',
            'enabled_customer_dob_field' => 'Activer le champ date de naissance du client',
            'enabled_customer_dob_field_helper' => 'Lorsqu\'activé, les clients peuvent entrer leur date de naissance dans tableau de bord client → Paramètres de compte.',
            'enabled_phone_field_in_registration_form' => 'Activer le champ téléphone dans le formulaire d\'inscription',
            'enabled_phone_field_in_registration_form_helper' => 'Lorsqu\'activé, le champ téléphone sera ajouté au formulaire d\'inscription.',
            'make_customer_phone_number_required' => 'Rendre le numéro de téléphone client obligatoire',
            'make_customer_phone_number_required_helper' => 'Lorsqu\'activé, les clients doivent entrer leur numéro de téléphone lors de l\'inscription. C\'est toujours obligatoire pour les clients se connectant avec un numéro de téléphone.',
            'default_avatar' => 'Avatar par défaut',
            'default_avatar_helper' => 'Avatar par défaut pour le client quand il n\'a pas d\'avatar. Si vous ne sélectionnez aucune image, il sera généré en utilisant votre logo ou le premier caractère du nom du client.',
            'keep_email_field_in_registration_form' => 'Garder le champ e-mail dans le formulaire d\'inscription',
            'keep_email_field_in_registration_form_helper' => 'Lorsque désactivé, le champ e-mail sera masqué dans le formulaire d\'inscription quand l\'option de connexion est "Connexion avec téléphone".',
        ],
    ],
    'shipping' => [
        'name' => 'Livraison',
        'description' => 'Afficher et mettre à jour les paramètres de livraison',
        'shipping_rule' => 'Règles de livraison',
        'shipping_rule_description' => 'Configurer les règles pour calculer les frais de livraison',
        'shipping_setting' => 'Paramètres de livraison',
        'shipping_setting_description' => 'Configurer les paramètres de livraison',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Masquer les autres options de livraison s\'il y a la livraison gratuite dans la liste',
            'disable_shipping_options' => 'Désactiver les options de livraison',
            'disable_shipping_options_helper' => 'Les options de livraison seront supprimées à la page de commande, le client ne pourra pas sélectionner d\'options de livraison.',
            'sort_shipping_options_direction' => 'Direction de tri des options de livraison',
            'sort_shipping_options_direction_helper' => 'Trier les options de livraison par prix du plus bas au plus haut ou du plus haut au plus bas.',
            'price_lower_to_higher' => 'Prix du plus bas au plus haut',
            'price_higher_to_lower' => 'Prix du plus haut au plus bas',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Configurer les paramètres de webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'Configurer les URL de webhook pour recevoir des notifications pour divers événements de commande',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook commande passée (méthode : POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Pour recevoir des notifications lorsqu\'une commande est passée, vous pouvez configurer une URL webhook externe. Si vous avez une URL webhook externe, vous pouvez entrer cette URL, ou simplement la laisser vide.',
            'order_updated_webhook_url' => 'URL webhook commande mise à jour (méthode : POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Pour recevoir des notifications lorsqu\'une commande est mise à jour, vous pouvez configurer une URL webhook externe. Cela inclut les changements de statut, les mises à jour d\'adresse et autres modifications de commande.',
            'shipping_status_updated_webhook_url' => 'URL webhook statut de livraison mis à jour (méthode : POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Pour recevoir des notifications lorsque le statut de livraison change (ex: expédié, livré, annulé), vous pouvez configurer une URL webhook externe.',
            'order_completed_webhook_url' => 'URL webhook commande terminée (méthode : POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Pour recevoir des notifications lorsqu\'une commande est terminée, vous pouvez configurer une URL webhook externe.',
            'order_cancelled_webhook_url' => 'URL webhook commande annulée (méthode : POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Pour recevoir des notifications lorsqu\'une commande est annulée, vous pouvez configurer une URL webhook externe.',
            'payment_status_updated_webhook_url' => 'URL webhook statut de paiement mis à jour (méthode : POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Pour recevoir des notifications lorsque le statut de paiement change (ex: payé, échoué, remboursé), vous pouvez configurer une URL webhook externe.',
            'abandoned_cart_webhook_url' => 'URL webhook panier abandonné (méthode : POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Pour recevoir des notifications lorsque les paniers sont abandonnés et faire un suivi avec les clients, vous pouvez configurer une URL webhook externe. Les notifications sont envoyées après une période configurable.',
        ],
        'test_button' => 'Tester Webhook',
        'test_success' => 'Test de webhook réussi ! Le point de terminaison a répondu correctement.',
        'test_failed' => 'Test de webhook échoué. Le point de terminaison n\'a pas répondu comme attendu.',
        'test_error' => 'Erreur de test de webhook : :error',
        'please_enter_url' => 'Veuillez d\'abord entrer une URL de webhook',
        'testing' => 'Test en cours...',
        'test_failed_title' => 'Test Échoué !',
        'test_success_title' => 'Test Réussi !',
        'status_code' => 'Code de Statut',
        'error_occurred' => 'Une erreur s\'est produite lors du test du webhook',
    ],
    'store_locator' => [
        'name' => 'Localisateurs de magasins',
        'description' => 'Afficher et mettre à jour les listes de vos chaînes',
        'store_locator_description' => 'Toutes les listes de vos chaînes, magasins principaux, succursales, etc. Les emplacements peuvent être utilisés pour suivre les ventes et nous aider à configurer les taux de taxe à facturer lors de la vente de produits.',
        'form' => [
            'change_primary_store' => 'changer le localisateur de magasin par défaut',
            'add_location' => 'Ajouter un emplacement',
            'edit_location' => 'Modifier l\'emplacement',
            'delete_location' => 'Supprimer l\'emplacement',
            'delete_location_confirmation' => 'Êtes-vous sûr de vouloir supprimer cet emplacement ? Cette action ne peut pas être annulée.',
            'change_primary_location' => 'Changer l\'emplacement principal',
            'save_location' => 'Enregistrer l\'emplacement',
            'add_new' => 'Ajouter nouveau',
        ],
    ],
    'tracking' => [
        'name' => 'Suivi',
        'description' => 'Afficher et mettre à jour les paramètres de suivi',
        'manage_tracking' => 'Gérer le suivi',
        'manage_tracking_description' => 'Gérer le suivi : UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Activer Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Allez sur https://developers.facebook.com/docs/meta-pixel pour créer Facebook Pixel. Assurez-vous que votre pixel est actif et correctement configuré.',
            'facebook_pixel_id' => 'ID Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Exemple : 1234567890123456',
            'facebook_pixel_debug_mode' => 'Activer le mode débogage Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Activer le mode débogage pour enregistrer les événements Facebook Pixel dans la console du navigateur et résoudre les problèmes de suivi',
            'enable_google_tag_manager_tracking_events' => 'Activer les événements de suivi Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Lorsqu\'activé, les événements e-commerce seront suivis via Google Tag Manager. Assurez-vous d\'avoir configuré Google Tag Manager ci-dessus.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'L\'ID Facebook Pixel doit contenir 15-16 chiffres (ex: 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Marketplace',
        'description' => 'Afficher et mettre à jour les paramètres de marketplace',
    ],
    'standard_and_format' => [
        'name' => 'Standard et Format',
        'panel_description' => 'Afficher et mettre à jour les paramètres de standard et format',
        'description' => 'Les standards et formats sont utilisés pour calculer des choses comme les prix des produits, les poids de livraison et les heures de commande.',
        'form' => [
            'change_order_format' => 'Modifier le format du code de commande (optionnel)',
            'change_order_format_description' => 'Le code de commande par défaut commence à : numéro. Vous pouvez changer la chaîne de début ou de fin pour créer le code de commande que vous voulez, par exemple "DH-: numéro" ou ": numéro-A"',
            'start_with' => 'Commencer par',
            'end_with' => 'Finir par',
            'order_will_be_shown' => 'Votre code de commande sera affiché',
            'weight_unit' => 'Unité de poids',
            'height_unit' => 'Unité longueur / hauteur',
            'weight_unit_gram' => 'Gramme (g)',
            'weight_unit_kilogram' => 'Kilogramme (kg)',
            'weight_unit_lb' => 'Livre (lb)',
            'weight_unit_oz' => 'Once (oz)',
            'height_unit_cm' => 'Centimètre (cm)',
            'height_unit_m' => 'Mètre (m)',
            'height_unit_inch' => 'Pouce',
        ],
    ],
    'sale_popup' => [
        'name' => 'Popup de Vente',
        'description' => 'Personnalisez facilement vos paramètres de popup de vente',
    ],
    'flash_sale' => [
        'name' => 'Vente Flash',
        'description' => 'Configurer les paramètres de vente flash pour offrir des remises promotionnelles limitées dans le temps',
        'enable' => 'Activer la fonctionnalité de vente flash',
        'enable_helper' => 'Lorsqu\'activé, vous pouvez créer et gérer des ventes flash avec des prix spéciaux réduits pour une période limitée.',
        'show_sale_count_left' => 'Afficher le tracker d\'inventaire',
        'show_sale_count_left_description' => 'Afficher une barre de progression avec "X vendu sur Y" pour créer une urgence et encourager les achats rapides pendant les ventes flash.',
    ],
    'payment_method_cod_minimum_amount' => 'Montant minimum de commande - :currency (Optionnel)',
    'payment_method_minimum_amount' => 'Montant minimum de commande - :currency (Optionnel)',
    'display_bank_info_at_the_checkout_success_page' => 'Afficher les informations bancaires sur la page de succès de commande ?',
    'invoice_templates' => 'Modèles de facture',
];