<?php

return [
    'save_settings' => '設定を保存',
    'ecommerce' => 'Ecommerce',
    'general' => [
        'name' => '一般',
        'description' => '一般設定を表示・更新します',
    ],
    'currency' => [
        'name' => '通貨',
        'description' => '通貨設定を表示・更新します',
        'currency_setting_description' => 'ウェブサイトで使用される通貨を表示・更新します',
        'form' => [
            'enable_auto_detect_visitor_currency' => '訪問者通貨の自動検出を有効にする',
            'enable_auto_detect_visitor_currency_helper' => '訪問者の位置に基づいて自動的に現地通貨を検出し、価格を表示します。これにより、よりパーソナライズされたショッピング体験を提供します。',
            'add_space_between_price_and_currency' => '価格と通貨の間にスペースを追加',
            'add_space_between_price_and_currency_helper' => '有効にすると、価格値と通貨記号の間にスペースを追加します（例：\"100USD\"ではなく\"100 USD\"）。',
            'thousands_separator' => '千の位区切り文字',
            'thousands_separator_helper' => '価格表示で千単位を区切る文字を選択してください（例：1,000 または 1.000 または 1 000）。',
            'decimal_separator' => '小数点区切り文字',
            'decimal_separator_helper' => '価格の小数値を区切る文字を選択してください（例：10.99 または 10,99）。',
            'separator_period' => 'ピリオド（.）',
            'separator_comma' => 'カンマ（,）',
            'separator_space' => 'スペース（ ）',
            'api_key' => 'API為替レートキー',
            'api_key_helper' => ':link で為替レートAPIキーを取得',
            'update_currency_rates' => '通貨レートを更新',
            'use_exchange_rate_from_api' => 'APIからの為替レートを使用',
            'use_exchange_rate_from_api_helper' => '設定されたAPIプロバイダーから自動的に通貨為替レートを更新します。これにより、価格が常に現在の市場レートで最新の状態に保たれます。',
            'clear_cache_rates' => 'キャッシュレートをクリア',
            'auto_detect_visitor_currency_description' => 'ブラウザ言語に基づいて訪問者の通貨を検出します。デフォルトの通貨選択を上書きします。',
            'exchange_rate' => [
                'api_provider' => 'APIプロバイダー',
                'select' => '-- 選択 --',
                'none' => 'なし',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'デフォルト通貨の場合、為替レートは1である必要があります。',
        ],
    ],
    'product' => [
        'name' => '商品',
        'description' => '商品設定を表示・更新します',
        'product_settings' => '商品設定',
        'product_settings_description' => '商品のルールを設定',
        'form' => [
            'show_number_of_products' => '商品詳細ページで商品数を表示',
            'show_number_of_products_helper' => '商品詳細ページに総商品数を表示します。',
            'show_out_of_stock_products' => '在庫切れ商品を表示',
            'show_out_of_stock_products_helper' => '有効にした場合、在庫切れ商品が商品一覧ページに表示されます。',
            'how_to_display_product_variation_images' => '商品バリエーション画像の表示方法',
            'how_to_display_product_variation_images_helper' => 'バリエーション専用画像のみを表示するか、バリエーション画像とメイン商品画像の両方を含めるかを選択します。',
            'only_variation_images' => 'バリエーション画像のみ',
            'variation_images_and_main_product_images' => 'バリエーション画像とメイン商品画像',
            'enable_product_options' => '商品オプションを有効にする',
            'enable_product_options_helper' => '商品にサイズ、色などのカスタマイズ可能なオプションを持たせることができます。',
            'is_enabled_cross_sale_products' => 'クロスセール商品を有効にする',
            'is_enabled_cross_sale_products_helper' => '追加購入を促すためのクロスセール商品提案を表示します。',
            'is_enabled_related_products' => '関連商品を有効にする',
            'is_enabled_related_products_helper' => 'カテゴリに基づく関連商品、または商品フォームで管理者が選択した関連商品を表示します。',
            'related_products_source' => '関連商品のソース',
            'related_products_source_helper' => '管理者が商品フォームで関連商品を選択していない場合、このソースに基づいて関連商品を表示します。',
            'related_products_source_category' => '同じカテゴリ',
            'related_products_source_brand' => '同じブランド',
            'trending_products_period' => 'トレンド商品の期間',
            'trending_products_period_helper' => '閲覧数に基づいてトレンド商品を計算するための期間を選択します。',
            'trending_products_period_1_day' => '過去24時間',
            'trending_products_period_3_days' => '過去3日間',
            'trending_products_period_7_days' => '過去7日間（1週間）',
            'trending_products_period_14_days' => '過去14日間（2週間）',
            'trending_products_period_30_days' => '過去30日間（1ヶ月）',
            'trending_products_period_60_days' => '過去60日間（2ヶ月）',
            'trending_products_period_90_days' => '過去90日間（3ヶ月）',
            'auto_generate_product_sku' => '商品作成時にSKUを自動生成',
            'auto_generate_product_sku_helper' => '以下のフォーマットに基づいて新商品の一意のSKUを自動生成します。',
            'product_sku_format' => 'SKUフォーマット',
            'product_sku_format_helper' => 'フォーマットで%s（1文字）または%d（1桁）を使用してランダム文字列を生成できます。例：SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => '商品仕様を有効にする',
            'enable_product_specification_help' => '有効にした場合、商品仕様テーブルが商品詳細ページに表示されます。',
            'make_product_barcode_required' => '商品バーコードを必須にする',
            'make_product_barcode_required_helper' => '有効にした場合、商品作成時に商品バーコードが必須になります。',
        ],
    ],
    'product_search' => [
        'name' => '商品検索',
        'description' => '商品検索設定を表示・更新します',
        'product_search_settings' => '商品検索',
        'product_search_settings_description' => '商品検索のルールを設定',
        'form' => [
            'search_for_an_exact_phrase' => '完全一致フレーズで検索',
            'search_products_by' => '商品検索対象:',
            'enable_filter_products_by_categories' => 'カテゴリによる商品フィルタを有効にする',
            'enable_filter_products_by_brands' => 'ブランドによる商品フィルタを有効にする',
            'enable_filter_products_by_tags' => 'タグによる商品フィルタを有効にする',
            'number_of_popular_tags_for_filter' => 'フィルタ用人気タグ数',
            'number_of_popular_tags_for_filter_placeholder' => '表示する人気タグ数を入力',
            'number_of_popular_tags_for_filter_helper' => 'フィルタに表示する人気タグの最大数を設定します。デフォルトは10です。',
            'enable_filter_products_by_attributes' => '属性による商品フィルタを有効にする',
            'enable_filter_products_by_price' => '価格による商品フィルタを有効にする',
            'max_product_price_for_filter' => 'フィルタ用最大商品価格',
            'max_product_price_for_filter_placeholder' => '空白または0の場合、既存商品から最大商品価格を取得します。',
            'max_product_price_for_filter_helper' => 'これに固定価格を設定するか、既存商品から最大商品価格を動的に取得します。現在は:priceです。',
        ],
    ],
    'digital_product' => [
        'name' => 'デジタル商品',
        'description' => 'デジタル商品設定を表示・更新します',
        'digital_products_settings' => 'デジタル商品',
        'digital_products_settings_description' => 'デジタル商品のルールを設定',
        'form' => [
            'enable_support_digital_product' => 'デジタル商品サポートを有効にする',
            'enable_support_digital_product_helper' => '有効にした場合、システムはソフトウェア、電子書籍、音楽、その他ダウンロード可能なコンテンツなどのデジタル商品の販売をサポートします。',
            'allow_guest_checkout_for_digital_products' => 'デジタル商品のゲストチェックアウトを許可',
            'allow_guest_checkout_for_digital_products_helper' => '有効にした場合、顧客はアカウントを作成せずにデジタル商品を購入できます。ダウンロードリンクはメールで受け取ります。',
            'disable_physical_product' => '物理商品を無効にする',
            'disable_physical_product_helper' => '有効にした場合、ショップはデジタル商品のみを販売します。物理商品のオプションは商品フォームとチェックアウトから非表示になります。',
            'enable_license_codes_for_digital_products' => 'デジタル商品のライセンスコードを有効にする',
            'auto_complete_digital_orders_after_payment' => '支払い後にデジタル注文を自動完了',
            'auto_complete_digital_orders_after_payment_helper' => '有効にした場合、デジタル商品のみを含む注文は、支払い受領後に自動的に完了としてマークされます。',
            'enable_license_codes_for_digital_products_helper' => '有効にした場合、デジタル商品にライセンスコードを追加できます。無効にした場合、ライセンスコード機能は商品フォームから非表示になります。',
            'hide_used_license_codes_in_product_form' => '商品フォームで使用済みライセンスコードを非表示',
            'hide_used_license_codes_in_product_form_helper' => '有効にした場合、使用済みライセンスコードは商品編集フォームのライセンスコードテーブルから非表示になります。多くの使用済みコードがある場合にインターフェースをきれいに保ちます。',
        ],
    ],
    'product_review' => [
        'name' => '商品レビュー',
        'description' => '商品レビュー設定を表示・更新します',
        'form' => [
            'enable_review' => '商品レビューを有効にする',
            'enable_review_help' => '顧客が商品にレビューと評価を残すことを許可します。無効にした場合、すべてのレビュー機能がショップから非表示になります。',
            'allow_customer_upload_image_in_review' => 'レビューでの顧客画像アップロードを許可',
            'allow_customer_upload_image_in_review_help' => '無効にした場合、顧客はレビュー投稿時に画像をアップロードできません',
            'review' => [
                'max_file_size' => 'レビュー最大ファイルサイズ（MB）',
                'max_file_number' => 'レビュー最大ファイル数',
            ],
            'only_allow_customers_purchased_to_review' => '商品を購入した顧客のみが商品をレビューできる',
            'review_need_to_be_approved' => '商品ページに表示する前にレビューの承認が必要',
            'show_customer_full_name' => '顧客のフルネームを表示',
            'show_customer_full_name_help' => 'チェックを外した場合、レビューした顧客の名前は非表示になり、アスタリスク（***）に置き換えられます',
            'hide_rating_when_no_reviews' => 'レビューがない場合は評価を非表示',
            'hide_rating_when_no_reviews_help' => '有効にした場合、商品にレビューがない時に商品一覧と商品詳細ページで商品評価が非表示になります',
            'display_uploaded_customer_review_images_list' => '「顧客からの画像」セクションを表示',
            'display_uploaded_customer_review_images_list_help' => '有効にした場合、レビューセクションの上部に顧客がアップロードしたすべての画像のギャラリーを表示します',
        ],
    ],
    'shopping' => [
        'name' => 'ショッピング',
        'description' => 'ショッピング設定を表示・更新します',
        'general_setting' => '一般設定',
        'return_settings' => '返品設定',
        'return_settings_description' => '返品設定のルールを設定',
        'form' => [
            'enable_cart' => 'ショッピングカートを有効にする',
            'enable_cart_helper' => '無効にした場合、カートボタンが削除され、サイトがカタログ専用表示になります。',
            'enable_wishlist' => 'ウィッシュリストを有効にする',
            'enable_wishlist_helper' => '無効にした場合、ウィッシュリストボタンがサイトから削除されます。',
            'enable_wishlist_sharing' => 'ウィッシュリスト共有を有効にする',
            'shared_wishlist_lifetime' => '共有ウィッシュリストの有効期間（日）',
            'shared_wishlist_lifetime_helper' => '共有ウィッシュリストの有効期間（日数）。この期間後、共有ウィッシュリストは削除されます。',
            'enable_compare' => '比較を有効にする',
            'enable_compare_helper' => '無効にした場合、比較ボタンがサイトから削除されます。',
            'enable_order_tracking' => '注文追跡を有効にする',
            'enable_order_tracking_helper' => '顧客は:urlで注文コードとメール/電話を入力して注文を追跡できます',
            'order_tracking_method' => '注文追跡方法',
            'order_tracking_method_helper' => '顧客の注文追跡方法を選択：注文ID+メールまたは注文ID+電話番号を使用。',
            'order_tracking_method_email' => '注文ID+メール',
            'order_tracking_method_phone' => '注文ID+電話番号',
            'enable_quick_buy_button' => 'クイック購入ボタンを有効にする',
            'enable_quick_buy_button_helper' => '商品一覧と詳細ページに今すぐ購入ボタンを表示します。顧客がこのボタンをクリックすると、商品がカートに追加され、カート/チェックアウトページにリダイレクトします。',
            'enable_order_auto_confirmed' => '注文自動確認',
            'enable_order_auto_confirmed_helper' => '有効にした場合、顧客が注文した後に注文が自動的に確認されます。',
            'quick_buy_target' => 'クイック購入対象ページ',
            'checkout_page' => 'チェックアウトページ',
            'cart_page' => 'カートページ',
            'cart_destroy_on_logout' => 'ログアウト時にカートを破棄',
            'cart_destroy_on_logout_helper' => '顧客がログアウトした時にカートが破棄されます。',
            'hide_product_price' => '商品価格を非表示',
            'hide_product_price_helper' => 'このオプションはショッピングカートを無効にしてサイトをカタログ専用表示にした場合にのみ機能します。有効にした場合、商品価格が非表示になります。価格を非表示にして顧客に価格について問い合わせを求めたい場合に便利です。',
            'enable_payment_proof' => '支払い証明アップロードを有効にする',
            'enable_payment_proof_helper' => '顧客が注文の支払い証明をアップロードできるようにします。手動支払い方法に便利です。',
            'enable_guest_payment_proof' => 'ゲスト顧客の支払い証明アップロードを許可',
            'enable_guest_payment_proof_helper' => '有効にした場合、ゲスト顧客はログインせずに注文トークンを使用して支払い証明をアップロードできます。注文確認メールでアップロードリンクを受け取ります。',
        ],
    ],
    'checkout' => [
        'name' => 'チェックアウト',
        'panel_description' => 'チェックアウト設定を表示・更新します',
        'description' => 'チェックアウト設定のルールを設定',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'チェックアウト成功ページで銀行情報を表示',
            'mandatory_form_fields_at_checkout' => 'チェックアウトページでの必須フィールド:',
            'mandatory_form_fields_at_checkout_helper' => 'チェックアウト時に必要なフィールドを選択します。顧客は注文を完了するためにこれらのフィールドを入力する必要があります。',
            'hide_form_fields_at_checkout' => 'チェックアウトページで非表示にする顧客フィールド:',
            'hide_form_fields_at_checkout_helper' => 'チェックアウトページで非表示にするフィールドを選択します。これらのフィールドは顧客に表示されません。',
            'load_countries_states_cities_from_location_plugin' => 'ロケーションプラグインから国、州、市を読み込み',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'このオプションを変更した後、すべての住所を再度更新する必要があります。一度設定してください。',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'その後、ツール → インポート/エクスポートデータに移動してロケーションデータをインポートする必要があります。',
            'minimum_order_amount' => '注文の最小金額（:currency）',
            'minimum_order_amount_helper' => '注文が処理されるために必要な最小合計金額を設定します。この金額を下回る注文は受け付けられません。',
            'zip_code_enabled' => '郵便番号を有効にする',
            'zip_code_enabled_helper' => '配送先住所フォームで郵便番号フィールドを有効または無効にします。',
            'billing_address_enabled' => '請求先住所を有効にする',
            'billing_address_enabled_helper' => '顧客が配送先住所とは異なる請求先住所を入力できるようにします。',
            'display_tax_fields_at_checkout_page' => 'チェックアウトページで税務情報フィールドを表示',
            'display_tax_fields_at_checkout_page_helper' => '有効にした場合、請求書を受け取るために会社の税務詳細を入力する税務情報フィールドが表示されます。',
            'use_city_field_as_field_text' => '市区町村フィールドを自由テキストフィールドとして使用',
            'available_countries' => '利用可能な国',
            'all' => 'すべて',
            'all_helper_text' => 'すべての国のチェックを外した場合、すべての国に適用されます。',
            'enable_guest_checkout' => 'ゲストチェックアウトを有効にする',
            'enable_guest_checkout_helper' => '有効にした場合、顧客はアカウントを作成せずに注文できます。',
            'recently_viewed' => [
                'enable' => '顧客の最近閲覧した商品を有効にする',
                'enable_helper' => '顧客が最近閲覧した商品を追跡・表示します。これにより顧客が興味を持った商品を簡単に見つけることができます。',
                'max' => '顧客の最近閲覧した商品の最大数',
                'max_helper_text' => '0に設定した場合、制限はありません。',
            ],
            'minimum_order_quantity' => '最小注文数量',
            'minimum_order_quantity_helper' => '注文する最小数量。設定したくない場合は0にしてください。',
            'maximum_order_quantity' => '最大注文数量',
            'maximum_order_quantity_helper' => '注文する最大数量。設定したくない場合は0にしてください。',
            'default_country_at_checkout_page' => 'チェックアウトページのデフォルト国',
            'default_country_at_checkout_page_placeholder' => '国を選択',
            'default_country_at_checkout_page_help' => '国を選択した場合、チェックアウトページでその国がデフォルトで選択されます。',
            'checkout_product_quantity_editable' => 'チェックアウトページで顧客の商品数量変更を許可',
            'checkout_product_quantity_editable_helper' => '有効にした場合、顧客はカートに戻ることなくチェックアウトページで直接商品の数量を変更できます。',
            'show_terms_and_policy_checkbox' => '利用規約とポリシーのチェックボックスを表示',
            'show_terms_and_policy_checkbox_helper' => '有効にした場合、顧客は注文前に利用規約とポリシーに同意する必要があります。まず外観 → テーマオプションで利用規約とプライバシーポリシーURLを設定してください。',
            'terms_and_policy_checkbox_checked_by_default' => '利用規約とポリシーのチェックボックスをデフォルトでチェック',
            'terms_and_policy_checkbox_checked_by_default_helper' => '有効にした場合、チェックアウトフォームが読み込まれたときに利用規約とポリシーのチェックボックスが事前にチェックされます。',
            'checkout_acceptance_message_enabled' => 'チェックアウト同意メッセージを表示',
            'checkout_acceptance_message_enabled_helper' => '注文することで同意する条件について顧客に知らせる情報メッセージを表示します。',
            'hide_customer_info_at_checkout' => 'チェックアウトで顧客情報を非表示',
            'hide_customer_info_at_checkout_helper' => 'チェックアウトページから顧客アカウント情報とログアウトボタンを非表示にします。有効にした場合、ログイン済み顧客はアカウント詳細が表示されません。',
        ],
    ],
    'return' => [
        'name' => '返品',
        'description' => '返品設定のルールを設定',
        'panel_description' => '返品設定を表示・更新します',
        'form' => [
            'is_enabled_order_return' => '注文返品を有効にする',
            'allow_partial_return' => '部分返品を許可',
            'allow_partial_return_description' => '顧客は一部の商品を返品でき、注文のすべての商品を返品する必要はありません。',
            'returnable_days' => '返品可能日数',
            'return_settings_helper' => '注文完了後に顧客が返品をリクエストできる日数。',
        ],
    ],
    'invoice' => [
        'name' => '請求書',
        'description' => '請求書設定を表示・更新します',
        'company_settings' => '会社設定',
        'company_settings_description' => '請求書作成のための会社情報設定',
        'form' => [
            'company_name' => '会社名',
            'company_name_helper' => 'お客様に送信されるすべての請求書に表示される会社名または事業名。',
            'company_name_placeholder' => 'アクメ株式会社',
            'company_address' => '会社住所',
            'company_address_helper' => '番地、市区町村、都道府県、国を含む会社の完全な住所。これは請求書に表示されます。',
            'company_address_placeholder' => '〒100-0001 東京都千代田区千代田1-1-1',
            'company_zipcode' => '会社郵便番号',
            'company_zipcode_helper' => '会社住所の郵便番号。',
            'company_zipcode_placeholder' => '100-0001',
            'company_email' => '会社メールアドレス',
            'company_email_helper' => 'ビジネスに関するお問い合わせ用のメールアドレス。お客様は請求書関連の質問に使用できます。',
            'company_email_placeholder' => 'invoice@company.co.jp',
            'company_phone' => '会社電話番号',
            'company_phone_helper' => 'カスタマーサポート用に請求書に表示される連絡先電話番号。',
            'company_phone_placeholder' => '+81 3-1234-5678',
            'company_logo' => '会社ロゴ',
            'company_logo_helper' => '請求書の上部に表示される会社のロゴ。推奨サイズ：200x60ピクセル。',
            'company_tax_id' => '会社税務ID',
            'company_tax_id_helper' => '税務コンプライアンスのための事業税識別番号（法人番号、登録番号など）。',
            'company_tax_id_placeholder' => '法人番号: 1234567890123',
            'invoice_code_prefix' => '請求書コード接頭辞',
            'invoice_code_prefix_helper' => '請求書番号の前に追加される接頭辞（例：「INV-」はINV-001、INV-002のような請求書コードを作成します）。',
            'invoice_code_prefix_placeholder' => 'INV-',
            'using_custom_font_for_invoice' => '請求書にカスタムフォントを使用',
            'using_custom_font_for_invoice_helper' => '有効にすると、デフォルトフォントの代わりに請求書PDFにカスタムGoogleフォントを使用します。',
            'invoice_font_family' => '請求書フォントファミリー（ラテン言語のみ対応）',
            'invoice_font_family_helper' => '請求書PDFで使用するGoogleフォントを選択します。ラテン文字セットでのみ動作します。',
            'enable_invoice_stamp' => '請求書スタンプを有効にする',
            'enable_invoice_stamp_helper' => '注文の支払いが完了したときに請求書に「支払済」スタンプを追加します。',
            'add_language_support' => '言語サポートを追加',
            'add_language_support_helper' => '請求書PDFの非ラテン言語用の追加文字セットサポートを選択します。',
            'invoice_processing_library' => '請求書処理ライブラリ',
            'invoice_processing_library_helper' => 'PDF生成ライブラリを選択します。DomPDFは高速ですが機能が限定的です。mPDFはより多くの言語と機能をサポートしますが、遅い場合があります。',
            'only_latin_languages' => 'ラテン言語のみ',
            'disable_order_invoice_until_order_confirmed' => '注文確認まで注文請求書を無効にする',
            'disable_order_invoice_until_order_confirmed_helper' => '有効にすると、請求書は注文確認後にのみ利用可能になり、注文直後には利用できません。',
            'date_format' => '日付フォーマット',
            'date_format_helper' => '請求書に日付を表示する方法を選択します（例：「F d, Y」は「1月 01, 2024」と表示されます）。',
            'languages' => [
                'arabic' => 'アラビア語',
                'bangladesh' => 'ベンガル語',
                'chinese' => '中国語',
            ],
        ],
    ],
    'tax' => [
        'name' => '税金',
        'description' => '税金設定',
        'enable' => '税金を有効にしますか？',
        'display_product_price_including_taxes' => '商品価格を税込みで表示しますか？',
        'display_tax_description' => '商品価格に税金情報を表示しますか？',
        'display_tax_description_help' => '商品詳細ページで商品価格の横に「（X% GST込み）」や「（X% GST別）」などのテキストを表示します。',
        'tax_included_in_products_price' => '商品価格に税金を含める',
        'tax_included_in_products_price_description' => '税金が商品価格に含まれます',
        'tax_setting' => '税金設定',
        'tax_setting_description' => '税金設定を構成',
        'tax_management' => '税金管理',
        'tax_management_description' => '税金を表示・管理します',
        'form' => [
            'enable_tax' => '税金を有効にする',
            'display_company_invoice_information_fields_at_checkout_page' => 'チェックアウトページで会社請求書情報フィールドを表示',
            'display_company_invoice_information_fields_at_checkout_page_helper' => '有効にした場合、チェックアウトページに会社請求書情報フィールドが表示されます。会社請求書情報フィールドへの入力が必要です。',
            'default_tax_rate' => 'デフォルト税率',
            'default_tax_rate_description' => '重要: 商品で税金が選択されていない場合に適用されます。',
            'select_tax' => '-- 選択 --',
            'display_product_price_including_taxes' => '商品価格を税込みで表示',
        ],
    ],
    'customer' => [
        'name' => '顧客',
        'description' => '顧客設定を表示・更新します',
        'customer_setting' => '顧客設定',
        'customer_setting_description' => '顧客設定を構成',
        'form' => [
            'enable_customer_registration' => '顧客登録を有効にする',
            'enable_customer_registration_helper' => '無効にした場合、顧客は新しいアカウントを登録できません。既存顧客はログインできます。',
            'verify_customer_email' => '顧客のメールを認証',
            'verify_customer_email_helper' => '有効にした場合、顧客のメールに認証リンクが送信され、顧客はログインする前にこのリンクをクリックしてメールを認証する必要があります。メール認証を送信するには管理者 → 設定 → メールでメールを設定する必要があります。',
            'verification_expire_minutes' => '認証リンク有効期限',
            'verification_expire_minutes_helper' => 'メール認証リンクが有効な時間（分）。デフォルトは60分（1時間）。最大は10080分（7日間）。',
            'login_using_phone' => 'メールの代わりに電話番号でサインイン',
            'login_option' => 'ログインオプション',
            'login_with_email' => 'メールでログイン',
            'login_with_phone' => '電話番号でログイン',
            'login_with_email_or_phone' => 'メールまたは電話番号でログイン',
            'enabled_customer_account_deletion' => '顧客アカウント削除を有効にする',
            'enabled_customer_account_deletion_helper' => '有効にした場合、顧客は顧客ダッシュボード → アカウント設定でアカウントを削除できます。',
            'enabled_customer_dob_field' => '顧客生年月日フィールドを有効にする',
            'enabled_customer_dob_field_helper' => '有効にした場合、顧客は顧客ダッシュボード → アカウント設定で生年月日を入力できます。',
            'enabled_phone_field_in_registration_form' => '登録フォームで電話番号フィールドを有効にする',
            'enabled_phone_field_in_registration_form_helper' => '有効にした場合、登録フォームに電話番号フィールドが追加されます。',
            'make_customer_phone_number_required' => '顧客電話番号を必須にする',
            'make_customer_phone_number_required_helper' => '有効にした場合、顧客は登録時に電話番号を入力する必要があります。電話番号でログインする顧客には常に必須です。',
            'default_avatar' => 'デフォルトアバター',
            'default_avatar_helper' => 'アバターを持たない顧客のデフォルトアバター。画像を選択しない場合、ロゴまたは顧客名の最初の文字を使用して生成されます。',
            'keep_email_field_in_registration_form' => '登録フォームでメールフィールドを保持',
            'keep_email_field_in_registration_form_helper' => '無効にした場合、ログインオプションが「電話番号でログイン」の時に登録フォームでメールフィールドが非表示になります。',
        ],
    ],
    'shipping' => [
        'name' => '配送',
        'description' => '配送設定を表示・更新します',
        'shipping_rule' => '配送ルール',
        'shipping_rule_description' => '配送料計算のルールを設定',
        'shipping_setting' => '配送設定',
        'shipping_setting_description' => '配送設定を構成',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'リストに送料無料がある場合、他の配送オプションを非表示',
            'disable_shipping_options' => '配送オプションを無効にする',
            'disable_shipping_options_helper' => '配送オプションがチェックアウトページから削除され、顧客は配送オプションを選択できません。',
            'sort_shipping_options_direction' => '配送オプションソート方向',
            'sort_shipping_options_direction_helper' => '配送オプションを価格の安い順から高い順、または高い順から安い順でソートします。',
            'price_lower_to_higher' => '価格安い順から高い順',
            'price_higher_to_lower' => '価格高い順から安い順',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Webhook設定を構成',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => '様々な注文イベントの通知を受信するためのWebhook URLを設定',
        'form' => [
            'order_placed_webhook_url' => '注文配置WebhookURL（メソッド: POST）',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => '注文が配置された時の通知を受信するために、外部WebhookURLを設定できます。外部WebhookURLがある場合はこのURLを入力するか、空のままにしてください。',
            'order_updated_webhook_url' => '注文更新WebhookURL（メソッド: POST）',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => '注文が更新された時の通知を受信するために、外部WebhookURLを設定できます。これにはステータス変更、住所更新、その他の注文変更が含まれます。',
            'shipping_status_updated_webhook_url' => '配送状況更新WebhookURL（メソッド: POST）',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => '配送状況が変更された時（例：配送済み、配送完了、キャンセル済み）の通知を受信するために、外部WebhookURLを設定できます。',
            'order_completed_webhook_url' => '注文完了WebhookURL（メソッド: POST）',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => '注文が完了した時の通知を受信するために、外部WebhookURLを設定できます。',
            'order_cancelled_webhook_url' => '注文キャンセルWebhookURL（メソッド: POST）',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => '注文がキャンセルされた時の通知を受信するために、外部WebhookURLを設定できます。',
            'payment_status_updated_webhook_url' => '支払い状況更新WebhookURL（メソッド: POST）',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => '支払い状況が変更された時（例：支払済み、失敗、返金済み）の通知を受信するために、外部WebhookURLを設定できます。',
            'abandoned_cart_webhook_url' => 'カート放棄WebhookURL（メソッド: POST）',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'カートが放棄され顧客にフォローアップする際の通知を受信するために、外部WebhookURLを設定できます。通知は設定可能な期間後に送信されます。',
        ],
        'test_button' => 'Webhookをテスト',
        'test_success' => 'Webhookテスト成功！エンドポイントが正しく応答しました。',
        'test_failed' => 'Webhookテスト失敗。エンドポイントが期待通りに応答しませんでした。',
        'test_error' => 'Webhookテストエラー: :error',
        'please_enter_url' => 'まずWebhookURLを入力してください',
        'testing' => 'テスト中...',
        'test_failed_title' => 'テスト失敗！',
        'test_success_title' => 'テスト成功！',
        'status_code' => 'ステータスコード',
        'error_occurred' => 'Webhookのテスト中にエラーが発生しました',
    ],
    'store_locator' => [
        'name' => '店舗検索',
        'description' => 'チェーン店舗リストを表示・更新します',
        'store_locator_description' => 'すべてのチェーン店舗、メイン店舗、支店などのリスト。これらの場所は売上追跡や、商品販売時に請求する税率の設定に使用できます。',
        'form' => [
            'change_primary_store' => 'デフォルト店舗検索を変更',
            'add_location' => '場所を追加',
            'edit_location' => '場所を編集',
            'delete_location' => '場所を削除',
            'delete_location_confirmation' => 'この場所を削除してもよろしいですか？この操作は元に戻せません。',
            'change_primary_location' => 'プライマリー場所を変更',
            'save_location' => '場所を保存',
            'add_new' => '新規追加',
        ],
    ],
    'tracking' => [
        'name' => 'トラッキング',
        'description' => 'トラッキング設定を表示・更新します',
        'manage_tracking' => 'トラッキング管理',
        'manage_tracking_description' => 'トラッキング管理: UTM、Facebook、Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Facebook Pixel（Meta Pixel）を有効にする',
            'facebook_pixel_helper' => 'https://developers.facebook.com/docs/meta-pixel に移動してFacebook Pixelを作成してください。ピクセルがアクティブで適切に設定されていることを確認してください。',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => '例: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Facebook Pixelデバッグモードを有効にする',
            'facebook_pixel_debug_mode_helper' => 'デバッグモードを有効にしてFacebook Pixelイベントをブラウザコンソールにログし、トラッキング問題をトラブルシューティングします',
            'enable_google_tag_manager_tracking_events' => 'Google Tag Managerトラッキングイベントを有効にする',
            'google_tag_manager_tracking_info' => '有効にした場合、EコマースイベントがGoogle Tag Managerを通じて追跡されます。上記でGoogle Tag Managerを設定していることを確認してください。',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel IDは15-16桁である必要があります（例: 1234567890123456）',
        ],
    ],
    'marketplace' => [
        'name' => 'マーケットプレイス',
        'description' => 'マーケットプレイス設定を表示・更新します',
    ],
    'standard_and_format' => [
        'name' => '標準とフォーマット',
        'panel_description' => '標準とフォーマット設定を表示・更新します',
        'description' => '標準とフォーマットは商品価格、配送重量、注文時間などの計算に使用されます。',
        'form' => [
            'change_order_format' => '注文コードフォーマットを編集（任意）',
            'change_order_format_description' => 'デフォルトの注文コードは番号から始まります。希望する注文コードを作成するために開始または終了文字列を変更できます。例："DH-:番号"または":番号-A"',
            'start_with' => '開始文字',
            'end_with' => '終了文字',
            'order_will_be_shown' => '注文コードは次のように表示されます',
            'weight_unit' => '重量単位',
            'height_unit' => '長さ/高さ単位',
            'weight_unit_gram' => 'グラム（g）',
            'weight_unit_kilogram' => 'キログラム（kg）',
            'weight_unit_lb' => 'ポンド（lb）',
            'weight_unit_oz' => 'オンス（oz）',
            'height_unit_cm' => 'センチメートル（cm）',
            'height_unit_m' => 'メートル（m）',
            'height_unit_inch' => 'インチ',
        ],
    ],
    'sale_popup' => [
        'name' => 'セールポップアップ',
        'description' => 'セールポップアップ設定を簡単にカスタマイズ',
    ],
    'flash_sale' => [
        'name' => 'フラッシュセール',
        'description' => '期間限定プロモーション割引を提供するためのフラッシュセール設定を構成',
        'enable' => 'フラッシュセール機能を有効にする',
        'enable_helper' => '有効にした場合、期間限定で特別割引価格のフラッシュセールを作成・管理できます。',
        'show_sale_count_left' => '在庫トラッカーを表示',
        'show_sale_count_left_description' => 'フラッシュセール中に緊急性を演出し迅速な購入を促すために「Y個中X個売り切れ」のプログレスバーを表示します。',
    ],
    'payment_method_cod_minimum_amount' => '最小注文金額 - :currency（任意）',
    'payment_method_minimum_amount' => '最小注文金額 - :currency（任意）',
    'display_bank_info_at_the_checkout_success_page' => 'チェックアウト成功ページで銀行情報を表示しますか？',
    'invoice_templates' => '請求書テンプレート',
];