<?php

return [
    'save_settings' => 'บันทึกการตั้งค่า',
    'ecommerce' => 'อีคอมเมิร์ซ',
    'general' => [
        'name' => 'ทั่วไป',
        'description' => 'ดูและอัปเดตการตั้งค่าทั่วไปของคุณ',
    ],
    'currency' => [
        'name' => 'สกุลเงิน',
        'description' => 'ดูและอัปเดตการตั้งค่าสกุลเงิน',
        'currency_setting_description' => 'ดูและอัปเดตสกุลเงินที่ใช้ในเว็บไซต์',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'เปิดใช้งานการตรวจสอบสกุลเงินผู้เยี่ยมชมอัตโนมัติ',
            'enable_auto_detect_visitor_currency_helper' => 'ตรวจจับและแสดงราคาในสกุลเงินท้องถิ่นของผู้เยี่ยมชมโดยอัตโนมัติตามตำแหน่งที่ตั้ง ซึ่งช่วยให้ประสบการณ์การช้อปปิ้งเป็นส่วนตัวมากขึ้น',
            'add_space_between_price_and_currency' => 'เพิ่มช่องว่างระหว่างราคาและสกุลเงิน',
            'add_space_between_price_and_currency_helper' => 'เมื่อเปิดใช้งาน จะเพิ่มช่องว่างระหว่างค่าราคาและสัญลักษณ์สกุลเงิน (เช่น \"100 USD\" แทนที่จะเป็น \"100USD\")',
            'thousands_separator' => 'ตัวคั่นหลักพัน',
            'thousands_separator_helper' => 'เลือกอักขระเพื่อแยกหลักพันในการแสดงราคา (เช่น 1,000 หรือ 1.000 หรือ 1 000)',
            'decimal_separator' => 'ตัวคั่นทศนิยม',
            'decimal_separator_helper' => 'เลือกอักขระเพื่อแยกค่าทศนิยมในราคา (เช่น 10.99 หรือ 10,99)',
            'separator_period' => 'จุด (.)',
            'separator_comma' => 'จุลภาค (,)',
            'separator_space' => 'ช่องว่าง ( )',
            'api_key' => 'คีย์ API อัตราแลกเปลี่ยน',
            'api_key_helper' => 'รับคีย์ API อัตราแลกเปลี่ยนได้ที่ :link',
            'update_currency_rates' => 'อัปเดตอัตราแลกเปลี่ยนสกุลเงิน',
            'use_exchange_rate_from_api' => 'ใช้อัตราแลกเปลี่ยนจาก API',
            'use_exchange_rate_from_api_helper' => 'เปิดใช้งานการอัปเดตอัตราแลกเปลี่ยนสกุลเงินอัตโนมัติจากผู้ให้บริการ API ที่กำหนดค่าไว้ ซึ่งทำให้มั่นใจได้ว่าราคาของคุณจะอัปเดตด้วยอัตราตลาดปัจจุบันเสมอ',
            'clear_cache_rates' => 'ล้างแคชอัตราแลกเปลี่ยน',
            'auto_detect_visitor_currency_description' => 'ตรวจสอบสกุลเงินผู้เยี่ยมชมตามภาษาของเบราว์เซอร์ จะแทนที่การเลือกสกุลเงินเริ่มต้น',
            'exchange_rate' => [
                'api_provider' => 'ผู้ให้บริการ API',
                'select' => '-- เลือก --',
                'none' => 'ไม่มี',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'สำหรับสกุลเงินเริ่มต้น อัตราแลกเปลี่ยนต้องเป็น 1',
        ],
    ],
    'product' => [
        'name' => 'สินค้า',
        'description' => 'ดูและอัปเดตการตั้งค่าสินค้าของคุณ',
        'product_settings' => 'การตั้งค่าสินค้า',
        'product_settings_description' => 'กำหนดค่ากฎสำหรับสินค้า',
        'form' => [
            'show_number_of_products' => 'แสดงจำนวนสินค้าในหน้าสินค้าเดี่ยว',
            'show_number_of_products_helper' => 'แสดงจำนวนสินค้าทั้งหมดในหน้ารายละเอียดสินค้า',
            'show_out_of_stock_products' => 'แสดงสินค้าที่หมดสต็อก',
            'show_out_of_stock_products_helper' => 'หากเปิดใช้งาน สินค้าที่หมดสต็อกจะแสดงในหน้ารายการสินค้า',
            'how_to_display_product_variation_images' => 'วิธีการแสดงรูปภาพรูปแบบสินค้า',
            'how_to_display_product_variation_images_helper' => 'เลือกว่าจะแสดงเฉพาะรูปภาพเฉพาะรูปแบบหรือรวมทั้งรูปภาพรูปแบบและสินค้าหลัก',
            'only_variation_images' => 'เฉพาะรูปภาพรูปแบบ',
            'variation_images_and_main_product_images' => 'รูปภาพรูปแบบและรูปภาพสินค้าหลัก',
            'enable_product_options' => 'เปิดใช้งานตัวเลือกสินค้า',
            'enable_product_options_helper' => 'อนุญาตให้สินค้ามีตัวเลือกที่ปรับแต่งได้ เช่น ขนาด สี ฯลฯ',
            'is_enabled_cross_sale_products' => 'เปิดใช้งานสินค้าขายไขว้',
            'is_enabled_cross_sale_products_helper' => 'แสดงข้อเสนอแนะสินค้าขายไขว้เพื่อส่งเสริมการซื้อเพิ่มเติม',
            'is_enabled_related_products' => 'เปิดใช้งานสินค้าที่เกี่ยวข้อง',
            'is_enabled_related_products_helper' => 'แสดงสินค้าที่เกี่ยวข้องตามหมวดหมู่ หรือที่เลือกโดยผู้ดูแลระบบในฟอร์มสินค้า',
            'related_products_source' => 'แหล่งสินค้าที่เกี่ยวข้อง',
            'related_products_source_helper' => 'เมื่อผู้ดูแลระบบไม่เลือกสินค้าที่เกี่ยวข้องในฟอร์มสินค้า แสดงสินค้าที่เกี่ยวข้องตามแหล่งนี้',
            'related_products_source_category' => 'หมวดหมู่เดียวกัน',
            'related_products_source_brand' => 'ยี่ห้อเดียวกัน',
            'trending_products_period' => 'ช่วงเวลาสินค้าที่กำลังนิยม',
            'trending_products_period_helper' => 'เลือกช่วงเวลาที่พิจารณาสำหรับการคำนวณสินค้าที่กำลังนิยมตามจำนวนการดู',
            'trending_products_period_1_day' => '24 ชั่วโมงที่ผ่านมา',
            'trending_products_period_3_days' => '3 วันที่ผ่านมา',
            'trending_products_period_7_days' => '7 วันที่ผ่านมา (1 สัปดาห์)',
            'trending_products_period_14_days' => '14 วันที่ผ่านมา (2 สัปดาห์)',
            'trending_products_period_30_days' => '30 วันที่ผ่านมา (1 เดือน)',
            'trending_products_period_60_days' => '60 วันที่ผ่านมา (2 เดือน)',
            'trending_products_period_90_days' => '90 วันที่ผ่านมา (3 เดือน)',
            'auto_generate_product_sku' => 'สร้าง SKU อัตโนมัติเมื่อสร้างสินค้า',
            'auto_generate_product_sku_helper' => 'สร้าง SKU ที่ไม่ซ้ำโดยอัตโนมัติสำหรับสินค้าใหม่ตามรูปแบบด้านล่าง',
            'product_sku_format' => 'รูปแบบ SKU',
            'product_sku_format_helper' => 'คุณสามารถใช้ %s (1 ตัวอักษร) หรือ %d (1 หลัก) ในรูปแบบเพื่อสร้างสตริงสุ่ม เช่น: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'เปิดใช้งานสเปคสินค้า',
            'enable_product_specification_help' => 'หากเปิดใช้งาน ตารางสเปคสินค้าจะแสดงในหน้ารายละเอียดสินค้า',
            'make_product_barcode_required' => 'ทำให้บาร์โค้ดสินค้าเป็นข้อมูลที่จำเป็น',
            'make_product_barcode_required_helper' => 'หากเปิดใช้งาน บาร์โค้ดสินค้าจะเป็นข้อมูลที่จำเป็นเมื่อสร้างสินค้า',
        ],
    ],
    'product_search' => [
        'name' => 'การค้นหาสินค้า',
        'description' => 'ดูและอัปเดตการตั้งค่าการค้นหาสินค้า',
        'product_search_settings' => 'การค้นหาสินค้า',
        'product_search_settings_description' => 'กำหนดค่ากฎสำหรับการค้นหาสินค้า',
        'form' => [
            'search_for_an_exact_phrase' => 'ค้นหาวลีที่แน่นอน',
            'search_products_by' => 'ค้นหาสินค้าโดย:',
            'enable_filter_products_by_categories' => 'เปิดใช้งานการกรองสินค้าตามหมวดหมู่',
            'enable_filter_products_by_brands' => 'เปิดใช้งานการกรองสินค้าตามยี่ห้อ',
            'enable_filter_products_by_tags' => 'เปิดใช้งานการกรองสินค้าตามแท็ก',
            'number_of_popular_tags_for_filter' => 'จำนวนแท็กยอดนิยมสำหรับการกรอง',
            'number_of_popular_tags_for_filter_placeholder' => 'ใส่จำนวนแท็กยอดนิยมที่จะแสดง',
            'number_of_popular_tags_for_filter_helper' => 'กำหนดจำนวนสูงสุดของแท็กยอดนิยมที่จะแสดงในตัวกรอง ค่าเริ่มต้นคือ 10',
            'enable_filter_products_by_attributes' => 'เปิดใช้งานการกรองสินค้าตามคุณสมบัติ',
            'enable_filter_products_by_price' => 'เปิดใช้งานการกรองสินค้าตามราคา',
            'max_product_price_for_filter' => 'ราคาสินค้าสูงสุดสำหรับการกรอง',
            'max_product_price_for_filter_placeholder' => 'หากเป็นค่าว่างหรือศูนย์ จะได้ราคาสินค้าสูงสุดจากสินค้าที่มีอยู่',
            'max_product_price_for_filter_helper' => 'คุณสามารถกำหนดราคาคงที่สำหรับสิ่งนี้หรือจะได้ราคาสินค้าสูงสุดจากสินค้าที่มีอยู่แบบไดนามิก ปัจจุบันคือ :price',
        ],
    ],
    'digital_product' => [
        'name' => 'สินค้าดิจิทัล',
        'description' => 'ดูและอัปเดตการตั้งค่าสินค้าดิจิทัล',
        'digital_products_settings' => 'สินค้าดิจิทัล',
        'digital_products_settings_description' => 'กำหนดค่ากฎสำหรับสินค้าดิจิทัล',
        'form' => [
            'enable_support_digital_product' => 'เปิดใช้งานการสนับสนุนสินค้าดิจิทัล',
            'enable_support_digital_product_helper' => 'เมื่อเปิดใช้งาน ระบบจะสนับสนุนการขายสินค้าดิจิทัล เช่น ซอฟต์แวร์ อีบุ๊ก เพลง และเนื้อหาที่ดาวน์โหลดได้อื่นๆ',
            'allow_guest_checkout_for_digital_products' => 'อนุญาตให้แขกชำระเงินสำหรับสินค้าดิจิทัล',
            'allow_guest_checkout_for_digital_products_helper' => 'เมื่อเปิดใช้งาน ลูกค้าสามารถซื้อสินค้าดิจิทัลโดยไม่ต้องสร้างบัญชี พวกเขาจะได้รับลิงก์ดาวน์โหลดทางอีเมล',
            'disable_physical_product' => 'ปิดใช้งานสินค้าทางกายภาพ',
            'disable_physical_product_helper' => 'เมื่อเปิดใช้งาน ร้านค้าจะขายเฉพาะสินค้าดิจิทัล ตัวเลือกสินค้าทางกายภาพจะถูกซ่อนจากฟอร์มสินค้าและการชำระเงิน',
            'enable_license_codes_for_digital_products' => 'เปิดใช้งานรหัสลิขสิทธิ์สำหรับสินค้าดิจิทัล',
            'auto_complete_digital_orders_after_payment' => 'ทำคำสั่งซื้อดิจิทัลให้เสร็จสมบูรณ์อัตโนมัติหลังการชำระเงิน',
            'auto_complete_digital_orders_after_payment_helper' => 'เมื่อเปิดใช้งาน คำสั่งซื้อที่มีเฉพาะสินค้าดิจิทัลจะถูกทำเครื่องหมายเป็นเสร็จสมบูรณ์โดยอัตโนมัติเมื่อได้รับการชำระเงิน',
            'enable_license_codes_for_digital_products_helper' => 'เมื่อเปิดใช้งาน คุณสามารถเพิ่มรหัสลิขสิทธิ์ให้กับสินค้าดิจิทัล เมื่อปิดใช้งาน ฟังก์ชันรหัสลิขสิทธิ์จะถูกซ่อนจากฟอร์มสินค้า',
            'hide_used_license_codes_in_product_form' => 'ซ่อนรหัสลิขสิทธิ์ที่ใช้แล้วในฟอร์มสินค้า',
            'hide_used_license_codes_in_product_form_helper' => 'เมื่อเปิดใช้งาน รหัสลิขสิทธิ์ที่ใช้แล้วจะถูกซ่อนจากตารางรหัสลิขสิทธิ์ในฟอร์มแก้ไขสินค้า ช่วยให้อินเตอร์เฟซสะอาดเมื่อมีรหัสที่ใช้แล้วจำนวนมาก',
        ],
    ],
    'product_review' => [
        'name' => 'รีวิวสินค้า',
        'description' => 'ดูและอัปเดตการตั้งค่ารีวิวสินค้าของคุณ',
        'form' => [
            'enable_review' => 'เปิดใช้งานรีวิวสินค้า',
            'enable_review_help' => 'อนุญาตให้ลูกค้าเขียนรีวิวและให้คะแนนสินค้า เมื่อปิดใช้งาน ฟีเจอร์รีวิวทั้งหมดจะถูกซ่อนจากร้านค้า',
            'allow_customer_upload_image_in_review' => 'อนุญาตให้ลูกค้าอัปโหลดรูปภาพในรีวิว',
            'allow_customer_upload_image_in_review_help' => 'เมื่อปิดใช้งาน ลูกค้าไม่สามารถอัปโหลดรูปภาพเมื่อส่งรีวิว',
            'review' => [
                'max_file_size' => 'ขนาดไฟล์สูงสุดสำหรับรีวิว (MB)',
                'max_file_number' => 'จำนวนไฟล์สูงสุดสำหรับรีวิว',
            ],
            'only_allow_customers_purchased_to_review' => 'อนุญาตเฉพาะลูกค้าที่ซื้อสินค้าแล้วให้รีวิวสินค้าได้',
            'review_need_to_be_approved' => 'รีวิวจำเป็นต้องได้รับการอนุมัติก่อนแสดงในหน้าสินค้า',
            'show_customer_full_name' => 'แสดงชื่อเต็มของลูกค้า',
            'show_customer_full_name_help' => 'หากไม่เลือก ชื่อของลูกค้าที่รีวิวจะถูกซ่อนและแทนที่ด้วยดอกจัน (***)',
            'hide_rating_when_no_reviews' => 'ซ่อนคะแนนเมื่อไม่มีรีวิว',
            'hide_rating_when_no_reviews_help' => 'เมื่อเปิดใช้งาน คะแนนสินค้าจะถูกซ่อนในรายการสินค้าและหน้ารายละเอียดสินค้าเมื่อสินค้าไม่มีรีวิว',
            'display_uploaded_customer_review_images_list' => 'แสดงส่วน "รูปภาพจากลูกค้า"',
            'display_uploaded_customer_review_images_list_help' => 'เมื่อเปิดใช้งาน แสดงแกลเลอรี่ของรูปภาพทั้งหมดที่ลูกค้าอัปโหลดที่ด้านบนของส่วนรีวิว',
        ],
    ],
    'shopping' => [
        'name' => 'การช้อปปิ้ง',
        'description' => 'ดูและอัปเดตการตั้งค่าการช้อปปิ้งของคุณ',
        'general_setting' => 'การตั้งค่าทั่วไป',
        'return_settings' => 'การตั้งค่าการคืนสินค้า',
        'return_settings_description' => 'กำหนดค่ากฎสำหรับการตั้งค่าการคืนสินค้า',
        'form' => [
            'enable_cart' => 'เปิดใช้งานตะกร้าสินค้า',
            'enable_cart_helper' => 'หากปิดใช้งาน ปุ่มตะกร้าจะถูกลบ ทำให้เว็บไซต์ของคุณกลายเป็นการแสดงแค็ตตาล็อกเท่านั้น',
            'enable_wishlist' => 'เปิดใช้งานรายการโปรด',
            'enable_wishlist_helper' => 'หากปิดใช้งาน ปุ่มรายการโปรดจะถูกลบจากเว็บไซต์',
            'enable_wishlist_sharing' => 'เปิดใช้งานการแชร์รายการโปรด',
            'shared_wishlist_lifetime' => 'อายุการใช้งานรายการโปรดที่แชร์ (วัน)',
            'shared_wishlist_lifetime_helper' => 'อายุการใช้งานของรายการโปรดที่แชร์เป็นวัน หลังจากเวลานี้ รายการโปรดที่แชร์จะถูกลบ',
            'enable_compare' => 'เปิดใช้งานการเปรียบเทียب',
            'enable_compare_helper' => 'หากปิดใช้งาน ปุ่มเปรียบเทียบจะถูกลบจากเว็บไซต์',
            'enable_order_tracking' => 'เปิดใช้งานการติดตามคำสั่งซื้อ',
            'enable_order_tracking_helper' => 'ลูกค้าสามารถติดตามคำสั่งซื้อของพวกเขาโดยการใส่รหัสคำสั่งซื้อและอีเมล/โทรศัพท์ที่ :url',
            'order_tracking_method' => 'วิธีการติดตามคำสั่งซื้อ',
            'order_tracking_method_helper' => 'เลือกวิธีที่ลูกค้าจะติดตามคำสั่งซื้อ: ใช้รหัสคำสั่งซื้อ + อีเมล หรือรหัสคำสั่งซื้อ + หมายเลขโทรศัพท์',
            'order_tracking_method_email' => 'รหัสคำสั่งซื้อ + อีเมล',
            'order_tracking_method_phone' => 'รหัสคำสั่งซื้อ + หมายเลขโทรศัพท์',
            'enable_quick_buy_button' => 'เปิดใช้งานปุ่มซื้อด่วน',
            'enable_quick_buy_button_helper' => 'จะแสดงปุ่มซื้อเลยในหน้ารายการสินค้าและรายละเอียดสินค้า เมื่อลูกค้าคลิกปุ่มนี้ สินค้าจะถูกเพิ่มเข้าตะกร้าและเปลี่ยนเส้นทางไปยังหน้าตะกร้า/ชำระเงิน',
            'enable_order_auto_confirmed' => 'ยืนยันคำสั่งซื้ออัตโนมัติ',
            'enable_order_auto_confirmed_helper' => 'หากเปิดใช้งาน คำสั่งซื้อจะได้รับการยืนยันโดยอัตโนมัติหลังจากลูกค้าสั่งซื้อ',
            'quick_buy_target' => 'หน้าเป้าหมายการซื้อด่วน',
            'checkout_page' => 'หน้าชำระเงิน',
            'cart_page' => 'หน้าตะกร้า',
            'cart_destroy_on_logout' => 'ทำลายตะกร้าเมื่อออกจากระบบ',
            'cart_destroy_on_logout_helper' => 'ตะกร้าจะถูกทำลายเมื่อลูกค้าออกจากระบบ',
            'hide_product_price' => 'ซ่อนราคาสินค้า',
            'hide_product_price_helper' => 'ตัวเลือกนี้ทำงานเฉพาะเมื่อคุณปิดใช้งานตะกร้าสินค้า ทำให้เว็บไซต์ของคุณกลายเป็นการแสดงแค็ตตาล็อกเท่านั้น หากเปิดใช้งาน ราคาสินค้าจะถูกซ่อน มีประโยชน์เมื่อคุณต้องการซ่อนราคาและต้องการให้ลูกค้าติดต่อขอราคา',
            'enable_payment_proof' => 'เปิดใช้งานการอัปโหลดหลักฐานการชำระเงิน',
            'enable_payment_proof_helper' => 'อนุญาตให้ลูกค้าอัปโหลดหลักฐานการชำระเงินสำหรับคำสั่งซื้อของพวกเขา มีประโยชน์สำหรับวิธีการชำระเงินแบบกำหนดเอง',
            'enable_guest_payment_proof' => 'อนุญาตให้ลูกค้าแขกอัปโหลดหลักฐานการชำระเงิน',
            'enable_guest_payment_proof_helper' => 'เมื่อเปิดใช้งาน ลูกค้าแขกสามารถอัปโหลดหลักฐานการชำระเงินโดยใช้โทเค็นคำสั่งซื้อของพวกเขาโดยไม่ต้องเข้าสู่ระบบ พวกเขาจะได้รับลิงก์อัปโหลดในอีเมลยืนยันคำสั่งซื้อ',
        ],
    ],
    'checkout' => [
        'name' => 'การชำระเงิน',
        'panel_description' => 'ดูและอัปเดตการตั้งค่าการชำระเงิน',
        'description' => 'กำหนดค่ากฎสำหรับการตั้งค่าการชำระเงิน',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'แสดงข้อมูลธนาคารในหน้าชำระเงินสำเร็จ',
            'mandatory_form_fields_at_checkout' => 'ฟิลด์บังคับในหน้าชำระเงิน:',
            'mandatory_form_fields_at_checkout_helper' => 'เลือกฟิลด์ที่จำเป็นระหว่างการชำระเงิน ลูกค้าต้องกรอกฟิลด์เหล่านี้เพื่อทำการสั่งซื้อให้เสร็จสมบูรณ์',
            'hide_form_fields_at_checkout' => 'ซ่อนฟิลด์ลูกค้าในหน้าชำระเงิน:',
            'hide_form_fields_at_checkout_helper' => 'เลือกฟิลด์ที่ควรซ่อนในหน้าชำระเงิน ฟิลด์เหล่านี้จะไม่มองเห็นให้ลูกค้า',
            'load_countries_states_cities_from_location_plugin' => 'โหลดประเทศ รัฐ เมือง จากปลั๊กอินตำแหน่ง',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'หลังจากเปลี่ยนตัวเลือกนี้ คุณต้องอัปเดตที่อยู่ทั้งหมดอีกครั้ง คุณควรตั้งค่าเพียงครั้งเดียว',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'จากนั้นคุณต้องไปที่เครื่องมือ -> นำเข้า/ส่งออกข้อมูล เพื่อนำเข้าข้อมูลตำแหน่ง',
            'minimum_order_amount' => 'จำนวนเงินคำสั่งซื้อขั้นต่ำเพื่อสั่งซื้อ (:currency)',
            'minimum_order_amount_helper' => 'กำหนดจำนวนเงินรวมขั้นต่ำที่จำเป็นสำหรับคำสั่งซื้อที่จะดำเนินการ คำสั่งซื้อที่ต่ำกว่าจำนวนนี้จะไม่ถูกยอมรับ',
            'zip_code_enabled' => 'เปิดใช้งานรหัสไปรษณีย์',
            'zip_code_enabled_helper' => 'เปิดหรือปิดใช้งานฟิลด์รหัสไปรษณีย์ในฟอร์มที่อยู่จัดส่ง',
            'billing_address_enabled' => 'เปิดใช้งานที่อยู่เรียกเก็บเงิน',
            'billing_address_enabled_helper' => 'อนุญาตให้ลูกค้าใส่ที่อยู่เรียกเก็บเงินแยกต่างหากที่แตกต่างจากที่อยู่จัดส่ง',
            'display_tax_fields_at_checkout_page' => 'แสดงฟิลด์ข้อมูลภาษีในหน้าชำระเงิน',
            'display_tax_fields_at_checkout_page_helper' => 'หากเปิดใช้งาน ฟิลด์ข้อมูลภาษีจะแสดงสำหรับการใส่รายละเอียดภาษีบริษัทเพื่อรับใบแจ้งหนี้',
            'use_city_field_as_field_text' => 'ใช้ฟิลด์เมืองเป็นฟิลด์ข้อความอิสระ',
            'available_countries' => 'ประเทศที่พร้อมให้บริการ',
            'all' => 'ทั้งหมด',
            'all_helper_text' => 'หากคุณยกเลิกการเลือกประเทศทั้งหมด จะใช้กับประเทศทั้งหมด',
            'enable_guest_checkout' => 'เปิดใช้งานการชำระเงินแขก',
            'enable_guest_checkout_helper' => 'หากเปิดใช้งาน ลูกค้าสามารถสั่งซื้อโดยไม่ต้องสร้างบัญชี',
            'recently_viewed' => [
                'enable' => 'เปิดใช้งานสินค้าที่ลูกค้าดูล่าสุด',
                'enable_helper' => 'ติดตามและแสดงสินค้าที่ลูกค้าดูล่าสุด ช่วยให้ลูกค้าค้นหาสินค้าที่พวกเขาสนใจได้อย่างง่ายดาย',
                'max' => 'จำนวนสูงสุดของสินค้าที่ลูกค้าดูล่าสุด',
                'max_helper_text' => 'หากตั้งค่าเป็น 0 จะไม่มีการจำกัด',
            ],
            'minimum_order_quantity' => 'จำนวนคำสั่งซื้อขั้นต่ำ',
            'minimum_order_quantity_helper' => 'จำนวนขั้นต่ำในการสั่งซื้อ ให้เป็น 0 หากคุณไม่ต้องการตั้งค่า',
            'maximum_order_quantity' => 'จำนวนคำสั่งซื้อสูงสุด',
            'maximum_order_quantity_helper' => 'จำนวนสูงสุดในการสั่งซื้อ ให้เป็น 0 หากคุณไม่ต้องการตั้งค่า',
            'default_country_at_checkout_page' => 'ประเทศเริ่มต้นในหน้าชำระเงิน',
            'default_country_at_checkout_page_placeholder' => 'เลือกประเทศ',
            'default_country_at_checkout_page_help' => 'หากคุณเลือกประเทศ ประเทศนั้นจะถูกเลือกเป็นค่าเริ่มต้นในหน้าชำระเงิน',
            'checkout_product_quantity_editable' => 'อนุญาตให้ลูกค้าเปลี่ยนจำนวนสินค้าในหน้าชำระเงิน',
            'checkout_product_quantity_editable_helper' => 'เมื่อเปิดใช้งาน ลูกค้าสามารถแก้ไขจำนวนสินค้าได้โดยตรงในหน้าชำระเงินโดยไม่ต้องกลับไปที่ตะกร้า',
            'show_terms_and_policy_checkbox' => 'แสดงช่องติ๊กข้อกำหนดและนโยบาย',
            'show_terms_and_policy_checkbox_helper' => 'หากเปิดใช้งาน ลูกค้าต้องยอมรับข้อกำหนดและนโยบายก่อนสั่งซื้อ กรุณาตั้งค่า URL ข้อกำหนดและนโยบายความเป็นส่วนตัวในการปรากฏ -> ตัวเลือกธีมก่อน',
            'terms_and_policy_checkbox_checked_by_default' => 'ช่องติ๊กข้อกำหนดและนโยบายติ๊กเป็นค่าเริ่มต้น',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'หากเปิดใช้งาน ช่องติ๊กข้อกำหนดและนโยบายจะถูกติ๊กไว้ล่วงหน้าเมื่อฟอร์มชำระเงินโหลด',
            'checkout_acceptance_message_enabled' => 'แสดงข้อความการยอมรับการชำระเงิน',
            'checkout_acceptance_message_enabled_helper' => 'แสดงข้อความแจ้งข้อมูลที่แจ้งลูกค้าเกี่ยวกับข้อกำหนดที่พวกเขายอมรับโดยการสั่งซื้อ',
            'hide_customer_info_at_checkout' => 'ซ่อนข้อมูลลูกค้าในการชำระเงิน',
            'hide_customer_info_at_checkout_helper' => 'ซ่อนข้อมูลบัญชีลูกค้าและปุ่มออกจากระบบจากหน้าชำระเงิน เมื่อเปิดใช้งาน ลูกค้าที่เข้าสู่ระบบแล้วจะไม่เห็นรายละเอียดบัญชีของพวกเขาแสดง',
        ],
    ],
    'return' => [
        'name' => 'การคืนสินค้า',
        'description' => 'กำหนดค่ากฎสำหรับการตั้งค่าการคืนสินค้า',
        'panel_description' => 'ดูและอัปเดตการตั้งค่าการคืนสินค้า',
        'form' => [
            'is_enabled_order_return' => 'เปิดใช้งานการคืนคำสั่งซื้อ',
            'allow_partial_return' => 'อนุญาตการคืนบางส่วน',
            'allow_partial_return_description' => 'ลูกค้าสามารถคืนสินค้าบางชิ้น ไม่จำเป็นต้องคืนสินค้าทั้งหมดในคำสั่งซื้อ',
            'returnable_days' => 'วันที่สามารถคืนได้',
            'return_settings_helper' => 'จำนวนวันที่ลูกค้าสามารถขอคืนสินค้าหลังจากคำสั่งซื้อเสร็จสมบูรณ์',
        ],
    ],
    'invoice' => [
        'name' => 'ใบแจ้งหนี้',
        'description' => 'ดูและอัปเดตการตั้งค่าใบแจ้งหนี้ของคุณ',
        'company_settings' => 'การตั้งค่าบริษัท',
        'company_settings_description' => 'ตั้งค่าข้อมูลบริษัทสำหรับการออกใบแจ้งหนี้',
        'form' => [
            'company_name' => 'ชื่อบริษัท',
            'company_address' => 'ที่อยู่บริษัท',
            'company_zipcode' => 'รหัสไปรษณีย์บริษัท',
            'company_email' => 'อีเมลบริษัท',
            'company_phone' => 'โทรศัพท์บริษัท',
            'company_logo' => 'โลโก้บริษัท',
            'company_tax_id' => 'หมายเลขภาษีบริษัท',
            'invoice_code_prefix' => 'คำนำหน้ารหัสใบแจ้งหนี้',
            'using_custom_font_for_invoice' => 'ใช้ฟอนต์กำหนดเองสำหรับใบแจ้งหนี้',
            'invoice_font_family' => 'ตระกูลฟอนต์ใบแจ้งหนี้ (ใช้งานได้เฉพาะภาษาละติน)',
            'enable_invoice_stamp' => 'เปิดใช้งานตราประทับใบแจ้งหนี้',
            'add_language_support' => 'เพิ่มการสนับสนุนภาษา',
            'invoice_processing_library' => 'ไลบรารี่ประมวลผลใบแจ้งหนี้',
            'only_latin_languages' => 'เฉพาะภาษาละติน',
            'disable_order_invoice_until_order_confirmed' => 'ปิดใช้งานใบแจ้งหนี้คำสั่งซื้อจนกว่าคำสั่งซื้อจะได้รับการยืนยัน',
            'date_format' => 'รูปแบบวันที่',
            'languages' => [
                'arabic' => 'อารบิก',
                'bangladesh' => 'เบงกาลี',
                'chinese' => 'จีน',
            ],
        ],
    ],
    'tax' => [
        'name' => 'ภาษี',
        'description' => 'การตั้งค่าภาษี',
        'enable' => 'เปิดใช้งานภาษี?',
        'display_product_price_including_taxes' => 'แสดงราคาสินค้ารวมภาษี?',
        'display_tax_description' => 'แสดงข้อมูลภาษีในราคาสินค้า?',
        'display_tax_description_help' => 'แสดงข้อความเช่น "(รวม X% GST)" หรือ "(ไม่รวม X% GST)" ข้างราคาสินค้าในหน้ารายละเอียดสินค้า',
        'tax_included_in_products_price' => 'ภาษีรวมในราคาสินค้า',
        'tax_included_in_products_price_description' => 'ภาษีจะรวมในราคาสินค้า',
        'tax_setting' => 'การตั้งค่าภาษี',
        'tax_setting_description' => 'กำหนดค่าการตั้งค่าภาษี',
        'tax_management' => 'การจัดการภาษี',
        'tax_management_description' => 'ดูและจัดการภาษีของคุณ',
        'form' => [
            'enable_tax' => 'เปิดใช้งานภาษี',
            'display_company_invoice_information_fields_at_checkout_page' => 'แสดงฟิลด์ข้อมูลใบแจ้งหนี้บริษัทในหน้าชำระเงิน',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'หากเปิดใช้งาน ฟิลด์ข้อมูลใบแจ้งหนี้บริษัทจะแสดงในหน้าชำระเงิน จำเป็นต้องกรอกฟิลด์ข้อมูลใบแจ้งหนี้บริษัท',
            'default_tax_rate' => 'อัตราภาษีเริ่มต้น',
            'default_tax_rate_description' => 'สำคัญ: จะถูกใช้หากไม่ได้เลือกภาษีในสินค้า',
            'select_tax' => '-- เลือก --',
            'display_product_price_including_taxes' => 'แสดงราคาสินค้ารวมภาษี',
        ],
    ],
    'customer' => [
        'name' => 'ลูกค้า',
        'description' => 'ดูและอัปเดตการตั้งค่าลูกค้าของคุณ',
        'customer_setting' => 'การตั้งค่าลูกค้า',
        'customer_setting_description' => 'กำหนดค่าการตั้งค่าลูกค้า',
        'form' => [
            'enable_customer_registration' => 'เปิดใช้งานการลงทะเบียนลูกค้า',
            'enable_customer_registration_helper' => 'หากปิดใช้งาน ลูกค้าจะไม่สามารถลงทะเบียนบัญชีใหม่ได้ ลูกค้าเดิมยังสามารถเข้าสู่ระบบได้',
            'verify_customer_email' => 'ยืนยันอีเมลลูกค้า',
            'verify_customer_email_helper' => 'เมื่อเปิดใช้งาน ลิงก์ยืนยันจะถูกส่งไปยังอีเมลลูกค้า ลูกค้าต้องคลิกลิงก์นี้เพื่อยืนยันอีเมลก่อนที่จะเข้าสู่ระบบได้ ต้องกำหนดค่าอีเมลในผู้ดูแลระบบ -> การตั้งค่า -> อีเมล เพื่อส่งการยืนยันอีเมล',
            'verification_expire_minutes' => 'เวลาหมดอายุลิงก์ยืนยัน',
            'verification_expire_minutes_helper' => 'เวลาเป็นนาทีที่ลิงก์ยืนยันอีเมลจะใช้ได้ ค่าเริ่มต้นคือ 60 นาที (1 ชั่วโมง) สูงสุด 10080 นาที (7 วัน)',
            'login_using_phone' => 'เข้าสู่ระบบด้วยหมายเลขโทรศัพท์แทนอีเมล',
            'login_option' => 'ตัวเลือกการเข้าสู่ระบบ',
            'login_with_email' => 'เข้าสู่ระบบด้วยอีเมล',
            'login_with_phone' => 'เข้าสู่ระบบด้วยโทรศัพท์',
            'login_with_email_or_phone' => 'เข้าสู่ระบบด้วยอีเมลหรือโทรศัพท์',
            'enabled_customer_account_deletion' => 'เปิดใช้งานการลบบัญชีลูกค้า',
            'enabled_customer_account_deletion_helper' => 'เมื่อเปิดใช้งาน ลูกค้าสามารถลบบัญชีของพวกเขาในแดชบอร์ดลูกค้า → การตั้งค่าบัญชี',
            'enabled_customer_dob_field' => 'เปิดใช้งานฟิลด์วันเกิดลูกค้า',
            'enabled_customer_dob_field_helper' => 'เมื่อเปิดใช้งาน ลูกค้าสามารถใส่วันเกิดของพวกเขาในแดชบอร์ดลูกค้า → การตั้งค่าบัญชี',
            'enabled_phone_field_in_registration_form' => 'เปิดใช้งานฟิลด์โทรศัพท์ในฟอร์มลงทะเบียน',
            'enabled_phone_field_in_registration_form_helper' => 'เมื่อเปิดใช้งาน ฟิลด์โทรศัพท์จะถูกเพิ่มในฟอร์มลงทะเบียน',
            'make_customer_phone_number_required' => 'ทำให้หมายเลขโทรศัพท์ลูกค้าเป็นข้อมูลที่จำเป็น',
            'make_customer_phone_number_required_helper' => 'เมื่อเปิดใช้งาน ลูกค้าต้องใส่หมายเลขโทรศัพท์ระหว่างการลงทะเบียน จำเป็นเสมอสำหรับลูกค้าที่เข้าสู่ระบบด้วยหมายเลขโทรศัพท์',
            'default_avatar' => 'อวตารเริ่มต้น',
            'default_avatar_helper' => 'อวตารเริ่มต้นสำหรับลูกค้าเมื่อพวกเขาไม่มีอวตาร หากคุณไม่เลือกรูปภาพใดๆ จะถูกสร้างโดยใช้โลโก้ของคุณหรือตัวอักษรแรกของชื่อลูกค้า',
            'keep_email_field_in_registration_form' => 'เก็บฟิลด์อีเมลในฟอร์มลงทะเบียน',
            'keep_email_field_in_registration_form_helper' => 'เมื่อปิดใช้งาน ฟิลด์อีเมลจะถูกซ่อนในฟอร์มลงทะเบียนเมื่อตัวเลือกการเข้าสู่ระบบเป็น "เข้าสู่ระบบด้วยโทรศัพท์"',
        ],
    ],
    'shipping' => [
        'name' => 'การจัดส่ง',
        'description' => 'ดูและอัปเดตการตั้งค่าการจัดส่ง',
        'shipping_rule' => 'กฎการจัดส่ง',
        'shipping_rule_description' => 'กำหนดค่ากฎเพื่อคำนวณค่าจัดส่ง',
        'shipping_setting' => 'การตั้งค่าการจัดส่ง',
        'shipping_setting_description' => 'กำหนดค่าการตั้งค่าการจัดส่ง',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'ซ่อนตัวเลือกการจัดส่งอื่นหากมีการจัดส่งฟรีในรายการ',
            'disable_shipping_options' => 'ปิดใช้งานตัวเลือกการจัดส่ง',
            'disable_shipping_options_helper' => 'ตัวเลือกการจัดส่งจะถูกลบในหน้าชำระเงิน ลูกค้าจะไม่สามารถเลือกตัวเลือกการจัดส่งได้',
            'sort_shipping_options_direction' => 'ทิศทางการเรียงลำดับตัวเลือกการจัดส่ง',
            'sort_shipping_options_direction_helper' => 'เรียงลำดับตัวเลือกการจัดส่งตามราคาจากต่ำไปสูงหรือสูงไปต่ำ',
            'price_lower_to_higher' => 'ราคาต่ำไปสูง',
            'price_higher_to_lower' => 'ราคาสูงไปต่ำ',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'กำหนดค่าการตั้งค่า webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'กำหนดค่า URL webhook เพื่อรับการแจ้งเตือนสำหรับเหตุการณ์คำสั่งซื้อต่างๆ',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook สำหรับการสั่งซื้อ (วิธีการ: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อมีการสั่งซื้อ คุณสามารถตั้งค่า URL webhook ภายนอก หากคุณมี URL webhook ภายนอก คุณสามารถใส่ URL นี้ หรือปล่อยว่างไว้',
            'order_updated_webhook_url' => 'URL webhook สำหรับการอัปเดตคำสั่งซื้อ (วิธีการ: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อคำสั่งซื้อได้รับการอัปเดต คุณสามารถตั้งค่า URL webhook ภายนอก รวมถึงการเปลี่ยนแปลงสถานะ การอัปเดตที่อยู่ และการแก้ไขคำสั่งซื้ออื่นๆ',
            'shipping_status_updated_webhook_url' => 'URL webhook สำหรับการอัปเดตสถานะการจัดส่ง (วิธีการ: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อสถานะการจัดส่งเปลี่ยนแปลง (เช่น จัดส่งแล้ว ส่งมอบแล้ว ยกเลิก) คุณสามารถตั้งค่า URL webhook ภายนอก',
            'order_completed_webhook_url' => 'URL webhook สำหรับคำสั่งซื้อเสร็จสมบูรณ์ (วิธีการ: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อคำสั่งซื้อเสร็จสมบูรณ์ คุณสามารถตั้งค่า URL webhook ภายนอก',
            'order_cancelled_webhook_url' => 'URL webhook สำหรับการยกเลิกคำสั่งซื้อ (วิธีการ: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อคำสั่งซื้อถูกยกเลิก คุณสามารถตั้งค่า URL webhook ภายนอก',
            'payment_status_updated_webhook_url' => 'URL webhook สำหรับการอัปเดตสถานะการชำระเงิน (วิธีการ: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อสถานะการชำระเงินเปลี่ยนแปลง (เช่น ชำระแล้ว ล้มเหลว คืนเงิน) คุณสามารถตั้งค่า URL webhook ภายนอก',
            'abandoned_cart_webhook_url' => 'URL webhook สำหรับตะกร้าที่ถูกทิ้ง (วิธีการ: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'เพื่อรับการแจ้งเตือนเมื่อตะกร้าถูกทิ้งและติดตามลูกค้า คุณสามารถตั้งค่า URL webhook ภายนอก การแจ้งเตือนจะถูกส่งหลังจากช่วงเวลาที่กำหนดค่าได้',
        ],
        'test_button' => 'ทดสอบ Webhook',
        'test_success' => 'การทดสอบ Webhook สำเร็จ! ปลายทางตอบสนองอย่างถูกต้อง',
        'test_failed' => 'การทดสอบ Webhook ล้มเหลว ปลายทางไม่ตอบสนองตามที่คาดหวัง',
        'test_error' => 'ข้อผิดพลาดการทดสอบ Webhook: :error',
        'please_enter_url' => 'กรุณาใส่ URL webhook ก่อน',
        'testing' => 'กำลังทดสอบ...',
        'test_failed_title' => 'การทดสอบล้มเหลว!',
        'test_success_title' => 'การทดสอบสำเร็จ!',
        'status_code' => 'รหัสสถานะ',
        'error_occurred' => 'เกิดข้อผิดพลาดขณะทดสอบ webhook',
    ],
    'store_locator' => [
        'name' => 'ตัวหาสถานที่ร้านค้า',
        'description' => 'ดูและอัปเดตรายการของเครือข่ายของคุณ',
        'store_locator_description' => 'รายการทั้งหมดของเครือข่ายของคุณ ร้านค้าหลัก สาขา ฯลฯ สถานที่สามารถใช้เพื่อติดตามการขายและช่วยเรากำหนดค่าอัตราภาษีที่จะเรียกเก็บเมื่อขายสินค้า',
        'form' => [
            'change_primary_store' => 'เปลี่ยนตัวหาสถานที่ร้านค้าเริ่มต้น',
            'add_location' => 'เพิ่มสถานที่',
            'edit_location' => 'แก้ไขสถานที่',
            'delete_location' => 'ลบสถานที่',
            'delete_location_confirmation' => 'คุณแน่ใจหรือไม่ที่จะลบสถานที่นี้? การกระทำนี้ไม่สามารถยกเลิกได้',
            'change_primary_location' => 'เปลี่ยนสถานที่หลัก',
            'save_location' => 'บันทึกสถานที่',
            'add_new' => 'เพิ่มใหม่',
        ],
    ],
    'tracking' => [
        'name' => 'การติดตาม',
        'description' => 'ดูและอัปเดตการตั้งค่าการติดตาม',
        'manage_tracking' => 'จัดการการติดตาม',
        'manage_tracking_description' => 'จัดการการติดตาม: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'เปิดใช้งาน Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'ไปที่ https://developers.facebook.com/docs/meta-pixel เพื่อสร้าง Facebook Pixel ตรวจสอบให้แน่ใจว่า pixel ของคุณทำงานอยู่และได้รับการกำหนดค่าอย่างถูกต้อง',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => 'ตัวอย่าง: 1234567890123456',
            'facebook_pixel_debug_mode' => 'เปิดใช้งานโหมดดีบัก Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'เปิดใช้งานโหมดดีบักเพื่อบันทึกเหตุการณ์ Facebook Pixel ไปยังคอนโซลเบราว์เซอร์และแก้ไขปัญหาการติดตาม',
            'enable_google_tag_manager_tracking_events' => 'เปิดใช้งานเหตุการณ์การติดตาม Google Tag Manager',
            'google_tag_manager_tracking_info' => 'เมื่อเปิดใช้งาน เหตุการณ์อีคอมเมิร์ซจะถูกติดตามผ่าน Google Tag Manager ตรวจสอบให้แน่ใจว่าคุณได้กำหนดค่า Google Tag Manager ด้านบนแล้ว',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel ID ต้องเป็นตัวเลข 15-16 หลัก (เช่น 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'ตลาดกลาง',
        'description' => 'ดูและอัปเดตการตั้งค่าตลาดกลาง',
    ],
    'standard_and_format' => [
        'name' => 'มาตรฐานและรูปแบบ',
        'panel_description' => 'ดูและอัปเดตการตั้งค่ามาตรฐานและรูปแบบ',
        'description' => 'มาตรฐานและรูปแบบใช้เพื่อคำนวณสิ่งต่างๆ เช่น ราคาสินค้า น้ำหนักการจัดส่ง และเวลาสั่งซื้อ',
        'form' => [
            'change_order_format' => 'แก้ไขรูปแบบรหัสคำสั่งซื้อ (ไม่บังคับ)',
            'change_order_format_description' => 'รหัสคำสั่งซื้อเริ่มต้นเริ่มต้นที่: หมายเลข คุณสามารถเปลี่ยนสตริงเริ่มต้นหรือสิ้นสุดเพื่อสร้างรหัสคำสั่งซื้อที่คุณต้องการ เช่น "DH-: หมายเลข" หรือ ": หมายเลข-A"',
            'start_with' => 'เริ่มต้นด้วย',
            'end_with' => 'สิ้นสุดด้วย',
            'order_will_be_shown' => 'รหัสคำสั่งซื้อของคุณจะแสดง',
            'weight_unit' => 'หน่วยน้ำหนัก',
            'height_unit' => 'หน่วยความยาว / ความสูง',
            'weight_unit_gram' => 'กรัม (g)',
            'weight_unit_kilogram' => 'กิโลกรัม (kg)',
            'weight_unit_lb' => 'ปอนด์ (lb)',
            'weight_unit_oz' => 'ออนซ์ (oz)',
            'height_unit_cm' => 'เซนติเมตร (cm)',
            'height_unit_m' => 'เมตร (m)',
            'height_unit_inch' => 'นิ้ว',
        ],
    ],
    'sale_popup' => [
        'name' => 'ป็อปอัปการขาย',
        'description' => 'ปรับแต่งการตั้งค่าป็อปอัปการขายของคุณอย่างง่ายดาย',
    ],
    'flash_sale' => [
        'name' => 'การขายแฟลช',
        'description' => 'กำหนดค่าการตั้งค่าการขายแฟลชเพื่อเสนอส่วนลดโปรโมชั่นจำกัดเวลา',
        'enable' => 'เปิดใช้งานฟังก์ชันการขายแฟลช',
        'enable_helper' => 'เมื่อเปิดใช้งาน คุณสามารถสร้างและจัดการการขายแฟลชด้วยราคาส่วนลดพิเศษสำหรับช่วงเวลาจำกัด',
        'show_sale_count_left' => 'แสดงตัวติดตามสินค้าคงคลัง',
        'show_sale_count_left_description' => 'แสดงแถบความคืบหน้าพร้อม "X ขายหมดจาก Y" เพื่อสร้างความเร่งด่วนและส่งเสริมการซื้ออย่างรวดเร็วระหว่างการขายแฟลช',
    ],
    'payment_method_cod_minimum_amount' => 'จำนวนเงินคำสั่งซื้อขั้นต่ำ - :currency (ไม่บังคับ)',
    'payment_method_minimum_amount' => 'จำนวนเงินคำสั่งซื้อขั้นต่ำ - :currency (ไม่บังคับ)',
    'display_bank_info_at_the_checkout_success_page' => 'แสดงข้อมูลธนาคารในหน้าชำระเงินสำเร็จ?',
    'invoice_templates' => 'เทมเพลตใบแจ้งหนี้',
];