<?php

return [
    'save_settings' => 'Зберегти налаштування',
    'ecommerce' => 'Електронна комерція',
    'general' => [
        'name' => 'Загальні',
        'description' => 'Перегляд і оновлення загальних налаштувань',
    ],
    'currency' => [
        'name' => 'Валюти',
        'description' => 'Перегляд і оновлення налаштувань валют',
        'currency_setting_description' => 'Перегляд і оновлення валют, які використовуються на веб-сайті',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Увімкнути автовизначення валюти відвідувача',
            'enable_auto_detect_visitor_currency_helper' => 'Автоматично визначати і відображати ціни в місцевій валюті відвідувача на основі їхнього місцезнаходження. Це забезпечує більш персоналізований досвід покупок.',
            'add_space_between_price_and_currency' => 'Додати пробіл між ціною та валютою',
            'add_space_between_price_and_currency_helper' => 'Коли увімкнено, додається пробіл між значенням ціни та символом валюти (наприклад, "100 USD" замість "100USD").',
            'thousands_separator' => 'Роздільник тисяч',
            'thousands_separator_helper' => 'Виберіть символ для розділення тисяч у відображенні ціни (наприклад, 1,000 або 1.000 або 1 000).',
            'decimal_separator' => 'Десятковий роздільник',
            'decimal_separator_helper' => 'Виберіть символ для розділення десяткових значень у цінах (наприклад, 10.99 або 10,99).',
            'separator_period' => 'Крапка (.)',
            'separator_comma' => 'Кома (,)',
            'separator_space' => 'Пробіл ( )',
            'api_key' => 'Ключ API обмінних курсів',
            'api_key_helper' => 'Отримати ключ API обмінного курсу на :link',
            'update_currency_rates' => 'Оновити курси валют',
            'use_exchange_rate_from_api' => 'Використовувати обмінний курс з API',
            'use_exchange_rate_from_api_helper' => 'Увімкнути автоматичне оновлення обмінного курсу валюти від налаштованого провайдера API. Це гарантує, що ваші ціни завжди актуальні з поточними ринковими курсами.',
            'clear_cache_rates' => 'Очистити кеш курсів',
            'auto_detect_visitor_currency_description' => 'Визначає валюту відвідувача на основі мови браузера. Це перевизначить вибір валюти за замовчуванням.',
            'exchange_rate' => [
                'api_provider' => 'Провайдер API',
                'select' => '-- Вибрати --',
                'none' => 'Немає',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Для валюти за замовчуванням обмінний курс має бути 1.',
        ],
    ],
    'product' => [
        'name' => 'Товари',
        'description' => 'Перегляд і оновлення налаштувань товарів',
        'product_settings' => 'Налаштування товарів',
        'product_settings_description' => 'Налаштування правил для товарів',
        'form' => [
            'show_number_of_products' => 'Показувати кількість товарів на сторінці товару',
            'show_number_of_products_helper' => 'Відображати загальну кількість товарів на сторінці деталей товару.',
            'show_out_of_stock_products' => 'Показувати товари, яких немає в наявності',
            'show_out_of_stock_products_helper' => 'Якщо увімкнено, товари, яких немає в наявності, будуть відображатися на сторінці списку товарів.',
            'how_to_display_product_variation_images' => 'Як відображати зображення варіацій товарів',
            'how_to_display_product_variation_images_helper' => 'Виберіть, чи показувати тільки зображення варіації, чи включати як зображення варіації, так і основні зображення товару.',
            'only_variation_images' => 'Тільки зображення варіації',
            'variation_images_and_main_product_images' => 'Зображення варіації та основні зображення товару',
            'enable_product_options' => 'Увімкнути опції товару',
            'enable_product_options_helper' => 'Дозволити товарам мати налаштовувані опції, такі як розмір, колір тощо.',
            'is_enabled_cross_sale_products' => 'Увімкнути крос-продажні товари',
            'is_enabled_cross_sale_products_helper' => 'Відображати пропозиції крос-продажних товарів для заохочення додаткових покупок.',
            'is_enabled_related_products' => 'Увімкнути пов\'язані товари',
            'is_enabled_related_products_helper' => 'Показувати пов\'язані товари на основі категорії або вибрані адміністратором у формі товару.',
            'related_products_source' => 'Джерело пов\'язаних товарів',
            'related_products_source_helper' => 'Коли адміністратор не вибирає пов\'язані товари у формі товару, показувати пов\'язані товари на основі цього джерела.',
            'related_products_source_category' => 'Та сама категорія',
            'related_products_source_brand' => 'Той самий бренд',
            'trending_products_period' => 'Період популярних товарів',
            'trending_products_period_helper' => 'Виберіть часовий період для розрахунку популярних товарів на основі кількості переглядів.',
            'trending_products_period_1_day' => 'Останні 24 години',
            'trending_products_period_3_days' => 'Останні 3 дні',
            'trending_products_period_7_days' => 'Останні 7 днів (1 тиждень)',
            'trending_products_period_14_days' => 'Останні 14 днів (2 тижні)',
            'trending_products_period_30_days' => 'Останні 30 днів (1 місяць)',
            'trending_products_period_60_days' => 'Останні 60 днів (2 місяці)',
            'trending_products_period_90_days' => 'Останні 90 днів (3 місяці)',
            'auto_generate_product_sku' => 'Автоматично генерувати SKU при створенні товару',
            'auto_generate_product_sku_helper' => 'Автоматично генерувати унікальні SKU для нових товарів на основі формату нижче.',
            'product_sku_format' => 'Формат SKU',
            'product_sku_format_helper' => 'Ви можете використовувати %s (1 символ рядка) або %d (1 цифра) у форматі для генерації випадкового рядка. Наприклад: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Увімкнути специфікацію товару',
            'enable_product_specification_help' => 'Якщо увімкнено, таблиця специфікацій товару буде відображатися на сторінці деталей товару.',
            'make_product_barcode_required' => 'Зробити штрих-код товару обов\'язковим',
            'make_product_barcode_required_helper' => 'Якщо увімкнено, штрих-код товару буде обов\'язковим при створенні товару.',
        ],
    ],
    'product_search' => [
        'name' => 'Пошук товарів',
        'description' => 'Перегляд і оновлення налаштувань пошуку товарів',
        'product_search_settings' => 'Пошук товарів',
        'product_search_settings_description' => 'Налаштування правил для пошуку товарів',
        'form' => [
            'search_for_an_exact_phrase' => 'Шукати точну фразу',
            'search_products_by' => 'Шукати товари за:',
            'enable_filter_products_by_categories' => 'Увімкнути фільтр товарів за категоріями',
            'enable_filter_products_by_brands' => 'Увімкнути фільтр товарів за брендами',
            'enable_filter_products_by_tags' => 'Увімкнути фільтр товарів за тегами',
            'number_of_popular_tags_for_filter' => 'Кількість популярних тегів для фільтра',
            'number_of_popular_tags_for_filter_placeholder' => 'Введіть кількість популярних тегів для відображення',
            'number_of_popular_tags_for_filter_helper' => 'Встановіть максимальну кількість популярних тегів для відображення у фільтрі. За замовчуванням - 10.',
            'enable_filter_products_by_attributes' => 'Увімкнути фільтр товарів за атрибутами',
            'enable_filter_products_by_price' => 'Увімкнути фільтр товарів за ціною',
            'max_product_price_for_filter' => 'Макс. ціна товару для фільтра',
            'max_product_price_for_filter_placeholder' => 'Якщо порожнє або нуль, буде отримана максимальна ціна товару з ваших існуючих товарів.',
            'max_product_price_for_filter_helper' => 'Ви можете встановити фіксовану ціну або вона буде динамічно отримана як максимальна ціна товару з ваших існуючих товарів. Зараз це :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Цифрові товари',
        'description' => 'Перегляд і оновлення налаштувань цифрових товарів',
        'digital_products_settings' => 'Цифрові товари',
        'digital_products_settings_description' => 'Налаштування правил для цифрових товарів',
        'form' => [
            'enable_support_digital_product' => 'Увімкнено підтримку цифрових товарів',
            'enable_support_digital_product_helper' => 'Коли увімкнено, система підтримуватиме продаж цифрових товарів, таких як програмне забезпечення, електронні книги, музика та інший контент для завантаження.',
            'allow_guest_checkout_for_digital_products' => 'Дозволити оформлення гостями для цифрових товарів',
            'allow_guest_checkout_for_digital_products_helper' => 'Коли увімкнено, клієнти можуть купувати цифрові товари без створення облікового запису. Вони отримають посилання для завантаження через email.',
            'disable_physical_product' => 'Вимкнути фізичний товар',
            'disable_physical_product_helper' => 'Коли увімкнено, магазин продаватиме лише цифрові товари. Опції фізичних товарів будуть приховані з форм товарів та оформлення.',
            'enable_license_codes_for_digital_products' => 'Увімкнути ліцензійні коди для цифрових товарів',
            'auto_complete_digital_orders_after_payment' => 'Автоматично завершувати цифрові замовлення після оплати',
            'auto_complete_digital_orders_after_payment_helper' => 'Коли увімкнено, замовлення, що містять лише цифрові товари, будуть автоматично позначатися як завершені після отримання оплати.',
            'enable_license_codes_for_digital_products_helper' => 'Коли увімкнено, ви можете додавати ліцензійні коди до цифрових товарів. Коли вимкнено, функціональність ліцензійних кодів буде прихована з форм товарів.',
            'hide_used_license_codes_in_product_form' => 'Приховати використані ліцензійні коди у формі товару',
            'hide_used_license_codes_in_product_form_helper' => 'Коли увімкнено, використані ліцензійні коди будуть приховані з таблиці ліцензійних кодів у формі редагування товару. Це допомагає підтримувати чистоту інтерфейсу, коли у вас багато використаних кодів.',
        ],
    ],
    'product_review' => [
        'name' => 'Відгуки про товари',
        'description' => 'Перегляд і оновлення налаштувань відгуків про товари',
        'form' => [
            'enable_review' => 'Увімкнути відгуки про товари',
            'enable_review_help' => 'Дозволити клієнтам залишати відгуки та оцінки на товари. Коли вимкнено, всі функції відгуків будуть приховані з магазину.',
            'allow_customer_upload_image_in_review' => 'Дозволити клієнтам завантажувати зображення у відгуках',
            'allow_customer_upload_image_in_review_help' => 'Коли вимкнено, клієнти не можуть завантажувати зображення при поданні відгуків',
            'review' => [
                'max_file_size' => 'Макс. розмір файлу відгуку (МБ)',
                'max_file_number' => 'Макс. кількість файлів відгуку',
            ],
            'only_allow_customers_purchased_to_review' => 'Тільки клієнти, які придбали товар, можуть залишати відгук про товар',
            'review_need_to_be_approved' => 'Відгук потрібно схвалити перед показом на сторінці товару',
            'show_customer_full_name' => 'Показувати повне ім\'я клієнта',
            'show_customer_full_name_help' => 'Якщо не відмічено, ім\'я клієнта, який залишає відгук, буде приховано і замінено зірочками (***)',
            'hide_rating_when_no_reviews' => 'Приховати оцінку, коли немає відгуків',
            'hide_rating_when_no_reviews_help' => 'Коли увімкнено, оцінки товарів будуть приховані у списках товарів та на сторінках деталей товару, коли товар не має відгуків',
            'display_uploaded_customer_review_images_list' => 'Відображати розділ "Зображення від клієнтів"',
            'display_uploaded_customer_review_images_list_help' => 'Коли увімкнено, показує галерею всіх завантажених клієнтами зображень вгорі розділу відгуків',
        ],
    ],
    'shopping' => [
        'name' => 'Покупки',
        'description' => 'Перегляд і оновлення налаштувань покупок',
        'general_setting' => 'Загальні налаштування',
        'return_settings' => 'Налаштування повернення',
        'return_settings_description' => 'Налаштування правил для налаштувань повернення',
        'form' => [
            'enable_cart' => 'Увімкнути кошик покупок',
            'enable_cart_helper' => 'Якщо вимкнено, кнопка кошика буде видалена, перетворюючи ваш сайт на каталог тільки для перегляду.',
            'enable_wishlist' => 'Увімкнути список бажань',
            'enable_wishlist_helper' => 'Якщо вимкнено, кнопка списку бажань буде видалена з сайту.',
            'enable_wishlist_sharing' => 'Увімкнути спільний доступ до списку бажань',
            'shared_wishlist_lifetime' => 'Час життя спільного списку бажань (днів)',
            'shared_wishlist_lifetime_helper' => 'Час життя спільного списку бажань у днях. Після цього часу спільний список бажань буде видалено.',
            'enable_compare' => 'Увімкнути порівняння',
            'enable_compare_helper' => 'Якщо вимкнено, кнопка порівняння буде видалена з сайту.',
            'enable_order_tracking' => 'Увімкнути відстеження замовлень',
            'enable_order_tracking_helper' => 'Клієнти можуть відстежувати свої замовлення, ввівши код замовлення та email/телефон на :url',
            'order_tracking_method' => 'Метод відстеження замовлень',
            'order_tracking_method_helper' => 'Виберіть, як клієнти відстежуватимуть свої замовлення: використовуючи ID замовлення + Email або ID замовлення + Номер телефону.',
            'order_tracking_method_email' => 'ID замовлення + Email',
            'order_tracking_method_phone' => 'ID замовлення + Номер телефону',
            'enable_quick_buy_button' => 'Увімкнути кнопку швидкої покупки',
            'enable_quick_buy_button_helper' => 'Відображатиме кнопку "Купити зараз" на сторінці списку товарів та сторінці деталей. Коли клієнти натискають цю кнопку, товар буде додано до кошика і перенаправлено на сторінку кошика/оформлення.',
            'enable_order_auto_confirmed' => 'Автопідтвердження замовлення',
            'enable_order_auto_confirmed_helper' => 'Якщо увімкнено, замовлення буде автоматично підтверджуватися після розміщення замовлення клієнтом.',
            'quick_buy_target' => 'Цільова сторінка швидкої покупки',
            'checkout_page' => 'Сторінка оформлення',
            'cart_page' => 'Сторінка кошика',
            'cart_destroy_on_logout' => 'Знищити кошик при виході',
            'cart_destroy_on_logout_helper' => 'Кошик буде знищено, коли клієнт виходить.',
            'hide_product_price' => 'Приховати ціну товару',
            'hide_product_price_helper' => 'Ця опція працює лише якщо ви вимкнете кошик покупок, перетворюючи ваш сайт на каталог тільки для перегляду. Якщо увімкнено, ціна товару буде прихована. Це корисно, коли ви хочете приховати ціну і вимагати від клієнтів звернення для ціни.',
            'enable_payment_proof' => 'Увімкнути завантаження підтвердження оплати',
            'enable_payment_proof_helper' => 'Дозволити клієнтам завантажувати підтвердження оплати для своїх замовлень. Це корисно для ручних способів оплати.',
            'enable_guest_payment_proof' => 'Дозволити гостям завантажувати підтвердження оплати',
            'enable_guest_payment_proof_helper' => 'Коли увімкнено, гості можуть завантажувати підтвердження оплати за допомогою токена замовлення без входу. Вони отримають посилання для завантаження в email підтвердження замовлення.',
        ],
    ],
    'checkout' => [
        'name' => 'Оформлення',
        'panel_description' => 'Перегляд і оновлення налаштувань оформлення',
        'description' => 'Налаштування правил для налаштувань оформлення',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Відображати банківську інформацію на сторінці успіху оформлення',
            'mandatory_form_fields_at_checkout' => 'Обов\'язкові поля на сторінці оформлення:',
            'mandatory_form_fields_at_checkout_helper' => 'Виберіть, які поля обов\'язкові під час оформлення. Клієнти повинні заповнити ці поля для завершення замовлення.',
            'hide_form_fields_at_checkout' => 'Приховати поля клієнта на сторінці оформлення:',
            'hide_form_fields_at_checkout_helper' => 'Виберіть, які поля слід приховати на сторінці оформлення. Ці поля не будуть видимі для клієнтів.',
            'load_countries_states_cities_from_location_plugin' => 'Завантажити країни, регіони, міста з плагіна місцезнаходження',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Після зміни цієї опції вам потрібно оновити всі адреси знову. Ви повинні встановити це один раз.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Тоді вам потрібно перейти до Інструменти -> Імпорт/Експорт даних для імпорту даних про місцезнаходження.',
            'minimum_order_amount' => 'Мінімальна сума замовлення для розміщення замовлення (:currency).',
            'minimum_order_amount_helper' => 'Встановіть мінімальну загальну суму, необхідну для обробки замовлення. Замовлення нижче цієї суми не будуть прийняті.',
            'zip_code_enabled' => 'Увімкнути поштовий індекс',
            'zip_code_enabled_helper' => 'Увімкнути або вимкнути поле поштового індексу у формі адреси доставки.',
            'billing_address_enabled' => 'Увімкнути адресу виставлення рахунку',
            'billing_address_enabled_helper' => 'Дозволити клієнтам вводити окрему адресу виставлення рахунку, яка відрізняється від адреси доставки.',
            'display_tax_fields_at_checkout_page' => 'Відображати поля податкової інформації на сторінці оформлення',
            'display_tax_fields_at_checkout_page_helper' => 'Якщо увімкнено, поля податкової інформації будуть відображатися для введення податкових деталей компанії для отримання рахунку.',
            'use_city_field_as_field_text' => 'Використовувати поле міста як текстове поле',
            'available_countries' => 'Доступні країни',
            'all' => 'Все',
            'all_helper_text' => 'Якщо ви зніміть позначки з усіх країн, це застосується для всіх країн.',
            'enable_guest_checkout' => 'Увімкнути оформлення гостями',
            'enable_guest_checkout_helper' => 'Якщо увімкнено, клієнти можуть розміщувати замовлення без створення облікового запису.',
            'recently_viewed' => [
                'enable' => 'Увімкнути нещодавно переглянуті товари клієнта',
                'enable_helper' => 'Відстежувати та відображати товари, які клієнти нещодавно переглядали. Це допомагає клієнтам легко знаходити товари, якими вони цікавилися.',
                'max' => 'Максимальна кількість нещодавно переглянутих товарів клієнта',
                'max_helper_text' => 'Якщо встановлено 0, обмеження не буде.',
            ],
            'minimum_order_quantity' => 'Мінімальна кількість замовлення',
            'minimum_order_quantity_helper' => 'Мінімальна кількість для розміщення замовлення. Залиште 0, якщо ви не хочете це встановлювати.',
            'maximum_order_quantity' => 'Максимальна кількість замовлення',
            'maximum_order_quantity_helper' => 'Максимальна кількість для розміщення замовлення. Залиште 0, якщо ви не хочете це встановлювати.',
            'default_country_at_checkout_page' => 'Країна за замовчуванням на сторінці оформлення',
            'default_country_at_checkout_page_placeholder' => 'Виберіть країну',
            'default_country_at_checkout_page_help' => 'Якщо ви виберете країну, вона буде вибрана за замовчуванням на сторінці оформлення.',
            'checkout_product_quantity_editable' => 'Дозволити клієнтам змінювати кількість товару на сторінці оформлення',
            'checkout_product_quantity_editable_helper' => 'Коли увімкнено, клієнти можуть змінювати кількість товарів безпосередньо на сторінці оформлення без повернення до кошика.',
            'show_terms_and_policy_checkbox' => 'Показувати прапорець умов і політики',
            'show_terms_and_policy_checkbox_helper' => 'Якщо увімкнено, клієнти повинні погодитися з умовами та політикою перед розміщенням замовлення. Будь ласка, спочатку налаштуйте URL умов і політики конфіденційності в Вигляд -> Опції теми.',
            'terms_and_policy_checkbox_checked_by_default' => 'Прапорець умов і політики відзначений за замовчуванням',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Якщо увімкнено, прапорець умов і політики буде попередньо відзначений при завантаженні форми оформлення.',
            'checkout_acceptance_message_enabled' => 'Показувати повідомлення прийняття оформлення',
            'checkout_acceptance_message_enabled_helper' => 'Відображати інформаційне повідомлення, яке інформує клієнтів про умови, з якими вони погоджуються, розміщуючи замовлення.',
            'hide_customer_info_at_checkout' => 'Приховати інформацію про клієнта при оформленні',
            'hide_customer_info_at_checkout_helper' => 'Приховати інформацію про обліковий запис клієнта та кнопку виходу зі сторінки оформлення. Коли увімкнено, увійдені клієнти не побачать відображену інформацію про свій обліковий запис.',
        ],
    ],
    'return' => [
        'name' => 'Повернення',
        'description' => 'Налаштування правил для налаштувань повернення',
        'panel_description' => 'Перегляд і оновлення налаштувань повернення',
        'form' => [
            'is_enabled_order_return' => 'Увімкнено повернення замовлень',
            'allow_partial_return' => 'Дозволити часткове повернення',
            'allow_partial_return_description' => 'Клієнт може повернути кілька товарів, не потрібно повертати всі товари в замовленні.',
            'returnable_days' => 'Дні для повернення',
            'return_settings_helper' => 'Кількість днів, протягом яких клієнт може запитати повернення після завершення замовлення.',
        ],
    ],
    'invoice' => [
        'name' => 'Рахунки',
        'description' => 'Перегляд і оновлення налаштувань рахунків',
        'company_settings' => 'Налаштування компанії',
        'company_settings_description' => 'Налаштування інформації про компанію для виставлення рахунків',
        'form' => [
            'company_name' => 'Назва компанії',
            'company_address' => 'Адреса компанії',
            'company_zipcode' => 'Поштовий індекс компанії',
            'company_email' => 'Email компанії',
            'company_phone' => 'Телефон компанії',
            'company_logo' => 'Логотип компанії',
            'company_tax_id' => 'Податковий номер компанії',
            'invoice_code_prefix' => 'Префікс коду рахунку',
            'using_custom_font_for_invoice' => 'Використовувати користувацький шрифт для рахунку',
            'invoice_font_family' => 'Сімейство шрифтів рахунку (Тільки для латинської мови)',
            'enable_invoice_stamp' => 'Увімкнути штамп рахунку',
            'add_language_support' => 'Додати підтримку мови',
            'invoice_processing_library' => 'Бібліотека обробки рахунків',
            'only_latin_languages' => 'Тільки латинські мови',
            'disable_order_invoice_until_order_confirmed' => 'Вимкнути рахунок замовлення до підтвердження замовлення',
            'date_format' => 'Формат дати',
            'languages' => [
                'arabic' => 'Арабська',
                'bangladesh' => 'Бенгальська',
                'chinese' => 'Китайська',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Податок',
        'description' => 'Налаштування податку',
        'enable' => 'Увімкнути податок?',
        'display_product_price_including_taxes' => 'Відображати ціну товару включаючи податки?',
        'display_tax_description' => 'Відображати податкову інформацію на ціні товару?',
        'display_tax_description_help' => 'Показувати текст на кшталт "(Включаючи X% ПДВ)" або "(Без X% ПДВ)" поруч з цінами товарів на сторінці деталей товару.',
        'tax_included_in_products_price' => 'Податок включено в ціни товарів',
        'tax_included_in_products_price_description' => 'Податок буде включено в ціни товарів',
        'tax_setting' => 'Налаштування податку',
        'tax_setting_description' => 'Налаштувати параметри податку',
        'tax_management' => 'Управління податками',
        'tax_management_description' => 'Переглянути та керувати вашими податками',
        'form' => [
            'enable_tax' => 'Увімкнути податок',
            'display_company_invoice_information_fields_at_checkout_page' => 'Відображати поля інформації про рахунок компанії на сторінці оформлення',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Якщо увімкнено, поля інформації про рахунок компанії будуть відображатися на сторінці оформлення. Потрібно заповнити поля інформації про рахунок компанії.',
            'default_tax_rate' => 'Ставка податку за замовчуванням',
            'default_tax_rate_description' => 'Важливо: буде застосовано, якщо податок не вибрано в товарі.',
            'select_tax' => '-- Вибрати --',
            'display_product_price_including_taxes' => 'Відображати ціну товару включаючи податки',
        ],
    ],
    'customer' => [
        'name' => 'Клієнти',
        'description' => 'Перегляд і оновлення налаштувань клієнтів',
        'customer_setting' => 'Налаштування клієнтів',
        'customer_setting_description' => 'Налаштувати параметри клієнтів',
        'form' => [
            'enable_customer_registration' => 'Увімкнути реєстрацію клієнтів',
            'enable_customer_registration_helper' => 'Якщо вимкнено, клієнти не зможуть реєструвати нові облікові записи. Існуючі клієнти все ще можуть входити.',
            'verify_customer_email' => "Підтвердження email клієнта",
            'verify_customer_email_helper' => "Коли увімкнено, посилання для підтвердження буде надіслано на email клієнта, клієнти повинні натиснути це посилання, щоб підтвердити свій email перед тим, як увійти. Потрібно налаштувати email в Адмін -> Налаштування -> Email для надсилання email підтвердження.",
            'verification_expire_minutes' => 'Час закінчення посилання для підтвердження',
            'verification_expire_minutes_helper' => 'Час у хвилинах, протягом якого посилання для підтвердження email буде дійсним. За замовчуванням - 60 хвилин (1 година). Максимум - 10080 хвилин (7 днів).',
            'login_using_phone' => 'Вхід з номером телефону замість email',
            'login_option' => 'Опція входу',
            'login_with_email' => 'Вхід з email',
            'login_with_phone' => 'Вхід з телефоном',
            'login_with_email_or_phone' => 'Вхід з email або телефоном',
            'enabled_customer_account_deletion' => 'Увімкнути видалення облікового запису клієнта',
            'enabled_customer_account_deletion_helper' => 'Коли увімкнено, клієнти можуть видалити свій обліковий запис в панелі клієнта → Налаштування облікового запису.',
            'enabled_customer_dob_field' => 'Увімкнути поле дати народження клієнта',
            'enabled_customer_dob_field_helper' => 'Коли увімкнено, клієнти можуть вводити дату народження в панелі клієнта → Налаштування облікового запису.',
            'enabled_phone_field_in_registration_form' => 'Увімкнути поле телефону в формі реєстрації',
            'enabled_phone_field_in_registration_form_helper' => 'Коли увімкнено, поле телефону буде додано до форми реєстрації.',
            'make_customer_phone_number_required' => 'Зробити номер телефону клієнта обов\'язковим',
            'make_customer_phone_number_required_helper' => 'Коли увімкнено, клієнти повинні ввести свій номер телефону під час реєстрації. Це завжди обов\'язково для клієнтів, які входять за допомогою номера телефону.',
            'default_avatar' => 'Аватар за замовчуванням',
            'default_avatar_helper' => 'Аватар за замовчуванням для клієнта, коли у нього немає аватара. Якщо ви не виберете жодного зображення, воно буде згенеровано за допомогою вашого логотипу або першого символу імені клієнта.',
            'keep_email_field_in_registration_form' => 'Зберегти поле email у формі реєстрації',
            'keep_email_field_in_registration_form_helper' => 'Коли вимкнено, поле email буде приховано у формі реєстрації, коли опція входу - "Вхід з телефоном".',
        ],
    ],
    'shipping' => [
        'name' => 'Доставка',
        'description' => 'Перегляд і оновлення налаштувань доставки',
        'shipping_rule' => 'Правила доставки',
        'shipping_rule_description' => 'Налаштування правил для розрахунку вартості доставки',
        'shipping_setting' => 'Налаштування доставки',
        'shipping_setting_description' => 'Налаштувати параметри доставки',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Приховати інші опції доставки, якщо є безкоштовна доставка в списку',
            'disable_shipping_options' => 'Вимкнути опції доставки',
            'disable_shipping_options_helper' => 'Опції доставки будуть видалені на сторінці оформлення, клієнт не зможе вибрати опції доставки.',
            'sort_shipping_options_direction' => 'Напрямок сортування опцій доставки',
            'sort_shipping_options_direction_helper' => 'Сортувати опції доставки за ціною від нижчої до вищої або від вищої до нижчої.',
            'price_lower_to_higher' => 'Ціна від нижчої до вищої',
            'price_higher_to_lower' => 'Ціна від вищої до нижчої',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Налаштування параметрів webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'Налаштуйте URL webhook для отримання повідомлень про різні події замовлень',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook розміщення замовлення (метод: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Щоб отримувати повідомлення при розміщенні замовлення, ви можете налаштувати зовнішній URL webhook. Якщо у вас є зовнішній URL webhook, ви можете ввести цей URL або просто залишити порожнім.',
            'order_updated_webhook_url' => 'URL webhook оновлення замовлення (метод: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Щоб отримувати повідомлення при оновленні замовлення, ви можете налаштувати зовнішній URL webhook. Це включає зміни статусу, оновлення адреси та інші модифікації замовлення.',
            'shipping_status_updated_webhook_url' => 'URL webhook оновлення статусу доставки (метод: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Щоб отримувати повідомлення при зміні статусу доставки (наприклад, відправлено, доставлено, скасовано), ви можете налаштувати зовнішній URL webhook.',
            'order_completed_webhook_url' => 'URL webhook завершення замовлення (метод: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Щоб отримувати повідомлення при завершенні замовлення, ви можете налаштувати зовнішній URL webhook.',
            'order_cancelled_webhook_url' => 'URL webhook скасування замовлення (метод: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Щоб отримувати повідомлення при скасуванні замовлення, ви можете налаштувати зовнішній URL webhook.',
            'payment_status_updated_webhook_url' => 'URL webhook оновлення статусу оплати (метод: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Щоб отримувати повідомлення при зміні статусу оплати (наприклад, оплачено, не вдалося, повернено), ви можете налаштувати зовнішній URL webhook.',
            'abandoned_cart_webhook_url' => 'URL webhook покинутого кошика (метод: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Щоб отримувати повідомлення про покинуті кошики та стежити за клієнтами, ви можете налаштувати зовнішній URL webhook. Повідомлення надсилаються після налаштованого періоду часу.',
        ],
        'test_button' => 'Тестувати Webhook',
        'test_success' => 'Тест webhook успішний! Кінцева точка відповіла правильно.',
        'test_failed' => 'Тест webhook не вдався. Кінцева точка не відповіла як очікувалося.',
        'test_error' => 'Помилка тесту webhook: :error',
        'please_enter_url' => 'Будь ласка, спочатку введіть URL webhook',
        'testing' => 'Тестування...',
        'test_failed_title' => 'Тест не вдався!',
        'test_success_title' => 'Тест успішний!',
        'status_code' => 'Код статусу',
        'error_occurred' => 'Сталася помилка під час тестування webhook',
    ],
    'store_locator' => [
        'name' => 'Локатори магазинів',
        'description' => 'Перегляд і оновлення списків ваших мереж',
        'store_locator_description' => 'Всі списки ваших мереж, основних магазинів, філій тощо. Локації можуть використовуватися для відстеження продажів та допомоги нам налаштувати податкові ставки для стягнення при продажу товарів.',
        'form' => [
            'change_primary_store' => 'змінити локатор магазину за замовчуванням',
            'add_location' => 'Додати місцезнаходження',
            'edit_location' => 'Редагувати місцезнаходження',
            'delete_location' => 'Видалити місцезнаходження',
            'delete_location_confirmation' => 'Ви впевнені, що хочете видалити це місцезнаходження? Цю дію неможливо скасувати.',
            'change_primary_location' => 'Змінити основне місцезнаходження',
            'save_location' => 'Зберегти місцезнаходження',
            'add_new' => 'Додати нове',
        ],
    ],
    'tracking' => [
        'name' => 'Відстеження',
        'description' => 'Перегляд і оновлення налаштувань відстеження',
        'manage_tracking' => 'Управління відстеженням',
        'manage_tracking_description' => 'Управління відстеженням: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Увімкнути Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Перейдіть на https://developers.facebook.com/docs/meta-pixel для створення Facebook Pixel. Переконайтеся, що ваш піксель активний і правильно налаштований.',
            'facebook_pixel_id' => 'ID Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Приклад: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Увімкнути режим налагодження Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Увімкнути режим налагодження для виводу подій Facebook Pixel в консоль браузера та усунення проблем відстеження',
            'enable_google_tag_manager_tracking_events' => 'Увімкнути події відстеження Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Коли увімкнено, події електронної комерції будуть відстежуватися через Google Tag Manager. Переконайтеся, що ви налаштували Google Tag Manager вище.',
            'google_ads_conversion_id' => 'ID конверсії Google Ads',
            'google_ads_conversion_id_helper' => 'Введіть свій ID конверсії Google Ads (формат: AW-123456789/AbC-D_efG-h1_ijk-lmN) для відстеження конверсій покупок на сторінці подяки.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'ID Facebook Pixel має бути 15-16 цифр (наприклад, 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Маркетплейс',
        'description' => 'Перегляд і оновлення налаштувань маркетплейсу',
    ],
    'standard_and_format' => [
        'name' => 'Стандарт і формат',
        'panel_description' => 'Перегляд і оновлення налаштувань стандарту та формату',
        'description' => 'Стандарти та формати використовуються для розрахунку таких речей, як ціни товарів, ваги доставки та час замовлень.',
        'form' => [
            'change_order_format' => 'Редагувати формат коду замовлення (необов\'язково)',
            'change_order_format_description' => 'Код замовлення за замовчуванням починається з: number. Ви можете змінити початковий або кінцевий рядок для створення потрібного коду замовлення, наприклад "DH-: number" або ": number-A"',
            'start_with' => 'Починається з',
            'end_with' => 'Закінчується на',
            'order_will_be_shown' => 'Ваш код замовлення буде показано',
            'weight_unit' => 'Одиниця ваги',
            'height_unit' => 'Одиниця довжини / висоти',
            'weight_unit_gram' => 'Грам (г)',
            'weight_unit_kilogram' => 'Кілограм (кг)',
            'weight_unit_lb' => 'Фунт (lb)',
            'weight_unit_oz' => 'Унція (oz)',
            'height_unit_cm' => 'Сантиметр (см)',
            'height_unit_m' => 'Метр (м)',
            'height_unit_inch' => 'Дюйм',
        ],
    ],
    'sale_popup' => [
        'name' => 'Спливаюче вікно розпродажу',
        'description' => 'Легко налаштуйте параметри спливаючого вікна розпродажу',
    ],
    'flash_sale' => [
        'name' => 'Блискавичний розпродаж',
        'description' => 'Налаштуйте параметри блискавичного розпродажу для пропозиції обмежених за часом рекламних знижок',
        'enable' => 'Увімкнути функціональність блискавичного розпродажу',
        'enable_helper' => 'Коли увімкнено, ви можете створювати та керувати блискавичними розпродажами зі спеціальними зниженими цінами на обмежений період часу.',
        'show_sale_count_left' => 'Відображати трекер інвентаря',
        'show_sale_count_left_description' => 'Показувати прогрес-бар з "X продано з Y" для створення терміновості та заохочення швидких покупок під час блискавичних розпродажів.',
    ],
    'payment_method_cod_minimum_amount' => 'Мінімальна сума замовлення - :currency (Необов\'язково)',
    'payment_method_minimum_amount' => 'Мінімальна сума замовлення - :currency (Необов\'язково)',
    'display_bank_info_at_the_checkout_success_page' => 'Відображати банківську інформацію на сторінці успіху оформлення?',
    'invoice_templates' => 'Шаблони рахунків',
];
