<?php

return [
    'name' => 'Locations',
    'all_states' => 'All states',
    'abbreviation' => 'Abbreviation',
    'abbreviation_placeholder' => 'E.g: CA',
    'import_type' => [
        'country' => 'Country',
        'state' => 'State',
        'city' => 'City',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Country',
            'state' => 'State',
            'city' => 'City',
        ],
    ],
    'export' => [
        'total' => 'Total Locations',
        'total_countries' => 'Total Countries',
        'total_states' => 'Total States',
        'total_cities' => 'Total Cities',
        'description' => 'Export your location data like countries, states, and cities.',
        'import_type' => 'Location Type',
        'all_types' => 'All types',
        'all_status' => 'All status',
        'use_chunked_export' => 'Use chunked export',
        'use_chunked_export_helper' => 'Process data in smaller batches to avoid memory issues with large datasets.',
        'optimize_memory' => 'Optimize memory usage',
        'optimize_memory_helper' => 'Load only necessary columns and free memory periodically during export.',
        'use_streaming' => 'Use streaming mode',
        'use_streaming_helper' => 'Stream data directly to file without loading everything into memory. Recommended for very large datasets.',
        'streaming_enabled_title' => 'Streaming mode enabled',
        'streaming_enabled_message' => 'Data will be streamed directly to the file for optimal memory usage.',
        'chunk_size' => 'Chunk size',
        'chunk_size_helper' => 'Number of records to process in each batch. Lower values use less memory but take longer.',
        'recommended_range' => 'Recommended range',
        'optimal_range' => 'Optimal',
        'too_small_slow' => 'Too small (slower)',
        'too_large_timeouts' => 'Too large (may timeout)',
        'range_large_export' => '150-300 records',
        'range_medium_export' => '200-500 records',
        'range_small_export' => '300-700 records',
        'large_dataset_title' => 'Large dataset detected',
        'large_dataset_message' => 'Optimized export mode enabled automatically for better performance.',
        'large_dataset_warning_title' => 'Large Dataset Export Recommendations',
        'large_dataset_specific_message' => 'You\'re exporting :count locations. For optimal performance, we recommend using CSV format with chunked export.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Recommended)',
        'chunk_label' => 'Chunk Size',
        'chunk_recommended' => '150-300 records',
        'time_label' => 'Estimated Time',
        'time_estimate' => '2-5 minutes',
        'pro_tip' => 'Pro Tip:',
        'pro_tip_message' => 'You can filter by location type (country/state/city) to export specific data.',
        'medium_dataset_detected' => 'Medium dataset detected',
        'medium_dataset_message' => 'Exporting :count locations. The export should complete within 1-2 minutes.',
        'excel_disabled_warning' => 'Excel format is not recommended for large datasets (:count+ records). Use CSV instead.',
    ],
    'import' => [
        'description' => 'Import location data easily from available data or by uploading a CSV/Excel file.',
        'rules' => [
            'name' => 'The name of the location is mandatory and should not exceed 120 characters.',
            'slug' => 'The slug of the location, if provided, should not exceed 120 characters.',
            'import_type' => 'The type of import is mandatory and should be one of the predefined values.',
            'order' => 'The order of the location, if provided, should be a positive integer between 0 and 127.',
            'abbreviation' => 'The abbreviation of the location, if provided, should not exceed 10 characters.',
            'status' => 'The status of the location is mandatory and should be one of the predefined values.',
            'country' => 'The country field is mandatory if the import type is state or city.',
            'state' => 'The state field is mandatory if the import type is city.',
            'nationality' => 'The nationality of the location, if provided, should not exceed 120 characters.',
        ],
    ],
];
