<?php

return [
    'name' => 'Posizioni',
    'all_states' => 'Tutti gli stati',
    'abbreviation' => 'Abbreviazione',
    'abbreviation_placeholder' => 'Es.: CA',
    'import_type' => [
        'country' => 'Paese',
        'state' => 'Stato',
        'city' => 'Città',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Paese',
            'state' => 'Stato',
            'city' => 'Città',
        ],
    ],
    'export' => [
        'total' => 'Totale Posizioni',
        'total_countries' => 'Totale Paesi',
        'total_states' => 'Totale Stati',
        'total_cities' => 'Totale Città',
        'description' => 'Esporta i tuoi dati di posizione come paesi, stati e città.',
        'import_type' => 'Tipo di Posizione',
        'all_types' => 'Tutti i tipi',
        'all_status' => 'Tutti gli stati',
        'use_chunked_export' => 'Usa esportazione suddivisa',
        'use_chunked_export_helper' => 'Elabora i dati in batch più piccoli per evitare problemi di memoria con dataset di grandi dimensioni.',
        'optimize_memory' => 'Ottimizza utilizzo memoria',
        'optimize_memory_helper' => 'Carica solo le colonne necessarie e libera periodicamente la memoria durante l\'esportazione.',
        'use_streaming' => 'Usa modalità streaming',
        'use_streaming_helper' => 'Trasmetti i dati direttamente al file senza caricare tutto in memoria. Consigliato per dataset molto grandi.',
        'streaming_enabled_title' => 'Modalità streaming abilitata',
        'streaming_enabled_message' => 'I dati verranno trasmessi direttamente al file per un utilizzo ottimale della memoria.',
        'chunk_size' => 'Dimensione batch',
        'chunk_size_helper' => 'Numero di record da elaborare in ogni batch. Valori più bassi usano meno memoria ma richiedono più tempo.',
        'recommended_range' => 'Intervallo consigliato',
        'optimal_range' => 'Ottimale',
        'too_small_slow' => 'Troppo piccolo (più lento)',
        'too_large_timeouts' => 'Troppo grande (possibile timeout)',
        'range_large_export' => '150-300 record',
        'range_medium_export' => '200-500 record',
        'range_small_export' => '300-700 record',
        'large_dataset_title' => 'Rilevato dataset di grandi dimensioni',
        'large_dataset_message' => 'Modalità di esportazione ottimizzata abilitata automaticamente per migliori prestazioni.',
        'large_dataset_warning_title' => 'Raccomandazioni Esportazione Dataset Grandi',
        'large_dataset_specific_message' => 'Stai esportando :count posizioni. Per prestazioni ottimali, consigliamo di utilizzare il formato CSV con esportazione suddivisa.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Consigliato)',
        'chunk_label' => 'Dimensione Batch',
        'chunk_recommended' => '150-300 record',
        'time_label' => 'Tempo Stimato',
        'time_estimate' => '2-5 minuti',
        'pro_tip' => 'Suggerimento:',
        'pro_tip_message' => 'Puoi filtrare per tipo di posizione (paese/stato/città) per esportare dati specifici.',
        'medium_dataset_detected' => 'Rilevato dataset di medie dimensioni',
        'medium_dataset_message' => 'Esportazione di :count posizioni. L\'esportazione dovrebbe completarsi entro 1-2 minuti.',
        'excel_disabled_warning' => 'Il formato Excel non è consigliato per dataset di grandi dimensioni (:count+ record). Usa CSV invece.',
    ],
    'import' => [
        'description' => 'Importa facilmente i dati di posizione da dati disponibili o caricando un file CSV/Excel.',
        'rules' => [
            'name' => 'Il nome della posizione è obbligatorio e non deve superare i 120 caratteri.',
            'slug' => 'Lo slug della posizione, se fornito, non deve superare i 120 caratteri.',
            'import_type' => 'Il tipo di importazione è obbligatorio e deve essere uno dei valori predefiniti.',
            'order' => 'L\'ordine della posizione, se fornito, deve essere un numero intero positivo tra 0 e 127.',
            'abbreviation' => 'L\'abbreviazione della posizione, se fornita, non deve superare i 10 caratteri.',
            'status' => 'Lo stato della posizione è obbligatorio e deve essere uno dei valori predefiniti.',
            'country' => 'Il campo paese è obbligatorio se il tipo di importazione è stato o città.',
            'state' => 'Il campo stato è obbligatorio se il tipo di importazione è città.',
            'nationality' => 'La nazionalità della posizione, se fornita, non deve superare i 120 caratteri.',
        ],
    ],
];
