<?php

return [
    'name' => '地點',
    'all_states' => '所有州',
    'abbreviation' => '縮寫',
    'abbreviation_placeholder' => '例如：CA',
    'enums' => [
        'import_type' => [
            'country' => '國家',
            'state' => '州',
            'city' => '城市',
        ],
    ],
    'import_type' => '導入類型',
    'export' => [
        'total' => '總地點',
        'total_countries' => '總國家',
        'total_states' => '總州',
        'total_cities' => '總城市',
        'description' => '導出你的地點數據，例如國家、州和城市。',
        'import_type' => '導入類型',
        'all_types' => '所有類型',
        'all_status' => '所有狀態',
        'use_chunked_export' => '使用分塊導出',
        'use_chunked_export_helper' => '對大型導出文件分塊處理數據。建議用於超過1,000條記錄的數據集。',
        'optimize_memory' => '優化記憶體使用',
        'optimize_memory_helper' => '通過分步處理減少記憶體使用。建議用於伺服器記憶體有限的情況。',
        'use_streaming' => '使用串流傳輸',
        'use_streaming_helper' => '直接將數據寫入檔案而不是儲存在記憶體中。最適合非常大的導出。',
        'streaming_enabled_title' => '已啟用串流傳輸',
        'streaming_enabled_message' => '數據將直接串流傳輸到檔案以實現最佳效率。',
        'chunk_size' => '塊大小',
        'chunk_size_helper' => '一次處理的行數。較小的值使用較少的記憶體，但可能會減慢導出速度。',
        'recommended_range' => '推薦範圍',
        'optimal_range' => '最佳範圍',
        'too_small_slow' => '太小的值可能會減慢處理速度',
        'too_large_timeouts' => '太大的值可能會導致逾時',
        'range_large_export' => '大型導出為500-2000',
        'range_medium_export' => '中型導出為200-1000',
        'range_small_export' => '小型導出為100-500',
        'large_dataset_title' => '檢測到大型數據集',
        'large_dataset_message' => '由於您的數據規模，導出可能需要一些時間。這是正常過程並確保穩定性。',
        'large_dataset_warning_title' => '大型導出',
        'large_dataset_specific_message' => '您正在導出超過:count條記錄。此操作可能需要幾分鐘。',
        'format_label' => '格式',
        'csv_recommended' => 'CSV（推薦用於大型數據集）',
        'chunk_label' => '塊大小',
        'chunk_recommended' => ':size行（推薦）',
        'time_label' => '預計時間',
        'time_estimate' => '約:minutes分鐘',
        'pro_tip' => '專業提示',
        'pro_tip_message' => 'CSV格式為大型導出提供更好的性能和兼容性。您可以將其導入Excel或Google Sheets。',
        'medium_dataset_detected' => '檢測到中型數據集',
        'medium_dataset_message' => '此導出可能需要幾秒鐘。為了獲得最佳性能，我們建議使用分塊導出設定。',
        'excel_disabled_warning' => 'Excel導出不適用於超過:count條記錄的數據集。請使用CSV格式。',
    ],
    'import' => [
        'description' => '輕鬆從可用數據導入位置數據或通過上傳CSV/Excel文件。',
        'rules' => [
            'name' => '地點名稱是必需的，並且不得超過120個字符。',
            'slug' => '地點的網址部分（如果提供）不應超過120個字符。',
            'import_type' => '進口類型是必需的，應該是預定值之一。',
            'order' => '位置的順序（如果提供）應該是一個介乎於0和127之間的正整數。',
            'abbreviation' => '地點的縮寫（如果提供）不應超過10個字符。',
            'status' => '位置的狀態是必需的，應該是預定義值之一。',
            'country' => '如果進口類型是州或城市，國家欄位是必填的。',
            'state' => '如果導入類型是城市，州字段是必需的。',
            'nationality' => '地點的國籍（如果提供）不應超過120個字符。',
        ],
    ],
];
