<?php

return [
    'name' => 'Tržiště',
    'email' => [
        'title' => 'Tržiště',
        'description' => 'Konfigurace e-mailových šablon pro Tržiště',
        'store_new_order_title' => 'Oznámení o nové objednávce',
        'store_new_order_description' => 'Odeslat e-mail majiteli obchodu při zadání objednávky',
        'verify_vendor_title' => 'Ověřit prodejce',
        'verify_vendor_description' => 'Odeslat e-mail administrátorovi při registraci prodejce',
        'pending_product_approval_title' => 'Čekající schválení produktu',
        'pending_product_approval_description' => 'Odeslat e-mail administrátorovi při zveřejnění produktu prodejcem',
        'vendor_account_approved_title' => 'Účet prodejce schválen',
        'vendor_account_approved_description' => 'Odeslat e-mail prodejci při schválení účtu',
        'product_approved_title' => 'Produkt schválen',
        'product_approved_description' => 'Odeslat e-mail prodejci při schválení produktu',
        'withdrawal_approved_title' => 'Výběr schválen',
        'withdrawal_approved_description' => 'Odeslat e-mail prodejci při schválení požadavku na výběr',
        'vendor_account_rejected_title' => 'Účet prodejce zamítnut',
        'vendor_account_rejected_description' => 'Odeslat e-mail prodejci při zamítnutí účtu',
        'vendor_account_unblocked_title' => 'Účet prodejce odblokován',
        'vendor_account_unblocked_description' => 'Odeslat e-mail prodejci při odblokování účtu',
        'vendor_account_blocked_title' => 'Účet prodejce zablokován',
        'vendor_account_blocked_description' => 'Odeslat e-mail prodejci při zablokování účtu',
        'store_new_order_subject' => 'Nová objednávka(y) na {{ site_title }}',
        'verify_vendor_subject' => 'Nový prodejce na {{ site_title }} potřebuje být ověřen',
        'vendor_account_approved_subject' => 'Váš účet byl schválen pro prodej na {{ site_title }}',
        'vendor_account_rejected_subject' => 'Váš účet byl zamítnut pro prodej na {{ site_title }}',
        'pending_product_approval_subject' => 'Nový produkt potřebuje být schválen pro prodej na {{ site_title }}',
        'product_approved_subject' => 'Váš produkt byl schválen pro prodej na {{ site_title }}',
        'withdrawal_approved_subject' => 'Váš požadavek na výběr byl schválen',
        'welcome_vendor_title' => 'Vítejte prodejce',
        'welcome_vendor_description' => 'Odeslat e-mail prodejci po registraci',
        'welcome_vendor_subject' => 'Vítejte na {{ site_title }}!',
        'contact_store_title' => 'Kontakt obchodu',
        'contact_store_description' => 'Odeslat e-mail majiteli obchodu když zákazník kontaktuje obchod',
        'contact_store_subject' => 'Nová zpráva od zákazníka',
        'vendor_account_blocked_subject' => 'Váš účet prodejce na {{ site_title }} byl zablokován',
        'vendor_account_unblocked_subject' => 'Váš účet prodejce na {{ site_title }} byl odblokován',
        'order_cancellation_to_vendor_title' => 'Zrušení objednávky (bude odesláno prodejci)',
        'order_cancellation_to_vendor_description' => 'Odeslat prodejci když zákazník zruší objednávku',
        'order_cancellation_to_vendor_subject' => 'Objednávka :order_id byla zrušena zákazníkem',
        'store_verified_title' => 'Ověření obchodu schváleno',
        'store_verified_description' => 'Odeslat oznámení když je obchod ověřen',
        'store_verified_subject' => 'Váš obchod {{ store_name }} byl ověřen',
        'store_unverified_title' => 'Ověření obchodu odebráno',
        'store_unverified_description' => 'Odeslat oznámení když je odebrán status ověření obchodu',
        'store_unverified_subject' => 'Status ověření změněn pro {{ store_name }}',
        'verified_by' => 'Ověřeno',
        'verified_at' => 'Ověřeno dne',
        'unverified_by' => 'Neověřeno',
        'unverified_at' => 'Neověřeno dne',
        'verification_note' => 'Poznámka k ověření',
        'store' => 'Obchod',
        'order' => 'Objednávka',
        'shipment' => 'Informace o zásilce',
        'address' => 'Dodací adresa',
        'products' => 'Produkty objednávky',
        'customer_message' => 'Zpráva zákazníka',
        'customer_name' => 'Jméno zákazníka',
        'customer_email' => 'E-mail zákazníka',
        'block_reason' => 'Důvod blokování',
        'block_date' => 'Datum blokování',
        'unblock_date' => 'Datum odblokování',
    ],
    'email_templates' => [
        'dear_vendor' => 'Vážený :vendor_name,',
        'dear_admin' => 'Vážený administrátore,',
        'hello' => 'Dobrý den,',
        'happy_selling' => 'Šťastný prodej!',
        'thank_you_understanding' => 'Děkujeme za pochopení.',
        'email_sent_by_team' => 'Tento e-mail byl odeslán týmem {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'Tento e-mail byl odeslán od :customer_name (:customer_email) prostřednictvím vašeho kontaktního formuláře na :site_title.',
        'contact_store_reply_instruction' => 'Můžete odpovědět přímo na tento e-mail pro reakci :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Váš účet prodejce na {{ site_title }} byl <strong>zablokován</strong> od :block_date.',
        'vendor_account_blocked_reason' => 'Důvod blokování: :block_reason',
        'vendor_account_blocked_contact_support' => 'Pokud si myslíte, že se jedná o chybu nebo máte jakékoli dotazy, kontaktujte náš tým podpory.',
        'vendor_account_unblocked_message' => 'S potěšením vás informujeme, že váš účet prodejce na {{ site_title }} byl <strong>odblokován</strong> od :unblock_date.',
        'vendor_account_unblocked_resume' => 'Nyní můžete přistupovat ke svému účtu a obnovit své aktivity.',
        'vendor_account_unblocked_questions' => 'Pokud máte jakékoliv dotazy, neváhejte kontaktovat náš tým podpory.',
        'vendor_account_approved_title' => 'Účet prodejce schválen',
        'vendor_account_approved_message' => 'Váš účet byl schválen pro prodej na našem webu <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Účet prodejce zamítnut',
        'vendor_account_rejected_message' => 'S lítostí vás informujeme, že váš účet nebyl schválen pro prodej na našem webu <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Objednávka úspěšná!',
        'store_new_order_message' => 'Máte novou objednávku na :site_title!',
        'customer_information' => 'Informace o zákazníkovi',
        'field_name' => 'Jméno',
        'field_phone' => 'Telefon',
        'field_email' => 'E-mail',
        'field_address' => 'Adresa',
        'field_note' => 'Poznámka',
        'order_number' => 'Číslo objednávky',
        'order_date' => 'Datum objednávky',
        'shipping_method' => 'Způsob doručení',
        'payment_method' => 'Způsob platby',

        // Product Approval
        'product_approved_title' => 'Produkt schválen',
        'product_approved_message' => 'Váš produkt byl schválen pro prodej na našem webu <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Čekající schválení produktu',
        'pending_product_approval_message' => 'Nový produkt byl vytvořen :store_name <a href=":product_url">:product_name</a> čeká na schválení.',

        // Verify Vendor
        'verify_vendor_title' => 'Ověřit prodejce',
        'verify_vendor_message' => 'Máte nového prodejce, který potřebuje být ověřen na :site_title!',
        'vendor_information' => 'Informace o prodejci',
        'shop_information' => 'Informace o obchodě',
        'field_store_name' => 'Název obchodu',
        'field_store_phone' => 'Telefonní číslo obchodu',
        'visit_store_button' => 'Navštívit obchod',

        // Withdrawal
        'withdrawal_approved_title' => 'Výběr schválen',
        'withdrawal_approved_message' => 'Váš požadavek na výplatu byl schválen, brzy pošleme <strong>:withdrawal_amount</strong> na vaše bankovní informace.',

        // Order Cancellation
        'order_cancellation_title' => 'Zákazník zrušil objednávku :order_id',
        'order_cancellation_message' => 'Zákazník :customer_name zrušil objednávku <strong>:order_id</strong> z důvodu :cancellation_reason.',
        'order_items_header' => 'Zde je to, co jste objednal:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Vítejte prodejce',
        'welcome_vendor_greeting' => 'S radostí vás vítáme v :store_name!',
        'welcome_vendor_registration_complete' => 'Vaše registrace prodejce byla úspěšně dokončena a nyní jste součástí naší živé komunity prodejců.',
        'welcome_vendor_next_steps' => 'Zde je to, co můžete udělat dále:',
        'welcome_vendor_step_login' => 'Přihlaste se do svého účtu prodejce pomocí svých přihlašovacích údajů.',
        'welcome_vendor_step_add_products' => 'Přidejte své produkty/služby do svého obchodu. Ujistěte se, že poskytujete podrobné popisy a poutavé obrázky pro přilákání potenciálních kupujících.',
        'welcome_vendor_support' => 'Pokud máte jakékoliv dotazy nebo potřebujete pomoc, náš tým podpory je zde, aby vám pomohl. Neváhejte se obrátit!',
        'login_vendor_account_button' => 'Přihlásit se do účtu prodejce',
        'welcome_vendor_closing' => 'Těšíme se, až uvidíme váš obchod prosperovat na :site_title!',

        // Store Verification
        'store_verified_title' => 'Ověření obchodu schváleno',
        'store_verified_message' => 'Gratulujeme! Váš obchod byl úspěšně ověřen na <strong>:site_title</strong>. Tento ověřovací odznak pomůže vybudovat důvěru u vašich zákazníků.',
        'dear_store_owner' => 'Vážený majiteli :store_name,',
        'verification_details' => 'Detaily ověření',
        'store_verified_benefits' => 'Výhody ověření',
        'verified_badge_benefit' => 'Ověřovací odznak zobrazený na vašem obchodě',
        'increased_trust_benefit' => 'Zvýšená důvěra a spolehlivost zákazníků',
        'higher_visibility_benefit' => 'Vyšší viditelnost ve výsledcích vyhledávání',
        'visit_your_store' => 'Navštívit váš obchod',
        'congratulations_verified' => 'Gratulujeme k vašemu ověření!',

        // Store Unverification
        'store_unverified_title' => 'Status ověření obchodu změněn',
        'store_unverified_message' => 'S lítostí vás informujeme, že status ověření vašeho obchodu na <strong>:site_title</strong> byl změněn.',
        'unverification_details' => 'Detaily změny statusu',
        'store_unverified_impacts' => 'Co to znamená',
        'verified_badge_removed' => 'Ověřovací odznak byl odstraněn z vašeho obchodu',
        'verification_benefits_lost' => 'Výhody ověření již nejsou aktivní',
        'store_unverified_next_steps' => 'Pokud máte jakékoliv dotazy ohledně tohoto rozhodnutí nebo byste chtěli diskutovat o opětovném ověření, prosím <strong>kontaktujte náš tým podpory</strong>.',
        'contact_support' => 'Kontaktovat podporu',
        'thank_you_understanding' => 'Děkujeme za pochopení.',
    ],
    'current_balance' => 'Aktuální zůstatek',
    'settings' => [
        'title' => 'Nastavení',
        'description' => 'Nastavení pro tržiště',
        'fee_per_order' => 'Poplatek za objednávku (%), doporučeno: 2 nebo 3',
        'default_commission_fee' => 'Výchozí provize (%), doporučeno: 2 nebo 3',
        'enable_commission_fee_for_each_category' => 'Povolit provizi pro každou kategorii?',
        'categories' => 'Kategorie',
        'select_categories' => 'Vyberte kategorie..',
        'commission_fee' => 'Provize (%)',
        'commission_fee_by_category' => 'Provize podle kategorie (%)',
        'fee_withdrawal_amount' => 'Poplatek za výběr',
        'withdrawal_fee_type' => 'Typ poplatku za výběr',
        'withdrawal_fee_types' => [
            'fixed' => 'Pevná částka',
            'percentage' => 'Procento',
        ],
        'check_valid_signature' => 'Kontrolovat platný podpis v příjmech prodejce',
        'verify_vendor' => 'Ověření prodejce (Prodejce může zveřejnit produkty pouze po ověření)',
        'verify_vendor_helper' => 'Pokud je povoleno, administrátor musí ověřit prodejce před zveřejněním produktů.',
        'requires_vendor_documentations_verification' => 'Vyžaduje ověření dokumentace prodejce',
        'requires_vendor_documentations_verification_helper' => 'Pokud je povoleno, prodejci musí nahrát dokumentaci při žádosti o prodejce.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Skrýt menu "Stát se prodejcem" v zákaznickém dashboardu',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Pokud je povoleno, menu "Stát se prodejcem" bude skryto v zákaznickém dashboardu.',
        'enable_product_approval' => 'Povolit schvalování produktů',
        'enable_product_approval_description' => 'Pokud je povoleno, administrátor musí schválit produkt před zveřejněním.',
        'hide_store_phone_number' => 'Skrýt telefonní číslo obchodu?',
        'hide_store_email' => 'Skrýt e-mail obchodu?',
        'hide_store_address' => 'Skrýt adresu obchodu?',
        'hide_store_social_links' => 'Skrýt sociální odkazy obchodu?',
        'enable_vendor_categories_filter' => 'Povolit filtr kategorií prodejce',
        'enable_vendor_categories_filter_description' => 'Zobrazit filtr kategorií na stránce obchodu prodejce. Zobrazí se pouze kategorie, které mají produkty prodejce.',
        'allow_vendor_manage_shipping' => 'Povolit prodejci spravovat doručení?',
        'allow_vendor_manage_shipping_description' => 'Pokud je povoleno, prodejce může změnit stav doručení objednávky na "doručování", "doručeno", ...',
        'charge_shipping_per_vendor' => 'Účtovat doručení za prodejce?',
        'charge_shipping_per_vendor_description' => 'Pokud je povoleno, doručení bude účtováno samostatně pro každého prodejce. Pokud je zakázáno, doručení bude účtováno jednou za celou objednávku.',
        'commission_fee_each_category_fee_name' => 'Provize nastavení provize :key',
        'commission_fee_each_category_name' => 'Kategorie nastavení provize :key',
        'add_new' => 'Přidat nový',
        'payout_methods' => 'Způsoby výplat',
        'max_upload_filesize' => 'Maximální velikost nahrávání (MB)',
        'max_upload_filesize_placeholder' => 'Výchozí: 10',
        'max_product_images_upload_by_vendor' => 'Maximální počet obrázků pro každý produkt',
        'enable_vendor_registration' => 'Povolit registraci prodejce',
        'enable_vendor_registration_helper' => 'Pokud je povoleno, prodejci si mohou registrovat účet na webu a zveřejnit své produkty.',
        'minimum_withdrawal_amount' => 'Minimální částka pro výběr (Pevná)',
        'minimum_withdrawal_amount_helper' => 'Zadejte minimální částku, kterou může prodejce vybrat. Výchozí je 0.',
        'allow_vendor_delete_their_orders' => 'Povolit prodejcům mazat jejich objednávky',
        'allow_vendor_delete_their_orders_description' => 'Když je povoleno, prodejci mohou spravovat svůj seznam objednávek odstraněním nežádoucích položek. Používejte opatrně, protože smazané objednávky mohou ovlivnit záznamy transakcí.',
        'enable_messaging_system' => 'Povolit systém zpráv',
        'enable_messaging_system_description' => 'Pokud je povoleno, prodejci a zákazníci mohou komunikovat prostřednictvím systému zpráv.',
        'term_and_privacy_policy_url' => 'URL obchodních podmínek a zásad ochrany osobních údajů',
        'show_vendor_registration_form_at_registration_page' => 'Zobrazit formulář registrace prodejce na stránce registrace',
        'show_vendor_registration_form_at_registration_page_description' => 'Pokud je povoleno, formulář registrace prodejce bude zobrazen na stránce registrace.',
        'single_vendor_checkout' => 'Omezit na jednoho prodejce na objednávku',
        'single_vendor_checkout_help' => 'Pokud je povoleno, zákazníci mohou nakupovat produkty pouze od jednoho prodejce na objednávku.',
        'display_order_total_info_for_each_store' => 'Zobrazit celkové informace objednávky pro každý obchod',
        'display_order_total_info_for_each_store_helper' => 'Pokud je povoleno, celkové informace objednávky budou zobrazeny pro každý obchod v souhrnu objednávky.',
        'show_vendor_info_at_checkout' => 'Zobrazit informace o prodejci při objednávání',
        'show_vendor_info_at_checkout_helper' => 'Pokud je povoleno, informace o prodejci (jméno, logo, recenze) budou zobrazeny na stránce objednávky.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Typy mediálních souborů, které může nahrát prodejce',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Určete typy mediálních souborů, které mohou prodejci nahrát. Vyberte je v seznamu výše.',
    ],
    'theme_options' => [
        'name' => 'Tržiště',
        'description' => 'Možnosti tématu pro Tržiště',
        'logo_vendor_dashboard' => 'Logo v dashboardu prodejce (Výchozí je hlavní logo)',
    ],
    'store_name' => 'Název obchodu',
    'store_email' => 'E-mail obchodu',
    'store_phone' => 'Telefon obchodu',
    'store_address' => 'Adresa obchodu',
    'store_url' => 'URL obchodu',
    'product_name' => 'Název produktu',
    'product_url' => 'URL produktu',
    'withdrawal_amount' => 'Částka výběru',
    'helpers' => [
        'store_status' => 'Pokud změníte status jiný než ":status", účet tohoto obchodu se také změní na ":customer"',
    ],
    'tables' => [
        'earnings' => 'Příjmy',
        'products_count' => 'Počet produktů',
    ],
    'vendors' => 'Prodejci',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankovní převod',
        'paypal' => 'PayPal',
        'cash' => 'Hotovost',
    ],
    'reports' => [
        'name' => 'Zprávy',
        'total_fee_earnings' => 'Celkové příjmy z poplatků: :value',
        'total_fee' => 'Celkový poplatek',
        'total_amount' => 'Celková částka',
        'store_revenues' => 'Příjmy obchodů',
        'sale_commissions' => 'Prodejní provize',
        'fee' => 'Poplatek (:symbol)',
        'amount' => 'Částka (:symbol)',
        'top_performing_stores' => 'Nejlepší obchody',
        'store_growth' => 'Růst obchodů',
        'withdrawal_status_chart' => 'Status výběrů',
        'product_distribution' => 'Distribuce produktů podle obchodů',
        'average_commission' => 'Průměrná sazba provize',
        'recent_withdrawals' => 'Nedávné výběry',
        'number_of_stores' => 'Počet obchodů',
        'number_of_products' => 'Počet produktů',
        'orders' => 'Objednávky',
        'revenue' => 'Příjmy',
        'increase' => ':count nárůst',
        'decrease' => ':count pokles',
    ],
    'vendor' => 'Prodejce',
    'vendor_name' => 'Jméno prodejce',
    'contact_store' => [
        'form_name' => 'Formulář kontaktu obchodu',
    ],
    'store_statuses' => [
        'pending' => 'Čekající',
        'published' => 'Schváleno',
        'blocked' => 'Zablokováno',
    ],
    'view_vendor' => 'Zobrazit prodejce :name',
    'vendor_information' => 'Informace o prodejci',
    'vendor_verified' => 'Prodejce ověřen',
    'vendor_not_verified' => 'Prodejce neověřen',
    'vendor_verified_at' => 'Prodejce ověřen dne',
    'view_certificate' => 'Zobrazit certifikát',
    'view_government_id' => 'Zobrazit průkaz totožnosti',
    'documents' => 'Dokumenty',
    'store_products' => 'Produkty obchodu',
    'store_orders' => 'Objednávky obchodu',
    'total_revenue' => 'Celkové příjmy',
    'total_earnings' => 'Celkové výdělky',
    'withdrawals' => 'Výběry',
    'pending_withdrawals' => 'Čekající výběry',
    'balance' => 'Zůstatek',
    'recent_products' => 'Nedávné produkty',
    'products_count' => 'Produkty',
    'store_status' => 'Status obchodu',
    'verified' => 'Ověřeno',
];