<?php

return [
    'name' => 'Marktplatz',
    'email' => [
        'title' => 'Marktplatz',
        'description' => 'E-Mail-Vorlagen für Marktplatz konfigurieren',
        'store_new_order_title' => 'Benachrichtigung über neue Bestellung',
        'store_new_order_description' => 'E-Mail an Shop-Besitzer senden, wenn eine Bestellung aufgegeben wird',
        'verify_vendor_title' => 'Verkäufer verifizieren',
        'verify_vendor_description' => 'E-Mail an Administrator senden, wenn sich ein Verkäufer registriert',
        'pending_product_approval_title' => 'Ausstehende Produktgenehmigung',
        'pending_product_approval_description' => 'E-Mail an Administrator senden, wenn ein Verkäufer Produkte veröffentlicht',
        'vendor_account_approved_title' => 'Verkäuferkonto genehmigt',
        'vendor_account_approved_description' => 'E-Mail an Verkäufer senden, wenn ihr Konto genehmigt wurde',
        'product_approved_title' => 'Produkt genehmigt',
        'product_approved_description' => 'E-Mail an Verkäufer senden, wenn ihr Produkt genehmigt wurde',
        'withdrawal_approved_title' => 'Auszahlung genehmigt',
        'withdrawal_approved_description' => 'E-Mail an Verkäufer senden, wenn ihr Auszahlungsantrag genehmigt wurde',
        'vendor_account_rejected_title' => 'Verkäuferkonto abgelehnt',
        'vendor_account_rejected_description' => 'E-Mail an Verkäufer senden, wenn ihr Konto abgelehnt wurde',
        'vendor_account_unblocked_title' => 'Verkäuferkonto entsperrt',
        'vendor_account_unblocked_description' => 'E-Mail an Verkäufer senden, wenn ihr Konto entsperrt wurde',
        'vendor_account_blocked_title' => 'Verkäuferkonto gesperrt',
        'vendor_account_blocked_description' => 'E-Mail an Verkäufer senden, wenn ihr Konto gesperrt wurde',
        'store_new_order_subject' => 'Neue Bestellung(en) bei {{ site_title }}',
        'verify_vendor_subject' => 'Neuer Verkäufer bei {{ site_title }} muss verifiziert werden',
        'vendor_account_approved_subject' => 'Ihr Konto wurde für den Verkauf bei {{ site_title }} genehmigt',
        'vendor_account_rejected_subject' => 'Ihr Konto wurde für den Verkauf bei {{ site_title }} abgelehnt',
        'pending_product_approval_subject' => 'Neues Produkt muss für den Verkauf bei {{ site_title }} genehmigt werden',
        'product_approved_subject' => 'Ihr Produkt wurde für den Verkauf bei {{ site_title }} genehmigt',
        'withdrawal_approved_subject' => 'Ihr Auszahlungsantrag wurde genehmigt',
        'welcome_vendor_title' => 'Willkommen Verkäufer',
        'welcome_vendor_description' => 'E-Mail an Verkäufer nach Registrierung senden',
        'welcome_vendor_subject' => 'Willkommen bei {{ site_title }}!',
        'contact_store_title' => 'Shop kontaktieren',
        'contact_store_description' => 'E-Mail an Shop-Besitzer senden, wenn ein Kunde den Shop kontaktiert',
        'contact_store_subject' => 'Neue Kundenkontaktnachricht',
        'vendor_account_blocked_subject' => 'Ihr Verkäuferkonto bei {{ site_title }} wurde gesperrt',
        'vendor_account_unblocked_subject' => 'Ihr Verkäuferkonto bei {{ site_title }} wurde entsperrt',
        'order_cancellation_to_vendor_title' => 'Bestellstornierung (wird an Verkäufer gesendet)',
        'order_cancellation_to_vendor_description' => 'An Verkäufer senden, wenn Kunde eine Bestellung storniert',
        'order_cancellation_to_vendor_subject' => 'Bestellung :order_id wurde vom Kunden storniert',
        'store_verified_title' => 'Shop-Verifizierung genehmigt',
        'store_verified_description' => 'Benachrichtigung senden, wenn Shop verifiziert wird',
        'store_verified_subject' => 'Ihr Shop {{ store_name }} wurde verifiziert',
        'store_unverified_title' => 'Shop-Verifizierung entfernt',
        'store_unverified_description' => 'Benachrichtigung senden, wenn Shop-Verifizierung entfernt wird',
        'store_unverified_subject' => 'Verifizierungsstatus geändert für {{ store_name }}',
        'verified_by' => 'Verifiziert von',
        'verified_at' => 'Verifiziert am',
        'unverified_by' => 'Nicht verifiziert von',
        'unverified_at' => 'Nicht verifiziert am',
        'verification_note' => 'Verifizierungsnotiz',
        'store' => 'Shop',
        'order' => 'Bestellung',
        'shipment' => 'Versandinfo',
        'address' => 'Lieferadresse',
        'products' => 'Bestellprodukte',
        'customer_message' => 'Kundennachricht',
        'customer_name' => 'Kundenname',
        'customer_email' => 'Kunden-E-Mail',
        'block_reason' => 'Sperrgrund',
        'block_date' => 'Sperrdatum',
        'unblock_date' => 'Entsperrdatum',
    ],
    'email_templates' => [
        'dear_vendor' => 'Lieber :vendor_name,',
        'dear_admin' => 'Lieber Administrator,',
        'hello' => 'Hallo,',
        'happy_selling' => 'Frohes Verkaufen!',
        'thank_you_understanding' => 'Vielen Dank für Ihr Verständnis.',
        'email_sent_by_team' => 'Diese E-Mail wurde vom {{ site_title }} Team gesendet.',

        // Contact Store
        'contact_store_sent_from' => 'Diese E-Mail wurde von :customer_name (:customer_email) über Ihr Profilkontaktformular auf :site_title gesendet.',
        'contact_store_reply_instruction' => 'Sie können direkt auf diese E-Mail antworten, um :customer_name (:customer_email) zu antworten.',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Ihr Verkäuferkonto bei {{ site_title }} wurde seit dem :block_date <strong>gesperrt</strong>.',
        'vendor_account_blocked_reason' => 'Sperrgrund: :block_reason',
        'vendor_account_blocked_contact_support' => 'Wenn Sie glauben, dass dies ein Fehler ist oder Fragen haben, kontaktieren Sie bitte unser Support-Team.',
        'vendor_account_unblocked_message' => 'Wir freuen uns, Ihnen mitteilen zu können, dass Ihr Verkäuferkonto bei {{ site_title }} seit dem :unblock_date <strong>entsperrt</strong> wurde.',
        'vendor_account_unblocked_resume' => 'Sie können nun auf Ihr Konto zugreifen und Ihre Aktivitäten fortsetzen.',
        'vendor_account_unblocked_questions' => 'Bei Fragen wenden Sie sich gerne an unser Support-Team.',
        'vendor_account_approved_title' => 'Verkäuferkonto genehmigt',
        'vendor_account_approved_message' => 'Ihr Konto wurde für den Verkauf auf unserer Website <a href=":site_url">:site_url</a> genehmigt.',
        'vendor_account_rejected_title' => 'Verkäuferkonto abgelehnt',
        'vendor_account_rejected_message' => 'Wir bedauern, Ihnen mitteilen zu müssen, dass Ihr Konto nicht für den Verkauf auf unserer Website <a href=":site_url">:site_url</a> genehmigt wurde.',

        // Store New Order
        'store_new_order_title' => 'Bestellung erfolgreich!',
        'store_new_order_message' => 'Sie haben eine neue Bestellung auf :site_title!',
        'customer_information' => 'Kundeninformationen',
        'field_name' => 'Name',
        'field_phone' => 'Telefon',
        'field_email' => 'E-Mail',
        'field_address' => 'Adresse',
        'field_note' => 'Notiz',
        'order_number' => 'Bestellnummer',
        'order_date' => 'Bestelldatum',
        'shipping_method' => 'Versandmethode',
        'payment_method' => 'Zahlungsmethode',

        // Product Approval
        'product_approved_title' => 'Produkt genehmigt',
        'product_approved_message' => 'Ihr Produkt wurde für den Verkauf auf unserer Website <a href=":site_url">:site_url</a> genehmigt.',
        'pending_product_approval_title' => 'Ausstehende Produktgenehmigung',
        'pending_product_approval_message' => 'Neues Produkt wurde von :store_name erstellt <a href=":product_url">:product_name</a> wartet auf Genehmigung.',

        // Verify Vendor
        'verify_vendor_title' => 'Verkäufer verifizieren',
        'verify_vendor_message' => 'Sie haben einen neuen Verkäufer, der auf :site_title verifiziert werden muss!',
        'vendor_information' => 'Verkäuferinformationen',
        'shop_information' => 'Shop-Informationen',
        'field_store_name' => 'Shop-Name',
        'field_store_phone' => 'Shop-Telefonnummer',
        'visit_store_button' => 'Shop besuchen',

        // Withdrawal
        'withdrawal_approved_title' => 'Auszahlung genehmigt',
        'withdrawal_approved_message' => 'Ihr Auszahlungsantrag wurde genehmigt, wir werden <strong>:withdrawal_amount</strong> in Kürze an Ihre Bankinformationen senden.',

        // Order Cancellation
        'order_cancellation_title' => 'Kunde hat Bestellung :order_id storniert',
        'order_cancellation_message' => 'Kunde :customer_name hat Bestellung <strong>:order_id</strong> aufgrund von :cancellation_reason storniert.',
        'order_items_header' => 'Hier ist was Sie bestellt haben:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Willkommen Verkäufer',
        'welcome_vendor_greeting' => 'Wir freuen uns, Sie bei :store_name willkommen zu heißen!',
        'welcome_vendor_registration_complete' => 'Ihre Verkäuferregistrierung wurde erfolgreich abgeschlossen und Sie sind nun Teil unserer lebendigen Verkäufergemeinschaft.',
        'welcome_vendor_next_steps' => 'Hier ist was Sie als nächstes tun können:',
        'welcome_vendor_step_login' => 'Melden Sie sich mit Ihren Anmeldedaten in Ihr Verkäuferkonto an.',
        'welcome_vendor_step_add_products' => 'Fügen Sie Ihre Produkte/Dienstleistungen zu Ihrem Shop hinzu. Stellen Sie sicher, dass Sie detaillierte Beschreibungen und ansprechende Bilder bereitstellen, um potenzielle Käufer anzulocken.',
        'welcome_vendor_support' => 'Wenn Sie Fragen haben oder Unterstützung benötigen, ist unser Support-Team da, um Ihnen zu helfen. Zögern Sie nicht, uns zu kontaktieren!',
        'login_vendor_account_button' => 'In Verkäuferkonto anmelden',
        'welcome_vendor_closing' => 'Wir freuen uns darauf, Ihren Shop auf :site_title florieren zu sehen!',

        // Store Verification
        'store_verified_title' => 'Shop-Verifizierung genehmigt',
        'store_verified_message' => 'Herzlichen Glückwunsch! Ihr Shop wurde erfolgreich auf <strong>:site_title</strong> verifiziert. Dieses Verifizierungsabzeichen wird dabei helfen, Vertrauen bei Ihren Kunden aufzubauen.',
        'dear_store_owner' => 'Lieber :store_name Besitzer,',
        'verification_details' => 'Verifizierungsdetails',
        'store_verified_benefits' => 'Vorteile der Verifizierung',
        'verified_badge_benefit' => 'Ein Verifizierungsabzeichen wird in Ihrem Shop angezeigt',
        'increased_trust_benefit' => 'Erhöhtes Kundenvertrauen und Zuversicht',
        'higher_visibility_benefit' => 'Höhere Sichtbarkeit in Suchergebnissen',
        'visit_your_store' => 'Ihren Shop besuchen',
        'congratulations_verified' => 'Herzlichen Glückwunsch zu Ihrer Verifizierung!',

        // Store Unverification
        'store_unverified_title' => 'Shop-Verifizierungsstatus geändert',
        'store_unverified_message' => 'Wir bedauern, Ihnen mitteilen zu müssen, dass der Verifizierungsstatus Ihres Shops auf <strong>:site_title</strong> geändert wurde.',
        'unverification_details' => 'Details der Statusänderung',
        'store_unverified_impacts' => 'Was das bedeutet',
        'verified_badge_removed' => 'Das Verifizierungsabzeichen wurde von Ihrem Shop entfernt',
        'verification_benefits_lost' => 'Verifizierungsvorteile sind nicht mehr aktiv',
        'store_unverified_next_steps' => 'Wenn Sie Fragen zu dieser Entscheidung haben oder eine erneute Verifizierung besprechen möchten, <strong>kontaktieren Sie bitte unser Support-Team</strong>.',
        'contact_support' => 'Support kontaktieren',
        'thank_you_understanding' => 'Vielen Dank für Ihr Verständnis.',
    ],
    'current_balance' => 'Aktueller Saldo',
    'settings' => [
        'title' => 'Einstellungen',
        'description' => 'Einstellungen für Marktplatz',
        'fee_per_order' => 'Gebühr pro Bestellung (%), empfohlen: 2 oder 3',
        'default_commission_fee' => 'Standard-Provision (%), empfohlen: 2 oder 3',
        'enable_commission_fee_for_each_category' => 'Provision für jede Kategorie aktivieren?',
        'categories' => 'Kategorien',
        'select_categories' => 'Kategorien auswählen..',
        'commission_fee' => 'Provision (%)',
        'commission_fee_by_category' => 'Provision nach Kategorie (%)',
        'fee_withdrawal_amount' => 'Auszahlungsgebühr',
        'withdrawal_fee_type' => 'Auszahlungsgebührentyp',
        'withdrawal_fee_types' => [
            'fixed' => 'Fester Betrag',
            'percentage' => 'Prozentsatz',
        ],
        'check_valid_signature' => 'Gültige Signatur in Verkäufereinnahmen prüfen',
        'verify_vendor' => 'Verkäuferverifizierung (Verkäufer kann erst nach Verifizierung Produkte veröffentlichen)',
        'verify_vendor_helper' => 'Wenn aktiviert, muss der Administrator den Verkäufer verifizieren, bevor er Produkte veröffentlichen kann.',
        'requires_vendor_documentations_verification' => 'Verkäuferdokumentationsverifizierung erforderlich',
        'requires_vendor_documentations_verification_helper' => 'Wenn aktiviert, müssen Verkäufer ihre Dokumentationsdateien hochladen, wenn sie sich als Verkäufer bewerben.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Menü "Verkäufer werden" im Kunden-Dashboard ausblenden',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Wenn aktiviert, wird das Menü "Verkäufer werden" im Kunden-Dashboard ausgeblendet.',
        'enable_product_approval' => 'Produktgenehmigung aktivieren',
        'enable_product_approval_description' => 'Wenn aktiviert, muss der Administrator das Produkt vor der Veröffentlichung genehmigen.',
        'hide_store_phone_number' => 'Shop-Telefonnummer ausblenden?',
        'hide_store_email' => 'Shop-E-Mail ausblenden?',
        'hide_store_address' => 'Shop-Adresse ausblenden?',
        'hide_store_social_links' => 'Shop-Social-Links ausblenden?',
        'enable_vendor_categories_filter' => 'Verkäuferkategorienfilter aktivieren',
        'enable_vendor_categories_filter_description' => 'Kategorienfilter auf Verkäufer-Shop-Seite anzeigen. Nur Kategorien mit Verkäuferprodukten werden angezeigt.',
        'allow_vendor_manage_shipping' => 'Verkäufer Versandverwaltung erlauben?',
        'allow_vendor_manage_shipping_description' => 'Wenn aktiviert, kann der Verkäufer den Versandstatus der Bestellung auf "liefernd", "geliefert", ... ändern',
        'charge_shipping_per_vendor' => 'Versand pro Verkäufer berechnen?',
        'charge_shipping_per_vendor_description' => 'Wenn aktiviert, wird der Versand separat für jeden Verkäufer berechnet. Wenn deaktiviert, wird der Versand einmal für die gesamte Bestellung berechnet.',
        'commission_fee_each_category_fee_name' => 'Provision der Provisionseinstellung :key',
        'commission_fee_each_category_name' => 'Kategorien der Provisionseinstellung :key',
        'add_new' => 'Neu hinzufügen',
        'payout_methods' => 'Auszahlungsmethoden',
        'max_upload_filesize' => 'Maximale Upload-Dateigröße (MB)',
        'max_upload_filesize_placeholder' => 'Standard: 10',
        'max_product_images_upload_by_vendor' => 'Maximale Anzahl von Bildern pro Produkt',
        'enable_vendor_registration' => 'Verkäuferregistrierung aktivieren',
        'enable_vendor_registration_helper' => 'Wenn aktiviert, können sich Verkäufer auf der Website registrieren und ihre Produkte veröffentlichen.',
        'minimum_withdrawal_amount' => 'Mindestabhebungsbetrag (Fest)',
        'minimum_withdrawal_amount_helper' => 'Geben Sie den Mindestbetrag an, den ein Verkäufer abheben kann. Standard ist 0.',
        'allow_vendor_delete_their_orders' => 'Verkäufern erlauben, ihre Bestellungen zu löschen',
        'allow_vendor_delete_their_orders_description' => 'Wenn aktiviert, können Verkäufer ihre Bestellliste verwalten, indem sie unerwünschte Einträge entfernen. Mit Vorsicht verwenden, da gelöschte Bestellungen Transaktionsaufzeichnungen beeinträchtigen können.',
        'enable_messaging_system' => 'Nachrichtensystem aktivieren',
        'enable_messaging_system_description' => 'Wenn aktiviert, können Verkäufer und Kunden über das Nachrichtensystem miteinander kommunizieren.',
        'term_and_privacy_policy_url' => 'AGB und Datenschutzrichtlinien-URL',
        'show_vendor_registration_form_at_registration_page' => 'Verkäuferregistrierungsformular auf Registrierungsseite anzeigen',
        'show_vendor_registration_form_at_registration_page_description' => 'Wenn aktiviert, wird das Verkäuferregistrierungsformular auf der Registrierungsseite angezeigt.',
        'single_vendor_checkout' => 'Auf einen Verkäufer pro Bestellung beschränken',
        'single_vendor_checkout_help' => 'Wenn aktiviert, können Kunden nur Produkte von einem Verkäufer pro Bestellung kaufen.',
        'display_order_total_info_for_each_store' => 'Bestellgesamtinformationen für jeden Shop anzeigen',
        'display_order_total_info_for_each_store_helper' => 'Wenn aktiviert, werden die Bestellgesamtinformationen für jeden Shop in der Bestellzusammenfassung angezeigt.',
        'show_vendor_info_at_checkout' => 'Verkäuferinformationen beim Checkout anzeigen',
        'show_vendor_info_at_checkout_helper' => 'Wenn aktiviert, werden Verkäuferinformationen (Name, Logo, Bewertungen) auf der Checkout-Seite angezeigt.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Mediendateitypen, die von Verkäufern hochgeladen werden können',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Geben Sie die Mediendateitypen an, die Verkäufer hochladen können. Wählen Sie sie in der obigen Liste aus.',
    ],
    'theme_options' => [
        'name' => 'Marktplatz',
        'description' => 'Theme-Optionen für Marktplatz',
        'logo_vendor_dashboard' => 'Logo im Verkäufer-Dashboard (Standard ist das Hauptlogo)',
    ],
    'store_name' => 'Shop-Name',
    'store_email' => 'Shop-E-Mail',
    'store_phone' => 'Shop-Telefon',
    'store_address' => 'Shop-Adresse',
    'store_url' => 'Shop-URL',
    'product_name' => 'Produktname',
    'product_url' => 'Produkt-URL',
    'withdrawal_amount' => 'Auszahlungsbetrag',
    'helpers' => [
        'store_status' => 'Wenn Sie den Status anders als ":status" ändern, wird sich auch das Konto dieses Shops zu ":customer" ändern',
    ],
    'tables' => [
        'earnings' => 'Einnahmen',
        'products_count' => 'Produktanzahl',
    ],
    'vendors' => 'Verkäufer',
    'payout_payment_methods' => [
        'bank_transfer' => 'Banküberweisung',
        'paypal' => 'PayPal',
        'cash' => 'Bargeld',
    ],
    'reports' => [
        'name' => 'Berichte',
        'total_fee_earnings' => 'Gesamte Gebühreneinnahmen: :value',
        'total_fee' => 'Gesamtgebühr',
        'total_amount' => 'Gesamtbetrag',
        'store_revenues' => 'Shop-Einnahmen',
        'sale_commissions' => 'Verkaufsprovisionen',
        'fee' => 'Gebühr (:symbol)',
        'amount' => 'Betrag (:symbol)',
        'top_performing_stores' => 'Leistungsstärkste Shops',
        'store_growth' => 'Shop-Wachstum',
        'withdrawal_status_chart' => 'Auszahlungsstatus',
        'product_distribution' => 'Produktverteilung nach Shop',
        'average_commission' => 'Durchschnittlicher Provisionssatz',
        'recent_withdrawals' => 'Aktuelle Auszahlungen',
        'number_of_stores' => 'Anzahl der Shops',
        'number_of_products' => 'Anzahl der Produkte',
        'orders' => 'Bestellungen',
        'revenue' => 'Einnahmen',
        'increase' => ':count Anstieg',
        'decrease' => ':count Rückgang',
    ],
    'vendor' => 'Verkäufer',
    'vendor_name' => 'Verkäufername',
    'contact_store' => [
        'form_name' => 'Shop kontaktieren Formular',
    ],
    'store_statuses' => [
        'pending' => 'Ausstehend',
        'published' => 'Genehmigt',
        'blocked' => 'Gesperrt',
    ],
    'view_vendor' => 'Verkäufer ansehen :name',
    'vendor_information' => 'Verkäuferinformationen',
    'vendor_verified' => 'Verkäufer verifiziert',
    'vendor_not_verified' => 'Verkäufer nicht verifiziert',
    'vendor_verified_at' => 'Verkäufer verifiziert am',
    'view_certificate' => 'Zertifikat ansehen',
    'view_government_id' => 'Ausweis ansehen',
    'documents' => 'Dokumente',
    'store_products' => 'Shop-Produkte',
    'store_orders' => 'Shop-Bestellungen',
    'total_revenue' => 'Gesamteinnahmen',
    'total_earnings' => 'Gesamtverdienst',
    'withdrawals' => 'Auszahlungen',
    'pending_withdrawals' => 'Ausstehende Auszahlungen',
    'balance' => 'Saldo',
    'recent_products' => 'Aktuelle Produkte',
    'products_count' => 'Produkte',
    'store_status' => 'Shop-Status',
    'verified' => 'Verifiziert',
];