<?php

return [
    'name' => 'Marketplace',
    'email' => [
        'title' => 'Marketplace',
        'description' => 'Config email templates for Marketplace',
        'store_new_order_title' => 'Notice about new order',
        'store_new_order_description' => 'Send email to the store owner when an order placed',
        'verify_vendor_title' => 'Verify vendor',
        'verify_vendor_description' => 'Send email to the admin when a vendor registers',
        'pending_product_approval_title' => 'Pending product approval',
        'pending_product_approval_description' => 'Send email to the admin when a vendor post their products',
        'vendor_account_approved_title' => 'Vendor account approved',
        'vendor_account_approved_description' => 'Send email to vendor when their account approved',
        'product_approved_title' => 'Product approved',
        'product_approved_description' => 'Send email to vendor when their product approved',
        'withdrawal_approved_title' => 'Withdrawal approved',
        'withdrawal_approved_description' => 'Send email to vendor when their withdrawal request approved',
        'vendor_account_rejected_title' => 'Vendor account rejected',
        'vendor_account_rejected_description' => 'Send email to vendor when their account rejected',
        'vendor_account_unblocked_title' => 'Vendor account unblocked',
        'vendor_account_unblocked_description' => 'Send email to vendor when their account unblocked',
        'vendor_account_blocked_title' => 'Vendor account blocked',
        'vendor_account_blocked_description' => 'Send email to vendor when their account blocked',
        'store_new_order_subject' => 'New order(s) at {{ site_title }}',
        'verify_vendor_subject' => 'New vendor at {{ site_title }} needs to be verified',
        'vendor_account_approved_subject' => 'Your account has been approved for selling at {{ site_title }}',
        'vendor_account_rejected_subject' => 'Your account has been rejected for selling at {{ site_title }}',
        'pending_product_approval_subject' => 'New product needs to be approved for selling at {{ site_title }}',
        'product_approved_subject' => 'Your product has been approved for selling at {{ site_title }}',
        'withdrawal_approved_subject' => 'Your withdrawal request has been approved',
        'welcome_vendor_title' => 'Welcome vendor',
        'welcome_vendor_description' => 'Send email to vendor after registered',
        'welcome_vendor_subject' => 'Welcome to {{ site_title }}!',
        'contact_store_title' => 'Contact Store',
        'contact_store_description' => 'Send email to the store owner when a customer contacts the store',
        'contact_store_subject' => 'New Customer Contact Message',
        'vendor_account_blocked_subject' => 'Your vendor account at {{ site_title }} has been blocked',
        'vendor_account_unblocked_subject' => 'Your vendor account at {{ site_title }} has been unblocked',
        'order_cancellation_to_vendor_title' => 'Order cancellation (will be sent to seller (vendor)',
        'order_cancellation_to_vendor_description' => 'Send to seller (vendor) when customer cancels an order',
        'order_cancellation_to_vendor_subject' => 'Order :order_id has been cancelled by customer',
        'store_verified_title' => 'Store Verification Approved',
        'store_verified_description' => 'Send notification when store is verified',
        'store_verified_subject' => 'Your store {{ store_name }} has been verified',
        'store_unverified_title' => 'Store Verification Removed',
        'store_unverified_description' => 'Send notification when store verification is removed',
        'store_unverified_subject' => 'Verification status changed for {{ store_name }}',
        'verified_by' => 'Verified by',
        'verified_at' => 'Verified at',
        'unverified_by' => 'Unverified by',
        'unverified_at' => 'Unverified at',
        'verification_note' => 'Verification note',
        'store' => 'Store',
        'order' => 'Order',
        'shipment' => 'Shipment info',
        'address' => 'Shipping address',
        'products' => 'Order products',
        'customer_message' => 'Customer message',
        'customer_name' => 'Customer name',
        'customer_email' => 'Customer email',
        'block_reason' => 'Reason for blocking',
        'block_date' => 'Date of blocking',
        'unblock_date' => 'Date of unblocking',
    ],
    'email_templates' => [
        'dear_vendor' => 'Dear :vendor_name,',
        'dear_admin' => 'Dear Admin,',
        'hello' => 'Hello,',
        'happy_selling' => 'Happy selling!',
        'thank_you_understanding' => 'Thank you for your understanding.',
        'email_sent_by_team' => 'This email was sent by the {{ site_title }} team.',
        
        // Contact Store
        'contact_store_sent_from' => 'This email was sent from :customer_name (:customer_email) through your profile contact form on :site_title.',
        'contact_store_reply_instruction' => 'You can reply directly to this email to respond to :customer_name (:customer_email).',
        
        // Vendor Account Status
        'vendor_account_blocked_message' => 'Your vendor account at {{ site_title }} has been <strong>blocked</strong> as of :block_date.',
        'vendor_account_blocked_reason' => 'Reason for blocking: :block_reason',
        'vendor_account_blocked_contact_support' => 'If you believe this is a mistake or have any questions, please contact our support team.',
        'vendor_account_unblocked_message' => 'We are pleased to inform you that your vendor account at {{ site_title }} has been <strong>unblocked</strong> as of :unblock_date.',
        'vendor_account_unblocked_resume' => 'You can now access your account and resume your activities.',
        'vendor_account_unblocked_questions' => 'If you have any questions, feel free to reach out to our support team.',
        'vendor_account_approved_title' => 'Vendor Account Approved',
        'vendor_account_approved_message' => 'Your account has been approved for selling on our site <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Vendor Account Rejected',
        'vendor_account_rejected_message' => 'We regret to inform you that your account has not been approved for selling on our site <a href=":site_url">:site_url</a>.',
        
        // Store New Order
        'store_new_order_title' => 'Order successfully!',
        'store_new_order_message' => 'You got a new order on :site_title!',
        'customer_information' => 'Customer Information',
        'field_name' => 'Name',
        'field_phone' => 'Phone',
        'field_email' => 'Email',
        'field_address' => 'Address',
        'field_note' => 'Note',
        'order_number' => 'Order number',
        'order_date' => 'Order date',
        'shipping_method' => 'Shipping Method',
        'payment_method' => 'Payment Method',
        
        // Product Approval
        'product_approved_title' => 'Product Approved',
        'product_approved_message' => 'Your product has been approved for selling on our site <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Pending product approval',
        'pending_product_approval_message' => 'New product was created by :store_name <a href=":product_url">:product_name</a> is waiting for approval.',
        
        // Verify Vendor
        'verify_vendor_title' => 'Verify Vendor',
        'verify_vendor_message' => 'You have a new vendor that needs to be verified on :site_title!',
        'vendor_information' => 'Vendor Information',
        'shop_information' => 'Shop information',
        'field_store_name' => 'Store Name',
        'field_store_phone' => 'Store Phone Number',
        'visit_store_button' => 'Visit store',
        
        // Withdrawal
        'withdrawal_approved_title' => 'Withdrawal Approved',
        'withdrawal_approved_message' => 'Your payout request has been approved, we will sent <strong>:withdrawal_amount</strong> to your bank information shortly.',
        
        // Order Cancellation
        'order_cancellation_title' => 'Customer has cancelled order :order_id',
        'order_cancellation_message' => 'Customer :customer_name has cancelled order <strong>:order_id</strong> due to reason :cancellation_reason.',
        'order_items_header' => 'Here\'s what you ordered:',
        
        // Welcome Vendor
        'welcome_vendor_title' => 'Welcome vendor',
        'welcome_vendor_greeting' => 'We\'re delighted to welcome you to :store_name!',
        'welcome_vendor_registration_complete' => 'Your vendor registration has been successfully completed, and you\'re now part of our vibrant community of sellers.',
        'welcome_vendor_next_steps' => 'Here\'s what you can do next:',
        'welcome_vendor_step_login' => 'Log in to your vendor account using your credentials.',
        'welcome_vendor_step_add_products' => 'Add your products/services to your store. Ensure to provide detailed descriptions and captivating images to attract potential buyers.',
        'welcome_vendor_support' => 'If you have any questions or need assistance along the way, our support team is here to assist you. Feel free to reach out!',
        'login_vendor_account_button' => 'Log in to your vendor account',
        'welcome_vendor_closing' => 'We\'re excited to see your store flourish on :site_title!',
        
        // Store Verification
        'store_verified_title' => 'Store Verification Approved',
        'store_verified_message' => 'Congratulations! Your store has been successfully verified on <strong>:site_title</strong>. This verification badge will help build trust with your customers.',
        'dear_store_owner' => 'Dear :store_name Owner,',
        'verification_details' => 'Verification Details',
        'store_verified_benefits' => 'Benefits of being verified',
        'verified_badge_benefit' => 'A verified badge displayed on your store',
        'increased_trust_benefit' => 'Increased customer trust and confidence',
        'higher_visibility_benefit' => 'Higher visibility in search results',
        'visit_your_store' => 'Visit Your Store',
        'congratulations_verified' => 'Congratulations on your verification!',
        
        // Store Unverification
        'store_unverified_title' => 'Store Verification Status Changed',
        'store_unverified_message' => 'We regret to inform you that the verification status of your store on <strong>:site_title</strong> has been changed.',
        'unverification_details' => 'Status Change Details',
        'store_unverified_impacts' => 'What this means',
        'verified_badge_removed' => 'The verified badge has been removed from your store',
        'verification_benefits_lost' => 'Verification benefits are no longer active',
        'store_unverified_next_steps' => 'If you have any questions about this decision or would like to discuss re-verification, please <strong>contact our support team</strong>.',
        'contact_support' => 'Contact Support',
        'thank_you_understanding' => 'Thank you for your understanding.',
    ],
    'current_balance' => 'Current balance',
    'settings' => [
        'title' => 'Settings',
        'description' => 'Settings for marketplace',
        'fee_per_order' => 'Fee per fee (%), suggest: 2 or 3',
        'default_commission_fee' => 'Default commission fee (%), suggest: 2 or 3',
        'enable_commission_fee_for_each_category' => 'Enable commission fee for each category?',
        'categories' => 'Categories',
        'select_categories' => 'Select categories..',
        'commission_fee' => 'Commission fee (%)',
        'commission_fee_by_category' => 'Commission fee by category (%)',
        'fee_withdrawal_amount' => 'Fee withdrawal',
        'withdrawal_fee_type' => 'Fee withdrawal type',
        'withdrawal_fee_types' => [
            'fixed' => 'Fixed amount',
            'percentage' => 'Percentage',
        ],
        'check_valid_signature' => 'Check valid signature in vendor\'s earnings',
        'verify_vendor' => 'Vendor verification (Vendor just can post their product listing after getting verified)',
        'verify_vendor_helper' => 'If enabled, the admin must verify the vendor before they can post their product listing.',
        'requires_vendor_documentations_verification' => 'Requires vendor documentations verification',
        'requires_vendor_documentations_verification_helper' => 'If enabled, vendors must upload their documentation files when applying to become a vendor.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Hide become vendor menu in customer dashboard',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'If enabled, the "Become a vendor" menu will be hidden in the customer dashboard.',
        'enable_product_approval' => 'Enable product approval',
        'enable_product_approval_description' => 'If enabled, the admin must approve the product before it is published.',
        'hide_store_phone_number' => 'Hide store phone number?',
        'hide_store_email' => 'Hide store email?',
        'hide_store_address' => 'Hide store address?',
        'hide_store_social_links' => 'Hide store social links?',
        'enable_vendor_categories_filter' => 'Enable vendor categories filter',
        'enable_vendor_categories_filter_description' => 'Show categories filter on vendor store page. Only categories that have vendor products will be displayed.',
        'allow_vendor_manage_shipping' => 'Allow vendor manage shipping?',
        'allow_vendor_manage_shipping_description' => 'If it is enabled, the vendor can change shipping status of order to "delivering", "delivered", ...',
        'charge_shipping_per_vendor' => 'Charge shipping per vendor?',
        'charge_shipping_per_vendor_description' => 'If enabled, shipping will be charged separately for each vendor. If disabled, shipping will be charged once for the entire order.',
        'commission_fee_each_category_fee_name' => 'Commission fee of commission setting :key',
        'commission_fee_each_category_name' => 'Categories of commission setting :key',
        'add_new' => 'Add new',
        'payout_methods' => 'Payout methods',
        'max_upload_filesize' => 'Max upload filesize (MB)',
        'max_upload_filesize_placeholder' => 'Default: 10',
        'max_product_images_upload_by_vendor' => 'Max number of images for each product',
        'enable_vendor_registration' => 'Enable vendor registration',
        'enable_vendor_registration_helper' => 'If enabled, vendors can register an account on the site and post their products.',
        'minimum_withdrawal_amount' => 'Minimum withdrawal amount (Fixed)',
        'minimum_withdrawal_amount_helper' => 'Specify the minimum amount a vendor can withdraw. Default is 0.',
        'allow_vendor_delete_their_orders' => 'Allow vendors to delete their orders',
        'allow_vendor_delete_their_orders_description' => 'When enabled, vendors can manage their order list by removing unwanted entries. Use with caution as deleted orders may impact transaction records.',
        'enable_messaging_system' => 'Enable messaging system',
        'enable_messaging_system_description' => 'If enabled, vendors and customers can communicate with each other via the messaging system.',
        'term_and_privacy_policy_url' => 'Term and privacy policy URL',
        'show_vendor_registration_form_at_registration_page' => 'Show vendor registration form at registration page',
        'show_vendor_registration_form_at_registration_page_description' => 'If enabled, the vendor registration form will be displayed on the registration page.',
        'single_vendor_checkout' => 'Limit to One Vendor per Order',
        'single_vendor_checkout_help' => 'If enabled, customers can only purchase products from one vendor per order.',
        'display_order_total_info_for_each_store' => 'Display order total info for each store',
        'display_order_total_info_for_each_store_helper' => 'If enabled, the order total information will be displayed for each store in the order summary.',
        'show_vendor_info_at_checkout' => 'Show vendor information at checkout',
        'show_vendor_info_at_checkout_helper' => 'If enabled, vendor information (name, logo, reviews) will be displayed on the checkout page.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Media file types can be uploaded by vendor',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Specify the media file types that vendors can upload. Select them in the above list.',
    ],
    'theme_options' => [
        'name' => 'Marketplace',
        'description' => 'Theme options for Marketplace',
        'logo_vendor_dashboard' => 'Logo in the vendor dashboard (Default is the main logo)',
    ],
    'store_name' => 'Store name',
    'store_email' => 'Store email',
    'store_phone' => 'Store phone',
    'store_address' => 'Store address',
    'store_url' => 'Store URL',
    'product_name' => 'Product name',
    'product_url' => 'Product URL',
    'withdrawal_amount' => 'Withdrawal amount',
    'helpers' => [
        'store_status' => 'If you change the status other than ":status" this store\'s account will also change to ":customer"',
    ],
    'tables' => [
        'earnings' => 'Earnings',
        'products_count' => 'Products Count',
    ],
    'vendors' => 'Vendors',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bank Transfer',
        'paypal' => 'PayPal',
        'cash' => 'Cash',
    ],
    'reports' => [
        'name' => 'Reports',
        'total_fee_earnings' => 'Total fee earnings: :value',
        'total_fee' => 'Total fee',
        'total_amount' => 'Total amount',
        'store_revenues' => 'Store revenues',
        'sale_commissions' => 'Sale commissions',
        'fee' => 'Fee (:symbol)',
        'amount' => 'Amount (:symbol)',
        'top_performing_stores' => 'Top Performing Stores',
        'store_growth' => 'Store Growth',
        'withdrawal_status_chart' => 'Withdrawal Status',
        'product_distribution' => 'Product Distribution by Store',
        'average_commission' => 'Average Commission Rate',
        'recent_withdrawals' => 'Recent Withdrawals',
        'number_of_stores' => 'Number of Stores',
        'number_of_products' => 'Number of Products',
        'orders' => 'Orders',
        'revenue' => 'Revenue',
        'increase' => ':count increase',
        'decrease' => ':count decrease',
    ],
    'vendor' => 'Vendor',
    'vendor_name' => 'Vendor name',
    'contact_store' => [
        'form_name' => 'Contact Store form',
    ],
    'store_statuses' => [
        'pending' => 'Pending',
        'published' => 'Approved',
        'blocked' => 'Blocked',
    ],
    'view_vendor' => 'View vendor :name',
    'vendor_information' => 'Vendor Information',
    'vendor_verified' => 'Vendor Verified',
    'vendor_not_verified' => 'Vendor Not Verified',
    'vendor_verified_at' => 'Vendor Verified At',
    'view_certificate' => 'View Certificate',
    'view_government_id' => 'View Government ID',
    'documents' => 'Documents',
    'store_products' => 'Store Products',
    'store_orders' => 'Store Orders',
    'total_revenue' => 'Total Revenue',
    'total_earnings' => 'Total Earnings',
    'withdrawals' => 'Withdrawals',
    'pending_withdrawals' => 'Pending Withdrawals',
    'balance' => 'Balance',
    'recent_products' => 'Recent Products',
    'products_count' => 'Products',
    'store_status' => 'Store Status',
    'verified' => 'Verified',
];
