<?php

return [
    'name' => 'Marketplace',
    'email' => [
        'title' => 'Marketplace',
        'description' => 'Configura modelli email per il Marketplace',
        'store_new_order_title' => 'Notifica nuovo ordine',
        'store_new_order_description' => 'Invia email al proprietario del negozio quando viene effettuato un ordine',
        'verify_vendor_title' => 'Verifica venditore',
        'verify_vendor_description' => 'Invia email all\'amministratore quando un venditore si registra',
        'pending_product_approval_title' => 'Approvazione prodotto in sospeso',
        'pending_product_approval_description' => 'Invia email all\'amministratore quando un venditore pubblica i suoi prodotti',
        'vendor_account_approved_title' => 'Account venditore approvato',
        'vendor_account_approved_description' => 'Invia email al venditore quando il suo account viene approvato',
        'product_approved_title' => 'Prodotto approvato',
        'product_approved_description' => 'Invia email al venditore quando il suo prodotto viene approvato',
        'withdrawal_approved_title' => 'Prelievo approvato',
        'withdrawal_approved_description' => 'Invia email al venditore quando la sua richiesta di prelievo viene approvata',
        'vendor_account_rejected_title' => 'Account venditore rifiutato',
        'vendor_account_rejected_description' => 'Invia email al venditore quando il suo account viene rifiutato',
        'vendor_account_unblocked_title' => 'Account venditore sbloccato',
        'vendor_account_unblocked_description' => 'Invia email al venditore quando il suo account viene sbloccato',
        'vendor_account_blocked_title' => 'Account venditore bloccato',
        'vendor_account_blocked_description' => 'Invia email al venditore quando il suo account viene bloccato',
        'store_new_order_subject' => 'Nuovo/i ordine/i su {{ site_title }}',
        'verify_vendor_subject' => 'Nuovo venditore su {{ site_title }} deve essere verificato',
        'vendor_account_approved_subject' => 'Il tuo account è stato approvato per vendere su {{ site_title }}',
        'vendor_account_rejected_subject' => 'Il tuo account è stato rifiutato per vendere su {{ site_title }}',
        'pending_product_approval_subject' => 'Nuovo prodotto deve essere approvato per vendere su {{ site_title }}',
        'product_approved_subject' => 'Il tuo prodotto è stato approvato per vendere su {{ site_title }}',
        'withdrawal_approved_subject' => 'La tua richiesta di prelievo è stata approvata',
        'welcome_vendor_title' => 'Benvenuto venditore',
        'welcome_vendor_description' => 'Invia email al venditore dopo la registrazione',
        'welcome_vendor_subject' => 'Benvenuto su {{ site_title }}!',
        'contact_store_title' => 'Contatta Negozio',
        'contact_store_description' => 'Invia email al proprietario del negozio quando un cliente contatta il negozio',
        'contact_store_subject' => 'Nuovo Messaggio di Contatto Cliente',
        'vendor_account_blocked_subject' => 'Il tuo account venditore su {{ site_title }} è stato bloccato',
        'vendor_account_unblocked_subject' => 'Il tuo account venditore su {{ site_title }} è stato sbloccato',
        'order_cancellation_to_vendor_title' => 'Cancellazione ordine (sarà inviata al venditore)',
        'order_cancellation_to_vendor_description' => 'Invia al venditore quando il cliente cancella un ordine',
        'order_cancellation_to_vendor_subject' => 'L\'ordine :order_id è stato cancellato dal cliente',
        'store_verified_title' => 'Verifica Negozio Approvata',
        'store_verified_description' => 'Invia notifica quando il negozio viene verificato',
        'store_verified_subject' => 'Il tuo negozio {{ store_name }} è stato verificato',
        'store_unverified_title' => 'Verifica Negozio Rimossa',
        'store_unverified_description' => 'Invia notifica quando la verifica del negozio viene rimossa',
        'store_unverified_subject' => 'Stato di verifica modificato per {{ store_name }}',
        'verified_by' => 'Verificato da',
        'verified_at' => 'Verificato il',
        'unverified_by' => 'Non verificato da',
        'unverified_at' => 'Non verificato il',
        'verification_note' => 'Nota di verifica',
        'store' => 'Negozio',
        'order' => 'Ordine',
        'shipment' => 'Info spedizione',
        'address' => 'Indirizzo di spedizione',
        'products' => 'Prodotti dell\'ordine',
        'customer_message' => 'Messaggio cliente',
        'customer_name' => 'Nome cliente',
        'customer_email' => 'Email cliente',
        'block_reason' => 'Motivo del blocco',
        'block_date' => 'Data di blocco',
        'unblock_date' => 'Data di sblocco',
    ],
    'email_templates' => [
        'dear_vendor' => 'Gentile :vendor_name,',
        'dear_admin' => 'Gentile Amministratore,',
        'hello' => 'Salve,',
        'happy_selling' => 'Buone vendite!',
        'thank_you_understanding' => 'Grazie per la comprensione.',
        'email_sent_by_team' => 'Questa email è stata inviata dal team di {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'Questa email è stata inviata da :customer_name (:customer_email) tramite il modulo di contatto del profilo su :site_title.',
        'contact_store_reply_instruction' => 'Puoi rispondere direttamente a questa email per rispondere a :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Il tuo account venditore su {{ site_title }} è stato <strong>bloccato</strong> dal :block_date.',
        'vendor_account_blocked_reason' => 'Motivo del blocco: :block_reason',
        'vendor_account_blocked_contact_support' => 'Se ritieni che si tratti di un errore o hai domande, contatta il nostro team di supporto.',
        'vendor_account_unblocked_message' => 'Siamo lieti di informarti che il tuo account venditore su {{ site_title }} è stato <strong>sbloccato</strong> dal :unblock_date.',
        'vendor_account_unblocked_resume' => 'Ora puoi accedere al tuo account e riprendere le tue attività.',
        'vendor_account_unblocked_questions' => 'Se hai domande, non esitare a contattare il nostro team di supporto.',
        'vendor_account_approved_title' => 'Account Venditore Approvato',
        'vendor_account_approved_message' => 'Il tuo account è stato approvato per vendere sul nostro sito <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Account Venditore Rifiutato',
        'vendor_account_rejected_message' => 'Ci dispiace informarti che il tuo account non è stato approvato per vendere sul nostro sito <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Ordine effettuato con successo!',
        'store_new_order_message' => 'Hai ricevuto un nuovo ordine su :site_title!',
        'customer_information' => 'Informazioni Cliente',
        'field_name' => 'Nome',
        'field_phone' => 'Telefono',
        'field_email' => 'Email',
        'field_address' => 'Indirizzo',
        'field_note' => 'Nota',
        'order_number' => 'Numero ordine',
        'order_date' => 'Data ordine',
        'shipping_method' => 'Metodo di Spedizione',
        'payment_method' => 'Metodo di Pagamento',

        // Product Approval
        'product_approved_title' => 'Prodotto Approvato',
        'product_approved_message' => 'Il tuo prodotto è stato approvato per la vendita sul nostro sito <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Approvazione prodotto in sospeso',
        'pending_product_approval_message' => 'Nuovo prodotto è stato creato da :store_name <a href=":product_url">:product_name</a> è in attesa di approvazione.',

        // Verify Vendor
        'verify_vendor_title' => 'Verifica Venditore',
        'verify_vendor_message' => 'Hai un nuovo venditore che deve essere verificato su :site_title!',
        'vendor_information' => 'Informazioni Venditore',
        'shop_information' => 'Informazioni negozio',
        'field_store_name' => 'Nome Negozio',
        'field_store_phone' => 'Numero Telefono Negozio',
        'visit_store_button' => 'Visita negozio',

        // Withdrawal
        'withdrawal_approved_title' => 'Prelievo Approvato',
        'withdrawal_approved_message' => 'La tua richiesta di pagamento è stata approvata, invieremo <strong>:withdrawal_amount</strong> alle tue informazioni bancarie a breve.',

        // Order Cancellation
        'order_cancellation_title' => 'Il cliente ha cancellato l\'ordine :order_id',
        'order_cancellation_message' => 'Il cliente :customer_name ha cancellato l\'ordine <strong>:order_id</strong> per il motivo :cancellation_reason.',
        'order_items_header' => 'Ecco cosa avevi ordinato:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Benvenuto venditore',
        'welcome_vendor_greeting' => 'Siamo lieti di darti il benvenuto su :store_name!',
        'welcome_vendor_registration_complete' => 'La tua registrazione come venditore è stata completata con successo e ora fai parte della nostra vibrante comunità di venditori.',
        'welcome_vendor_next_steps' => 'Ecco cosa puoi fare ora:',
        'welcome_vendor_step_login' => 'Accedi al tuo account venditore utilizzando le tue credenziali.',
        'welcome_vendor_step_add_products' => 'Aggiungi i tuoi prodotti/servizi al tuo negozio. Assicurati di fornire descrizioni dettagliate e immagini accattivanti per attirare potenziali acquirenti.',
        'welcome_vendor_support' => 'Se hai domande o hai bisogno di assistenza, il nostro team di supporto è qui per aiutarti. Non esitare a contattarci!',
        'login_vendor_account_button' => 'Accedi al tuo account venditore',
        'welcome_vendor_closing' => 'Siamo entusiasti di vedere il tuo negozio prosperare su :site_title!',

        // Store Verification
        'store_verified_title' => 'Verifica Negozio Approvata',
        'store_verified_message' => 'Congratulazioni! Il tuo negozio è stato verificato con successo su <strong>:site_title</strong>. Questo badge di verifica aiuterà a costruire fiducia con i tuoi clienti.',
        'dear_store_owner' => 'Gentile Proprietario di :store_name,',
        'verification_details' => 'Dettagli Verifica',
        'store_verified_benefits' => 'Vantaggi di essere verificato',
        'verified_badge_benefit' => 'Un badge verificato mostrato sul tuo negozio',
        'increased_trust_benefit' => 'Maggiore fiducia e confidenza dei clienti',
        'higher_visibility_benefit' => 'Maggiore visibilità nei risultati di ricerca',
        'visit_your_store' => 'Visita Il Tuo Negozio',
        'congratulations_verified' => 'Congratulazioni per la tua verifica!',

        // Store Unverification
        'store_unverified_title' => 'Stato Verifica Negozio Modificato',
        'store_unverified_message' => 'Ci dispiace informarti che lo stato di verifica del tuo negozio su <strong>:site_title</strong> è stato modificato.',
        'unverification_details' => 'Dettagli Modifica Stato',
        'store_unverified_impacts' => 'Cosa significa questo',
        'verified_badge_removed' => 'Il badge verificato è stato rimosso dal tuo negozio',
        'verification_benefits_lost' => 'I vantaggi della verifica non sono più attivi',
        'store_unverified_next_steps' => 'Se hai domande su questa decisione o vuoi discutere una ri-verifica, <strong>contatta il nostro team di supporto</strong>.',
        'contact_support' => 'Contatta Supporto',
        'thank_you_understanding' => 'Grazie per la comprensione.',
    ],
    'current_balance' => 'Saldo attuale',
    'settings' => [
        'title' => 'Impostazioni',
        'description' => 'Impostazioni per il marketplace',
        'fee_per_order' => 'Commissione per ordine (%), suggerito: 2 o 3',
        'default_commission_fee' => 'Commissione predefinita (%), suggerito: 2 o 3',
        'enable_commission_fee_for_each_category' => 'Abilitare commissione per ogni categoria?',
        'categories' => 'Categorie',
        'select_categories' => 'Seleziona categorie..',
        'commission_fee' => 'Commissione (%)',
        'commission_fee_by_category' => 'Commissione per categoria (%)',
        'fee_withdrawal_amount' => 'Commissione prelievo',
        'withdrawal_fee_type' => 'Tipo commissione prelievo',
        'withdrawal_fee_types' => [
            'fixed' => 'Importo fisso',
            'percentage' => 'Percentuale',
        ],
        'check_valid_signature' => 'Controlla firma valida nei guadagni del venditore',
        'verify_vendor' => 'Verifica venditore (Il venditore può pubblicare prodotti solo dopo essere stato verificato)',
        'verify_vendor_helper' => 'Se abilitato, l\'amministratore deve verificare il venditore prima che possa pubblicare prodotti.',
        'requires_vendor_documentations_verification' => 'Richiede verifica documentazione venditore',
        'requires_vendor_documentations_verification_helper' => 'Se abilitato, i venditori devono caricare i loro documenti quando si candidano per diventare venditori.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Nascondi menu "Diventa venditore" nella dashboard cliente',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Se abilitato, il menu "Diventa venditore" sarà nascosto nella dashboard cliente.',
        'enable_product_approval' => 'Abilita approvazione prodotto',
        'enable_product_approval_description' => 'Se abilitato, l\'amministratore deve approvare il prodotto prima che sia pubblicato.',
        'hide_store_phone_number' => 'Nascondere numero telefono negozio?',
        'hide_store_email' => 'Nascondere email negozio?',
        'hide_store_address' => 'Nascondere indirizzo negozio?',
        'hide_store_social_links' => 'Nascondere link social negozio?',
        'enable_vendor_categories_filter' => 'Abilita filtro categorie venditore',
        'enable_vendor_categories_filter_description' => 'Mostra filtro categorie sulla pagina negozio venditore. Solo le categorie che hanno prodotti del venditore saranno mostrate.',
        'allow_vendor_manage_shipping' => 'Permettere al venditore di gestire spedizioni?',
        'allow_vendor_manage_shipping_description' => 'Se abilitato, il venditore può cambiare lo stato di spedizione dell\'ordine a "in consegna", "consegnato", ...',
        'charge_shipping_per_vendor' => 'Addebitare spedizione per venditore?',
        'charge_shipping_per_vendor_description' => 'Se abilitato, la spedizione sarà addebitata separatamente per ogni venditore. Se disabilitato, la spedizione sarà addebitata una volta per l\'intero ordine.',
        'commission_fee_each_category_fee_name' => 'Commissione dell\'impostazione commissione :key',
        'commission_fee_each_category_name' => 'Categorie dell\'impostazione commissione :key',
        'add_new' => 'Aggiungi nuovo',
        'payout_methods' => 'Metodi di pagamento',
        'max_upload_filesize' => 'Dimensione massima file upload (MB)',
        'max_upload_filesize_placeholder' => 'Predefinito: 10',
        'max_product_images_upload_by_vendor' => 'Numero massimo di immagini per ogni prodotto',
        'enable_vendor_registration' => 'Abilita registrazione venditore',
        'enable_vendor_registration_helper' => 'Se abilitato, i venditori possono registrare un account sul sito e pubblicare i loro prodotti.',
        'minimum_withdrawal_amount' => 'Importo minimo prelievo (Fisso)',
        'minimum_withdrawal_amount_helper' => 'Specifica l\'importo minimo che un venditore può prelevare. Predefinito è 0.',
        'allow_vendor_delete_their_orders' => 'Permettere ai venditori di eliminare i loro ordini',
        'allow_vendor_delete_their_orders_description' => 'Quando abilitato, i venditori possono gestire la loro lista ordini rimuovendo voci indesiderate. Usare con cautela poiché ordini eliminati possono impattare i record delle transazioni.',
        'enable_messaging_system' => 'Abilita sistema messaggi',
        'enable_messaging_system_description' => 'Se abilitato, venditori e clienti possono comunicare tra loro tramite il sistema di messaggi.',
        'term_and_privacy_policy_url' => 'URL termini e politica privacy',
        'show_vendor_registration_form_at_registration_page' => 'Mostra modulo registrazione venditore nella pagina di registrazione',
        'show_vendor_registration_form_at_registration_page_description' => 'Se abilitato, il modulo di registrazione venditore sarà mostrato nella pagina di registrazione.',
        'single_vendor_checkout' => 'Limita a Un Venditore per Ordine',
        'single_vendor_checkout_help' => 'Se abilitato, i clienti possono acquistare prodotti solo da un venditore per ordine.',
        'display_order_total_info_for_each_store' => 'Mostra informazioni totale ordine per ogni negozio',
        'display_order_total_info_for_each_store_helper' => 'Se abilitato, le informazioni del totale ordine saranno mostrate per ogni negozio nel riepilogo ordine.',
        'show_vendor_info_at_checkout' => 'Mostra informazioni venditore al checkout',
        'show_vendor_info_at_checkout_helper' => 'Se abilitato, le informazioni del venditore (nome, logo, recensioni) saranno mostrate nella pagina di checkout.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Tipi di file media che possono essere caricati dal venditore',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Specifica i tipi di file media che i venditori possono caricare. Selezionali nella lista sopra.',
    ],
    'theme_options' => [
        'name' => 'Marketplace',
        'description' => 'Opzioni tema per Marketplace',
        'logo_vendor_dashboard' => 'Logo nella dashboard venditore (Predefinito è il logo principale)',
    ],
    'store_name' => 'Nome negozio',
    'store_email' => 'Email negozio',
    'store_phone' => 'Telefono negozio',
    'store_address' => 'Indirizzo negozio',
    'store_url' => 'URL negozio',
    'product_name' => 'Nome prodotto',
    'product_url' => 'URL prodotto',
    'withdrawal_amount' => 'Importo prelievo',
    'helpers' => [
        'store_status' => 'Se cambi lo stato diverso da ":status" questo account negozio cambierà anche a ":customer"',
    ],
    'tables' => [
        'earnings' => 'Guadagni',
        'products_count' => 'Conteggio Prodotti',
    ],
    'vendors' => 'Venditori',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bonifico Bancario',
        'paypal' => 'PayPal',
        'cash' => 'Contanti',
    ],
    'reports' => [
        'name' => 'Rapporti',
        'total_fee_earnings' => 'Totale guadagni commissioni: :value',
        'total_fee' => 'Commissione totale',
        'total_amount' => 'Importo totale',
        'store_revenues' => 'Ricavi negozi',
        'sale_commissions' => 'Commissioni vendite',
        'fee' => 'Commissione (:symbol)',
        'amount' => 'Importo (:symbol)',
        'top_performing_stores' => 'Negozi con Migliori Prestazioni',
        'store_growth' => 'Crescita Negozi',
        'withdrawal_status_chart' => 'Stato Prelievi',
        'product_distribution' => 'Distribuzione Prodotti per Negozio',
        'average_commission' => 'Tasso Commissione Medio',
        'recent_withdrawals' => 'Prelievi Recenti',
        'number_of_stores' => 'Numero di Negozi',
        'number_of_products' => 'Numero di Prodotti',
        'orders' => 'Ordini',
        'revenue' => 'Ricavi',
        'increase' => ':count aumento',
        'decrease' => ':count diminuzione',
    ],
    'vendor' => 'Venditore',
    'vendor_name' => 'Nome venditore',
    'contact_store' => [
        'form_name' => 'Modulo Contatta Negozio',
    ],
    'store_statuses' => [
        'pending' => 'In sospeso',
        'published' => 'Approvato',
        'blocked' => 'Bloccato',
    ],
    'view_vendor' => 'Visualizza venditore :name',
    'vendor_information' => 'Informazioni Venditore',
    'vendor_verified' => 'Venditore Verificato',
    'vendor_not_verified' => 'Venditore Non Verificato',
    'vendor_verified_at' => 'Venditore Verificato Il',
    'view_certificate' => 'Visualizza Certificato',
    'view_government_id' => 'Visualizza Documento Identità',
    'documents' => 'Documenti',
    'store_products' => 'Prodotti Negozio',
    'store_orders' => 'Ordini Negozio',
    'total_revenue' => 'Ricavi Totali',
    'total_earnings' => 'Guadagni Totali',
    'withdrawals' => 'Prelievi',
    'pending_withdrawals' => 'Prelievi in Sospeso',
    'balance' => 'Saldo',
    'recent_products' => 'Prodotti Recenti',
    'products_count' => 'Prodotti',
    'store_status' => 'Stato Negozio',
    'verified' => 'Verificato',
];