<?php

return [
    'name' => '마켓플레이스',
    'email' => [
        'title' => '마켓플레이스',
        'description' => '마켓플레이스용 이메일 템플릿 설정',
        'store_new_order_title' => '신규 주문 알림',
        'store_new_order_description' => '주문이 들어올 때 스토어 소유자에게 이메일 발송',
        'verify_vendor_title' => '판매자 인증',
        'verify_vendor_description' => '판매자가 등록할 때 관리자에게 이메일 발송',
        'pending_product_approval_title' => '상품 승인 대기',
        'pending_product_approval_description' => '판매자가 상품을 등록할 때 관리자에게 이메일 발송',
        'vendor_account_approved_title' => '판매자 계정 승인됨',
        'vendor_account_approved_description' => '판매자 계정이 승인될 때 판매자에게 이메일 발송',
        'product_approved_title' => '상품 승인됨',
        'product_approved_description' => '상품이 승인될 때 판매자에게 이메일 발송',
        'withdrawal_approved_title' => '출금 승인됨',
        'withdrawal_approved_description' => '출금 요청이 승인될 때 판매자에게 이메일 발송',
        'vendor_account_rejected_title' => '판매자 계정 거절됨',
        'vendor_account_rejected_description' => '판매자 계정이 거절될 때 판매자에게 이메일 발송',
        'vendor_account_unblocked_title' => '판매자 계정 차단 해제됨',
        'vendor_account_unblocked_description' => '판매자 계정이 차단 해제될 때 판매자에게 이메일 발송',
        'vendor_account_blocked_title' => '판매자 계정 차단됨',
        'vendor_account_blocked_description' => '판매자 계정이 차단될 때 판매자에게 이메일 발송',
        'store_new_order_subject' => '{{ site_title }}에서 새로운 주문이 있습니다',
        'verify_vendor_subject' => '{{ site_title }}에서 새로운 판매자 인증이 필요합니다',
        'vendor_account_approved_subject' => '{{ site_title }}에서 판매할 수 있는 계정이 승인되었습니다',
        'vendor_account_rejected_subject' => '{{ site_title }}에서 판매할 수 있는 계정이 거절되었습니다',
        'pending_product_approval_subject' => '{{ site_title }}에서 판매할 새로운 상품이 승인 대기 중입니다',
        'product_approved_subject' => '{{ site_title }}에서 판매할 상품이 승인되었습니다',
        'withdrawal_approved_subject' => '출금 요청이 승인되었습니다',
        'welcome_vendor_title' => '판매자 환영',
        'welcome_vendor_description' => '등록 후 판매자에게 이메일 발송',
        'welcome_vendor_subject' => '{{ site_title }}에 오신 것을 환영합니다!',
        'contact_store_title' => '스토어 문의',
        'contact_store_description' => '고객이 스토어에 문의할 때 스토어 소유자에게 이메일 발송',
        'contact_store_subject' => '새로운 고객 문의 메시지',
        'vendor_account_blocked_subject' => '{{ site_title }}의 판매자 계정이 차단되었습니다',
        'vendor_account_unblocked_subject' => '{{ site_title }}의 판매자 계정이 차단 해제되었습니다',
        'order_cancellation_to_vendor_title' => '주문 취소 (판매자에게 발송)',
        'order_cancellation_to_vendor_description' => '고객이 주문을 취소할 때 판매자에게 발송',
        'order_cancellation_to_vendor_subject' => '고객이 :order_id 주문을 취소했습니다',
        'store_verified_title' => '스토어 인증 승인됨',
        'store_verified_description' => '스토어가 인증될 때 알림 발송',
        'store_verified_subject' => '스토어 {{ store_name }}이 인증되었습니다',
        'store_unverified_title' => '스토어 인증 제거됨',
        'store_unverified_description' => '스토어 인증이 제거될 때 알림 발송',
        'store_unverified_subject' => '{{ store_name }}의 인증 상태가 변경되었습니다',
        'verified_by' => '인증자',
        'verified_at' => '인증일',
        'unverified_by' => '인증 해제자',
        'unverified_at' => '인증 해제일',
        'verification_note' => '인증 메모',
        'store' => '스토어',
        'order' => '주문',
        'shipment' => '배송 정보',
        'address' => '배송 주소',
        'products' => '주문 상품',
        'customer_message' => '고객 메시지',
        'customer_name' => '고객명',
        'customer_email' => '고객 이메일',
        'block_reason' => '차단 사유',
        'block_date' => '차단일',
        'unblock_date' => '차단 해제일',
    ],
    'email_templates' => [
        'dear_vendor' => '안녕하세요 :vendor_name님,',
        'dear_admin' => '관리자님께,',
        'hello' => '안녕하세요,',
        'happy_selling' => '즐거운 판매 되세요!',
        'thank_you_understanding' => '양해해 주셔서 감사합니다.',
        'email_sent_by_team' => '이 이메일은 {{ site_title }} 팀에서 발송되었습니다.',

        // Contact Store
        'contact_store_sent_from' => '이 이메일은 :site_title의 프로필 문의 폼을 통해 :customer_name (:customer_email)님이 보낸 것입니다.',
        'contact_store_reply_instruction' => ':customer_name (:customer_email)님에게 응답하려면 이 이메일에 직접 답장하시면 됩니다.',

        // Vendor Account Status
        'vendor_account_blocked_message' => '{{ site_title }}의 판매자 계정이 :block_date부터 <strong>차단</strong>되었습니다.',
        'vendor_account_blocked_reason' => '차단 사유: :block_reason',
        'vendor_account_blocked_contact_support' => '이것이 실수라고 생각되거나 질문이 있으시면 고객지원팀에 문의해 주세요.',
        'vendor_account_unblocked_message' => '{{ site_title }}의 판매자 계정이 :unblock_date부터 <strong>차단 해제</strong>되었음을 알려드립니다.',
        'vendor_account_unblocked_resume' => '이제 계정에 접속하여 활동을 재개할 수 있습니다.',
        'vendor_account_unblocked_questions' => '질문이 있으시면 언제든지 고객지원팀에 문의해 주세요.',
        'vendor_account_approved_title' => '판매자 계정 승인됨',
        'vendor_account_approved_message' => '저희 사이트 <a href=":site_url">:site_url</a>에서 판매할 수 있는 계정이 승인되었습니다.',
        'vendor_account_rejected_title' => '판매자 계정 거절됨',
        'vendor_account_rejected_message' => '죄송하지만 저희 사이트 <a href=":site_url">:site_url</a>에서 판매할 수 있는 계정이 승인되지 않았습니다.',

        // Store New Order
        'store_new_order_title' => '주문 성공!',
        'store_new_order_message' => ':site_title에서 새로운 주문이 들어왔습니다!',
        'customer_information' => '고객 정보',
        'field_name' => '이름',
        'field_phone' => '전화번호',
        'field_email' => '이메일',
        'field_address' => '주소',
        'field_note' => '메모',
        'order_number' => '주문번호',
        'order_date' => '주문일',
        'shipping_method' => '배송 방법',
        'payment_method' => '결제 방법',

        // Product Approval
        'product_approved_title' => '상품 승인됨',
        'product_approved_message' => '저희 사이트 <a href=":site_url">:site_url</a>에서 판매할 상품이 승인되었습니다.',
        'pending_product_approval_title' => '상품 승인 대기',
        'pending_product_approval_message' => ':store_name에서 새로운 상품 <a href=":product_url">:product_name</a>이 승인 대기 중입니다.',

        // Verify Vendor
        'verify_vendor_title' => '판매자 인증',
        'verify_vendor_message' => ':site_title에서 인증이 필요한 새로운 판매자가 있습니다!',
        'vendor_information' => '판매자 정보',
        'shop_information' => '쇼핑몰 정보',
        'field_store_name' => '스토어명',
        'field_store_phone' => '스토어 전화번호',
        'visit_store_button' => '스토어 방문',

        // Withdrawal
        'withdrawal_approved_title' => '출금 승인됨',
        'withdrawal_approved_message' => '출금 요청이 승인되었습니다. <strong>:withdrawal_amount</strong>를 은행 정보로 곧 송금해 드리겠습니다.',

        // Order Cancellation
        'order_cancellation_title' => '고객이 :order_id 주문을 취소했습니다',
        'order_cancellation_message' => '고객 :customer_name님이 :cancellation_reason 사유로 <strong>:order_id</strong> 주문을 취소했습니다.',
        'order_items_header' => '주문하신 상품입니다:',

        // Welcome Vendor
        'welcome_vendor_title' => '판매자 환영',
        'welcome_vendor_greeting' => ':store_name에 오신 것을 환영합니다!',
        'welcome_vendor_registration_complete' => '판매자 등록이 성공적으로 완료되었으며, 이제 저희의 활기찬 판매자 커뮤니티의 일원이 되셨습니다.',
        'welcome_vendor_next_steps' => '다음 단계는 다음과 같습니다:',
        'welcome_vendor_step_login' => '자격 증명을 사용하여 판매자 계정에 로그인하세요.',
        'welcome_vendor_step_add_products' => '스토어에 상품/서비스를 추가하세요. 잠재 구매자를 끌어들이기 위해 자세한 설명과 매력적인 이미지를 제공해 주세요.',
        'welcome_vendor_support' => '궁금한 점이 있거나 도움이 필요하시면 고객지원팀이 도와드리겠습니다. 언제든지 문의해 주세요!',
        'login_vendor_account_button' => '판매자 계정 로그인',
        'welcome_vendor_closing' => ':site_title에서 스토어가 번영하기를 기대합니다!',

        // Store Verification
        'store_verified_title' => '스토어 인증 승인됨',
        'store_verified_message' => '축하합니다! <strong>:site_title</strong>에서 스토어가 성공적으로 인증되었습니다. 이 인증 배지는 고객과의 신뢰 구축에 도움이 될 것입니다.',
        'dear_store_owner' => ':store_name 소유자님께,',
        'verification_details' => '인증 세부사항',
        'store_verified_benefits' => '인증의 혜택',
        'verified_badge_benefit' => '스토어에 표시되는 인증 배지',
        'increased_trust_benefit' => '고객 신뢰 및 신뢰도 증가',
        'higher_visibility_benefit' => '검색 결과에서 높은 가시성',
        'visit_your_store' => '스토어 방문하기',
        'congratulations_verified' => '인증을 축하드립니다!',

        // Store Unverification
        'store_unverified_title' => '스토어 인증 상태 변경됨',
        'store_unverified_message' => '<strong>:site_title</strong>에서 스토어의 인증 상태가 변경되었음을 알려드립니다.',
        'unverification_details' => '상태 변경 세부사항',
        'store_unverified_impacts' => '이것이 의미하는 것',
        'verified_badge_removed' => '스토어에서 인증 배지가 제거되었습니다',
        'verification_benefits_lost' => '인증 혜택이 더 이상 활성화되지 않습니다',
        'store_unverified_next_steps' => '이 결정에 대해 질문이 있거나 재인증을 논의하고 싶으시면 <strong>고객지원팀에 문의</strong>해 주세요.',
        'contact_support' => '고객지원 문의',
        'thank_you_understanding' => '양해해 주셔서 감사합니다.',
    ],
    'current_balance' => '현재 잔액',
    'settings' => [
        'title' => '설정',
        'description' => '마켓플레이스 설정',
        'fee_per_order' => '주문당 수수료 (%), 권장: 2 또는 3',
        'default_commission_fee' => '기본 수수료 (%), 권장: 2 또는 3',
        'enable_commission_fee_for_each_category' => '카테고리별 수수료 활성화?',
        'categories' => '카테고리',
        'select_categories' => '카테고리 선택..',
        'commission_fee' => '수수료 (%)',
        'commission_fee_by_category' => '카테고리별 수수료 (%)',
        'fee_withdrawal_amount' => '출금 수수료',
        'withdrawal_fee_type' => '출금 수수료 유형',
        'withdrawal_fee_types' => [
            'fixed' => '고정 금액',
            'percentage' => '백분율',
        ],
        'check_valid_signature' => '판매자 수익에서 유효한 서명 확인',
        'verify_vendor' => '판매자 인증 (판매자는 인증 후에만 상품을 등록할 수 있습니다)',
        'verify_vendor_helper' => '활성화하면 관리자가 판매자를 인증한 후에만 상품을 등록할 수 있습니다.',
        'requires_vendor_documentations_verification' => '판매자 서류 인증 필요',
        'requires_vendor_documentations_verification_helper' => '활성화하면 판매자가 되기 위해 지원할 때 서류를 업로드해야 합니다.',
        'hide_become_vendor_menu_in_customer_dashboard' => '고객 대시보드에서 판매자 되기 메뉴 숨기기',
        'hide_become_vendor_menu_in_customer_dashboard_description' => '활성화하면 고객 대시보드에서 "판매자 되기" 메뉴가 숨겨집니다.',
        'enable_product_approval' => '상품 승인 활성화',
        'enable_product_approval_description' => '활성화하면 관리자가 상품을 승인한 후에만 게시됩니다.',
        'hide_store_phone_number' => '스토어 전화번호 숨기기?',
        'hide_store_email' => '스토어 이메일 숨기기?',
        'hide_store_address' => '스토어 주소 숨기기?',
        'hide_store_social_links' => '스토어 소셜 링크 숨기기?',
        'enable_vendor_categories_filter' => '판매자 카테고리 필터 활성화',
        'enable_vendor_categories_filter_description' => '판매자 스토어 페이지에서 카테고리 필터를 표시합니다. 판매자 상품이 있는 카테고리만 표시됩니다.',
        'allow_vendor_manage_shipping' => '판매자 배송 관리 허용?',
        'allow_vendor_manage_shipping_description' => '활성화하면 판매자가 주문의 배송 상태를 "배송중", "배송완료" 등으로 변경할 수 있습니다.',
        'charge_shipping_per_vendor' => '판매자별 배송비 청구?',
        'charge_shipping_per_vendor_description' => '활성화하면 각 판매자별로 배송비가 따로 청구됩니다. 비활성화하면 전체 주문에 대해 한 번만 배송비가 청구됩니다.',
        'commission_fee_each_category_fee_name' => '수수료 설정 :key의 수수료',
        'commission_fee_each_category_name' => '수수료 설정 :key의 카테고리',
        'add_new' => '새로 추가',
        'payout_methods' => '지급 방법',
        'max_upload_filesize' => '최대 업로드 파일 크기 (MB)',
        'max_upload_filesize_placeholder' => '기본값: 10',
        'max_product_images_upload_by_vendor' => '상품당 최대 이미지 수',
        'enable_vendor_registration' => '판매자 등록 활성화',
        'enable_vendor_registration_helper' => '활성화하면 판매자가 사이트에서 계정을 등록하고 상품을 등록할 수 있습니다.',
        'minimum_withdrawal_amount' => '최소 출금 금액 (고정)',
        'minimum_withdrawal_amount_helper' => '판매자가 출금할 수 있는 최소 금액을 지정합니다. 기본값은 0입니다.',
        'allow_vendor_delete_their_orders' => '판매자의 주문 삭제 허용',
        'allow_vendor_delete_their_orders_description' => '활성화하면 판매자가 원하지 않는 항목을 제거하여 주문 목록을 관리할 수 있습니다. 삭제된 주문이 거래 기록에 영향을 줄 수 있으므로 주의해서 사용하세요.',
        'enable_messaging_system' => '메시징 시스템 활성화',
        'enable_messaging_system_description' => '활성화하면 판매자와 고객이 메시징 시스템을 통해 서로 소통할 수 있습니다.',
        'term_and_privacy_policy_url' => '이용약관 및 개인정보처리방침 URL',
        'show_vendor_registration_form_at_registration_page' => '회원가입 페이지에서 판매자 등록 폼 표시',
        'show_vendor_registration_form_at_registration_page_description' => '활성화하면 회원가입 페이지에서 판매자 등록 폼이 표시됩니다.',
        'single_vendor_checkout' => '주문당 한 판매자로 제한',
        'single_vendor_checkout_help' => '활성화하면 고객은 주문당 한 판매자의 상품만 구매할 수 있습니다.',
        'display_order_total_info_for_each_store' => '각 스토어별 주문 총액 정보 표시',
        'display_order_total_info_for_each_store_helper' => '활성화하면 주문 요약에서 각 스토어별 주문 총액 정보가 표시됩니다.',
        'show_vendor_info_at_checkout' => '결제 시 판매자 정보 표시',
        'show_vendor_info_at_checkout_helper' => '활성화하면 결제 페이지에서 판매자 정보(이름, 로고, 리뷰)가 표시됩니다.',
        'media_file_types_can_be_uploaded_by_vendor' => '판매자가 업로드할 수 있는 미디어 파일 유형',
        'media_file_types_can_be_uploaded_by_vendor_helper' => '판매자가 업로드할 수 있는 미디어 파일 유형을 지정합니다. 위 목록에서 선택하세요.',
    ],
    'theme_options' => [
        'name' => '마켓플레이스',
        'description' => '마켓플레이스 테마 옵션',
        'logo_vendor_dashboard' => '판매자 대시보드 로고 (기본값은 메인 로고)',
    ],
    'store_name' => '스토어명',
    'store_email' => '스토어 이메일',
    'store_phone' => '스토어 전화번호',
    'store_address' => '스토어 주소',
    'store_url' => '스토어 URL',
    'product_name' => '상품명',
    'product_url' => '상품 URL',
    'withdrawal_amount' => '출금 금액',
    'helpers' => [
        'store_status' => '상태를 ":status"가 아닌 다른 상태로 변경하면 이 스토어의 계정도 ":customer"로 변경됩니다',
    ],
    'tables' => [
        'earnings' => '수익',
        'products_count' => '상품 수',
    ],
    'vendors' => '판매자',
    'payout_payment_methods' => [
        'bank_transfer' => '계좌이체',
        'paypal' => 'PayPal',
        'cash' => '현금',
    ],
    'reports' => [
        'name' => '보고서',
        'total_fee_earnings' => '총 수수료 수익: :value',
        'total_fee' => '총 수수료',
        'total_amount' => '총 금액',
        'store_revenues' => '스토어 수익',
        'sale_commissions' => '판매 수수료',
        'fee' => '수수료 (:symbol)',
        'amount' => '금액 (:symbol)',
        'top_performing_stores' => '최고 성과 스토어',
        'store_growth' => '스토어 성장',
        'withdrawal_status_chart' => '출금 상태',
        'product_distribution' => '스토어별 상품 분포',
        'average_commission' => '평균 수수료율',
        'recent_withdrawals' => '최근 출금',
        'number_of_stores' => '스토어 수',
        'number_of_products' => '상품 수',
        'orders' => '주문',
        'revenue' => '수익',
        'increase' => ':count 증가',
        'decrease' => ':count 감소',
    ],
    'vendor' => '판매자',
    'vendor_name' => '판매자명',
    'contact_store' => [
        'form_name' => '스토어 문의 폼',
    ],
    'store_statuses' => [
        'pending' => '대기중',
        'published' => '승인됨',
        'blocked' => '차단됨',
    ],
    'view_vendor' => '판매자 :name 보기',
    'vendor_information' => '판매자 정보',
    'vendor_verified' => '판매자 인증됨',
    'vendor_not_verified' => '판매자 미인증',
    'vendor_verified_at' => '판매자 인증일',
    'view_certificate' => '인증서 보기',
    'view_government_id' => '신분증 보기',
    'documents' => '서류',
    'store_products' => '스토어 상품',
    'store_orders' => '스토어 주문',
    'total_revenue' => '총 수익',
    'total_earnings' => '총 수입',
    'withdrawals' => '출금',
    'pending_withdrawals' => '대기중인 출금',
    'balance' => '잔액',
    'recent_products' => '최근 상품',
    'products_count' => '상품',
    'store_status' => '스토어 상태',
    'verified' => '인증됨',
];