<?php

return [
    'name' => 'Mercado',
    'email' => [
        'title' => 'Mercado',
        'description' => 'Configurar modelos de e-mail para o Marketplace',
        'store_new_order_title' => 'Aviso sobre novo pedido',
        'store_new_order_description' => 'Enviar e-mail para o proprietário da loja quando um pedido for feito',
        'verify_vendor_title' => 'Verifique o fornecedor',
        'verify_vendor_description' => 'Enviar e-mail ao administrador quando um fornecedor se registrar',
        'pending_product_approval_title' => 'Aprovação do produto pendente',
        'pending_product_approval_description' => 'Envie um e-mail para o administrador quando um fornecedor postar seus produtos',
        'vendor_account_approved_title' => 'Conta de fornecedor aprovada',
        'vendor_account_approved_description' => 'Enviar e-mail ao fornecedor quando sua conta for aprovada',
        'product_approved_title' => 'Produto aprovado',
        'product_approved_description' => 'Enviar e-mail ao fornecedor quando o produto for aprovado',
        'withdrawal_approved_title' => 'Retirada aprovada',
        'withdrawal_approved_description' => 'Enviar e-mail ao fornecedor quando sua solicitação de retirada for aprovada',
        'vendor_account_rejected_title' => 'Conta de fornecedor rejeitada',
        'vendor_account_rejected_description' => 'Enviar e-mail ao fornecedor quando sua conta for rejeitada',
        'vendor_account_unblocked_title' => 'Conta de fornecedor desbloqueada',
        'vendor_account_unblocked_description' => 'Enviar e-mail ao fornecedor quando sua conta for desbloqueada',
        'vendor_account_blocked_title' => 'Conta de fornecedor bloqueada',
        'vendor_account_blocked_description' => 'Enviar e-mail ao fornecedor quando sua conta for bloqueada',
        'store_new_order_subject' => 'Novo(s) pedido(s) em {{ site_title }}',
        'verify_vendor_subject' => 'O novo fornecedor em {{ site_title }} precisa ser verificado',
        'vendor_account_approved_subject' => 'Sua conta foi aprovada para venda em {{ site_title }}',
        'vendor_account_rejected_subject' => 'Sua conta foi rejeitada por venda em {{ site_title }}',
        'pending_product_approval_subject' => 'O novo produto precisa ser aprovado para venda em {{ site_title }}',
        'product_approved_subject' => 'Seu produto foi aprovado para venda em {{ site_title }}',
        'withdrawal_approved_subject' => 'Sua solicitação de saque foi aprovada',
        'welcome_vendor_title' => 'Bem-vindo fornecedor',
        'welcome_vendor_description' => 'Enviar e-mail para o fornecedor após cadastrado',
        'welcome_vendor_subject' => 'Bem-vindo ao {{ site_title }}!',
        'contact_store_title' => 'Contate a loja',
        'contact_store_description' => 'Envie um e-mail ao proprietário da loja quando um cliente entrar em contato com a loja',
        'contact_store_subject' => 'Nova mensagem de contato do cliente',
        'vendor_account_blocked_subject' => 'Sua conta de fornecedor em {{ site_title }} foi bloqueada',
        'vendor_account_unblocked_subject' => 'Sua conta de fornecedor em {{ site_title }} foi desbloqueada',
        'store' => 'Loja',
        'order' => 'Ordem',
        'shipment' => 'Informações de envio',
        'address' => 'Endereço para envio',
        'products' => 'Encomendar produtos',
        'customer_message' => 'Mensagem do cliente',
        'customer_name' => 'Nome do cliente',
        'customer_email' => 'E-mail do cliente',
        'block_reason' => 'Motivo do bloqueio',
        'block_date' => 'Data do bloqueio',
        'unblock_date' => 'Data de desbloqueio',
        'order_cancellation_to_vendor_title' => 'Cancelamento de pedido (será enviado ao vendedor (fornecedor)',
        'order_cancellation_to_vendor_description' => 'Enviar ao vendedor (fornecedor) quando o cliente cancelar um pedido',
        'order_cancellation_to_vendor_subject' => 'Pedido :order_id foi cancelado pelo cliente',
        'store_verified_title' => 'Verificação da Loja Aprovada',
        'store_verified_description' => 'Enviar notificação quando a loja for verificada',
        'store_verified_subject' => 'Sua loja {{ store_name }} foi verificada',
        'store_unverified_title' => 'Verificação da Loja Removida',
        'store_unverified_description' => 'Enviar notificação quando a verificação da loja for removida',
        'store_unverified_subject' => 'Status de verificação alterado para {{ store_name }}',
        'verified_by' => 'Verificado por',
        'verified_at' => 'Verificado em',
        'unverified_by' => 'Não verificado por',
        'unverified_at' => 'Não verificado em',
        'verification_note' => 'Nota de verificação',
    ],
    'email_templates' => [
        'dear_vendor' => 'Caro :vendor_name,',
        'dear_admin' => 'Caro Administrador,',
        'hello' => 'Olá,',
        'happy_selling' => 'Boas vendas!',
        'thank_you_understanding' => 'Obrigado pela sua compreensão.',
        'email_sent_by_team' => 'Este e-mail foi enviado pela equipe {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'Este e-mail foi enviado de :customer_name (:customer_email) através do seu formulário de contato do perfil em :site_title.',
        'contact_store_reply_instruction' => 'Você pode responder diretamente a este e-mail para responder a :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Sua conta de fornecedor em {{ site_title }} foi <strong>bloqueada</strong> em :block_date.',
        'vendor_account_blocked_reason' => 'Motivo do bloqueio: :block_reason',
        'vendor_account_blocked_contact_support' => 'Se você acredita que isso é um erro ou tem alguma dúvida, entre em contato com nossa equipe de suporte.',
        'vendor_account_unblocked_message' => 'Temos o prazer de informar que sua conta de fornecedor em {{ site_title }} foi <strong>desbloqueada</strong> em :unblock_date.',
        'vendor_account_unblocked_resume' => 'Agora você pode acessar sua conta e retomar suas atividades.',
        'vendor_account_unblocked_questions' => 'Se você tiver alguma dúvida, sinta-se à vontade para entrar em contato com nossa equipe de suporte.',
        'vendor_account_approved_title' => 'Conta de Fornecedor Aprovada',
        'vendor_account_approved_message' => 'Sua conta foi aprovada para venda em nosso site <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Conta de Fornecedor Rejeitada',
        'vendor_account_rejected_message' => 'Lamentamos informar que sua conta não foi aprovada para venda em nosso site <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Pedido realizado com sucesso!',
        'store_new_order_message' => 'Você recebeu um novo pedido em :site_title!',
        'customer_information' => 'Informações do Cliente',
        'field_name' => 'Nome',
        'field_phone' => 'Telefone',
        'field_email' => 'E-mail',
        'field_address' => 'Endereço',
        'field_note' => 'Nota',
        'order_number' => 'Número do pedido',
        'order_date' => 'Data do pedido',
        'shipping_method' => 'Método de Envio',
        'payment_method' => 'Método de Pagamento',

        // Product Approval
        'product_approved_title' => 'Produto Aprovado',
        'product_approved_message' => 'Seu produto foi aprovado para venda em nosso site <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Aprovação de produto pendente',
        'pending_product_approval_message' => 'Novo produto foi criado por :store_name <a href=":product_url">:product_name</a> está aguardando aprovação.',

        // Verify Vendor
        'verify_vendor_title' => 'Verificar Fornecedor',
        'verify_vendor_message' => 'Você tem um novo fornecedor que precisa ser verificado em :site_title!',
        'vendor_information' => 'Informações do Fornecedor',
        'shop_information' => 'Informações da loja',
        'field_store_name' => 'Nome da Loja',
        'field_store_phone' => 'Número de Telefone da Loja',
        'visit_store_button' => 'Visitar loja',

        // Withdrawal
        'withdrawal_approved_title' => 'Saque Aprovado',
        'withdrawal_approved_message' => 'Sua solicitação de pagamento foi aprovada, enviaremos <strong>:withdrawal_amount</strong> para suas informações bancárias em breve.',

        // Order Cancellation
        'order_cancellation_title' => 'Cliente cancelou o pedido :order_id',
        'order_cancellation_message' => 'Cliente :customer_name cancelou o pedido <strong>:order_id</strong> devido ao motivo :cancellation_reason.',
        'order_items_header' => 'Aqui está o que você pediu:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Bem-vindo fornecedor',
        'welcome_vendor_greeting' => 'Estamos encantados em recebê-lo na :store_name!',
        'welcome_vendor_registration_complete' => 'Seu registro de fornecedor foi concluído com sucesso e agora você faz parte de nossa vibrante comunidade de vendedores.',
        'welcome_vendor_next_steps' => 'Aqui está o que você pode fazer a seguir:',
        'welcome_vendor_step_login' => 'Faça login em sua conta de fornecedor usando suas credenciais.',
        'welcome_vendor_step_add_products' => 'Adicione seus produtos/serviços à sua loja. Certifique-se de fornecer descrições detalhadas e imagens cativantes para atrair compradores em potencial.',
        'welcome_vendor_support' => 'Se você tiver alguma dúvida ou precisar de assistência ao longo do caminho, nossa equipe de suporte está aqui para ajudá-lo. Sinta-se à vontade para entrar em contato!',
        'login_vendor_account_button' => 'Faça login em sua conta de fornecedor',
        'welcome_vendor_closing' => 'Estamos ansiosos para ver sua loja florescer em :site_title!',

        // Store Verification
        'store_verified_title' => 'Verificação da Loja Aprovada',
        'store_verified_message' => 'Parabéns! Sua loja foi verificada com sucesso em <strong>:site_title</strong>. Este selo de verificação ajudará a construir confiança com seus clientes.',
        'dear_store_owner' => 'Caro Proprietário da :store_name,',
        'verification_details' => 'Detalhes da Verificação',
        'store_verified_benefits' => 'Benefícios de ser verificado',
        'verified_badge_benefit' => 'Um selo de verificado exibido em sua loja',
        'increased_trust_benefit' => 'Aumento da confiança e confiança do cliente',
        'higher_visibility_benefit' => 'Maior visibilidade nos resultados de pesquisa',
        'visit_your_store' => 'Visite Sua Loja',
        'congratulations_verified' => 'Parabéns pela sua verificação!',

        // Store Unverification
        'store_unverified_title' => 'Status de Verificação da Loja Alterado',
        'store_unverified_message' => 'Lamentamos informar que o status de verificação de sua loja em <strong>:site_title</strong> foi alterado.',
        'unverification_details' => 'Detalhes da Alteração de Status',
        'store_unverified_impacts' => 'O que isso significa',
        'verified_badge_removed' => 'O selo de verificado foi removido de sua loja',
        'verification_benefits_lost' => 'Os benefícios de verificação não estão mais ativos',
        'store_unverified_next_steps' => 'Se você tiver alguma dúvida sobre esta decisão ou gostaria de discutir a re-verificação, <strong>entre em contato com nossa equipe de suporte</strong>.',
        'contact_support' => 'Contatar Suporte',
        'thank_you_understanding' => 'Obrigado pela sua compreensão.',
    ],
    'current_balance' => 'Saldo atual',
    'settings' => [
        'title' => 'Configurações para mercado',
        'description' => 'Taxa de comissão de configuração',
        'fee_per_order' => 'Taxa por taxa (%), sugira: 2 ou 3',
        'default_commission_fee' => 'Taxa de comissão padrão (%), sugestão: 2 ou 3',
        'enable_commission_fee_for_each_category' => 'Habilitar taxa de comissão para cada categoria?',
        'categories' => 'Categorias',
        'select_categories' => 'Selecione categorias..',
        'commission_fee' => 'Taxa de comissão (%)',
        'commission_fee_by_category' => 'Taxa de comissão por categoria (%)',
        'fee_withdrawal_amount' => 'Taxa de retirada',
        'withdrawal_fee_type' => 'Tipo de taxa de retirada',
        'withdrawal_fee_types' => [
            'fixed' => 'Valor fixo',
            'percentage' => 'Porcentagem',
        ],
        'check_valid_signature' => 'Verifique a assinatura válida nos ganhos do fornecedor',
        'verify_vendor' => 'Verificação do fornecedor (o fornecedor só pode postar sua lista de produtos após ser verificado)',
        'verify_vendor_helper' => 'Se ativado, o administrador deverá verificar o fornecedor antes de publicar sua lista de produtos.',
        'requires_vendor_documentations_verification' => 'Requer verificação de documentação do fornecedor',
        'requires_vendor_documentations_verification_helper' => 'Se ativado, os fornecedores deverão fazer upload de seus arquivos de documentação ao se inscreverem para se tornarem fornecedores.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Ocultar o menu de tornar-se fornecedor no painel do cliente',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Se ativado, o menu “Torne-se um fornecedor” ficará oculto no painel do cliente.',
        'enable_product_approval' => 'Habilitar aprovação de produto',
        'enable_product_approval_description' => 'Se ativado, o administrador deverá aprovar o produto antes de ser publicado.',
        'hide_store_phone_number' => 'Ocultar o número de telefone da loja?',
        'hide_store_email' => 'Ocultar e-mail da loja?',
        'hide_store_address' => 'Ocultar endereço da loja?',
        'hide_store_social_links' => 'Ocultar links sociais da loja?',
        'enable_vendor_categories_filter' => 'Habilitar filtro de categorias de fornecedor',
        'enable_vendor_categories_filter_description' => 'Mostrar filtro de categorias na página da loja do fornecedor. Apenas categorias que possuem produtos de fornecedor serão exibidas.',
        'allow_vendor_manage_shipping' => 'Permitir que o fornecedor gerencie o frete?',
        'allow_vendor_manage_shipping_description' => 'Se estiver habilitado, o fornecedor pode alterar o status de envio do pedido para "entregando", "entregue", ...',
        'charge_shipping_per_vendor' => 'Cobrar frete por fornecedor?',
        'charge_shipping_per_vendor_description' => 'Se habilitado, o frete será cobrado separadamente para cada fornecedor. Se desabilitado, o frete será cobrado uma vez para todo o pedido.',
        'commission_fee_each_category_fee_name' => 'Taxa de comissão da configuração de comissão :key',
        'commission_fee_each_category_name' => 'Categorias da configuração de comissão :key',
        'add_new' => 'Adicionar novo',
        'payout_methods' => 'Métodos de pagamento',
        'max_upload_filesize' => 'Tamanho máximo do arquivo de upload (MB)',
        'max_upload_filesize_placeholder' => 'Padrão: 10',
        'max_product_images_upload_by_vendor' => 'Número máximo de imagens para cada produto',
        'enable_vendor_registration' => 'Habilitar registro de fornecedor',
        'enable_vendor_registration_helper' => 'Se ativado, os fornecedores podem registrar uma conta no site e publicar seus produtos.',
        'minimum_withdrawal_amount' => 'Valor mínimo de retirada (fixo)',
        'minimum_withdrawal_amount_helper' => 'Especifique o valor mínimo que um fornecedor pode sacar. O padrão é 0.',
        'allow_vendor_delete_their_orders' => 'Permitir que os fornecedores excluam seus pedidos',
        'allow_vendor_delete_their_orders_description' => 'Quando ativado, os fornecedores podem gerenciar sua lista de pedidos removendo entradas indesejadas. Use com cuidado, pois os pedidos excluídos podem afetar os registros de transações.',
        'enable_messaging_system' => 'Habilitar sistema de mensagens',
        'enable_messaging_system_description' => 'Se ativado, fornecedores e clientes poderão se comunicar entre si por meio do sistema de mensagens.',
        'term_and_privacy_policy_url' => 'URL do termo e da política de privacidade',
        'show_vendor_registration_form_at_registration_page' => 'Mostrar formulário de registro de fornecedor na página de registro',
        'show_vendor_registration_form_at_registration_page_description' => 'Se ativado, o formulário de registro do fornecedor será exibido na página de registro.',
        'single_vendor_checkout' => 'Limite a um fornecedor por pedido',
        'single_vendor_checkout_help' => 'Se ativado, os clientes só poderão comprar produtos de um fornecedor por pedido.',
        'display_order_total_info_for_each_store' => 'Exibir informações do total do pedido para cada loja',
        'display_order_total_info_for_each_store_helper' => 'Se habilitado, as informações do total do pedido serão exibidas para cada loja no resumo do pedido.',
        'show_vendor_info_at_checkout' => 'Mostrar informações do fornecedor no checkout',
        'show_vendor_info_at_checkout_helper' => 'Se habilitado, as informações do fornecedor (nome, logotipo, avaliações) serão exibidas na página de checkout.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Tipos de arquivo de mídia que podem ser carregados pelo fornecedor',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Especifique os tipos de arquivo de mídia que os fornecedores podem carregar. Selecione-os na lista acima.',
    ],
    'theme_options' => [
        'name' => 'Mercado',
        'description' => 'Opções de tema para Marketplace',
        'logo_vendor_dashboard' => 'Logotipo no painel do fornecedor (o padrão é o logotipo principal)',
    ],
    'store_name' => 'Nome da loja',
    'store_email' => 'Armazenar e-mail',
    'store_phone' => 'Armazenar telefone',
    'store_address' => 'Endereço da loja',
    'store_url' => 'URL da loja',
    'product_name' => 'Nome do produto',
    'product_url' => 'URL do produto',
    'withdrawal_amount' => 'Valor da retirada',
    'helpers' => [
        'store_status' => 'Se você alterar o status diferente de ":status" a conta desta loja também mudará para ":customer"',
    ],
    'tables' => [
        'earnings' => 'Ganhos',
        'products_count' => 'Contagem de produtos',
    ],
    'vendors' => 'Fornecedores',
    'payout_payment_methods' => [
        'bank_transfer' => 'Transferência Bancária',
        'paypal' => 'PayPal',
        'cash' => 'Dinheiro',
    ],
    'reports' => [
        'name' => 'Relatórios',
        'total_fee_earnings' => 'Total de ganhos de taxas: :value',
        'total_fee' => 'Taxa total',
        'total_amount' => 'Montante total',
        'store_revenues' => 'Receitas da loja',
        'sale_commissions' => 'Comissões de venda',
        'fee' => 'Taxa (:symbol)',
        'amount' => 'Quantidade (:symbol)',
        'top_performing_stores' => 'Lojas com Melhor Desempenho',
        'store_growth' => 'Crescimento da Loja',
        'withdrawal_status_chart' => 'Status de Retirada',
        'product_distribution' => 'Distribuição de Produtos por Loja',
        'average_commission' => 'Taxa Média de Comissão',
        'recent_withdrawals' => 'Retiradas Recentes',
        'number_of_stores' => 'Número de Lojas',
        'number_of_products' => 'Número de Produtos',
        'orders' => 'Pedidos',
        'revenue' => 'Receita',
        'increase' => ':count aumento',
        'decrease' => ':count diminuição',
    ],
    'vendor' => 'Fornecedor',
    'vendor_name' => 'Nome do fornecedor',
    'contact_store' => [
        'form_name' => 'Formulário de contato da loja',
    ],
    'store_statuses' => [
        'pending' => 'Pendente',
        'published' => 'Aprovado',
        'blocked' => 'Bloqueado',
    ],
    'view_vendor' => 'Ver fornecedor :name',
    'vendor_information' => 'Informações do Fornecedor',
    'vendor_verified' => 'Fornecedor Verificado',
    'vendor_not_verified' => 'Fornecedor Não Verificado',
    'vendor_verified_at' => 'Fornecedor Verificado Em',
    'view_certificate' => 'Ver Certificado',
    'view_government_id' => 'Ver Documento de Identidade',
    'documents' => 'Documentos',
    'store_products' => 'Produtos da Loja',
    'store_orders' => 'Pedidos da Loja',
    'total_revenue' => 'Receita Total',
    'total_earnings' => 'Ganhos Totais',
    'withdrawals' => 'Retiradas',
    'pending_withdrawals' => 'Retiradas Pendentes',
    'balance' => 'Saldo',
    'recent_products' => 'Produtos Recentes',
    'products_count' => 'Produtos',
    'store_status' => 'Status da Loja',
    'verified' => 'Verificado',
];
