<?php

return [
    'name' => 'Торговая площадка',
    'email' => [
        'store_new_order_title' => 'Уведомление о новом заказе',
        'store_new_order_description' => 'Отправлять электронное письмо владельцу магазина при оформлении заказа',
        'verify_vendor_title' => 'Проверить поставщика',
        'verify_vendor_description' => 'Отправка сообщения на электронную почту администратору при регистрации продавца',
        'pending_product_approval_title' => 'Ожидается одобрение продукта',
        'pending_product_approval_description' => 'Отправлять электронное письмо администратору, когда продавец размещает свои товары',
        'vendor_account_approved_title' => 'Счет поставщика одобрен',
        'vendor_account_approved_description' => 'Отправить электронное письмо поставщику, когда его счет будет одобрен',
        'product_approved_title' => 'Продукт одобрен',
        'product_approved_description' => 'Отправить электронное письмо поставщику, когда его продукт одобрен',
        'withdrawal_approved_title' => 'Одобрен отзыв',
        'withdrawal_approved_description' => 'Отправить электронное письмо продавцу, когда его запрос на снятие средств одобрен',
        'vendor_account_rejected_title' => 'Аккаунт поставщика отклонен',
        'vendor_account_rejected_description' => 'Отправить электронное письмо поставщику, когда его аккаунт отклонен',
        'vendor_account_unblocked_title' => 'Аккаунт поставщика разблокирован',
        'vendor_account_unblocked_description' => 'Отправить электронное письмо поставщику, когда его аккаунт разблокирован',
        'vendor_account_blocked_title' => 'Аккаунт поставщика заблокирован',
        'vendor_account_blocked_description' => 'Отправить электронное письмо поставщику, когда его аккаунт заблокирован',
        'store_new_order_subject' => 'Новый заказ(ы) на {{ site_title }}',
        'verify_vendor_subject' => 'Новый поставщик на {{ site_title }} нуждается в проверке',
        'vendor_account_approved_subject' => 'Ваш аккаунт одобрен для продажи на {{ site_title }}',
        'vendor_account_rejected_subject' => 'Ваш аккаунт отклонен для продажи на {{ site_title }}',
        'pending_product_approval_subject' => 'Новый товар требует одобрения для продажи на {{ site_title }}',
        'product_approved_subject' => 'Ваш товар одобрен для продажи на {{ site_title }}',
        'withdrawal_approved_subject' => 'Ваш запрос на снятие средств одобрен',
        'welcome_vendor_title' => 'Добро пожаловать, поставщик',
        'welcome_vendor_description' => 'Отправить электронное письмо поставщику после регистрации',
        'welcome_vendor_subject' => 'Добро пожаловать на {{ site_title }}!',
        'contact_store_title' => 'Связаться с магазином',
        'contact_store_description' => 'Отправить электронное письмо владельцу магазина, когда клиент связывается с магазином',
        'contact_store_subject' => 'Новое сообщение от клиента',
        'vendor_account_blocked_subject' => 'Ваш аккаунт поставщика на {{ site_title }} заблокирован',
        'vendor_account_unblocked_subject' => 'Ваш аккаунт поставщика на {{ site_title }} разблокирован',
        'order_cancellation_to_vendor_title' => 'Отмена заказа (будет отправлена продавцу (поставщику)',
        'order_cancellation_to_vendor_description' => 'Отправить продавцу (поставщику), когда клиент отменяет заказ',
        'order_cancellation_to_vendor_subject' => 'Заказ :order_id был отменен клиентом',
        'store_verified_title' => 'Верификация магазина одобрена',
        'store_verified_description' => 'Отправить уведомление, когда магазин верифицирован',
        'store_verified_subject' => 'Ваш магазин {{ store_name }} был верифицирован',
        'store_unverified_title' => 'Верификация магазина удалена',
        'store_unverified_description' => 'Отправить уведомление, когда верификация магазина удалена',
        'store_unverified_subject' => 'Статус верификации изменен для {{ store_name }}',
        'verified_by' => 'Верифицирован',
        'verified_at' => 'Верифицирован в',
        'unverified_by' => 'Не верифицирован',
        'unverified_at' => 'Не верифицирован в',
        'verification_note' => 'Примечание к верификации',
        'store' => 'Магазин',
        'order' => 'Заказ',
        'shipment' => 'Информация о доставке',
        'address' => 'Адрес доставки',
        'products' => 'Товары заказа',
        'customer_message' => 'Сообщение клиента',
        'customer_name' => 'Имя клиента',
        'customer_email' => 'Электронная почта клиента',
        'block_reason' => 'Причина блокировки',
        'block_date' => 'Дата блокировки',
        'unblock_date' => 'Дата разблокировки',
    ],
    'email_templates' => [
        'dear_vendor' => 'Уважаемый :vendor_name,',
        'dear_admin' => 'Уважаемый администратор,',
        'hello' => 'Здравствуйте,',
        'happy_selling' => 'Удачных продаж!',
        'thank_you_understanding' => 'Спасибо за понимание.',
        'email_sent_by_team' => 'Это письмо отправлено командой {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'Это письмо отправлено от :customer_name (:customer_email) через форму обратной связи в вашем профиле на :site_title.',
        'contact_store_reply_instruction' => 'Вы можете ответить прямо на это письмо, чтобы ответить :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Ваш аккаунт поставщика на {{ site_title }} был <strong>заблокирован</strong> :block_date.',
        'vendor_account_blocked_reason' => 'Причина блокировки: :block_reason',
        'vendor_account_blocked_contact_support' => 'Если вы считаете, что это ошибка, или у вас есть вопросы, обратитесь в службу поддержки.',
        'vendor_account_unblocked_message' => 'Мы рады сообщить, что ваш аккаунт поставщика на {{ site_title }} был <strong>разблокирован</strong> :unblock_date.',
        'vendor_account_unblocked_resume' => 'Теперь вы можете получить доступ к своему аккаунту и возобновить деятельность.',
        'vendor_account_unblocked_questions' => 'Если у вас есть вопросы, обращайтесь в службу поддержки.',
        'vendor_account_approved_title' => 'Аккаунт поставщика одобрен',
        'vendor_account_approved_message' => 'Ваш аккаунт одобрен для продажи на нашем сайте <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Аккаунт поставщика отклонен',
        'vendor_account_rejected_message' => 'К сожалению, ваш аккаунт не одобрен для продажи на нашем сайте <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Заказ успешно оформлен!',
        'store_new_order_message' => 'У вас новый заказ на :site_title!',
        'customer_information' => 'Информация о клиенте',
        'field_name' => 'Имя',
        'field_phone' => 'Телефон',
        'field_email' => 'Электронная почта',
        'field_address' => 'Адрес',
        'field_note' => 'Примечание',
        'order_number' => 'Номер заказа',
        'order_date' => 'Дата заказа',
        'shipping_method' => 'Способ доставки',
        'payment_method' => 'Способ оплаты',

        // Product Approval
        'product_approved_title' => 'Товар одобрен',
        'product_approved_message' => 'Ваш товар одобрен для продажи на нашем сайте <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Ожидается одобрение товара',
        'pending_product_approval_message' => 'Новый товар создан магазином :store_name <a href=":product_url">:product_name</a> ожидает одобрения.',

        // Verify Vendor
        'verify_vendor_title' => 'Проверить поставщика',
        'verify_vendor_message' => 'У вас есть новый поставщик, который нуждается в проверке на :site_title!',
        'vendor_information' => 'Информация о поставщике',
        'shop_information' => 'Информация о магазине',
        'field_store_name' => 'Название магазина',
        'field_store_phone' => 'Номер телефона магазина',
        'visit_store_button' => 'Посетить магазин',

        // Withdrawal
        'withdrawal_approved_title' => 'Снятие средств одобрено',
        'withdrawal_approved_message' => 'Ваш запрос на выплату одобрен, мы вскоре отправим <strong>:withdrawal_amount</strong> на ваши банковские реквизиты.',

        // Order Cancellation
        'order_cancellation_title' => 'Клиент отменил заказ :order_id',
        'order_cancellation_message' => 'Клиент :customer_name отменил заказ <strong>:order_id</strong> по причине :cancellation_reason.',
        'order_items_header' => 'Вот что вы заказали:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Добро пожаловать, поставщик',
        'welcome_vendor_greeting' => 'Мы рады приветствовать вас в :store_name!',
        'welcome_vendor_registration_complete' => 'Ваша регистрация поставщика успешно завершена, и теперь вы являетесь частью нашего яркого сообщества продавцов.',
        'welcome_vendor_next_steps' => 'Вот что вы можете сделать дальше:',
        'welcome_vendor_step_login' => 'Войдите в свой аккаунт поставщика, используя свои учетные данные.',
        'welcome_vendor_step_add_products' => 'Добавьте свои товары/услуги в магазин. Убедитесь, что предоставили подробные описания и привлекательные изображения для привлечения потенциальных покупателей.',
        'welcome_vendor_support' => 'Если у вас есть вопросы или нужна помощь, наша служба поддержки готова вам помочь. Обращайтесь!',
        'login_vendor_account_button' => 'Войти в аккаунт поставщика',
        'welcome_vendor_closing' => 'Мы с нетерпением ждем процветания вашего магазина на :site_title!',

        // Store Verification
        'store_verified_title' => 'Верификация магазина одобрена',
        'store_verified_message' => 'Поздравляем! Ваш магазин успешно верифицирован на <strong>:site_title</strong>. Этот знак верификации поможет завоевать доверие клиентов.',
        'dear_store_owner' => 'Уважаемый владелец :store_name,',
        'verification_details' => 'Детали верификации',
        'store_verified_benefits' => 'Преимущества верификации',
        'verified_badge_benefit' => 'Знак верификации, отображаемый в вашем магазине',
        'increased_trust_benefit' => 'Повышенное доверие и уверенность клиентов',
        'higher_visibility_benefit' => 'Более высокая видимость в результатах поиска',
        'visit_your_store' => 'Посетить ваш магазин',
        'congratulations_verified' => 'Поздравляем с верификацией!',

        // Store Unverification
        'store_unverified_title' => 'Статус верификации магазина изменен',
        'store_unverified_message' => 'К сожалению, статус верификации вашего магазина на <strong>:site_title</strong> был изменен.',
        'unverification_details' => 'Детали изменения статуса',
        'store_unverified_impacts' => 'Что это означает',
        'verified_badge_removed' => 'Знак верификации удален из вашего магазина',
        'verification_benefits_lost' => 'Преимущества верификации больше не активны',
        'store_unverified_next_steps' => 'Если у вас есть вопросы об этом решении или хотите обсудить повторную верификацию, <strong>обратитесь в службу поддержки</strong>.',
        'contact_support' => 'Связаться с поддержкой',
        'thank_you_understanding' => 'Спасибо за понимание.',
    ],
    'current_balance' => 'Текущий баланс',
    'settings' => [
        'name' => 'Настройки',
        'title' => 'Настройки для торговой площадки',
        'description' => 'Комиссия за установку',
        'fee_per_order' => 'Комиссия за заказ (%), предложите: 2 или 3',
        'fee_withdrawal_amount' => 'Комиссия за снятие',
        'withdrawal_fee_type' => 'Тип комиссии за снятие',
        'withdrawal_fee_types' => [
            'fixed' => 'Фиксированная сумма',
            'percentage' => 'Процент',
        ],
        'check_valid_signature' => 'Проверка действительной подписи в доходах продавца',
        'verify_vendor' => 'Верификация поставщика (поставщик может размещать объявления о своей продукции только после прохождения верификации)',
        'verify_vendor_helper' => 'Если включено, администратор должен верифицировать поставщика перед тем, как он сможет публиковать свои товары.',
        'requires_vendor_documentations_verification' => 'Требуется верификация документов поставщика',
        'requires_vendor_documentations_verification_helper' => 'Если включено, поставщики должны загружать файлы документов при подаче заявки на становление поставщиком.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Скрыть меню "Стать поставщиком" в панели клиента',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Если включено, меню "Стать поставщиком" будет скрыто в панели клиента.',
        'enable_product_approval' => 'Включить одобрение товаров',
        'enable_product_approval_description' => 'Если включено, администратор должен одобрить товар перед его публикацией.',
        'hide_store_phone_number' => 'Скрыть номер телефона магазина?',
        'hide_store_email' => 'Скрыть электронную почту магазина?',
        'hide_store_address' => 'Скрыть адрес магазина?',
        'hide_store_social_links' => 'Скрыть социальные ссылки магазина?',
        'enable_vendor_categories_filter' => 'Включить фильтр категорий поставщика',
        'enable_vendor_categories_filter_description' => 'Показать фильтр категорий на странице магазина поставщика. Будут отображаться только категории, в которых есть товары поставщика.',
        'add_new' => 'Добавить новое',
        'allow_vendor_manage_shipping' => 'Разрешить поставщику управлять доставкой?',
        'allow_vendor_manage_shipping_description' => 'Если включено, поставщик может изменять статус доставки заказа на "доставляется", "доставлен", ...',
        'charge_shipping_per_vendor' => 'Взимать плату за доставку с каждого поставщика?',
        'charge_shipping_per_vendor_description' => 'Если включено, доставка будет оплачиваться отдельно для каждого поставщика. Если отключено, доставка будет оплачиваться один раз за весь заказ.',
        'categories' => 'Категории',
        'commission_fee' => 'Комиссия (%)',
        'commission_fee_by_category' => 'Комиссия по категориям (%)',
        'commission_fee_each_category_fee_name' => 'Комиссионное вознаграждение установки комиссии :key',
        'commission_fee_each_category_name' => 'Категории настройки комиссии :key',
        'default_commission_fee' => 'Комиссия по умолчанию (%), рекомендуем: 2 или 3',
        'enable_commission_fee_for_each_category' => 'Включить комиссию для каждой категории?',
        'select_categories' => 'Выберите категории..',
        'payout_methods' => 'Методы выплат',
        'max_upload_filesize' => 'Максимальный размер загружаемого файла (МБ)',
        'max_upload_filesize_placeholder' => 'По умолчанию: 10',
        'max_product_images_upload_by_vendor' => 'Максимальное количество изображений для каждого товара',
        'enable_vendor_registration' => 'Включить регистрацию поставщиков',
        'enable_vendor_registration_helper' => 'Если включено, поставщики могут зарегистрировать аккаунт на сайте и публиковать свои товары.',
        'minimum_withdrawal_amount' => 'Минимальная сумма для снятия (фиксированная)',
        'minimum_withdrawal_amount_helper' => 'Укажите минимальную сумму, которую может снять поставщик. По умолчанию 0.',
        'allow_vendor_delete_their_orders' => 'Разрешить поставщикам удалять свои заказы',
        'allow_vendor_delete_their_orders_description' => 'Если включено, поставщики могут управлять списком заказов, удаляя нежелательные записи. Используйте с осторожностью, так как удаленные заказы могут повлиять на записи транзакций.',
        'enable_messaging_system' => 'Включить систему сообщений',
        'enable_messaging_system_description' => 'Если включено, поставщики и клиенты могут общаться друг с другом через систему сообщений.',
        'term_and_privacy_policy_url' => 'URL условий и политики конфиденциальности',
        'show_vendor_registration_form_at_registration_page' => 'Показать форму регистрации поставщика на странице регистрации',
        'show_vendor_registration_form_at_registration_page_description' => 'Если включено, форма регистрации поставщика будет отображаться на странице регистрации.',
        'single_vendor_checkout' => 'Ограничить одним поставщиком на заказ',
        'single_vendor_checkout_help' => 'Если включено, клиенты могут покупать товары только от одного поставщика за заказ.',
        'display_order_total_info_for_each_store' => 'Отображать информацию об общей сумме заказа для каждого магазина',
        'display_order_total_info_for_each_store_helper' => 'Если включено, информация об общей сумме заказа будет отображаться для каждого магазина в сводке заказа.',
        'show_vendor_info_at_checkout' => 'Показать информацию о поставщике при оформлении заказа',
        'show_vendor_info_at_checkout_helper' => 'Если включено, информация о поставщике (имя, логотип, отзывы) будет отображаться на странице оформления заказа.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Типы медиафайлов, которые могут быть загружены поставщиком',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Укажите типы медиафайлов, которые могут загружать поставщики. Выберите их в списке выше.',
    ],
    'theme_options' => [
        'name' => 'Торговая площадка',
        'description' => 'Параметры темы для торговой площадки',
        'logo_vendor_dashboard' => 'Логотип на приборной панели поставщика (по умолчанию - основной логотип)',
    ],
    'store_name' => 'Название магазина',
    'store_email' => 'Электронная почта магазина',
    'store_phone' => 'Телефон магазина',
    'store_address' => 'Адрес магазина',
    'store_url' => 'URL магазина',
    'product_name' => 'Наименование товара',
    'product_url' => 'URL продукта',
    'withdrawal_amount' => 'Сумма вывода',
    'helpers' => [
        'customer_status' => 'Если вы измените статус, отличный от ":status" магазин этого продавца также изменится на ":store"',
        'store_status' => 'Если вы измените статус, отличный от ":status" счет этого магазина также изменится на ":customer"',
    ],
    'tables' => [
        'earnings' => 'Заработок',
        'products_count' => 'Количество продуктов',
    ],
    'vendors' => 'Поставщики',
    'payout_payment_methods' => [
        'bank_transfer' => 'Банковский перевод',
        'paypal' => 'PayPal',
        'cash' => 'Наличные',
    ],
    'reports' => [
        'name' => 'Отчеты',
        'total_fee_earnings' => 'Общий доход от комиссий: :value',
        'total_fee' => 'Общая комиссия',
        'total_amount' => 'Общая сумма',
        'store_revenues' => 'Доходы магазинов',
        'sale_commissions' => 'Комиссии с продаж',
        'fee' => 'Комиссия (:symbol)',
        'amount' => 'Сумма (:symbol)',
        'top_performing_stores' => 'Лучшие магазины',
        'store_growth' => 'Рост магазинов',
        'withdrawal_status_chart' => 'Статус снятия средств',
        'product_distribution' => 'Распределение товаров по магазинам',
        'average_commission' => 'Средняя ставка комиссии',
        'recent_withdrawals' => 'Недавние снятия',
        'number_of_stores' => 'Количество магазинов',
        'number_of_products' => 'Количество товаров',
        'orders' => 'Заказы',
        'revenue' => 'Доход',
        'increase' => ':count увеличение',
        'decrease' => ':count уменьшение',
    ],
    'vendor' => 'Поставщик',
    'vendor_name' => 'Имя поставщика',
    'contact_store' => [
        'form_name' => 'Форма связи с магазином',
    ],
    'store_statuses' => [
        'pending' => 'Ожидает',
        'published' => 'Одобрен',
        'blocked' => 'Заблокирован',
    ],
    'view_vendor' => 'Просмотр поставщика :name',
    'vendor_information' => 'Информация о поставщике',
    'vendor_verified' => 'Поставщик верифицирован',
    'vendor_not_verified' => 'Поставщик не верифицирован',
    'vendor_verified_at' => 'Поставщик верифицирован в',
    'view_certificate' => 'Просмотр сертификата',
    'view_government_id' => 'Просмотр удостоверения личности',
    'documents' => 'Документы',
    'store_products' => 'Товары магазина',
    'store_orders' => 'Заказы магазина',
    'total_revenue' => 'Общий доход',
    'total_earnings' => 'Общие заработки',
    'withdrawals' => 'Снятия',
    'pending_withdrawals' => 'Ожидающие снятия',
    'balance' => 'Баланс',
    'recent_products' => 'Недавние товары',
    'products_count' => 'Товары',
    'store_status' => 'Статус магазина',
    'verified' => 'Верифицирован',
];
