<?php

return [
    'name' => 'Tržisko',
    'email' => [
        'title' => 'Tržisko',
        'description' => 'Konfigurácia e-mailových šablón pre Tržisko',
        'store_new_order_title' => 'Oznámenie o novej objednávke',
        'store_new_order_description' => 'Odoslať e-mail majiteľovi obchodu pri vytvorení objednávky',
        'verify_vendor_title' => 'Overenie predajcu',
        'verify_vendor_description' => 'Odoslať e-mail administrátorovi pri registrácii predajcu',
        'pending_product_approval_title' => 'Čakajúce schválenie produktu',
        'pending_product_approval_description' => 'Odoslať e-mail administrátorovi pri pridaní produktov predajcom',
        'vendor_account_approved_title' => 'Účet predajcu schválený',
        'vendor_account_approved_description' => 'Odoslať e-mail predajcovi pri schválení účtu',
        'product_approved_title' => 'Produkt schválený',
        'product_approved_description' => 'Odoslať e-mail predajcovi pri schválení produktu',
        'withdrawal_approved_title' => 'Výber schválený',
        'withdrawal_approved_description' => 'Odoslať e-mail predajcovi pri schválení žiadosti o výber',
        'vendor_account_rejected_title' => 'Účet predajcu zamietnutý',
        'vendor_account_rejected_description' => 'Odoslať e-mail predajcovi pri zamietnutí účtu',
        'vendor_account_unblocked_title' => 'Účet predajcu odblokovaný',
        'vendor_account_unblocked_description' => 'Odoslať e-mail predajcovi pri odblokovaní účtu',
        'vendor_account_blocked_title' => 'Účet predajcu zablokovaný',
        'vendor_account_blocked_description' => 'Odoslať e-mail predajcovi pri zablokovaní účtu',
        'store_new_order_subject' => 'Nová objednávka na {{ site_title }}',
        'verify_vendor_subject' => 'Nový predajca na {{ site_title }} čaká na overenie',
        'vendor_account_approved_subject' => 'Váš účet bol schválený na predaj na {{ site_title }}',
        'vendor_account_rejected_subject' => 'Váš účet bol zamietnutý na predaj na {{ site_title }}',
        'pending_product_approval_subject' => 'Nový produkt čaká na schválenie na predaj na {{ site_title }}',
        'product_approved_subject' => 'Váš produkt bol schválený na predaj na {{ site_title }}',
        'withdrawal_approved_subject' => 'Vaša žiadosť o výber bola schválená',
        'welcome_vendor_title' => 'Vitajte predajca',
        'welcome_vendor_description' => 'Odoslať e-mail predajcovi po registrácii',
        'welcome_vendor_subject' => 'Vitajte na {{ site_title }}!',
        'contact_store_title' => 'Kontaktovať obchod',
        'contact_store_description' => 'Odoslať e-mail majiteľovi obchodu pri kontaktovaní zákazníkom',
        'contact_store_subject' => 'Nová správa od zákazníka',
        'vendor_account_blocked_subject' => 'Váš účet predajcu na {{ site_title }} bol zablokovaný',
        'vendor_account_unblocked_subject' => 'Váš účet predajcu na {{ site_title }} bol odblokovaný',
        'order_cancellation_to_vendor_title' => 'Zrušenie objednávky (bude odoslané predajcovi)',
        'order_cancellation_to_vendor_description' => 'Odoslať predajcovi pri zrušení objednávky zákazníkom',
        'order_cancellation_to_vendor_subject' => 'Objednávka :order_id bola zrušená zákazníkom',
        'store_verified_title' => 'Overenie obchodu schválené',
        'store_verified_description' => 'Odoslať oznámenie pri overení obchodu',
        'store_verified_subject' => 'Váš obchod {{ store_name }} bol overený',
        'store_unverified_title' => 'Overenie obchodu odstránené',
        'store_unverified_description' => 'Odoslať oznámenie pri odstránení overenia obchodu',
        'store_unverified_subject' => 'Stav overenia zmenený pre {{ store_name }}',
        'verified_by' => 'Overené',
        'verified_at' => 'Overené dňa',
        'unverified_by' => 'Zrušené overenie',
        'unverified_at' => 'Zrušené overenie dňa',
        'verification_note' => 'Poznámka k overeniu',
        'store' => 'Obchod',
        'order' => 'Objednávka',
        'shipment' => 'Informácie o zásielke',
        'address' => 'Doručovacia adresa',
        'products' => 'Produkty v objednávke',
        'customer_message' => 'Správa od zákazníka',
        'customer_name' => 'Meno zákazníka',
        'customer_email' => 'E-mail zákazníka',
        'block_reason' => 'Dôvod zablokovania',
        'block_date' => 'Dátum zablokovania',
        'unblock_date' => 'Dátum odblokovania',
    ],
    'email_templates' => [
        'dear_vendor' => 'Vážený :vendor_name,',
        'dear_admin' => 'Vážený administrátor,',
        'hello' => 'Dobrý deň,',
        'happy_selling' => 'Úspešný predaj!',
        'thank_you_understanding' => 'Ďakujeme za pochopenie.',
        'email_sent_by_team' => 'Tento e-mail bol odoslaný tímom {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'Tento e-mail bol odoslaný od :customer_name (:customer_email) prostredníctvom kontaktného formulára vášho profilu na :site_title.',
        'contact_store_reply_instruction' => 'Môžete odpovedať priamo na tento e-mail pre odpoveď :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Váš účet predajcu na {{ site_title }} bol <strong>zablokovaný</strong> dňa :block_date.',
        'vendor_account_blocked_reason' => 'Dôvod zablokovania: :block_reason',
        'vendor_account_blocked_contact_support' => 'Ak si myslíte, že došlo k chybe alebo máte otázky, kontaktujte náš tím podpory.',
        'vendor_account_unblocked_message' => 'S potešením vás informujeme, že váš účet predajcu na {{ site_title }} bol <strong>odblokovaný</strong> dňa :unblock_date.',
        'vendor_account_unblocked_resume' => 'Teraz môžete pristupovať k svojmu účtu a pokračovať vo svojich aktivitách.',
        'vendor_account_unblocked_questions' => 'Ak máte akékoľvek otázky, neváhajte kontaktovať náš tím podpory.',
        'vendor_account_approved_title' => 'Účet predajcu schválený',
        'vendor_account_approved_message' => 'Váš účet bol schválený na predaj na našej stránke <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Účet predajcu zamietnutý',
        'vendor_account_rejected_message' => 'S ľútosťou vás informujeme, že váš účet nebol schválený na predaj na našej stránke <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Objednávka úspešná!',
        'store_new_order_message' => 'Máte novú objednávku na :site_title!',
        'customer_information' => 'Informácie o zákazníkovi',
        'field_name' => 'Meno',
        'field_phone' => 'Telefón',
        'field_email' => 'E-mail',
        'field_address' => 'Adresa',
        'field_note' => 'Poznámka',
        'order_number' => 'Číslo objednávky',
        'order_date' => 'Dátum objednávky',
        'shipping_method' => 'Spôsob dopravy',
        'payment_method' => 'Spôsob platby',

        // Product Approval
        'product_approved_title' => 'Produkt schválený',
        'product_approved_message' => 'Váš produkt bol schválený na predaj na našej stránke <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Čakajúce schválenie produktu',
        'pending_product_approval_message' => 'Nový produkt vytvorený od :store_name <a href=":product_url">:product_name</a> čaká na schválenie.',

        // Verify Vendor
        'verify_vendor_title' => 'Overenie predajcu',
        'verify_vendor_message' => 'Máte nového predajcu, ktorý čaká na overenie na :site_title!',
        'vendor_information' => 'Informácie o predajcovi',
        'shop_information' => 'Informácie o obchode',
        'field_store_name' => 'Názov obchodu',
        'field_store_phone' => 'Telefónne číslo obchodu',
        'visit_store_button' => 'Navštíviť obchod',

        // Withdrawal
        'withdrawal_approved_title' => 'Výber schválený',
        'withdrawal_approved_message' => 'Vaša žiadosť o výplatu bola schválená, pošleme <strong>:withdrawal_amount</strong> na vaše bankové údaje čoskoro.',

        // Order Cancellation
        'order_cancellation_title' => 'Zákazník zrušil objednávku :order_id',
        'order_cancellation_message' => 'Zákazník :customer_name zrušil objednávku <strong>:order_id</strong> z dôvodu :cancellation_reason.',
        'order_items_header' => 'Tu je to, co ste objednali:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Vitajte predajca',
        'welcome_vendor_greeting' => 'S radosťou vás vítame na :store_name!',
        'welcome_vendor_registration_complete' => 'Vaša registrácia predajcu bola úspešne dokončená a teraz ste súčasťou našej živej komunity predajcov.',
        'welcome_vendor_next_steps' => 'Tu je to, čo môžete urobiť ďalej:',
        'welcome_vendor_step_login' => 'Prihláste sa do svojho účtu predajcu pomocou vašich prístupových údajov.',
        'welcome_vendor_step_add_products' => 'Pridajte svoje produkty/služby do svojho obchodu. Uistite sa, že poskytnete podrobné popisy a pútavé obrázky na prilákanie potenciálnych kupujúcich.',
        'welcome_vendor_support' => 'Ak máte akékoľvek otázky alebo potrebujete pomoc, náš tím podpory je tu pre vás. Neváhajte nás kontaktovať!',
        'login_vendor_account_button' => 'Prihláste sa do svojho účtu predajcu',
        'welcome_vendor_closing' => 'Tešíme sa na váš prosperujúci obchod na :site_title!',

        // Store Verification
        'store_verified_title' => 'Overenie obchodu schválené',
        'store_verified_message' => 'Blahoželáme! Váš obchod bol úspešne overený na <strong>:site_title</strong>. Táto značka overenia pomôže budovať dôveru vašich zákazníkov.',
        'dear_store_owner' => 'Vážený majiteľ obchodu :store_name,',
        'verification_details' => 'Detaily overenia',
        'store_verified_benefits' => 'Výhody overenia',
        'verified_badge_benefit' => 'Značka overenia zobrazená vo vašom obchode',
        'increased_trust_benefit' => 'Zvýšená dôvera a istota zákazníkov',
        'higher_visibility_benefit' => 'Vyššia viditeľnosť vo výsledkoch vyhľadávania',
        'visit_your_store' => 'Navštíviť váš obchod',
        'congratulations_verified' => 'Blahoželáme k vášmu overeniu!',

        // Store Unverification
        'store_unverified_title' => 'Stav overenia obchodu zmenený',
        'store_unverified_message' => 'S ľútosťou vás informujeme, že stav overenia vášho obchodu na <strong>:site_title</strong> bol zmenený.',
        'unverification_details' => 'Detaily zmeny stavu',
        'store_unverified_impacts' => 'Čo to znamená',
        'verified_badge_removed' => 'Značka overenia bola odstránená z vášho obchodu',
        'verification_benefits_lost' => 'Výhody overenia už nie sú aktívne',
        'store_unverified_next_steps' => 'Ak máte akékoľvek otázky k tomuto rozhodnutiu alebo by ste chceli diskutovať o opätovnom overení, prosím <strong>kontaktujte náš tím podpory</strong>.',
        'contact_support' => 'Kontaktovať podporu',
        'thank_you_understanding' => 'Ďakujeme za pochopenie.',
    ],
    'current_balance' => 'Aktuálny zostatok',
    'settings' => [
        'title' => 'Nastavenia',
        'description' => 'Nastavenia pre tržisko',
        'fee_per_order' => 'Poplatok za objednávku (%), odporúča sa: 2 alebo 3',
        'default_commission_fee' => 'Predvolený poplatok provízie (%), odporúča sa: 2 alebo 3',
        'enable_commission_fee_for_each_category' => 'Povoliť poplatok provízie pre každú kategóriu?',
        'categories' => 'Kategórie',
        'select_categories' => 'Vyberte kategórie..',
        'commission_fee' => 'Poplatok provízie (%)',
        'commission_fee_by_category' => 'Poplatok provízie podľa kategórie (%)',
        'fee_withdrawal_amount' => 'Poplatok za výber',
        'withdrawal_fee_type' => 'Typ poplatku za výber',
        'withdrawal_fee_types' => [
            'fixed' => 'Pevná suma',
            'percentage' => 'Percento',
        ],
        'check_valid_signature' => 'Kontrolovať platný podpis v zárobkoch predajcu',
        'verify_vendor' => 'Overenie predajcu (Predajca môže zverejniť produkty až po overení)',
        'verify_vendor_helper' => 'Ak je povolené, administrátor musí overiť predajcu predtým, ako môže zverejniť produkty.',
        'requires_vendor_documentations_verification' => 'Vyžaduje overenie dokumentácie predajcu',
        'requires_vendor_documentations_verification_helper' => 'Ak je povolené, predajcovia musia nahrať dokumenty pri žiadosti o status predajcu.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Skryť menu "Stať sa predajcom" v zákazníckom paneli',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Ak je povolené, menu "Stať sa predajcom" bude skryté v zákazníckom paneli.',
        'enable_product_approval' => 'Povoliť schvaľovanie produktov',
        'enable_product_approval_description' => 'Ak je povolené, administrátor musí schváliť produkt pred jeho zverejnením.',
        'hide_store_phone_number' => 'Skryť telefónne číslo obchodu?',
        'hide_store_email' => 'Skryť e-mail obchodu?',
        'hide_store_address' => 'Skryť adresu obchodu?',
        'hide_store_social_links' => 'Skryť sociálne odkazy obchodu?',
        'enable_vendor_categories_filter' => 'Povoliť filter kategórií predajcu',
        'enable_vendor_categories_filter_description' => 'Zobraziť filter kategórií na stránke obchodu predajcu. Zobrazia sa iba kategórie, ktoré majú produkty predajcu.',
        'allow_vendor_manage_shipping' => 'Povoliť predajcovi spravovať dopravu?',
        'allow_vendor_manage_shipping_description' => 'Ak je povolené, predajca môže meniť stav dopravy objednávky na "doručuje sa", "doručené", ...',
        'charge_shipping_per_vendor' => 'Účtovať dopravu za každého predajcu?',
        'charge_shipping_per_vendor_description' => 'Ak je povolené, doprava bude účtovaná samostatne pre každého predajcu. Ak je zakázané, doprava bude účtovaná raz pre celú objednávku.',
        'commission_fee_each_category_fee_name' => 'Poplatok provízie nastavenia provízie :key',
        'commission_fee_each_category_name' => 'Kategórie nastavenia provízie :key',
        'add_new' => 'Pridať nové',
        'payout_methods' => 'Metódy výplaty',
        'max_upload_filesize' => 'Maximálna veľkosť nahrávaného súboru (MB)',
        'max_upload_filesize_placeholder' => 'Predvolené: 10',
        'max_product_images_upload_by_vendor' => 'Maximálny počet obrázkov pre každý produkt',
        'enable_vendor_registration' => 'Povoliť registráciu predajcov',
        'enable_vendor_registration_helper' => 'Ak je povolené, predajcovia sa môžu zaregistrovať na stránke a zverejňovať svoje produkty.',
        'minimum_withdrawal_amount' => 'Minimálna suma výberu (pevná)',
        'minimum_withdrawal_amount_helper' => 'Určite minimálnu sumu, ktorú môže predajca vybrať. Predvolené je 0.',
        'allow_vendor_delete_their_orders' => 'Povoliť predajcom odstraňovať svoje objednávky',
        'allow_vendor_delete_their_orders_description' => 'Ak je povolené, predajcovia môžu spravovať svoj zoznam objednávok odstránením nechcených položiek. Používajte opatrne, pretože odstránené objednávky môžu ovplyvniť záznamy transakcií.',
        'enable_messaging_system' => 'Povoliť systém správ',
        'enable_messaging_system_description' => 'Ak je povolené, predajcovia a zákazníci môžu komunikovať cez systém správ.',
        'term_and_privacy_policy_url' => 'URL podmienok a zásad ochrany osobných údajov',
        'show_vendor_registration_form_at_registration_page' => 'Zobraziť formulár registrácie predajcu na registračnej stránke',
        'show_vendor_registration_form_at_registration_page_description' => 'Ak je povolené, formulár registrácie predajcu bude zobrazený na registračnej stránke.',
        'single_vendor_checkout' => 'Obmedzenie na jedného predajcu na objednávku',
        'single_vendor_checkout_help' => 'Ak je povolené, zákazníci môžu nakúpiť produkty len od jedného predajcu na objednávku.',
        'display_order_total_info_for_each_store' => 'Zobraziť celkové informácie o objednávke pre každý obchod',
        'display_order_total_info_for_each_store_helper' => 'Ak je povolené, celkové informácie o objednávke sa zobrazia pre každý obchod v súhrne objednávky.',
        'show_vendor_info_at_checkout' => 'Zobraziť informácie o predajcovi pri pokladni',
        'show_vendor_info_at_checkout_helper' => 'Ak je povolené, informácie o predajcovi (názov, logo, recenzie) sa zobrazia na stránke pokladne.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Typy mediálnych súborov, ktoré môžu byť nahrané predajcom',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Určite typy mediálnych súborov, ktoré môžu predajcovia nahrávať. Vyberte ich v zozname vyššie.',
    ],
    'theme_options' => [
        'name' => 'Tržisko',
        'description' => 'Možnosti témy pre Tržisko',
        'logo_vendor_dashboard' => 'Logo v paneli predajcu (Predvolené je hlavné logo)',
    ],
    'store_name' => 'Názov obchodu',
    'store_email' => 'E-mail obchodu',
    'store_phone' => 'Telefón obchodu',
    'store_address' => 'Adresa obchodu',
    'store_url' => 'URL obchodu',
    'product_name' => 'Názov produktu',
    'product_url' => 'URL produktu',
    'withdrawal_amount' => 'Suma výberu',
    'helpers' => [
        'store_status' => 'Ak zmeníte stav na iný ako ":status", účet tohto obchodu sa zmení na ":customer"',
    ],
    'tables' => [
        'earnings' => 'Zárobky',
        'products_count' => 'Počet produktov',
    ],
    'vendors' => 'Predajcovia',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankový prevod',
        'paypal' => 'PayPal',
        'cash' => 'Hotovosť',
    ],
    'reports' => [
        'name' => 'Správy',
        'total_fee_earnings' => 'Celkový zárobok z poplatkov: :value',
        'total_fee' => 'Celkový poplatok',
        'total_amount' => 'Celková suma',
        'store_revenues' => 'Príjmy obchodov',
        'sale_commissions' => 'Predajné provízie',
        'fee' => 'Poplatok (:symbol)',
        'amount' => 'Suma (:symbol)',
        'top_performing_stores' => 'Najúspešnejšie obchody',
        'store_growth' => 'Rast obchodov',
        'withdrawal_status_chart' => 'Stav výberov',
        'product_distribution' => 'Distribúcia produktov podľa obchodu',
        'average_commission' => 'Priemerná sadzba provízie',
        'recent_withdrawals' => 'Nedávne výbery',
        'number_of_stores' => 'Počet obchodov',
        'number_of_products' => 'Počet produktov',
        'orders' => 'Objednávky',
        'revenue' => 'Príjem',
        'increase' => ':count nárast',
        'decrease' => ':count pokles',
    ],
    'vendor' => 'Predajca',
    'vendor_name' => 'Meno predajcu',
    'contact_store' => [
        'form_name' => 'Formulár kontaktovania obchodu',
    ],
    'store_statuses' => [
        'pending' => 'Čakajúce',
        'published' => 'Schválené',
        'blocked' => 'Zablokované',
    ],
    'view_vendor' => 'Zobraziť predajcu :name',
    'vendor_information' => 'Informácie o predajcovi',
    'vendor_verified' => 'Predajca overený',
    'vendor_not_verified' => 'Predajca neoverený',
    'vendor_verified_at' => 'Predajca overený dňa',
    'view_certificate' => 'Zobraziť certifikát',
    'view_government_id' => 'Zobraziť občiansky preukaz',
    'documents' => 'Dokumenty',
    'store_products' => 'Produkty obchodu',
    'store_orders' => 'Objednávky obchodu',
    'total_revenue' => 'Celkový príjem',
    'total_earnings' => 'Celkové zárobky',
    'withdrawals' => 'Výbery',
    'pending_withdrawals' => 'Čakajúce výbery',
    'balance' => 'Zostatok',
    'recent_products' => 'Nedávne produkty',
    'products_count' => 'Produkty',
    'store_status' => 'Stav obchodu',
    'verified' => 'Overené',
];
