<?php

return [
    'name' => 'Tržnica',
    'email' => [
        'title' => 'Tržnica',
        'description' => 'Konfiguracija predlog e-poštnih sporočil za Tržnico',
        'store_new_order_title' => 'Obvestilo o novem naročilu',
        'store_new_order_description' => 'Pošlji e-poštno sporočilo lastniku trgovine ob oddaji naročila',
        'verify_vendor_title' => 'Preveri prodajalca',
        'verify_vendor_description' => 'Pošlji e-poštno sporočilo administratorju, ko se prodajalec registrira',
        'pending_product_approval_title' => 'Čakajoča odobritev izdelka',
        'pending_product_approval_description' => 'Pošlji e-poštno sporočilo administratorju, ko prodajalec objavi svoje izdelke',
        'vendor_account_approved_title' => 'Račun prodajalca odobren',
        'vendor_account_approved_description' => 'Pošlji e-poštno sporočilo prodajalcu, ko je njegov račun odobren',
        'product_approved_title' => 'Izdelek odobren',
        'product_approved_description' => 'Pošlji e-poštno sporočilo prodajalcu, ko je njihov izdelek odobren',
        'withdrawal_approved_title' => 'Dvig odobren',
        'withdrawal_approved_description' => 'Pošlji e-poštno sporočilo prodajalcu, ko je njihova zahteva za dvig odobrena',
        'vendor_account_rejected_title' => 'Račun prodajalca zavrnjen',
        'vendor_account_rejected_description' => 'Pošlji e-poštno sporočilo prodajalcu, ko je njegov račun zavrnjen',
        'vendor_account_unblocked_title' => 'Račun prodajalca odblokiran',
        'vendor_account_unblocked_description' => 'Pošlji e-poštno sporočilo prodajalcu, ko je njihov račun odblokiran',
        'vendor_account_blocked_title' => 'Račun prodajalca blokiran',
        'vendor_account_blocked_description' => 'Pošlji e-poštno sporočilo prodajalcu, ko je njihov račun blokiran',
        'store_new_order_subject' => 'Novo naročilo na {{ site_title }}',
        'verify_vendor_subject' => 'Nov prodajalec na {{ site_title }} mora biti preverjen',
        'vendor_account_approved_subject' => 'Vaš račun je bil odobren za prodajo na {{ site_title }}',
        'vendor_account_rejected_subject' => 'Vaš račun je bil zavrnjen za prodajo na {{ site_title }}',
        'pending_product_approval_subject' => 'Nov izdelek mora biti odobren za prodajo na {{ site_title }}',
        'product_approved_subject' => 'Vaš izdelek je bil odobren za prodajo na {{ site_title }}',
        'withdrawal_approved_subject' => 'Vaša zahteva za dvig je bila odobrena',
        'welcome_vendor_title' => 'Dobrodošli prodajalec',
        'welcome_vendor_description' => 'Pošlji e-poštno sporočilo prodajalcu po registraciji',
        'welcome_vendor_subject' => 'Dobrodošli na {{ site_title }}!',
        'contact_store_title' => 'Kontaktiraj trgovino',
        'contact_store_description' => 'Pošlji e-poštno sporočilo lastniku trgovine, ko stranka kontaktira trgovino',
        'contact_store_subject' => 'Novo sporočilo stranke',
        'vendor_account_blocked_subject' => 'Vaš račun prodajalca na {{ site_title }} je bil blokiran',
        'vendor_account_unblocked_subject' => 'Vaš račun prodajalca na {{ site_title }} je bil odblokiran',
        'order_cancellation_to_vendor_title' => 'Preklic naročila (bo poslano prodajalcu)',
        'order_cancellation_to_vendor_description' => 'Pošlji prodajalcu, ko stranka prekliče naročilo',
        'order_cancellation_to_vendor_subject' => 'Naročilo :order_id je bilo preklicano s strani stranke',
        'store_verified_title' => 'Verifikacija trgovine odobrena',
        'store_verified_description' => 'Pošlji obvestilo, ko je trgovina verificirana',
        'store_verified_subject' => 'Vaša trgovina {{ store_name }} je bila verificirana',
        'store_unverified_title' => 'Verifikacija trgovine odstranjena',
        'store_unverified_description' => 'Pošlji obvestilo, ko je verifikacija trgovine odstranjena',
        'store_unverified_subject' => 'Status verifikacije spremenjen za {{ store_name }}',
        'verified_by' => 'Verificiral',
        'verified_at' => 'Verificirano',
        'unverified_by' => 'Odstranil verifikacijo',
        'unverified_at' => 'Verifikacija odstranjena',
        'verification_note' => 'Opomba o verifikaciji',
        'store' => 'Trgovina',
        'order' => 'Naročilo',
        'shipment' => 'Informacije o pošiljki',
        'address' => 'Naslov dostave',
        'products' => 'Izdelki naročila',
        'customer_message' => 'Sporočilo stranke',
        'customer_name' => 'Ime stranke',
        'customer_email' => 'E-pošta stranke',
        'block_reason' => 'Razlog za blokiranje',
        'block_date' => 'Datum blokiranja',
        'unblock_date' => 'Datum odblokiranja',
    ],
    'email_templates' => [
        'dear_vendor' => 'Spoštovani :vendor_name,',
        'dear_admin' => 'Spoštovani Administrator,',
        'hello' => 'Pozdravljeni,',
        'happy_selling' => 'Uspešno prodajo!',
        'thank_you_understanding' => 'Hvala za razumevanje.',
        'email_sent_by_team' => 'To e-poštno sporočilo je poslala ekipa {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'To e-poštno sporočilo je poslal :customer_name (:customer_email) preko vašega kontaktnega obrazca na :site_title.',
        'contact_store_reply_instruction' => 'Lahko odgovorite neposredno na to e-poštno sporočilo za odgovor na :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Vaš račun prodajalca na {{ site_title }} je bil <strong>blokiran</strong> dne :block_date.',
        'vendor_account_blocked_reason' => 'Razlog za blokiranje: :block_reason',
        'vendor_account_blocked_contact_support' => 'Če menite, da je to napaka ali imate kakršna koli vprašanja, kontaktirajte našo podporo.',
        'vendor_account_unblocked_message' => 'Z veseljem vas obveščamo, da je bil vaš račun prodajalca na {{ site_title }} <strong>odblokiran</strong> dne :unblock_date.',
        'vendor_account_unblocked_resume' => 'Zdaj lahko dostopate do svojega računa in nadaljujete s svojimi aktivnostmi.',
        'vendor_account_unblocked_questions' => 'Če imate kakršna koli vprašanja, se obrnite na našo podporo.',
        'vendor_account_approved_title' => 'Račun prodajalca odobren',
        'vendor_account_approved_message' => 'Vaš račun je bil odobren za prodajo na naši spletni strani <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Račun prodajalca zavrnjen',
        'vendor_account_rejected_message' => 'Žal vas obveščamo, da vaš račun ni bil odobren za prodajo na naši spletni strani <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Naročilo uspešno!',
        'store_new_order_message' => 'Dobili ste novo naročilo na :site_title!',
        'customer_information' => 'Informacije o stranki',
        'field_name' => 'Ime',
        'field_phone' => 'Telefon',
        'field_email' => 'E-pošta',
        'field_address' => 'Naslov',
        'field_note' => 'Opomba',
        'order_number' => 'Številka naročila',
        'order_date' => 'Datum naročila',
        'shipping_method' => 'Način dostave',
        'payment_method' => 'Način plačila',

        // Product Approval
        'product_approved_title' => 'Izdelek odobren',
        'product_approved_message' => 'Vaš izdelek je bil odobren za prodajo na naši spletni strani <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Čakajoča odobritev izdelka',
        'pending_product_approval_message' => 'Nov izdelek je ustvaril :store_name <a href=":product_url">:product_name</a> in čaka na odobritev.',

        // Verify Vendor
        'verify_vendor_title' => 'Preveri prodajalca',
        'verify_vendor_message' => 'Imate novega prodajalca, ki ga je treba preveriti na :site_title!',
        'vendor_information' => 'Informacije o prodajalcu',
        'shop_information' => 'Informacije o trgovini',
        'field_store_name' => 'Ime trgovine',
        'field_store_phone' => 'Telefonska številka trgovine',
        'visit_store_button' => 'Obišči trgovino',

        // Withdrawal
        'withdrawal_approved_title' => 'Dvig odobren',
        'withdrawal_approved_message' => 'Vaša zahteva za izplačilo je bila odobrena, kmalu bomo poslali <strong>:withdrawal_amount</strong> na vaše bančne podatke.',

        // Order Cancellation
        'order_cancellation_title' => 'Stranka je preklicala naročilo :order_id',
        'order_cancellation_message' => 'Stranka :customer_name je preklicala naročilo <strong>:order_id</strong> zaradi razloga :cancellation_reason.',
        'order_items_header' => 'Tukaj je, kar ste naročili:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Dobrodošli prodajalec',
        'welcome_vendor_greeting' => 'Z veseljem vas pozdravljamo v :store_name!',
        'welcome_vendor_registration_complete' => 'Vaša registracija prodajalca je bila uspešno zaključena in zdaj ste del naše živahne skupnosti prodajalcev.',
        'welcome_vendor_next_steps' => 'Tukaj je, kar lahko storite naslednje:',
        'welcome_vendor_step_login' => 'Prijavite se v svoj račun prodajalca z vašimi poverilnicami.',
        'welcome_vendor_step_add_products' => 'Dodajte svoje izdelke/storitve v svojo trgovino. Poskrbite za podrobne opise in privlačne slike, da pritegnete potencialne kupce.',
        'welcome_vendor_support' => 'Če imate kakršna koli vprašanja ali potrebujete pomoč, je naša ekipa podpore tukaj, da vam pomaga. Ne oklevajte in nas kontaktirajte!',
        'login_vendor_account_button' => 'Prijavite se v račun prodajalca',
        'welcome_vendor_closing' => 'Veselimo se uspešnega razvoja vaše trgovine na :site_title!',

        // Store Verification
        'store_verified_title' => 'Verifikacija trgovine odobrena',
        'store_verified_message' => 'Čestitamo! Vaša trgovina je bila uspešno verificirana na <strong>:site_title</strong>. Ta verifikacijski znak bo pomagal zgraditi zaupanje s vašimi strankami.',
        'dear_store_owner' => 'Spoštovani lastnik :store_name,',
        'verification_details' => 'Podrobnosti verifikacije',
        'store_verified_benefits' => 'Prednosti verificirane trgovine',
        'verified_badge_benefit' => 'Verifikacijski znak prikazan na vaši trgovini',
        'increased_trust_benefit' => 'Povečano zaupanje in samozavest strank',
        'higher_visibility_benefit' => 'Višja vidnost v rezultatih iskanja',
        'visit_your_store' => 'Obiščite svojo trgovino',
        'congratulations_verified' => 'Čestitamo za verifikacijo!',

        // Store Unverification
        'store_unverified_title' => 'Status verifikacije trgovine spremenjen',
        'store_unverified_message' => 'Žal vas obveščamo, da je bil verifikacijski status vaše trgovine na <strong>:site_title</strong> spremenjen.',
        'unverification_details' => 'Podrobnosti spremembe statusa',
        'store_unverified_impacts' => 'Kaj to pomeni',
        'verified_badge_removed' => 'Verifikacijski znak je bil odstranjen iz vaše trgovine',
        'verification_benefits_lost' => 'Prednosti verifikacije niso več aktivne',
        'store_unverified_next_steps' => 'Če imate kakršna koli vprašanja o tej odločitvi ali bi radi razpravljali o ponovni verifikaciji, prosimo <strong>kontaktirajte našo ekipo podpore</strong>.',
        'contact_support' => 'Kontaktirajte podporo',
        'thank_you_understanding' => 'Hvala za razumevanje.',
    ],
    'current_balance' => 'Trenutno stanje',
    'settings' => [
        'title' => 'Nastavitve',
        'description' => 'Nastavitve za tržnico',
        'fee_per_order' => 'Provizija na naročilo (%), predlog: 2 ali 3',
        'default_commission_fee' => 'Privzeta provizija (%), predlog: 2 ali 3',
        'enable_commission_fee_for_each_category' => 'Omogoči provizijo za vsako kategorijo?',
        'categories' => 'Kategorije',
        'select_categories' => 'Izberi kategorije..',
        'commission_fee' => 'Provizija (%)',
        'commission_fee_by_category' => 'Provizija po kategoriji (%)',
        'fee_withdrawal_amount' => 'Provizija za dvig',
        'withdrawal_fee_type' => 'Vrsta provizije za dvig',
        'withdrawal_fee_types' => [
            'fixed' => 'Fiksni znesek',
            'percentage' => 'Odstotek',
        ],
        'check_valid_signature' => 'Preveri veljaven podpis v dohodkih prodajalca',
        'verify_vendor' => 'Verifikacija prodajalca (Prodajalec lahko objavlja svoje izdelke šele po verifikaciji)',
        'verify_vendor_helper' => 'Če je omogočeno, mora administrator preveriti prodajalca, preden lahko objavlja svoje izdelke.',
        'requires_vendor_documentations_verification' => 'Zahteva verifikacijo dokumentacije prodajalca',
        'requires_vendor_documentations_verification_helper' => 'Če je omogočeno, morajo prodajalci naložiti svoje dokumente pri prijavi za prodajalca.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Skrij meni "Postani prodajalec" na nadzorni plošči stranke',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Če je omogočeno, bo meni "Postani prodajalec" skrit na nadzorni plošči stranke.',
        'enable_product_approval' => 'Omogoči odobritev izdelkov',
        'enable_product_approval_description' => 'Če je omogočeno, mora administrator odobriti izdelek, preden je objavljen.',
        'hide_store_phone_number' => 'Skrij telefonsko številko trgovine?',
        'hide_store_email' => 'Skrij e-pošto trgovine?',
        'hide_store_address' => 'Skrij naslov trgovine?',
        'hide_store_social_links' => 'Skrij družbene povezave trgovine?',
        'enable_vendor_categories_filter' => 'Omogoči filter kategorij prodajalcev',
        'enable_vendor_categories_filter_description' => 'Prikaži filter kategorij na strani trgovine prodajalca. Prikazane bodo samo kategorije, ki imajo izdelke prodajalca.',
        'allow_vendor_manage_shipping' => 'Dovoli prodajalcu upravljanje dostave?',
        'allow_vendor_manage_shipping_description' => 'Če je omogočeno, lahko prodajalec spreminja status dostave naročila v "dostava", "dostavljeno", ...',
        'charge_shipping_per_vendor' => 'Zaračunaj dostavo na prodajalca?',
        'charge_shipping_per_vendor_description' => 'Če je omogočeno, bo dostava zaračunana ločeno za vsakega prodajalca. Če je onemogočeno, bo dostava zaračunana enkrat za celotno naročilo.',
        'commission_fee_each_category_fee_name' => 'Provizija provizijske nastavitve :key',
        'commission_fee_each_category_name' => 'Kategorije provizijske nastavitve :key',
        'add_new' => 'Dodaj novo',
        'payout_methods' => 'Načini izplačila',
        'max_upload_filesize' => 'Največja velikost naložene datoteke (MB)',
        'max_upload_filesize_placeholder' => 'Privzeto: 10',
        'max_product_images_upload_by_vendor' => 'Največje število slik za vsak izdelek',
        'enable_vendor_registration' => 'Omogoči registracijo prodajalcev',
        'enable_vendor_registration_helper' => 'Če je omogočeno, se lahko prodajalci registrirajo na strani in objavijo svoje izdelke.',
        'minimum_withdrawal_amount' => 'Minimalni znesek dviga (Fiksno)',
        'minimum_withdrawal_amount_helper' => 'Določite minimalni znesek, ki ga lahko prodajalec dvigne. Privzeto je 0.',
        'allow_vendor_delete_their_orders' => 'Dovoli prodajalcem brisanje svojih naročil',
        'allow_vendor_delete_their_orders_description' => 'Ko je omogočeno, lahko prodajalci upravljajo svoj seznam naročil z odstranjevanjem neželjenih vnosov. Uporabljajte previdno, saj lahko izbrisana naročila vplivajo na evidence transakcij.',
        'enable_messaging_system' => 'Omogoči sistem sporočanja',
        'enable_messaging_system_description' => 'Če je omogočeno, lahko prodajalci in stranke komunicirajo med seboj prek sistema sporočanja.',
        'term_and_privacy_policy_url' => 'URL pogojev in politike zasebnosti',
        'show_vendor_registration_form_at_registration_page' => 'Prikaži obrazec za registracijo prodajalca na registracijski strani',
        'show_vendor_registration_form_at_registration_page_description' => 'Če je omogočeno, bo obrazec za registracijo prodajalca prikazan na registracijski strani.',
        'single_vendor_checkout' => 'Omejitev na enega prodajalca na naročilo',
        'single_vendor_checkout_help' => 'Če je omogočeno, lahko stranke kupijo izdelke samo enega prodajalca na naročilo.',
        'display_order_total_info_for_each_store' => 'Prikaži skupne informacije naročila za vsako trgovino',
        'display_order_total_info_for_each_store_helper' => 'Če je omogočeno, bodo skupne informacije naročila prikazane za vsako trgovino v povzetku naročila.',
        'show_vendor_info_at_checkout' => 'Prikaži informacije o prodajalcu pri zaključku nakupa',
        'show_vendor_info_at_checkout_helper' => 'Če je omogočeno, bodo informacije o prodajalcu (ime, logotip, ocene) prikazane na strani zaključka nakupa.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Vrste medijskih datotek, ki jih lahko naložijo prodajalci',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Določite vrste medijskih datotek, ki jih lahko naložijo prodajalci. Izberite jih na zgornjem seznamu.',
    ],
    'theme_options' => [
        'name' => 'Tržnica',
        'description' => 'Možnosti teme za Tržnico',
        'logo_vendor_dashboard' => 'Logotip na nadzorni plošči prodajalca (Privzeto je glavni logotip)',
    ],
    'store_name' => 'Ime trgovine',
    'store_email' => 'E-pošta trgovine',
    'store_phone' => 'Telefon trgovine',
    'store_address' => 'Naslov trgovine',
    'store_url' => 'URL trgovine',
    'product_name' => 'Ime izdelka',
    'product_url' => 'URL izdelka',
    'withdrawal_amount' => 'Znesek dviga',
    'helpers' => [
        'store_status' => 'Če spremenite status v karkoli drugega kot ":status", se bo račun te trgovine tudi spremenil v ":customer"',
    ],
    'tables' => [
        'earnings' => 'Zaslužki',
        'products_count' => 'Število izdelkov',
    ],
    'vendors' => 'Prodajalci',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bančno nakazilo',
        'paypal' => 'PayPal',
        'cash' => 'Gotovina',
    ],
    'reports' => [
        'name' => 'Poročila',
        'total_fee_earnings' => 'Skupni zaslužki provizije: :value',
        'total_fee' => 'Skupna provizija',
        'total_amount' => 'Skupni znesek',
        'store_revenues' => 'Prihodki trgovin',
        'sale_commissions' => 'Prodajne provizije',
        'fee' => 'Provizija (:symbol)',
        'amount' => 'Znesek (:symbol)',
        'top_performing_stores' => 'Najbolj uspešne trgovine',
        'store_growth' => 'Rast trgovin',
        'withdrawal_status_chart' => 'Status dvigov',
        'product_distribution' => 'Porazdelitev izdelkov po trgovinah',
        'average_commission' => 'Povprečna stopnja provizije',
        'recent_withdrawals' => 'Nedavni dvigi',
        'number_of_stores' => 'Število trgovin',
        'number_of_products' => 'Število izdelkov',
        'orders' => 'Naročila',
        'revenue' => 'Prihodek',
        'increase' => ':count povečanje',
        'decrease' => ':count zmanjšanje',
    ],
    'vendor' => 'Prodajalec',
    'vendor_name' => 'Ime prodajalca',
    'contact_store' => [
        'form_name' => 'Obrazec za kontakt trgovine',
    ],
    'store_statuses' => [
        'pending' => 'V obdelavi',
        'published' => 'Odobreno',
        'blocked' => 'Blokirano',
    ],
    'view_vendor' => 'Poglej prodajalca :name',
    'vendor_information' => 'Informacije o prodajalcu',
    'vendor_verified' => 'Prodajalec verificiran',
    'vendor_not_verified' => 'Prodajalec ni verificiran',
    'vendor_verified_at' => 'Prodajalec verificiran',
    'view_certificate' => 'Poglej certifikat',
    'view_government_id' => 'Poglej osebni dokument',
    'documents' => 'Dokumenti',
    'store_products' => 'Izdelki trgovine',
    'store_orders' => 'Naročila trgovine',
    'total_revenue' => 'Skupni prihodek',
    'total_earnings' => 'Skupni zaslužki',
    'withdrawals' => 'Dvigi',
    'pending_withdrawals' => 'Čakajoči dvigi',
    'balance' => 'Stanje',
    'recent_products' => 'Nedavni izdelki',
    'products_count' => 'Izdelki',
    'store_status' => 'Status trgovine',
    'verified' => 'Verificirano',
];
