<?php

return [
    'name' => 'Tržište',
    'email' => [
        'title' => 'Tržište',
        'description' => 'Podešavanje email šablona za Tržište',
        'store_new_order_title' => 'Obaveštenje o novoj porudžbini',
        'store_new_order_description' => 'Pošalji email vlasniku prodavnice kada se izvrši porudžbina',
        'verify_vendor_title' => 'Verifikuj prodavca',
        'verify_vendor_description' => 'Pošalji email administratoru kada se prodavac registruje',
        'pending_product_approval_title' => 'Odobrenje proizvoda na čekanju',
        'pending_product_approval_description' => 'Pošalji email administratoru kada prodavac objavi svoje proizvode',
        'vendor_account_approved_title' => 'Nalog prodavca odobren',
        'vendor_account_approved_description' => 'Pošalji email prodavcu kada je njihov nalog odobren',
        'product_approved_title' => 'Proizvod odobren',
        'product_approved_description' => 'Pošalji email prodavcu kada je njihov proizvod odobren',
        'withdrawal_approved_title' => 'Isplata odobrena',
        'withdrawal_approved_description' => 'Pošalji email prodavcu kada je njihov zahtev za isplatu odobren',
        'vendor_account_rejected_title' => 'Nalog prodavca odbijen',
        'vendor_account_rejected_description' => 'Pošalji email prodavcu kada je njihov nalog odbijen',
        'vendor_account_unblocked_title' => 'Nalog prodavca deblokiran',
        'vendor_account_unblocked_description' => 'Pošalji email prodavcu kada je njihov nalog deblokiran',
        'vendor_account_blocked_title' => 'Nalog prodavca blokiran',
        'vendor_account_blocked_description' => 'Pošalji email prodavcu kada je njihov nalog blokiran',
        'store_new_order_subject' => 'Nova porudžbina na {{ site_title }}',
        'verify_vendor_subject' => 'Novi prodavac na {{ site_title }} treba da bude verifikovan',
        'vendor_account_approved_subject' => 'Vaš nalog je odobren za prodaju na {{ site_title }}',
        'vendor_account_rejected_subject' => 'Vaš nalog je odbijen za prodaju na {{ site_title }}',
        'pending_product_approval_subject' => 'Novi proizvod treba da bude odobren za prodaju na {{ site_title }}',
        'product_approved_subject' => 'Vaš proizvod je odobren za prodaju na {{ site_title }}',
        'withdrawal_approved_subject' => 'Vaš zahtev za isplatu je odobren',
        'welcome_vendor_title' => 'Dobrodošli prodavče',
        'welcome_vendor_description' => 'Pošalji email prodavcu nakon registracije',
        'welcome_vendor_subject' => 'Dobrodošli na {{ site_title }}!',
        'contact_store_title' => 'Kontaktiraj prodavnicu',
        'contact_store_description' => 'Pošalji email vlasniku prodavnice kada kupac kontaktira prodavnicu',
        'contact_store_subject' => 'Nova poruka od kupca',
        'vendor_account_blocked_subject' => 'Vaš nalog prodavca na {{ site_title }} je blokiran',
        'vendor_account_unblocked_subject' => 'Vaš nalog prodavca na {{ site_title }} je deblokiran',
        'order_cancellation_to_vendor_title' => 'Otkazivanje porudžbine (biće poslato prodavcu)',
        'order_cancellation_to_vendor_description' => 'Pošalji prodavcu kada kupac otkaže porudžbinu',
        'order_cancellation_to_vendor_subject' => 'Kupac je otkazao porudžbinu :order_id',
        'store_verified_title' => 'Verifikacija prodavnice odobrena',
        'store_verified_description' => 'Pošalji obaveštenje kada je prodavnica verifikovana',
        'store_verified_subject' => 'Vaša prodavnica {{ store_name }} je verifikovana',
        'store_unverified_title' => 'Verifikacija prodavnice uklonjena',
        'store_unverified_description' => 'Pošalji obaveštenje kada je verifikacija prodavnice uklonjena',
        'store_unverified_subject' => 'Status verifikacije promenjen za {{ store_name }}',
        'verified_by' => 'Verifikovao',
        'verified_at' => 'Verifikovano',
        'unverified_by' => 'Uklonio verifikaciju',
        'unverified_at' => 'Verifikacija uklonjena',
        'verification_note' => 'Napomena o verifikaciji',
        'store' => 'Prodavnica',
        'order' => 'Porudžbina',
        'shipment' => 'Informacije o pošiljci',
        'address' => 'Adresa za dostavu',
        'products' => 'Proizvodi u porudžbini',
        'customer_message' => 'Poruka kupca',
        'customer_name' => 'Ime kupca',
        'customer_email' => 'Email kupca',
        'block_reason' => 'Razlog blokiranja',
        'block_date' => 'Datum blokiranja',
        'unblock_date' => 'Datum deblokiranja',
    ],
    'email_templates' => [
        'dear_vendor' => 'Poštovani :vendor_name,',
        'dear_admin' => 'Poštovani administratore,',
        'hello' => 'Zdravo,',
        'happy_selling' => 'Srećnu prodaju!',
        'thank_you_understanding' => 'Hvala vam na razumevanju.',
        'email_sent_by_team' => 'Ovaj email je poslao {{ site_title }} tim.',

        // Contact Store
        'contact_store_sent_from' => 'Ovaj email je poslao :customer_name (:customer_email) putem kontakt forme na vašem profilu na :site_title.',
        'contact_store_reply_instruction' => 'Možete direktno odgovoriti na ovaj email da odgovorite na poruku od :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Vaš nalog prodavca na {{ site_title }} je <strong>blokiran</strong> od :block_date.',
        'vendor_account_blocked_reason' => 'Razlog blokiranja: :block_reason',
        'vendor_account_blocked_contact_support' => 'Ako smatrate da je ovo greška ili imate pitanja, molimo kontaktirajte našu podršku.',
        'vendor_account_unblocked_message' => 'Sa zadovoljstvom vas obaveštavamo da je vaš nalog prodavca na {{ site_title }} <strong>deblokiran</strong> od :unblock_date.',
        'vendor_account_unblocked_resume' => 'Sada možete pristupiti svom nalogu i nastaviti sa aktivnostima.',
        'vendor_account_unblocked_questions' => 'Ako imate pitanja, slobodno kontaktirajte našu podršku.',
        'vendor_account_approved_title' => 'Nalog prodavca odobren',
        'vendor_account_approved_message' => 'Vaš nalog je odobren za prodaju na našem sajtu <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Nalog prodavca odbijen',
        'vendor_account_rejected_message' => 'Sa žaljenjem vas obaveštavamo da vaš nalog nije odobren za prodaju na našem sajtu <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Porudžbina uspešna!',
        'store_new_order_message' => 'Dobili ste novu porudžbinu na :site_title!',
        'customer_information' => 'Informacije o kupcu',
        'field_name' => 'Ime',
        'field_phone' => 'Telefon',
        'field_email' => 'Email',
        'field_address' => 'Adresa',
        'field_note' => 'Napomena',
        'order_number' => 'Broj porudžbine',
        'order_date' => 'Datum porudžbine',
        'shipping_method' => 'Način dostave',
        'payment_method' => 'Način plaćanja',

        // Product Approval
        'product_approved_title' => 'Proizvod odobren',
        'product_approved_message' => 'Vaš proizvod je odobren za prodaju na našem sajtu <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Odobrenje proizvoda na čekanju',
        'pending_product_approval_message' => 'Novi proizvod kreiran od strane :store_name <a href=":product_url">:product_name</a> čeka na odobrenje.',

        // Verify Vendor
        'verify_vendor_title' => 'Verifikuj prodavca',
        'verify_vendor_message' => 'Imate novog prodavca koji treba da bude verifikovan na :site_title!',
        'vendor_information' => 'Informacije o prodavcu',
        'shop_information' => 'Informacije o prodavnici',
        'field_store_name' => 'Naziv prodavnice',
        'field_store_phone' => 'Telefon prodavnice',
        'visit_store_button' => 'Posetite prodavnicu',

        // Withdrawal
        'withdrawal_approved_title' => 'Isplata odobrena',
        'withdrawal_approved_message' => 'Vaš zahtev za isplatu je odobren, uskoro ćemo poslati <strong>:withdrawal_amount</strong> na vaše bankovne podatke.',

        // Order Cancellation
        'order_cancellation_title' => 'Kupac je otkazao porudžbinu :order_id',
        'order_cancellation_message' => 'Kupac :customer_name je otkazao porudžbinu <strong>:order_id</strong> iz razloga :cancellation_reason.',
        'order_items_header' => 'Evo šta je bilo poručeno:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Dobrodošli prodavče',
        'welcome_vendor_greeting' => 'Sa radošću vas pozdravljamo u :store_name!',
        'welcome_vendor_registration_complete' => 'Vaša registracija prodavca je uspešno završena i sada ste deo naše živahne zajednice prodavaca.',
        'welcome_vendor_next_steps' => 'Evo šta možete da uradite sledeće:',
        'welcome_vendor_step_login' => 'Prijavite se na svoj nalog prodavca koristeći svoje podatke.',
        'welcome_vendor_step_add_products' => 'Dodajte svoje proizvode/usluge u svoju prodavnicu. Obavezno navedite detaljne opise i primamljive slike kako biste privukli potencijalne kupce.',
        'welcome_vendor_support' => 'Ako imate pitanja ili vam je potrebna pomoć, naš tim podrške je tu da vam pomogne. Slobodno nas kontaktirajte!',
        'login_vendor_account_button' => 'Prijavite se na svoj nalog prodavca',
        'welcome_vendor_closing' => 'Radujemo se što vidimo vašu prodavnicu da napreduje na :site_title!',

        // Store Verification
        'store_verified_title' => 'Verifikacija prodavnice odobrena',
        'store_verified_message' => 'Čestitamo! Vaša prodavnica je uspešno verifikovana na <strong>:site_title</strong>. Ova značka verifikacije će pomoći u izgradnji poverenja sa vašim kupcima.',
        'dear_store_owner' => 'Poštovani vlasniče :store_name,',
        'verification_details' => 'Detalji verifikacije',
        'store_verified_benefits' => 'Prednosti verifikacije',
        'verified_badge_benefit' => 'Značka verifikacije prikazana na vašoj prodavnici',
        'increased_trust_benefit' => 'Povećano poverenje i sigurnost kupaca',
        'higher_visibility_benefit' => 'Veća vidljivost u rezultatima pretrage',
        'visit_your_store' => 'Posetite svoju prodavnicu',
        'congratulations_verified' => 'Čestitamo na verifikaciji!',

        // Store Unverification
        'store_unverified_title' => 'Status verifikacije prodavnice promenjen',
        'store_unverified_message' => 'Sa žaljenjem vas obaveštavamo da je status verifikacije vaše prodavnice na <strong>:site_title</strong> promenjen.',
        'unverification_details' => 'Detalji promene statusa',
        'store_unverified_impacts' => 'Šta ovo znači',
        'verified_badge_removed' => 'Značka verifikacije je uklonjena sa vaše prodavnice',
        'verification_benefits_lost' => 'Prednosti verifikacije više nisu aktivne',
        'store_unverified_next_steps' => 'Ako imate pitanja o ovoj odluci ili želite da razgovarate o ponovnoj verifikaciji, molimo <strong>kontaktirajte našu podršku</strong>.',
        'contact_support' => 'Kontaktirajte podršku',
        'thank_you_understanding' => 'Hvala vam na razumevanju.',
    ],
    'current_balance' => 'Trenutno stanje',
    'settings' => [
        'title' => 'Podešavanja',
        'description' => 'Podešavanja za tržište',
        'fee_per_order' => 'Naknada po porudžbini (%), preporuka: 2 ili 3',
        'default_commission_fee' => 'Podrazumevana provizija (%), preporuka: 2 ili 3',
        'enable_commission_fee_for_each_category' => 'Omogući proviziju za svaku kategoriju?',
        'categories' => 'Kategorije',
        'select_categories' => 'Izaberite kategorije..',
        'commission_fee' => 'Provizija (%)',
        'commission_fee_by_category' => 'Provizija po kategoriji (%)',
        'fee_withdrawal_amount' => 'Naknada za isplatu',
        'withdrawal_fee_type' => 'Tip naknade za isplatu',
        'withdrawal_fee_types' => [
            'fixed' => 'Fiksni iznos',
            'percentage' => 'Procenat',
        ],
        'check_valid_signature' => 'Proveri valjan potpis u zaradama prodavca',
        'verify_vendor' => 'Verifikacija prodavca (Prodavac može objavljivati proizvode samo nakon verifikacije)',
        'verify_vendor_helper' => 'Ako je omogućeno, administrator mora da verifikuje prodavca pre nego što može da objavi svoje proizvode.',
        'requires_vendor_documentations_verification' => 'Zahteva verifikaciju dokumenata prodavca',
        'requires_vendor_documentations_verification_helper' => 'Ako je omogućeno, prodavci moraju da otpreme svoje dokumente prilikom prijave za prodavca.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Sakrij meni "Postani prodavac" u kontrolnoj tabli kupca',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Ako je omogućeno, meni "Postani prodavac" će biti sakriven u kontrolnoj tabli kupca.',
        'enable_product_approval' => 'Omogući odobrenje proizvoda',
        'enable_product_approval_description' => 'Ako je omogućeno, administrator mora da odobri proizvod pre nego što bude objavljen.',
        'hide_store_phone_number' => 'Sakrij broj telefona prodavnice?',
        'hide_store_email' => 'Sakrij email prodavnice?',
        'hide_store_address' => 'Sakrij adresu prodavnice?',
        'hide_store_social_links' => 'Sakrij društvene mreže prodavnice?',
        'enable_vendor_categories_filter' => 'Omogući filter kategorija prodavca',
        'enable_vendor_categories_filter_description' => 'Prikaži filter kategorija na stranici prodavnice. Biće prikazane samo kategorije koje imaju proizvode prodavca.',
        'allow_vendor_manage_shipping' => 'Dozvoli prodavcu da upravlja dostavom?',
        'allow_vendor_manage_shipping_description' => 'Ako je omogućeno, prodavac može da menja status dostave porudžbine na "u dostavi", "dostavljeno", itd.',
        'charge_shipping_per_vendor' => 'Naplati dostavu po prodavcu?',
        'charge_shipping_per_vendor_description' => 'Ako je omogućeno, dostava će biti naplaćena odvojeno za svakog prodavca. Ako je onemogućeno, dostava će biti naplaćena jednom za celu porudžbinu.',
        'commission_fee_each_category_fee_name' => 'Provizija za podešavanje provizije :key',
        'commission_fee_each_category_name' => 'Kategorije za podešavanje provizije :key',
        'add_new' => 'Dodaj novo',
        'payout_methods' => 'Metode isplate',
        'max_upload_filesize' => 'Maksimalna veličina fajla za otpremanje (MB)',
        'max_upload_filesize_placeholder' => 'Podrazumevano: 10',
        'max_product_images_upload_by_vendor' => 'Maksimalan broj slika po proizvodu',
        'enable_vendor_registration' => 'Omogući registraciju prodavaca',
        'enable_vendor_registration_helper' => 'Ako je omogućeno, prodavci mogu da registruju nalog na sajtu i objavljuju svoje proizvode.',
        'minimum_withdrawal_amount' => 'Minimalni iznos za isplatu (Fiksno)',
        'minimum_withdrawal_amount_helper' => 'Navedite minimalni iznos koji prodavac može da podigne. Podrazumevano je 0.',
        'allow_vendor_delete_their_orders' => 'Dozvoli prodavcima da brišu svoje porudžbine',
        'allow_vendor_delete_their_orders_description' => 'Kada je omogućeno, prodavci mogu da upravljaju svojom listom porudžbina uklanjanjem neželjenih stavki. Koristite sa oprezom jer obrisane porudžbine mogu uticati na evidenciju transakcija.',
        'enable_messaging_system' => 'Omogući sistem poruka',
        'enable_messaging_system_description' => 'Ako je omogućeno, prodavci i kupci mogu da komuniciraju jedni sa drugima putem sistema poruka.',
        'term_and_privacy_policy_url' => 'URL uslova korišćenja i politike privatnosti',
        'show_vendor_registration_form_at_registration_page' => 'Prikaži formu za registraciju prodavca na stranici za registraciju',
        'show_vendor_registration_form_at_registration_page_description' => 'Ako je omogućeno, forma za registraciju prodavca će biti prikazana na stranici za registraciju.',
        'single_vendor_checkout' => 'Ograniči na jednog prodavca po porudžbini',
        'single_vendor_checkout_help' => 'Ako je omogućeno, kupci mogu kupiti proizvode samo od jednog prodavca po porudžbini.',
        'display_order_total_info_for_each_store' => 'Prikaži ukupne informacije o porudžbini za svaku prodavnicu',
        'display_order_total_info_for_each_store_helper' => 'Ako je omogućeno, ukupne informacije o porudžbini će biti prikazane za svaku prodavnicu u rezimeu porudžbine.',
        'show_vendor_info_at_checkout' => 'Prikaži informacije o prodavcu pri plaćanju',
        'show_vendor_info_at_checkout_helper' => 'Ako je omogućeno, informacije o prodavcu (ime, logo, ocene) će biti prikazane na stranici za plaćanje.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Tipovi medijskih fajlova koje prodavac može da otpremi',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Navedite tipove medijskih fajlova koje prodavci mogu da otpreme. Izaberite ih sa gornje liste.',
    ],
    'theme_options' => [
        'name' => 'Tržište',
        'description' => 'Opcije teme za Tržište',
        'logo_vendor_dashboard' => 'Logo u kontrolnoj tabli prodavca (Podrazumevano je glavni logo)',
    ],
    'store_name' => 'Naziv prodavnice',
    'store_email' => 'Email prodavnice',
    'store_phone' => 'Telefon prodavnice',
    'store_address' => 'Adresa prodavnice',
    'store_url' => 'URL prodavnice',
    'product_name' => 'Naziv proizvoda',
    'product_url' => 'URL proizvoda',
    'withdrawal_amount' => 'Iznos isplate',
    'helpers' => [
        'store_status' => 'Ako promenite status na bilo šta osim ":status", nalog ove prodavnice će takođe biti promenjen na ":customer"',
    ],
    'tables' => [
        'earnings' => 'Zarade',
        'products_count' => 'Broj proizvoda',
    ],
    'vendors' => 'Prodavci',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankarski prenos',
        'paypal' => 'PayPal',
        'cash' => 'Gotovina',
    ],
    'reports' => [
        'name' => 'Izveštaji',
        'total_fee_earnings' => 'Ukupna zarada od naknada: :value',
        'total_fee' => 'Ukupna naknada',
        'total_amount' => 'Ukupan iznos',
        'store_revenues' => 'Prihodi prodavnice',
        'sale_commissions' => 'Provizije od prodaje',
        'fee' => 'Naknada (:symbol)',
        'amount' => 'Iznos (:symbol)',
        'top_performing_stores' => 'Najbolje prodavnice',
        'store_growth' => 'Rast prodavnice',
        'withdrawal_status_chart' => 'Status isplata',
        'product_distribution' => 'Distribucija proizvoda po prodavnici',
        'average_commission' => 'Prosečna stopa provizije',
        'recent_withdrawals' => 'Nedavne isplate',
        'number_of_stores' => 'Broj prodavnica',
        'number_of_products' => 'Broj proizvoda',
        'orders' => 'Porudžbine',
        'revenue' => 'Prihod',
        'increase' => ':count povećanje',
        'decrease' => ':count smanjenje',
    ],
    'vendor' => 'Prodavac',
    'vendor_name' => 'Ime prodavca',
    'contact_store' => [
        'form_name' => 'Forma za kontakt sa prodavnicom',
    ],
    'store_statuses' => [
        'pending' => 'Na čekanju',
        'published' => 'Odobreno',
        'blocked' => 'Blokirano',
    ],
    'view_vendor' => 'Pregled prodavca :name',
    'vendor_information' => 'Informacije o prodavcu',
    'vendor_verified' => 'Prodavac verifikovan',
    'vendor_not_verified' => 'Prodavac nije verifikovan',
    'vendor_verified_at' => 'Prodavac verifikovan',
    'view_certificate' => 'Pregled sertifikata',
    'view_government_id' => 'Pregled lične karte',
    'documents' => 'Dokumenta',
    'store_products' => 'Proizvodi prodavnice',
    'store_orders' => 'Porudžbine prodavnice',
    'total_revenue' => 'Ukupan prihod',
    'total_earnings' => 'Ukupne zarade',
    'withdrawals' => 'Isplate',
    'pending_withdrawals' => 'Isplate na čekanju',
    'balance' => 'Stanje',
    'recent_products' => 'Nedavni proizvodi',
    'products_count' => 'Proizvodi',
    'store_status' => 'Status prodavnice',
    'verified' => 'Verifikovano',
];
