<?php

return [
    'name' => 'Marknadsplats',
    'email' => [
        'title' => 'Marknadsplats',
        'description' => 'Konfigurera e-postmallar för Marknadsplats',
        'store_new_order_title' => 'Meddelande om ny beställning',
        'store_new_order_description' => 'Skicka e-post till butiksägaren när en beställning läggs',
        'verify_vendor_title' => 'Verifiera säljare',
        'verify_vendor_description' => 'Skicka e-post till administratören när en säljare registrerar sig',
        'pending_product_approval_title' => 'Väntande produktgodkännande',
        'pending_product_approval_description' => 'Skicka e-post till administratören när en säljare publicerar sina produkter',
        'vendor_account_approved_title' => 'Säljarkonto godkänt',
        'vendor_account_approved_description' => 'Skicka e-post till säljare när deras konto godkänns',
        'product_approved_title' => 'Produkt godkänd',
        'product_approved_description' => 'Skicka e-post till säljare när deras produkt godkänns',
        'withdrawal_approved_title' => 'Uttag godkänt',
        'withdrawal_approved_description' => 'Skicka e-post till säljare när deras uttagsförfrågan godkänns',
        'vendor_account_rejected_title' => 'Säljarkonto avvisat',
        'vendor_account_rejected_description' => 'Skicka e-post till säljare när deras konto avvisas',
        'vendor_account_unblocked_title' => 'Säljarkonto avblockerat',
        'vendor_account_unblocked_description' => 'Skicka e-post till säljare när deras konto avblockeras',
        'vendor_account_blocked_title' => 'Säljarkonto blockerat',
        'vendor_account_blocked_description' => 'Skicka e-post till säljare när deras konto blockeras',
        'store_new_order_subject' => 'Ny beställning på {{ site_title }}',
        'verify_vendor_subject' => 'Ny säljare på {{ site_title }} behöver verifieras',
        'vendor_account_approved_subject' => 'Ditt konto har godkänts för försäljning på {{ site_title }}',
        'vendor_account_rejected_subject' => 'Ditt konto har avvisats för försäljning på {{ site_title }}',
        'pending_product_approval_subject' => 'Ny produkt behöver godkännas för försäljning på {{ site_title }}',
        'product_approved_subject' => 'Din produkt har godkänts för försäljning på {{ site_title }}',
        'withdrawal_approved_subject' => 'Din uttagsförfrågan har godkänts',
        'welcome_vendor_title' => 'Välkommen säljare',
        'welcome_vendor_description' => 'Skicka e-post till säljare efter registrering',
        'welcome_vendor_subject' => 'Välkommen till {{ site_title }}!',
        'contact_store_title' => 'Kontakta Butik',
        'contact_store_description' => 'Skicka e-post till butiksägaren när en kund kontaktar butiken',
        'contact_store_subject' => 'Nytt Kundkontaktmeddelande',
        'vendor_account_blocked_subject' => 'Ditt säljarkonto på {{ site_title }} har blockerats',
        'vendor_account_unblocked_subject' => 'Ditt säljarkonto på {{ site_title }} har avblockerats',
        'order_cancellation_to_vendor_title' => 'Beställningsavbokning (skickas till säljare)',
        'order_cancellation_to_vendor_description' => 'Skicka till säljare när kund avbokar en beställning',
        'order_cancellation_to_vendor_subject' => 'Beställning :order_id har avbokats av kund',
        'store_verified_title' => 'Butiksverifiering Godkänd',
        'store_verified_description' => 'Skicka meddelande när butik verifieras',
        'store_verified_subject' => 'Din butik {{ store_name }} har verifierats',
        'store_unverified_title' => 'Butiksverifiering Borttagen',
        'store_unverified_description' => 'Skicka meddelande när butiksverifiering tas bort',
        'store_unverified_subject' => 'Verifieringsstatus ändrad för {{ store_name }}',
        'verified_by' => 'Verifierad av',
        'verified_at' => 'Verifierad den',
        'unverified_by' => 'Inte verifierad av',
        'unverified_at' => 'Inte verifierad den',
        'verification_note' => 'Verifieringsanteckning',
        'store' => 'Butik',
        'order' => 'Beställning',
        'shipment' => 'Leveransinfo',
        'address' => 'Leveransadress',
        'products' => 'Beställningsprodukter',
        'customer_message' => 'Kundmeddelande',
        'customer_name' => 'Kundnamn',
        'customer_email' => 'Kunde-mail',
        'block_reason' => 'Anledning för blockering',
        'block_date' => 'Datum för blockering',
        'unblock_date' => 'Datum för avblockering',
    ],
    'email_templates' => [
        'dear_vendor' => 'Kära :vendor_name,',
        'dear_admin' => 'Kära Administratör,',
        'hello' => 'Hej,',
        'happy_selling' => 'Lycklig försäljning!',
        'thank_you_understanding' => 'Tack för din förståelse.',
        'email_sent_by_team' => 'Detta e-postmeddelande skickades av {{ site_title }} teamet.',

        // Contact Store
        'contact_store_sent_from' => 'Detta e-postmeddelande skickades från :customer_name (:customer_email) genom ditt profilkontaktformulär på :site_title.',
        'contact_store_reply_instruction' => 'Du kan svara direkt på detta e-postmeddelande för att svara :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Ditt säljarkonto på {{ site_title }} har <strong>blockerats</strong> från :block_date.',
        'vendor_account_blocked_reason' => 'Anledning för blockering: :block_reason',
        'vendor_account_blocked_contact_support' => 'Om du tror att detta är ett misstag eller har frågor, kontakta vårt supportteam.',
        'vendor_account_unblocked_message' => 'Vi är glada att informera dig om att ditt säljarkonto på {{ site_title }} har <strong>avblockerats</strong> från :unblock_date.',
        'vendor_account_unblocked_resume' => 'Du kan nu komma åt ditt konto och återuppta dina aktiviteter.',
        'vendor_account_unblocked_questions' => 'Om du har frågor, tveka inte att kontakta vårt supportteam.',
        'vendor_account_approved_title' => 'Säljarkonto Godkänt',
        'vendor_account_approved_message' => 'Ditt konto har godkänts för försäljning på vår webbplats <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Säljarkonto Avvisat',
        'vendor_account_rejected_message' => 'Vi beklagar att informera dig om att ditt konto inte har godkänts för försäljning på vår webbplats <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Beställning lyckad!',
        'store_new_order_message' => 'Du fick en ny beställning på :site_title!',
        'customer_information' => 'Kundinformation',
        'field_name' => 'Namn',
        'field_phone' => 'Telefon',
        'field_email' => 'E-post',
        'field_address' => 'Adress',
        'field_note' => 'Anteckning',
        'order_number' => 'Beställningsnummer',
        'order_date' => 'Beställningsdatum',
        'shipping_method' => 'Leveransmetod',
        'payment_method' => 'Betalningsmetod',

        // Product Approval
        'product_approved_title' => 'Produkt Godkänd',
        'product_approved_message' => 'Din produkt har godkänts för försäljning på vår webbplats <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Väntande produktgodkännande',
        'pending_product_approval_message' => 'Ny produkt skapades av :store_name <a href=":product_url">:product_name</a> väntar på godkännande.',

        // Verify Vendor
        'verify_vendor_title' => 'Verifiera Säljare',
        'verify_vendor_message' => 'Du har en ny säljare som behöver verifieras på :site_title!',
        'vendor_information' => 'Säljarinformation',
        'shop_information' => 'Butiksinformation',
        'field_store_name' => 'Butiksnamn',
        'field_store_phone' => 'Butiks Telefonnummer',
        'visit_store_button' => 'Besök butik',

        // Withdrawal
        'withdrawal_approved_title' => 'Uttag Godkänt',
        'withdrawal_approved_message' => 'Din utbetalningsförfrågan har godkänts, vi skickar <strong>:withdrawal_amount</strong> till din bankinformation inom kort.',

        // Order Cancellation
        'order_cancellation_title' => 'Kund har avbokat beställning :order_id',
        'order_cancellation_message' => 'Kund :customer_name har avbokat beställning <strong>:order_id</strong> på grund av :cancellation_reason.',
        'order_items_header' => 'Här är vad du beställde:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Välkommen säljare',
        'welcome_vendor_greeting' => 'Vi är glada att välkomna dig till :store_name!',
        'welcome_vendor_registration_complete' => 'Din säljarregistrering har slutförts framgångsrikt och du är nu en del av vår livliga community av säljare.',
        'welcome_vendor_next_steps' => 'Här är vad du kan göra härnäst:',
        'welcome_vendor_step_login' => 'Logga in på ditt säljarkonto med dina inloggningsuppgifter.',
        'welcome_vendor_step_add_products' => 'Lägg till dina produkter/tjänster i din butik. Se till att ge detaljerade beskrivningar och fängslande bilder för att locka potentiella köpare.',
        'welcome_vendor_support' => 'Om du har frågor eller behöver hjälp längs vägen, vårt supportteam är här för att hjälpa dig. Tveka inte att kontakta oss!',
        'login_vendor_account_button' => 'Logga in på ditt säljarkonto',
        'welcome_vendor_closing' => 'Vi är entusiastiska över att se din butik blomstra på :site_title!',

        // Store Verification
        'store_verified_title' => 'Butiksverifiering Godkänd',
        'store_verified_message' => 'Grattis! Din butik har framgångsrikt verifierats på <strong>:site_title</strong>. Denna verifieringsmärkning kommer att hjälpa till att bygga förtroende med dina kunder.',
        'dear_store_owner' => 'Kära :store_name Ägare,',
        'verification_details' => 'Verifieringsdetaljer',
        'store_verified_benefits' => 'Fördelar med att vara verifierad',
        'verified_badge_benefit' => 'En verifierad märkning visas på din butik',
        'increased_trust_benefit' => 'Ökat kundförtroende och tillförlitlighet',
        'higher_visibility_benefit' => 'Högre synlighet i sökresultat',
        'visit_your_store' => 'Besök Din Butik',
        'congratulations_verified' => 'Grattis till din verifiering!',

        // Store Unverification
        'store_unverified_title' => 'Butiksverifieringsstatus Ändrad',
        'store_unverified_message' => 'Vi beklagar att informera dig om att verifieringsstatusen för din butik på <strong>:site_title</strong> har ändrats.',
        'unverification_details' => 'Statusändringsdetaljer',
        'store_unverified_impacts' => 'Vad detta betyder',
        'verified_badge_removed' => 'Den verifierade märkningen har tagits bort från din butik',
        'verification_benefits_lost' => 'Verifieringsfördelar är inte längre aktiva',
        'store_unverified_next_steps' => 'Om du har frågor om detta beslut eller vill diskutera återverifiering, <strong>kontakta vårt supportteam</strong>.',
        'contact_support' => 'Kontakta Support',
        'thank_you_understanding' => 'Tack för din förståelse.',
    ],
    'current_balance' => 'Nuvarande saldo',
    'settings' => [
        'title' => 'Inställningar',
        'description' => 'Inställningar för marknadsplats',
        'fee_per_order' => 'Avgift per beställning (%), förslag: 2 eller 3',
        'default_commission_fee' => 'Standard kommissionsavgift (%), förslag: 2 eller 3',
        'enable_commission_fee_for_each_category' => 'Aktivera kommissionsavgift för varje kategori?',
        'categories' => 'Kategorier',
        'select_categories' => 'Välj kategorier..',
        'commission_fee' => 'Kommissionsavgift (%)',
        'commission_fee_by_category' => 'Kommissionsavgift per kategori (%)',
        'fee_withdrawal_amount' => 'Avgift för uttag',
        'withdrawal_fee_type' => 'Typ av uttagsavgift',
        'withdrawal_fee_types' => [
            'fixed' => 'Fast belopp',
            'percentage' => 'Procent',
        ],
        'check_valid_signature' => 'Kontrollera giltig signatur i säljarens intäkter',
        'verify_vendor' => 'Säljarverifiering (Säljare kan bara publicera produkter efter verifiering)',
        'verify_vendor_helper' => 'Om aktiverat måste administratören verifiera säljaren innan de kan publicera sina produktlistor.',
        'requires_vendor_documentations_verification' => 'Kräver verifiering av säljardokumentation',
        'requires_vendor_documentations_verification_helper' => 'Om aktiverat måste säljare ladda upp sina dokumentationsfiler när de ansöker om att bli säljare.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Dölj bli säljare-menyn i kunddashboard',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Om aktiverat kommer "Bli säljare"-menyn att döljas i kunddashboard.',
        'enable_product_approval' => 'Aktivera produktgodkännande',
        'enable_product_approval_description' => 'Om aktiverat måste administratören godkänna produkten innan den publiceras.',
        'hide_store_phone_number' => 'Dölj butiks telefonnummer?',
        'hide_store_email' => 'Dölj butiks e-post?',
        'hide_store_address' => 'Dölj butiksadress?',
        'hide_store_social_links' => 'Dölj butiks sociala länkar?',
        'enable_vendor_categories_filter' => 'Aktivera säljarkategorier filter',
        'enable_vendor_categories_filter_description' => 'Visa kategorier filter på säljarbutikssidan. Endast kategorier som har säljarprodukter kommer att visas.',
        'allow_vendor_manage_shipping' => 'Tillåt säljare att hantera leverans?',
        'allow_vendor_manage_shipping_description' => 'Om aktiverat kan säljaren ändra leveransstatus för beställning till "levererar", "levererad", ...',
        'charge_shipping_per_vendor' => 'Ta betalt för leverans per säljare?',
        'charge_shipping_per_vendor_description' => 'Om aktiverat kommer leverans att debiteras separat för varje säljare. Om inaktiverat kommer leverans att debiteras en gång för hela beställningen.',
        'commission_fee_each_category_fee_name' => 'Kommissionsavgift för kommissionsinställning :key',
        'commission_fee_each_category_name' => 'Kategorier för kommissionsinställning :key',
        'add_new' => 'Lägg till ny',
        'payout_methods' => 'Utbetalningsmetoder',
        'max_upload_filesize' => 'Max uppladdning filstorlek (MB)',
        'max_upload_filesize_placeholder' => 'Standard: 10',
        'max_product_images_upload_by_vendor' => 'Max antal bilder för varje produkt',
        'enable_vendor_registration' => 'Aktivera säljarregistrering',
        'enable_vendor_registration_helper' => 'Om aktiverat kan säljare registrera ett konto på webbplatsen och publicera sina produkter.',
        'minimum_withdrawal_amount' => 'Minimum uttagsbelopp (Fast)',
        'minimum_withdrawal_amount_helper' => 'Ange det minsta beloppet en säljare kan ta ut. Standard är 0.',
        'allow_vendor_delete_their_orders' => 'Tillåt säljare att ta bort sina beställningar',
        'allow_vendor_delete_their_orders_description' => 'När aktiverat kan säljare hantera sin beställningslista genom att ta bort oönskade poster. Använd med försiktighet eftersom borttagna beställningar kan påverka transaktionsposter.',
        'enable_messaging_system' => 'Aktivera meddelandesystem',
        'enable_messaging_system_description' => 'Om aktiverat kan säljare och kunder kommunicera med varandra via meddelandesystemet.',
        'term_and_privacy_policy_url' => 'Villkor och integritetspolicy URL',
        'show_vendor_registration_form_at_registration_page' => 'Visa säljarregistreringsformulär på registreringssidan',
        'show_vendor_registration_form_at_registration_page_description' => 'Om aktiverat kommer säljarregistreringsformuläret att visas på registreringssidan.',
        'single_vendor_checkout' => 'Begränsa till En Säljare per Beställning',
        'single_vendor_checkout_help' => 'Om aktiverat kan kunder bara köpa produkter från en säljare per beställning.',
        'display_order_total_info_for_each_store' => 'Visa beställningstotalinfo för varje butik',
        'display_order_total_info_for_each_store_helper' => 'Om aktiverat kommer beställningstotalinformationen att visas för varje butik i beställningssammanfattningen.',
        'show_vendor_info_at_checkout' => 'Visa säljarinformation vid kassan',
        'show_vendor_info_at_checkout_helper' => 'Om aktiverat kommer säljarinformation (namn, logotyp, recensioner) att visas på kassasidan.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Mediefiltyper som kan laddas upp av säljare',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Ange de mediefiltyper som säljare kan ladda upp. Välj dem i listan ovan.',
    ],
    'theme_options' => [
        'name' => 'Marknadsplats',
        'description' => 'Temaalternativ för Marknadsplats',
        'logo_vendor_dashboard' => 'Logotyp i säljardashboard (Standard är huvudlogotypen)',
    ],
    'store_name' => 'Butiksnamn',
    'store_email' => 'Butiks e-post',
    'store_phone' => 'Butiks telefon',
    'store_address' => 'Butiksadress',
    'store_url' => 'Butiks URL',
    'product_name' => 'Produktnamn',
    'product_url' => 'Produkt URL',
    'withdrawal_amount' => 'Uttagsbelopp',
    'helpers' => [
        'store_status' => 'Om du ändrar statusen till annat än ":status" kommer denna butiks konto också att ändras till ":customer"',
    ],
    'tables' => [
        'earnings' => 'Intäkter',
        'products_count' => 'Produktantal',
    ],
    'vendors' => 'Säljare',
    'payout_payment_methods' => [
        'bank_transfer' => 'Banköverföring',
        'paypal' => 'PayPal',
        'cash' => 'Kontant',
    ],
    'reports' => [
        'name' => 'Rapporter',
        'total_fee_earnings' => 'Totala avgiftsintäkter: :value',
        'total_fee' => 'Total avgift',
        'total_amount' => 'Totalt belopp',
        'store_revenues' => 'Butiksintäkter',
        'sale_commissions' => 'Försäljningskommissioner',
        'fee' => 'Avgift (:symbol)',
        'amount' => 'Belopp (:symbol)',
        'top_performing_stores' => 'Bäst Presterande Butiker',
        'store_growth' => 'Butikstillväxt',
        'withdrawal_status_chart' => 'Uttagsstatus',
        'product_distribution' => 'Produktdistribution per Butik',
        'average_commission' => 'Genomsnittlig Kommissionsränta',
        'recent_withdrawals' => 'Senaste Uttag',
        'number_of_stores' => 'Antal Butiker',
        'number_of_products' => 'Antal Produkter',
        'orders' => 'Beställningar',
        'revenue' => 'Intäkter',
        'increase' => ':count ökning',
        'decrease' => ':count minskning',
    ],
    'vendor' => 'Säljare',
    'vendor_name' => 'Säljarnamn',
    'contact_store' => [
        'form_name' => 'Kontakta Butik formulär',
    ],
    'store_statuses' => [
        'pending' => 'Väntande',
        'published' => 'Godkänd',
        'blocked' => 'Blockerad',
    ],
    'view_vendor' => 'Visa säljare :name',
    'vendor_information' => 'Säljarinformation',
    'vendor_verified' => 'Säljare Verifierad',
    'vendor_not_verified' => 'Säljare Inte Verifierad',
    'vendor_verified_at' => 'Säljare Verifierad Den',
    'view_certificate' => 'Visa Certifikat',
    'view_government_id' => 'Visa Statlig ID',
    'documents' => 'Dokument',
    'store_products' => 'Butiksprodukter',
    'store_orders' => 'Butiksbeställningar',
    'total_revenue' => 'Totala Intäkter',
    'total_earnings' => 'Totala Intäkter',
    'withdrawals' => 'Uttag',
    'pending_withdrawals' => 'Väntande Uttag',
    'balance' => 'Saldo',
    'recent_products' => 'Senaste Produkter',
    'products_count' => 'Produkter',
    'store_status' => 'Butiksstatus',
    'verified' => 'Verifierad',
];