<?php

return [
    'name' => '市场',
    'email' => [
        'title' => '市场',
        'description' => '配置市场邮件模板',
        'store_new_order_title' => '新订单通知',
        'store_new_order_description' => '当有订单时向店主发送邮件',
        'verify_vendor_title' => '验证卖家',
        'verify_vendor_description' => '当卖家注册时向管理员发送邮件',
        'pending_product_approval_title' => '待审核商品',
        'pending_product_approval_description' => '当卖家发布商品时向管理员发送邮件',
        'vendor_account_approved_title' => '卖家账户已批准',
        'vendor_account_approved_description' => '当卖家账户被批准时向卖家发送邮件',
        'product_approved_title' => '商品已批准',
        'product_approved_description' => '当商品被批准时向卖家发送邮件',
        'withdrawal_approved_title' => '提现已批准',
        'withdrawal_approved_description' => '当提现请求被批准时向卖家发送邮件',
        'vendor_account_rejected_title' => '卖家账户被拒绝',
        'vendor_account_rejected_description' => '当卖家账户被拒绝时向卖家发送邮件',
        'vendor_account_unblocked_title' => '卖家账户已解封',
        'vendor_account_unblocked_description' => '当卖家账户被解封时向卖家发送邮件',
        'vendor_account_blocked_title' => '卖家账户已封禁',
        'vendor_account_blocked_description' => '当卖家账户被封禁时向卖家发送邮件',
        'store_new_order_subject' => '{{ site_title }} 上的新订单',
        'verify_vendor_subject' => '{{ site_title }} 上的新卖家需要验证',
        'vendor_account_approved_subject' => '您的账户已获批在 {{ site_title }} 上销售',
        'vendor_account_rejected_subject' => '您的账户被拒绝在 {{ site_title }} 上销售',
        'pending_product_approval_subject' => '新商品需要批准在 {{ site_title }} 上销售',
        'product_approved_subject' => '您的商品已获批在 {{ site_title }} 上销售',
        'withdrawal_approved_subject' => '您的提现请求已被批准',
        'welcome_vendor_title' => '欢迎卖家',
        'welcome_vendor_description' => '注册后向卖家发送邮件',
        'welcome_vendor_subject' => '欢迎来到 {{ site_title }}！',
        'contact_store_title' => '联系店铺',
        'contact_store_description' => '当客户联系店铺时向店主发送邮件',
        'contact_store_subject' => '新的客户联系消息',
        'vendor_account_blocked_subject' => '您在 {{ site_title }} 的卖家账户已被封禁',
        'vendor_account_unblocked_subject' => '您在 {{ site_title }} 的卖家账户已被解封',
        'order_cancellation_to_vendor_title' => '订单取消（将发送给卖家）',
        'order_cancellation_to_vendor_description' => '当客户取消订单时发送给卖家',
        'order_cancellation_to_vendor_subject' => '订单 :order_id 已被客户取消',
        'store_verified_title' => '店铺验证已批准',
        'store_verified_description' => '当店铺被验证时发送通知',
        'store_verified_subject' => '您的店铺 {{ store_name }} 已被验证',
        'store_unverified_title' => '店铺验证已移除',
        'store_unverified_description' => '当店铺验证被移除时发送通知',
        'store_unverified_subject' => '{{ store_name }} 的验证状态已更改',
        'verified_by' => '验证人',
        'verified_at' => '验证时间',
        'unverified_by' => '取消验证人',
        'unverified_at' => '取消验证时间',
        'verification_note' => '验证备注',
        'store' => '店铺',
        'order' => '订单',
        'shipment' => '发货信息',
        'address' => '收货地址',
        'products' => '订单商品',
        'customer_message' => '客户消息',
        'customer_name' => '客户姓名',
        'customer_email' => '客户邮箱',
        'block_reason' => '封禁原因',
        'block_date' => '封禁日期',
        'unblock_date' => '解封日期',
    ],
    'email_templates' => [
        'dear_vendor' => '亲爱的 :vendor_name，',
        'dear_admin' => '亲爱的管理员，',
        'hello' => '您好，',
        'happy_selling' => '销售愉快！',
        'thank_you_understanding' => '感谢您的理解。',
        'email_sent_by_team' => '此邮件由 {{ site_title }} 团队发送。',

        // Contact Store
        'contact_store_sent_from' => '此邮件由 :customer_name (:customer_email) 通过您在 :site_title 的个人资料联系表单发送。',
        'contact_store_reply_instruction' => '您可以直接回复此邮件来回复 :customer_name (:customer_email)。',

        // Vendor Account Status
        'vendor_account_blocked_message' => '您在 {{ site_title }} 的卖家账户自 :block_date 起已被<strong>封禁</strong>。',
        'vendor_account_blocked_reason' => '封禁原因：:block_reason',
        'vendor_account_blocked_contact_support' => '如果您认为这是错误或有任何疑问，请联系我们的支持团队。',
        'vendor_account_unblocked_message' => '我们很高兴地通知您，您在 {{ site_title }} 的卖家账户自 :unblock_date 起已被<strong>解封</strong>。',
        'vendor_account_unblocked_resume' => '您现在可以访问您的账户并恢复您的活动。',
        'vendor_account_unblocked_questions' => '如有任何疑问，请随时联系我们的支持团队。',
        'vendor_account_approved_title' => '卖家账户已批准',
        'vendor_account_approved_message' => '您的账户已获批在我们的网站 <a href=":site_url">:site_url</a> 上销售。',
        'vendor_account_rejected_title' => '卖家账户被拒绝',
        'vendor_account_rejected_message' => '很遗憾地通知您，您的账户未获批在我们的网站 <a href=":site_url">:site_url</a> 上销售。',

        // Store New Order
        'store_new_order_title' => '订单成功！',
        'store_new_order_message' => '您在 :site_title 上收到了新订单！',
        'customer_information' => '客户信息',
        'field_name' => '姓名',
        'field_phone' => '电话',
        'field_email' => '邮箱',
        'field_address' => '地址',
        'field_note' => '备注',
        'order_number' => '订单号',
        'order_date' => '订单日期',
        'shipping_method' => '配送方式',
        'payment_method' => '支付方式',

        // Product Approval
        'product_approved_title' => '商品已批准',
        'product_approved_message' => '您的商品已获批在我们的网站 <a href=":site_url">:site_url</a> 上销售。',
        'pending_product_approval_title' => '待审核商品',
        'pending_product_approval_message' => '由 :store_name 创建的新商品 <a href=":product_url">:product_name</a> 正在等待审批。',

        // Verify Vendor
        'verify_vendor_title' => '验证卖家',
        'verify_vendor_message' => '您在 :site_title 上有一个新卖家需要验证！',
        'vendor_information' => '卖家信息',
        'shop_information' => '店铺信息',
        'field_store_name' => '店铺名称',
        'field_store_phone' => '店铺电话号码',
        'visit_store_button' => '访问店铺',

        // Withdrawal
        'withdrawal_approved_title' => '提现已批准',
        'withdrawal_approved_message' => '您的提现请求已被批准，我们将很快将 <strong>:withdrawal_amount</strong> 发送到您的银行信息。',

        // Order Cancellation
        'order_cancellation_title' => '客户已取消订单 :order_id',
        'order_cancellation_message' => '客户 :customer_name 因 :cancellation_reason 取消了订单 <strong>:order_id</strong>。',
        'order_items_header' => '您的订购内容：',

        // Welcome Vendor
        'welcome_vendor_title' => '欢迎卖家',
        'welcome_vendor_greeting' => '我们很高兴欢迎您来到 :store_name！',
        'welcome_vendor_registration_complete' => '您的卖家注册已成功完成，您现在是我们充满活力的卖家社区的一员。',
        'welcome_vendor_next_steps' => '您接下来可以做的事情：',
        'welcome_vendor_step_login' => '使用您的凭据登录您的卖家账户。',
        'welcome_vendor_step_add_products' => '将您的产品/服务添加到您的店铺。确保提供详细的描述和吸引人的图片来吸引潜在买家。',
        'welcome_vendor_support' => '如果您有任何疑问或需要帮助，我们的支持团队随时为您提供帮助。请随时联系！',
        'login_vendor_account_button' => '登录您的卖家账户',
        'welcome_vendor_closing' => '我们很兴奋看到您的店铺在 :site_title 上蓬勃发展！',

        // Store Verification
        'store_verified_title' => '店铺验证已批准',
        'store_verified_message' => '恭喜！您的店铺已在 <strong>:site_title</strong> 上成功验证。此验证徽章将有助于与您的客户建立信任。',
        'dear_store_owner' => '亲爱的 :store_name 店主，',
        'verification_details' => '验证详情',
        'store_verified_benefits' => '获得验证的好处',
        'verified_badge_benefit' => '您的店铺上显示验证徽章',
        'increased_trust_benefit' => '增强客户信任和信心',
        'higher_visibility_benefit' => '在搜索结果中获得更高的可见性',
        'visit_your_store' => '访问您的店铺',
        'congratulations_verified' => '恭喜您获得验证！',

        // Store Unverification
        'store_unverified_title' => '店铺验证状态已更改',
        'store_unverified_message' => '很遗憾地通知您，您在 <strong>:site_title</strong> 上的店铺验证状态已更改。',
        'unverification_details' => '状态更改详情',
        'store_unverified_impacts' => '这意味着什么',
        'verified_badge_removed' => '验证徽章已从您的店铺中移除',
        'verification_benefits_lost' => '验证好处不再有效',
        'store_unverified_next_steps' => '如果您对此决定有疑问或想讨论重新验证，请<strong>联系我们的支持团队</strong>。',
        'contact_support' => '联系支持',
        'thank_you_understanding' => '感谢您的理解。',
    ],
    'current_balance' => '当前余额',
    'settings' => [
        'title' => '设置',
        'description' => '市场设置',
        'fee_per_order' => '每单费用 (%)，建议：2 或 3',
        'default_commission_fee' => '默认佣金费用 (%)，建议：2 或 3',
        'enable_commission_fee_for_each_category' => '为每个类别启用佣金费用？',
        'categories' => '类别',
        'select_categories' => '选择类别..',
        'commission_fee' => '佣金费用 (%)',
        'commission_fee_by_category' => '按类别的佣金费用 (%)',
        'fee_withdrawal_amount' => '提现费用',
        'withdrawal_fee_type' => '提现费用类型',
        'withdrawal_fee_types' => [
            'fixed' => '固定金额',
            'percentage' => '百分比',
        ],
        'check_valid_signature' => '检查卖家收入中的有效签名',
        'verify_vendor' => '卖家验证（卖家只有在获得验证后才能发布产品清单）',
        'verify_vendor_helper' => '如果启用，管理员必须在卖家发布产品清单之前验证卖家。',
        'requires_vendor_documentations_verification' => '需要卖家文档验证',
        'requires_vendor_documentations_verification_helper' => '如果启用，卖家在申请成为卖家时必须上传其文档文件。',
        'hide_become_vendor_menu_in_customer_dashboard' => '在客户仪表板中隐藏成为卖家菜单',
        'hide_become_vendor_menu_in_customer_dashboard_description' => '如果启用，"成为卖家"菜单将在客户仪表板中隐藏。',
        'enable_product_approval' => '启用商品审批',
        'enable_product_approval_description' => '如果启用，管理员必须在商品发布之前批准商品。',
        'hide_store_phone_number' => '隐藏店铺电话号码？',
        'hide_store_email' => '隐藏店铺邮箱？',
        'hide_store_address' => '隐藏店铺地址？',
        'hide_store_social_links' => '隐藏店铺社交链接？',
        'enable_vendor_categories_filter' => '启用卖家类别过滤器',
        'enable_vendor_categories_filter_description' => '在卖家店铺页面显示类别过滤器。只会显示有卖家产品的类别。',
        'allow_vendor_manage_shipping' => '允许卖家管理配送？',
        'allow_vendor_manage_shipping_description' => '如果启用，卖家可以将订单的配送状态更改为"配送中"、"已配送"等。',
        'charge_shipping_per_vendor' => '按卖家收取配送费？',
        'charge_shipping_per_vendor_description' => '如果启用，每个卖家将单独收取配送费。如果禁用，整个订单只收取一次配送费。',
        'commission_fee_each_category_fee_name' => '佣金设置 :key 的佣金费用',
        'commission_fee_each_category_name' => '佣金设置 :key 的类别',
        'add_new' => '添加新的',
        'payout_methods' => '支付方式',
        'max_upload_filesize' => '最大上传文件大小 (MB)',
        'max_upload_filesize_placeholder' => '默认：10',
        'max_product_images_upload_by_vendor' => '每个产品的最大图片数量',
        'enable_vendor_registration' => '启用卖家注册',
        'enable_vendor_registration_helper' => '如果启用，卖家可以在网站上注册账户并发布他们的产品。',
        'minimum_withdrawal_amount' => '最小提现金额（固定）',
        'minimum_withdrawal_amount_helper' => '指定卖家可以提现的最小金额。默认为0。',
        'allow_vendor_delete_their_orders' => '允许卖家删除他们的订单',
        'allow_vendor_delete_their_orders_description' => '启用后，卖家可以通过删除不需要的条目来管理他们的订单列表。请谨慎使用，因为删除的订单可能会影响交易记录。',
        'enable_messaging_system' => '启用消息系统',
        'enable_messaging_system_description' => '如果启用，卖家和客户可以通过消息系统相互交流。',
        'term_and_privacy_policy_url' => '条款和隐私政策URL',
        'show_vendor_registration_form_at_registration_page' => '在注册页面显示卖家注册表单',
        'show_vendor_registration_form_at_registration_page_description' => '如果启用，卖家注册表单将在注册页面显示。',
        'single_vendor_checkout' => '限制每个订单只能有一个卖家',
        'single_vendor_checkout_help' => '如果启用，客户每个订单只能购买一个卖家的产品。',
        'display_order_total_info_for_each_store' => '为每个店铺显示订单总额信息',
        'display_order_total_info_for_each_store_helper' => '如果启用，订单总额信息将在订单摘要中为每个店铺显示。',
        'show_vendor_info_at_checkout' => '在结账时显示卖家信息',
        'show_vendor_info_at_checkout_helper' => '如果启用，卖家信息（姓名、徽标、评论）将在结账页面显示。',
        'media_file_types_can_be_uploaded_by_vendor' => '卖家可以上传的媒体文件类型',
        'media_file_types_can_be_uploaded_by_vendor_helper' => '指定卖家可以上传的媒体文件类型。从上面的列表中选择它们。',
    ],
    'theme_options' => [
        'name' => '市场',
        'description' => '市场主题选项',
        'logo_vendor_dashboard' => '卖家仪表板中的徽标（默认为主徽标）',
    ],
    'store_name' => '店铺名称',
    'store_email' => '店铺邮箱',
    'store_phone' => '店铺电话',
    'store_address' => '店铺地址',
    'store_url' => '店铺URL',
    'product_name' => '商品名称',
    'product_url' => '商品URL',
    'withdrawal_amount' => '提现金额',
    'helpers' => [
        'store_status' => '如果您将状态更改为除":status"以外的状态，此店铺账户也将更改为":customer"',
    ],
    'tables' => [
        'earnings' => '收入',
        'products_count' => '商品数量',
    ],
    'vendors' => '卖家',
    'payout_payment_methods' => [
        'bank_transfer' => '银行转账',
        'paypal' => 'PayPal',
        'cash' => '现金',
    ],
    'reports' => [
        'name' => '报告',
        'total_fee_earnings' => '总费用收入：:value',
        'total_fee' => '总费用',
        'total_amount' => '总金额',
        'store_revenues' => '店铺收入',
        'sale_commissions' => '销售佣金',
        'fee' => '费用 (:symbol)',
        'amount' => '金额 (:symbol)',
        'top_performing_stores' => '表现最佳的店铺',
        'store_growth' => '店铺增长',
        'withdrawal_status_chart' => '提现状态',
        'product_distribution' => '按店铺的商品分布',
        'average_commission' => '平均佣金率',
        'recent_withdrawals' => '最近提现',
        'number_of_stores' => '店铺数量',
        'number_of_products' => '商品数量',
        'orders' => '订单',
        'revenue' => '收入',
        'increase' => ':count 增加',
        'decrease' => ':count 减少',
    ],
    'vendor' => '卖家',
    'vendor_name' => '卖家名称',
    'contact_store' => [
        'form_name' => '联系店铺表单',
    ],
    'store_statuses' => [
        'pending' => '待处理',
        'published' => '已批准',
        'blocked' => '已封禁',
    ],
    'view_vendor' => '查看卖家 :name',
    'vendor_information' => '卖家信息',
    'vendor_verified' => '卖家已验证',
    'vendor_not_verified' => '卖家未验证',
    'vendor_verified_at' => '卖家验证时间',
    'view_certificate' => '查看证书',
    'view_government_id' => '查看身份证',
    'documents' => '文档',
    'store_products' => '店铺商品',
    'store_orders' => '店铺订单',
    'total_revenue' => '总收入',
    'total_earnings' => '总收入',
    'withdrawals' => '提现',
    'pending_withdrawals' => '待处理提现',
    'balance' => '余额',
    'recent_products' => '最近商品',
    'products_count' => '商品',
    'store_status' => '店铺状态',
    'verified' => '已验证',
];