<?php

return [
    'name' => '市集',
    'email' => [
        'title' => '市集',
        'description' => '配置市集電郵範本',
        'store_new_order_title' => '新訂單通知',
        'store_new_order_description' => '當有訂單提交時向商店擁有者發送電郵',
        'verify_vendor_title' => '驗證賣家',
        'verify_vendor_description' => '當賣家註冊時向管理員發送電郵',
        'pending_product_approval_title' => '待批核產品',
        'pending_product_approval_description' => '當賣家發佈產品時向管理員發送電郵',
        'vendor_account_approved_title' => '賣家帳戶已批准',
        'vendor_account_approved_description' => '當賣家帳戶獲批准時向賣家發送電郵',
        'product_approved_title' => '產品已批准',
        'product_approved_description' => '當賣家產品獲批准時向賣家發送電郵',
        'withdrawal_approved_title' => '提款已批准',
        'withdrawal_approved_description' => '當賣家提款申請獲批准時向賣家發送電郵',
        'vendor_account_rejected_title' => '賣家帳戶已拒絕',
        'vendor_account_rejected_description' => '當賣家帳戶被拒絕時向賣家發送電郵',
        'vendor_account_unblocked_title' => '賣家帳戶已解封',
        'vendor_account_unblocked_description' => '當賣家帳戶被解封時向賣家發送電郵',
        'vendor_account_blocked_title' => '賣家帳戶已封鎖',
        'vendor_account_blocked_description' => '當賣家帳戶被封鎖時向賣家發送電郵',
        'store_new_order_subject' => '{{ site_title }} 有新訂單',
        'verify_vendor_subject' => '{{ site_title }} 有新賣家需要驗證',
        'vendor_account_approved_subject' => '您的帳戶已獲批准在 {{ site_title }} 上銷售',
        'vendor_account_rejected_subject' => '您的帳戶已被拒絕在 {{ site_title }} 上銷售',
        'pending_product_approval_subject' => '有新產品需要批准在 {{ site_title }} 上銷售',
        'product_approved_subject' => '您的產品已獲批准在 {{ site_title }} 上銷售',
        'withdrawal_approved_subject' => '您的提款申請已獲批准',
        'welcome_vendor_title' => '歡迎賣家',
        'welcome_vendor_description' => '賣家註冊後向其發送電郵',
        'welcome_vendor_subject' => '歡迎來到 {{ site_title }}!',
        'contact_store_title' => '聯絡商店',
        'contact_store_description' => '當顧客聯絡商店時向商店擁有者發送電郵',
        'contact_store_subject' => '新顧客聯絡訊息',
        'vendor_account_blocked_subject' => '您在 {{ site_title }} 的賣家帳戶已被封鎖',
        'vendor_account_unblocked_subject' => '您在 {{ site_title }} 的賣家帳戶已解封',
        'order_cancellation_to_vendor_title' => '取消訂單(將發送給賣家)',
        'order_cancellation_to_vendor_description' => '當顧客取消訂單時發送給賣家',
        'order_cancellation_to_vendor_subject' => '訂單 :order_id 已被顧客取消',
        'store_verified_title' => '商店驗證已批准',
        'store_verified_description' => '當商店獲得驗證時發送通知',
        'store_verified_subject' => '您的商店 {{ store_name }} 已通過驗證',
        'store_unverified_title' => '商店驗證已移除',
        'store_unverified_description' => '當商店驗證被移除時發送通知',
        'store_unverified_subject' => '{{ store_name }} 的驗證狀態已更改',
        'verified_by' => '驗證者',
        'verified_at' => '驗證時間',
        'unverified_by' => '移除驗證者',
        'unverified_at' => '移除驗證時間',
        'verification_note' => '驗證備註',
        'store' => '商店',
        'order' => '訂單',
        'shipment' => '付運資訊',
        'address' => '送貨地址',
        'products' => '訂單產品',
        'customer_message' => '顧客訊息',
        'customer_name' => '顧客姓名',
        'customer_email' => '顧客電郵',
        'block_reason' => '封鎖原因',
        'block_date' => '封鎖日期',
        'unblock_date' => '解封日期',
    ],
    'email_templates' => [
        'dear_vendor' => '親愛的 :vendor_name,',
        'dear_admin' => '親愛的管理員,',
        'hello' => '您好,',
        'happy_selling' => '祝您銷售順利!',
        'thank_you_understanding' => '感謝您的理解。',
        'email_sent_by_team' => '此電郵由 {{ site_title }} 團隊發送。',

        // Contact Store
        'contact_store_sent_from' => '此電郵由 :customer_name (:customer_email) 透過您在 :site_title 的個人資料聯絡表格發送。',
        'contact_store_reply_instruction' => '您可以直接回覆此電郵來回應 :customer_name (:customer_email)。',

        // Vendor Account Status
        'vendor_account_blocked_message' => '您在 {{ site_title }} 的賣家帳戶已於 :block_date <strong>被封鎖</strong>。',
        'vendor_account_blocked_reason' => '封鎖原因: :block_reason',
        'vendor_account_blocked_contact_support' => '如您認為這是錯誤或有任何疑問,請聯絡我們的支援團隊。',
        'vendor_account_unblocked_message' => '我們很高興通知您,您在 {{ site_title }} 的賣家帳戶已於 :unblock_date <strong>解封</strong>。',
        'vendor_account_unblocked_resume' => '您現在可以登入帳戶並恢復您的活動。',
        'vendor_account_unblocked_questions' => '如有任何疑問,歡迎聯絡我們的支援團隊。',
        'vendor_account_approved_title' => '賣家帳戶已批准',
        'vendor_account_approved_message' => '您的帳戶已獲批准在我們的網站 <a href=":site_url">:site_url</a> 上銷售。',
        'vendor_account_rejected_title' => '賣家帳戶已拒絕',
        'vendor_account_rejected_message' => '很遺憾通知您,您的帳戶未獲批准在我們的網站 <a href=":site_url">:site_url</a> 上銷售。',

        // Store New Order
        'store_new_order_title' => '訂單成功!',
        'store_new_order_message' => '您在 :site_title 收到新訂單!',
        'customer_information' => '顧客資料',
        'field_name' => '姓名',
        'field_phone' => '電話',
        'field_email' => '電郵',
        'field_address' => '地址',
        'field_note' => '備註',
        'order_number' => '訂單編號',
        'order_date' => '訂單日期',
        'shipping_method' => '送貨方式',
        'payment_method' => '付款方式',

        // Product Approval
        'product_approved_title' => '產品已批准',
        'product_approved_message' => '您的產品已獲批准在我們的網站 <a href=":site_url">:site_url</a> 上銷售。',
        'pending_product_approval_title' => '待批核產品',
        'pending_product_approval_message' => ':store_name 建立的新產品 <a href=":product_url">:product_name</a> 正在等待批准。',

        // Verify Vendor
        'verify_vendor_title' => '驗證賣家',
        'verify_vendor_message' => '您在 :site_title 有新賣家需要驗證!',
        'vendor_information' => '賣家資料',
        'shop_information' => '商店資料',
        'field_store_name' => '商店名稱',
        'field_store_phone' => '商店電話號碼',
        'visit_store_button' => '造訪商店',

        // Withdrawal
        'withdrawal_approved_title' => '提款已批准',
        'withdrawal_approved_message' => '您的提款申請已獲批准,我們將很快把 <strong>:withdrawal_amount</strong> 轉帳到您的銀行帳戶。',

        // Order Cancellation
        'order_cancellation_title' => '顧客已取消訂單 :order_id',
        'order_cancellation_message' => '顧客 :customer_name 已取消訂單 <strong>:order_id</strong>,原因是 :cancellation_reason。',
        'order_items_header' => '以下是您訂購的商品:',

        // Welcome Vendor
        'welcome_vendor_title' => '歡迎賣家',
        'welcome_vendor_greeting' => '我們非常高興歡迎您來到 :store_name!',
        'welcome_vendor_registration_complete' => '您的賣家註冊已成功完成,您現在已成為我們充滿活力的賣家社群的一員。',
        'welcome_vendor_next_steps' => '以下是您接下來可以做的事情:',
        'welcome_vendor_step_login' => '使用您的登入資料登入您的賣家帳戶。',
        'welcome_vendor_step_add_products' => '將您的產品/服務添加到您的商店。請務必提供詳細的描述和吸引人的圖片,以吸引潛在買家。',
        'welcome_vendor_support' => '如果您有任何疑問或需要協助,我們的支援團隊隨時為您提供協助。歡迎隨時聯絡我們!',
        'login_vendor_account_button' => '登入您的賣家帳戶',
        'welcome_vendor_closing' => '我們期待看到您的商店在 :site_title 蓬勃發展!',

        // Store Verification
        'store_verified_title' => '商店驗證已批准',
        'store_verified_message' => '恭喜!您的商店已在 <strong>:site_title</strong> 成功通過驗證。此驗證徽章將有助於建立顧客對您的信任。',
        'dear_store_owner' => '親愛的 :store_name 擁有者,',
        'verification_details' => '驗證詳情',
        'store_verified_benefits' => '獲得驗證的好處',
        'verified_badge_benefit' => '在您的商店上顯示已驗證徽章',
        'increased_trust_benefit' => '提高顧客的信任和信心',
        'higher_visibility_benefit' => '在搜尋結果中獲得更高的曝光率',
        'visit_your_store' => '造訪您的商店',
        'congratulations_verified' => '恭喜您獲得驗證!',

        // Store Unverification
        'store_unverified_title' => '商店驗證狀態已更改',
        'store_unverified_message' => '很遺憾通知您,您在 <strong>:site_title</strong> 的商店驗證狀態已更改。',
        'unverification_details' => '狀態更改詳情',
        'store_unverified_impacts' => '這意味著什麼',
        'verified_badge_removed' => '已驗證徽章已從您的商店移除',
        'verification_benefits_lost' => '驗證權益已不再有效',
        'store_unverified_next_steps' => '如您對此決定有任何疑問或想討論重新驗證,請<strong>聯絡我們的支援團隊</strong>。',
        'contact_support' => '聯絡支援',
        'thank_you_understanding' => '感謝您的理解。',
    ],
    'current_balance' => '當前餘額',
    'settings' => [
        'title' => '設定',
        'description' => '市集設定',
        'fee_per_order' => '每筆訂單手續費(%),建議:2或3',
        'default_commission_fee' => '預設佣金費用(%),建議:2或3',
        'enable_commission_fee_for_each_category' => '為每個類別啟用佣金費用?',
        'categories' => '類別',
        'select_categories' => '選擇類別..',
        'commission_fee' => '佣金費用(%)',
        'commission_fee_by_category' => '按類別的佣金費用(%)',
        'fee_withdrawal_amount' => '提款手續費',
        'withdrawal_fee_type' => '提款手續費類型',
        'withdrawal_fee_types' => [
            'fixed' => '固定金額',
            'percentage' => '百分比',
        ],
        'check_valid_signature' => '檢查賣家收入中的有效簽名',
        'verify_vendor' => '賣家驗證(賣家必須通過驗證後才能發佈產品)',
        'verify_vendor_helper' => '如啟用,管理員必須先驗證賣家,然後賣家才能發佈產品。',
        'requires_vendor_documentations_verification' => '需要驗證賣家文件',
        'requires_vendor_documentations_verification_helper' => '如啟用,賣家在申請成為賣家時必須上傳文件檔案。',
        'hide_become_vendor_menu_in_customer_dashboard' => '在顧客儀表板中隱藏成為賣家選單',
        'hide_become_vendor_menu_in_customer_dashboard_description' => '如啟用,"成為賣家"選單將在顧客儀表板中隱藏。',
        'enable_product_approval' => '啟用產品批准',
        'enable_product_approval_description' => '如啟用,管理員必須先批准產品才能發佈。',
        'hide_store_phone_number' => '隱藏商店電話號碼?',
        'hide_store_email' => '隱藏商店電郵?',
        'hide_store_address' => '隱藏商店地址?',
        'hide_store_social_links' => '隱藏商店社交連結?',
        'enable_vendor_categories_filter' => '啟用賣家類別篩選器',
        'enable_vendor_categories_filter_description' => '在賣家商店頁面顯示類別篩選器。只會顯示有賣家產品的類別。',
        'allow_vendor_manage_shipping' => '允許賣家管理付運?',
        'allow_vendor_manage_shipping_description' => '如啟用,賣家可以將訂單的付運狀態更改為"配送中"、"已送達"等。',
        'charge_shipping_per_vendor' => '按賣家收取運費?',
        'charge_shipping_per_vendor_description' => '如啟用,將為每個賣家分別收取運費。如停用,整個訂單只收取一次運費。',
        'commission_fee_each_category_fee_name' => '佣金設定 :key 的佣金費用',
        'commission_fee_each_category_name' => '佣金設定 :key 的類別',
        'add_new' => '新增',
        'payout_methods' => '付款方式',
        'max_upload_filesize' => '最大上傳檔案大小(MB)',
        'max_upload_filesize_placeholder' => '預設:10',
        'max_product_images_upload_by_vendor' => '每件產品的最大圖片數量',
        'enable_vendor_registration' => '啟用賣家註冊',
        'enable_vendor_registration_helper' => '如啟用,賣家可以在網站上註冊帳戶並發佈產品。',
        'minimum_withdrawal_amount' => '最低提款金額(固定)',
        'minimum_withdrawal_amount_helper' => '指定賣家可以提款的最低金額。預設為0。',
        'allow_vendor_delete_their_orders' => '允許賣家刪除他們的訂單',
        'allow_vendor_delete_their_orders_description' => '啟用後,賣家可以透過移除不需要的項目來管理其訂單列表。請謹慎使用,因為已刪除的訂單可能會影響交易記錄。',
        'enable_messaging_system' => '啟用訊息系統',
        'enable_messaging_system_description' => '如啟用,賣家和顧客可以透過訊息系統互相溝通。',
        'term_and_privacy_policy_url' => '條款及私隱政策網址',
        'show_vendor_registration_form_at_registration_page' => '在註冊頁面顯示賣家註冊表格',
        'show_vendor_registration_form_at_registration_page_description' => '如啟用,賣家註冊表格將在註冊頁面顯示。',
        'single_vendor_checkout' => '每筆訂單限制一個賣家',
        'single_vendor_checkout_help' => '如啟用,顧客每筆訂單只能購買一個賣家的產品。',
        'display_order_total_info_for_each_store' => '為每個商店顯示訂單總額資訊',
        'display_order_total_info_for_each_store_helper' => '如啟用,訂單摘要中將為每個商店顯示訂單總額資訊。',
        'show_vendor_info_at_checkout' => '在結帳頁面顯示賣家資訊',
        'show_vendor_info_at_checkout_helper' => '如啟用,結帳頁面將顯示賣家資訊(姓名、標誌、評價)。',
        'media_file_types_can_be_uploaded_by_vendor' => '賣家可上傳的媒體檔案類型',
        'media_file_types_can_be_uploaded_by_vendor_helper' => '指定賣家可以上傳的媒體檔案類型。在上面的列表中選擇它們。',
    ],
    'theme_options' => [
        'name' => '市集',
        'description' => '市集的主題選項',
        'logo_vendor_dashboard' => '賣家儀表板中的標誌(預設為主標誌)',
    ],
    'store_name' => '商店名稱',
    'store_email' => '商店電郵',
    'store_phone' => '商店電話',
    'store_address' => '商店地址',
    'store_url' => '商店網址',
    'product_name' => '產品名稱',
    'product_url' => '產品網址',
    'withdrawal_amount' => '提款金額',
    'helpers' => [
        'store_status' => '如果您將狀態更改為":status"以外的狀態,此商店的帳戶也會更改為":customer"',
    ],
    'tables' => [
        'earnings' => '收入',
        'products_count' => '產品數量',
    ],
    'vendors' => '賣家',
    'payout_payment_methods' => [
        'bank_transfer' => '銀行轉帳',
        'paypal' => 'PayPal',
        'cash' => '現金',
    ],
    'reports' => [
        'name' => '報告',
        'total_fee_earnings' => '總手續費收入: :value',
        'total_fee' => '總手續費',
        'total_amount' => '總金額',
        'store_revenues' => '商店收入',
        'sale_commissions' => '銷售佣金',
        'fee' => '手續費(:symbol)',
        'amount' => '金額(:symbol)',
        'top_performing_stores' => '表現最佳的商店',
        'store_growth' => '商店增長',
        'withdrawal_status_chart' => '提款狀態',
        'product_distribution' => '按商店的產品分布',
        'average_commission' => '平均佣金率',
        'recent_withdrawals' => '最近的提款',
        'number_of_stores' => '商店數量',
        'number_of_products' => '產品數量',
        'orders' => '訂單',
        'revenue' => '收入',
        'increase' => '增加 :count',
        'decrease' => '減少 :count',
    ],
    'vendor' => '賣家',
    'vendor_name' => '賣家名稱',
    'contact_store' => [
        'form_name' => '聯絡商店表格',
    ],
    'store_statuses' => [
        'pending' => '待處理',
        'published' => '已批准',
        'blocked' => '已封鎖',
    ],
    'view_vendor' => '查看賣家 :name',
    'vendor_information' => '賣家資料',
    'vendor_verified' => '賣家已驗證',
    'vendor_not_verified' => '賣家未驗證',
    'vendor_verified_at' => '賣家驗證時間',
    'view_certificate' => '查看證書',
    'view_government_id' => '查看身份證明文件',
    'documents' => '文件',
    'store_products' => '商店產品',
    'store_orders' => '商店訂單',
    'total_revenue' => '總收入',
    'total_earnings' => '總收益',
    'withdrawals' => '提款',
    'pending_withdrawals' => '待處理的提款',
    'balance' => '餘額',
    'recent_products' => '最近的產品',
    'products_count' => '產品',
    'store_status' => '商店狀態',
    'verified' => '已驗證',
];
