@extends(Theme::getThemeNamespace('layouts.base'))

@section('content')
    @php
        Theme::asset()->container('footer')->usePath()->add('jquery.theia.sticky-js', 'js/plugins/jquery.theia.sticky.js');
    @endphp

    {!! Theme::partial('header') !!}

    <main class="main" id="main-section">
        @if (Theme::get('hasBreadcrumb', true))
            {!! Theme::partial('breadcrumb') !!}
        @endif
        <div class="page-content mb-50">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 m-auto">
                        <div class="row">
                            <div class="col-lg-9">
                                {!! Theme::content() !!}
                            </div>
                            <div class="col-lg-3 primary-sidebar sticky-sidebar pt-50">
                                <div class="widget-area">
                                    {!! dynamic_sidebar('primary_sidebar') !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    {!! Theme::partial('footer') !!}
@endsection
