<div class="product-cart-wrap style-2 wow animate__animated animate__fadeInUp" data-wow-delay="0">
    <div class="product-img-action-wrap">
        <div class="product-img">
            <a href="{{ $product->url }}">
                <img src="{{ RvMedia::getImageUrl($flashSale->getMetaData('image', true), null, false, RvMedia::getDefaultImage()) }}" alt="{{ $product->name }}" />
            </a>
        </div>
    </div>
    <div class="product-content-wrap">
        <div class="deals-countdown-wrap">
            <div class="deals-countdown" data-countdown="{{ $flashSale->end_date }}"></div>
        </div>
        <div class="deals-content">
            <h2 class="text-truncate"><a href="{{ $product->url }}" title="{{ $product->name }}">{{ $product->name }}</a></h2>
            @if (EcommerceHelper::isReviewEnabled())
                <div class="product-rate-cover">
                    <div class="product-rate d-inline-block">
                        <div class="product-rating" style="width: {{ $product->reviews_avg * 20 }}%"></div>
                    </div>
                    <span class="font-small ml-5 text-muted">({{ $product->reviews_count }})</span>
                </div>
            @endif
            @if (is_plugin_active('marketplace') && $product->store->id)
                <div class="text-truncate">
                    <span class="font-small text-muted">{{ __('Sold By') }} <a href="{{ $product->store->url }}">{!! BaseHelper::clean($product->store->name) !!}</a></span>
                </div>
            @endif
            <div class="product-card-bottom">
                @include(Theme::getThemeNamespace('views.ecommerce.includes.product-price'))
                @if (EcommerceHelper::isCartEnabled())
                    <div class="add-cart">
                        @if($product->has_variations)
                            <a aria-label="{{ __('Quick Shop') }}"
                                class="action-btn add"
                                data-bb-toggle="quick-shop"
                                data-url="{{ route('public.ajax.quick-shop', $product->slug) }}"
                                href="#">
                                <i class="fi-rs-shopping-cart mr-5"></i> <span class="d-inline-block">{{ __('Add') }}</span>
                            </a>
                        @else
                            <a aria-label="{{ __('Add To Cart') }}"
                                class="action-btn add-to-cart-button add"
                                data-bb-toggle="add-to-cart"
                                data-id="{{ $product->id }}"
                                data-url="{{ route('public.cart.add-to-cart') }}"
                                href="#">
                                <i class="fi-rs-shopping-cart mr-5"></i> <span class="d-inline-block">{{ __('Add') }}</span>
                            </a>
                        @endif
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
